/*!******************************************************************************

  @file         hak92.h

  ------------------------------------------------------------------------------

  @author       ElkeZ

  @brief        Deal-With-User-Commands

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HAK92_H
#define HAK92_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x99\xac\xfa\xae\xef\xbd\x2c\xce\xb0\x4c\xaf\x5d\xa5\xad\x8b\x3b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "vsp001.h"
#include "ggg00.h"
#include "vak001.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a92find_return_part (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp1_part_kind_Param                 part_kind,
    tsp1_part_ptr         VAR_VALUE_REF  part_ptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_mode_analyzer (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_ddl_descriptor_Param                 ddl,
    pasbool                              corr_select);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92parse_again (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parsid,
    pasbool                              dropStoredCmd);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_reject (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    pasbool                              utilityprocess);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_map_into_upper (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    void                  *  buf,
    tsp00_Int4                           startpos,
    tsp00_Int4                           endpos,
    pasbool                              uni_map);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_next_part_get (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp1_part_ptr         VAR_VALUE_REF  curr_part);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_resname_to_varpart (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92next_pcount (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parskey           VAR_VALUE_REF  parsk);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92next_monitor_pcount (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parskey           VAR_VALUE_REF  parsk);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92_add_pcount (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_C3              VAR_ARRAY_REF  pcount,
    tgg00_MessType_Param                 parskind);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a92ReadLongDemandData (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int4                           LongColCnt,
    tsp00_Int4            VAR_VALUE_REF  MaxColCnt,
    tsp00_Int4            VAR_VALUE_REF  Position,
    tsp00_Int4            VAR_VALUE_REF  Length,
    pasbool               VAR_VALUE_REF  AtOnce);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

