/*!******************************************************************************

  @file         hak05.h

  ------------------------------------------------------------------------------

  @author       ElkeZ

  @brief        AK_semantic_scanner_tools

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HAK05_H
#define HAK05_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x24\x29\x9f\x00\x06\x7d\x74\x49\x2a\xd9\x62\xc8\x13\x7f\x52\x74'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gak00.h"
#include "vak001.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a05init ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05int4_get (
    tak_all_command_glob  &  acv,
    integer                  pos,
    tsp00_Int2               l,
    tsp00_Int4            &  val);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05get_err_tabid (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  tree,
    tgg00_Surrogate       &  tableid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_identifier_get_from_buffer (
    tak_all_command_glob  &  acv,
    void                  *  SourceBuffer,
    tsp00_Int4               BufferLength,
    tsp00_Int4               IdentifierPosition,
    tsp00_Int2               IdentifierLength,
    pasbool                  ComplexStringID,
    integer                  ObjLength,
    void                  *  MoveObj);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05identifier_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    integer                  obj_len,
    void                  *  moveobj);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_identifier_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    integer                  obj_len,
    void                  *  moveobj);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_unsigned_int2_get (
    tak_all_command_glob  &  acv,
    integer                  pos,
    tsp00_Int2               l,
    tsp00_Int4               err_code,
    tsp00_Int2            &  val);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_int4_unsigned_get (
    tak_all_command_glob  &  acv,
    integer                  pos,
    tsp00_Int2               l,
    tsp00_Int4            &  val);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_li_constant_get (
    tak_all_command_glob  &  acv,
    integer                  ni,
    tak00_columninfo      &  colinfo,
    integer                  orig_len,
    integer                  mv_dest,
    void                  *  dest,
    integer                  destpos,
    pasbool                  variable_length,
    integer               &  actlen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_constant_get (
    tak_all_command_glob  &  acv,
    integer                  ni,
    tak00_columninfo      &  colinfo,
    pasbool                  may_be_longer,
    integer                  mv_dest,
    void                  *  dest,
    integer                  destpos,
    integer               &  actlen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05var_constant_get (
    tak_all_command_glob  &  acv,
    integer                  ni,
    tak00_columninfo      &  colinfo,
    pasbool                  may_be_longer,
    integer               &  valfieldno,
    tsp00_MoveObjPtr      &  valstart,
    integer               &  actlen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_stamp_get (
    tak_all_command_glob  &  acv,
    void                  *  dest,
    integer                  destpos,
    integer                  mv_dest);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05surrogate_get (
    tak_all_command_glob  &  acv,
    tgg00_Surrogate       &  surrogate);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05temp_nextval (
    void                  *  data_part,
    tsp00_Int4               data_size,
    tgg00_StackEntry      &  st_entry,
    tgg00_SeqInfo         &  seq_info,
    void                  *  moveobj,
    tsp00_Int4            &  moveobj_size,
    tsp00_Int4               result_pos,
    integer               &  result_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_transaction_get (
    tak_all_command_glob  &  acv,
    void                  *  dest,
    integer                  destpos,
    integer                  mv_dest);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_nextval_get (
    tak_all_command_glob  &  acv,
    tgg00_MessType2_Param     m2_type,
    const tgg00_Surrogate VAR_ARRAY_REF     seq_id,
    tgg00_SeqInfo         &  seq_info,
    void                  *  dest,
    integer                  destpos,
    integer               &  actlen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05constraint_fulfilled (
    tak_all_command_glob  &  acv,
    tgg00_Rec             &  valbuf,
    tgg00_FileId          &  tree,
    integer                  constraint_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05is_const_in_constraint (
    tak_all_command_glob  &  acv,
    void                  *  valbuf,
    integer                  val_pos,
    integer                  val_len,
    tgg00_FileId          &  tree,
    integer                  constraint_id,
    tgg00_BasisError         b_err,
    integer                  error_pos);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05password_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    tsp00_Pw              &  password);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05put_identifier (
    tsp00_KnlIdentifier   &  id,
    void                  *  moveobj,
    tsp00_Int4               moveobj_size,
    tsp00_Int4            &  pos,
    tsp00_Int2            &  retcode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05qualification_test (
    tak_all_command_glob  &  acv,
    tgg00_MessBlock       &  m,
    pasbool                  result_wanted,
    pasbool                  check_new_rec,
    integer                  error_pos,
    tgg00_Rec             &  rec,
    void                  *  result_buf,
    tsp00_Int4               resultBufSize,
    integer               &  result_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05varqualification_test (
    tak_all_command_glob  &  acv,
    tgg00_MessBlock       &  m,
    pasbool                  result_wanted,
    pasbool                  check_new_rec,
    integer                  error_pos,
    integer                  fieldlistno,
    tsp00_Int2            &  result_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05serial (
    tak_all_command_glob  &  acv,
    tak00_columninfo      &  colinfo,
    tgg00_FileId          &  treeid,
    void                  *  moveobj,
    tsp00_Int4               moveobj_size,
    tsp00_Int4               number_pos,
    integer               &  number_len,
    pasbool                  with_retpart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05return_serial (
    tak_all_command_glob  &  acv,
    tsp00_Number          &  first_serial,
    tsp00_Number          &  last_serial);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05string_literal_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    tsp00_DataType_Param     datatyp,
    void                  *  moveobj,
    integer                  obj_pos,
    integer                  obj_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_str_literal_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    tsp00_DataType_Param     datatyp,
    void                  *  moveobj,
    integer                  obj_pos,
    integer                  obj_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_string_literal_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    tsp00_DataType_Param     datatyp,
    integer                  obj_len,
    void                  *  moveobj);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05dfts_date_from_timestamp (
    void                  *  sbuf,
    void                  *  dbuf,
    tsp00_Int4               spos,
    tsp00_Int4               dpos,
    tsp00_Int4               dbufsize,
    integer                  actlen,
    tgg00_DateTimeFormat_Param     format,
    tsp00_C3              &  language,
    tgg00_BasisError      &  b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05tfts_time_from_timestamp (
    void                  *  sbuf,
    void                  *  dbuf,
    tsp00_Int4               spos,
    tsp00_Int4               dpos,
    tsp00_Int4               dbufsize,
    integer                  actlen,
    tgg00_DateTimeFormat_Param     format,
    tsp00_C3              &  language,
    tgg00_BasisError      &  b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05tsfdt_timestamp_from_dattim (
    void                  *  sbuf,
    void                  *  dbuf,
    tsp00_Int4               spos,
    tsp00_Int4               dpos,
    tsp00_Int4               dbufsize,
    integer                  actlen,
    tgg00_DateTimeFormat_Param     format,
    tsp00_DataType_Param     stype,
    tgg00_BasisError      &  b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05timestamp_get (
    tak_all_command_glob  &  acv,
    void                  *  src,
    tsp00_Int4               src_pos,
    pasbool                  source_undef,
    void                  *  dest,
    tsp00_Int4               dest_pos,
    tsp00_Int4               check_len,
    tgg00_BasisError      &  b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05get_digit (
    void                  *  num_buf,
    integer                  pos,
    integer                  length,
    integer               &  dig_len,
    integer               &  dig_frac);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05long_literal_get (
    tak_all_command_glob  &  acv,
    integer                  tree_index,
    tsp00_DataType_Param     datatyp,
    void                  *  moveobj,
    integer                  obj_pos,
    integer               &  obj_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05_verify_not_null (
    tak_all_command_glob  &  acv,
    tgg00_Rec             &  valbuf,
    tgg00_StackEntry      &  stackentry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 a05lnr_space_defbyte (
    tak_acv_address          acv,
    tsp00_MoveObjPtr      &  str,
    char                     defbyte,
    tsp00_Int4               start_pos,
    tsp00_Int4               length);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05luc_space (
    tak_acv_address          acv,
    void                  *  buf1,
    tsp00_Int4               fieldpos1,
    tsp00_Int4               fieldlength1,
    void                  *  buf2,
    tsp00_Int4               fieldpos2,
    tsp00_Int4               fieldlength2,
    tsp00_LcompResult     &  l_result);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a05space_option (
    tak_acv_address          acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a05int_range_check (
    tak_all_command_glob  &  acv,
    void                  *  dest,
    integer                  destpos,
    integer                  numlen,
    tsp00_Int2               cdatalen,
    tsp00_Int4               errorpos);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

