/*****************************************************************************/
/*!
  @file         SQLTab_SysUpdStatWanted.hpp
  @author       MartinKi
  @ingroup

  @brief        Header file for class SQLTab_SysUpdStatWanted.

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/
/*****************************************************************************/

#ifndef SQLTAB_SYSUPDSTATWANTED_HPP
#define SQLTAB_SYSUPDSTATWANTED_HPP

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SQLManager/SQLMan_Context.hpp"
#include "SAPDBCommon/SAPDB_Types.hpp"

#include "ggg00.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

class Catalog_TableDescriptor;
class Catalog_ColumnDescriptor;
class Msg_List;

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/
/*!
 * @class SQLTab_SysUpdStatWanted
 * @author MartinKi
 *
 * Allows access and manipulation of system table SYSUPDSTATWANTED.
 */
class SQLTab_SysUpdStatWanted
{
private:
    // no copy-construction or assignment
    SQLTab_SysUpdStatWanted(const SQLTab_SysUpdStatWanted&);
    SQLTab_SysUpdStatWanted operator=(const SQLTab_SysUpdStatWanted&);

    SQLMan_Context& m_context;

    static void BuildKey(
        const SQLMan_Identifier& schemaName,
        const SQLMan_Identifier& ownerName,
        const SQLMan_Identifier& tableName,
        const SQLMan_Identifier& columnName,
        tgg00_Lkey&              key);

    static SAPDB_Bool GetRecord(
        tgg00_TransContext& trans,
        tgg00_Lkey&        key,
        SQLMan_Identifier& schemaName,
        SQLMan_Identifier& ownerName,
        SQLMan_Identifier& tableName,
        SQLMan_Identifier& columnName);

    static void ParseRecord(
        const tgg00_Rec&    recBuf,
        SQLMan_Identifier&  schemaName,
        SQLMan_Identifier&  ownerName,
        SQLMan_Identifier&  tableName,
        SQLMan_Identifier&  columnName);

public:
    class Iterator;
    friend class Iterator;
    class RequestColumnIterator;
    friend class RequestColumnIterator;

    /// Possible return codes.
    enum ReturnCode {
        Okay,
        SystemError
    };

    /*!
     * @brief Constructor.
     */
    SQLTab_SysUpdStatWanted(SQLMan_Context& context);

    /*!
     * @brief Return codes of insert operation
     */
    enum InsertRc {
        irOkay,
        irNoStatisticsPossible,
        irFailed,
        irCancelled,
        irLockRowFailed,
        irSystemError
    };

    /*!
     * @brief Return codes of delete operation.
     */
    enum DeleteRc {
        delRcOkay,
        delRcRowNotFound,
        delRcCancelled,
        delRcLockRequestTimeout,
        delRcSystemError
    };

    /*!
     * @brief Inserts a row into for SYSUPDSTATWANTED. Basic checks if
     * the table and column types are ok are performed.
     */
    InsertRc InsertRow(
        const Catalog_TableDescriptor&  tableDesc,
        const Catalog_ColumnDescriptor& columnDesc,
        Msg_List&                       errMsg);

    /*!
     * @brief Inserts a row into for SYSUPDSTATWANTED. No checks are
     * performed.
     */
    InsertRc InsertRow(
        const SQLMan_Identifier&  schemaName,
        const SQLMan_Identifier&  ownerName,
        const SQLMan_Identifier&  tableName,
        const SQLMan_Identifier&  columnName,
        Msg_List&                 errMsg);


    /*!
     * @brief Returns an iterator over all columnnames of the table
     * described by tableDesc for which an update statistics request
     * exists.
     */
    RequestColumnIterator GetRequestColumnIterator(
        const Catalog_TableDescriptor& tableDesc) const;

    /*!
     * @brief Deletes the row specified from SYSUPDSTATWANTED.
     *
     * @param schemaName [in] qualification for column SCHEMA
     * @param ownerName  [in] qualification for column OWNER
     * @param tableName  [in] qualification for column TABLE
     * @param columnName [in] qualification for column COLUMN
     * @param errMsg     [in] possible error messages
     */
    DeleteRc DeleteRow(
        const SQLMan_Identifier&  schemaName,
        const SQLMan_Identifier&  ownerName,
        const SQLMan_Identifier&  tableName,
        const SQLMan_Identifier&  columnName,
        Msg_List&                 errMsg);

//     class Iterator
//     {
//     private:
// //        class SQLTab_SysUpdStatWanted;
//         friend class SQLTab_SysUpdStatWanted;

//         tgg00_Lkey m_curKey;

//         Iterator(SQLMan_TransContext& transContext);

//         Iterator(SQLMan_TransContext& transContext, bool);

//         // no assignment
//         Iterator& operator=(const Iterator& it);

//         SQLMan_TransContext& m_trans;
//     public:
//         Iterator(const Iterator& it);


//         SAPDB_Bool Next();

//         SAPDB_Bool GetKey(tgg00_Lkey& key) const;

//         SAPDB_Bool operator==(const Iterator& it) const;

//         SAPDB_Bool operator!=(const Iterator& it) const;

//         Iterator& operator++();
//     };

    /*!
     * @brief Provides an iterator over all column names of a table
     * for which an update statistics request exists.
     */
    class RequestColumnIterator
    {
    private:
        friend class SQLTab_SysUpdStatWanted;

        tgg00_Lkey m_curKey;

        RequestColumnIterator(
            SQLMan_TransContext&           transContext,
            const Catalog_TableDescriptor& tableDesc);

        // no assignment
        Iterator& operator=(const Iterator& it);

        SQLMan_TransContext&           m_trans;
        const Catalog_TableDescriptor* m_tableDesc;
        SAPDB_Bool                     m_firstCall;
    public:
        /*!
         * @brief copy-constructor
         */
        RequestColumnIterator(const RequestColumnIterator& it);

        /*!
         * @brief Advances the iterator by one.
         *
         * @param columnName [out] name of column for which statistics
         *                         are requested
         *
         * @return true, if columnName is a valid column name
         */
        SAPDB_Bool Next(SQLMan_Identifier& columnName);
    };
};

/**************************************************************************/

// inline SAPDB_Bool
// SQLTab_SysUpdStatWanted::Iterator::operator==(const Iterator& it) const
// {
//     return
//         ( m_curKey.keyLen_gg00() == it.m_curKey.keyLen_gg00() )
//         && ( m_curKey.keyVal_gg00() == m_curKey.keyVal_gg00() );
// }

// /**************************************************************************/

// inline SAPDB_Bool
// SQLTab_SysUpdStatWanted::Iterator::operator!=(const Iterator& it) const
// {
//     return ! (*this == it );
// }

/**************************************************************************/

#endif // SQLTAB_SYSUPDSTATWANTED_HPP
