/*!***************************************************************************

    @file     Query_NodeRoot.cpp
    @ingroup  Query
    @author   DirkT
    @brief    
    @see  

  -------------------------------------------------------------------------

  responsible : DirkT

  special area: SQL Manager / Query
  description : 

  last changed: 2005-06-08  12:00
  first created:2004-04-29  10:00

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 2000-2005 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

#include "SAPDB/SQLManager/Query/Query_NodeRoot.hpp"
#include "SAPDB/SQLManager/Query/Query_NodeSelect.hpp"
#include "SAPDB/SQLManager/Query/Query_NodeUnion.hpp"
#include "SAPDB/SQLManager/Query/Query_Graph.hpp"

// ------------------------------------------------------------------------------------------------
    
Query_RootNode::Query_RootNode( Query_ManipulationContext& Context, Query_QueryGraph& QueryGraph ) 
    : Query_Node(Context, QueryGraph, P_Start, 0, false, DT_Preserve)
    , mIsExplain(false)
{
}

Query_RootNode::Query_RootNode( Query_Node* AnyOtherNode )
	: Query_Node(AnyOtherNode->Context()
                , AnyOtherNode->QueryGraph()
                , AnyOtherNode->Position()
                , AnyOtherNode->SyntaxNode(), 
                false, DT_Preserve)
    , mIsExplain(false)
{
}

Query_RootNode::Query_RootNode( const Query_RootNode& N, Query_Node* Father, Query_Quantifier* Q, Query_NodeMapper* mpMap, Query_QuantifierMapper* mpQMap )
    : Query_Node(N, Father, Q, mpMap, mpQMap) 
    , mIsExplain(false)
{
}

Query_Node* Query_RootNode::CreateDuplicate( Query_Node* Father, Query_Quantifier* Q, Query_NodeMapper* mpMap, Query_QuantifierMapper* mpQMap )
{
    Query_RootNode* R = new(mAllocator) Query_RootNode(*this, Father, Q, mpMap, mpQMap);
    R->mIsExplain = mIsExplain;
    return R;
}

void Query_RootNode::PrintToTrace( Kernel_VTrace& VTrace )
{
    SAPDBTRACE_METHOD_DEBUG ("Query_RootNode::PrintToTrace", QueryRewrite_Trace, 8);

    Query_Node::PrintToTrace(VTrace);
    if ( QueryRewrite_Trace.TracesLevel(2) )
    {
        VTrace << "NodeType  : Top" << FlushLine;
    }
    PrintChildNodesToTrace(VTrace);
}

bool Query_RootNode::Parse( bool ComplexViewReplacement )
{
    Query_SyntaxTree& SyntaxTree = mQueryGraph.SyntaxTree();
    SyntaxTree.SetRefBack(mAPNode);   // DDT - sollte man das nicht "on the fly" machen ?

    SyntaxTreeNodeNo N = (mAPNode==0 ? SyntaxTree[mAPNode].n_lo_level : mAPNode);

    if ( SyntaxTree[N].n_proc == a63 && SyntaxTree[N].n_subproc() == cak_x_recursive_select )
    {
        mQueryGraph.SetNotYetImplemented("cak_x_recursive_select", false);  // DDT : recursive select 
        return false;
    }

    if ( SyntaxTree[N].n_proc == a43 && SyntaxTree[N].n_subproc() == cak_x_explain )
    {
        mIsExplain = true;
        N = SyntaxTree[N].n_lo_level;
    }

    Query_Node* Query = AddQuery(N, mPosition, ComplexViewReplacement);
    if ( Query )
    {
        if ( Query->Parse(ComplexViewReplacement) )
        {
            mQueryGraph.SetProgress(PG_Nodes);
            return true;
        }
    }
    return false;
}

//bool Query_RootNode::StartSetTempFileNameAndCounter( void )
//{
//    bool ContainsCorrelatedSubquery   = false, 
//         ContainsFromSelectInSubquery = false; 
//    bool FatherIsUnion = false;
//
//    SAPDB_Int2  MaxSubqueryLevel = 0,
//                FromSelCnt = 0,
//                ParsCnt = 0,
//                Cnt=0;
//    bool rc = Query_Node::SetTempFileNameAndCounter(0, Cnt, FatherIsUnion, FromSelCnt, ParsCnt, ContainsCorrelatedSubquery, ContainsFromSelectInSubquery, MaxSubqueryLevel);
//    
//    if ( rc ) 
//    {
//        if ( mQueryGraph.FromSelectsCnt() != FromSelCnt )
//        {
//            SAPDBERR_ASSERT_STATE( mQueryGraph.FromSelectsCnt() == FromSelCnt );
//            return false;
//        }
//
//        if ( ContainsCorrelatedSubquery )
//        {
//            if ( MaxSubqueryLevel >= Query_MaxCorrLevel )
//            {
//                mQueryGraph.SetNotYetImplemented("Too complicated SQL statement (too many subqueries) -1102");
//                return false;
//            }
//            if ( ContainsFromSelectInSubquery )
//            {
//                mQueryGraph.SetNotYetImplemented("Correlated Subquery with Select in From Part -7058");
//                return false;
//            }
//        }
//    }
//    return rc;
//}



// ------------------------------------------------------------------------------------------------
