/*!***************************************************************************

    @file     Query_Node.hpp
    @ingroup  Query
    @author   DirkT
    @brief    
    @see  

  -------------------------------------------------------------------------

  responsible : DirkT

  special area: SQL Manager / Query
  description : 

  last changed: 2005-06-08  12:00
  first created:2004-04-29  10:00

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 2000-2005 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

#ifndef Query_Node_H
#define Query_Node_H

// ------------------------------------------------------------------------------------------------

#include "SAPDB/SQLManager/SQLMan_Types.hpp"
#include "SAPDB/SQLManager/SQLMan_Context.hpp"
#include "SAPDB/SQLManager/SQLMan_ContextSessionMembers.hpp" // DDT why ???

#include "SAPDB/SQLManager/Query/Query_Types.hpp"
#include "SAPDB/SQLManager/Query/Query_OutputColumn.hpp"
#include "SAPDB/SQLManager/Query/Query_Column.hpp"

#include "SAPDB/SAPDBCommon/SAPDB_Types.hpp"
#include "SAPDB/Container/Container_Vector.hpp"

#include "SAPDBCommon/Tracing/SAPDBTrace_Streaming.hpp"

// ------------------------------------------------------------------------------------------------

class	Query_ManipulationContext;
class   Query_Quantifier;
class   Query_Expression;
class   Query_QueryGraph;
class   Query_SelectNode;
class   SAPDBMem_IRawAllocator;

// ------------------------------------------------------------------------------------------------
/*!
    @class          Query_Node
    @brief          ...
 */
class Query_Node
{
protected:    // private copyconstuctor used by CreateDuplicate
    /// ...
    Query_Node( const Query_Node& N, Query_Node* Father, Query_Quantifier* Q, Query_NodeMapper* mpMap, Query_QuantifierMapper* mpQMap );
public:

    /// ...
    enum NodeType { Top, TableAccess, Select, Union, Difference, Intersect,Insert, Update, Delete, Unknown };

    /// ...
    virtual Query_Node* CreateDuplicate( Query_Node* Father, Query_Quantifier* Q, Query_NodeMapper* mpMap, Query_QuantifierMapper* mpQMap ) = 0;

    /// ...
    Query_Node( Query_ManipulationContext& Context, Query_QueryGraph& QueryGraph, 
                Query_Position Position, SyntaxTreeNodeNo APNode,
                bool HeadDistinct, Query_DistinctType BodyDistinctType ); 

    /// ...
	virtual ~Query_Node( void );

    /// ...
	bool IllegalUseOfMethod( const char* MethodName );

    /// ...
    virtual NodeType GetNodeType( void ) = 0;
    /// ...
    virtual Query_JoinType GetJoinType( void )		{ return JT_NoJoin; }
    /// ...
    virtual bool OuterJoin( void )					{ return IllegalUseOfMethod("OuterJoin");	}
    /// ...
    virtual bool Aggregates( void )					{ return IllegalUseOfMethod("Aggregates");	} 
    /// ...
    virtual bool AggregatesInOutput( void )			{ return IllegalUseOfMethod("AggregatesInOutput");	} 
    /// ...
    virtual bool AggregatesInCorrSubQuery( void )	{ return IllegalUseOfMethod("AggregatesInCorrSubQuery");	} 
    /// ...
    virtual void AddJoinType( Query_JoinType JT )	{ IllegalUseOfMethod("AddJoinType");		}
    /// ...
    virtual void SetForReuse( void )				{ IllegalUseOfMethod("SetForReuse");		}
    /// ...
	virtual void SetGivenSequence( void )			{ IllegalUseOfMethod("SetGivenSequence");	}
    /// ...
	virtual bool HasGivenSequence( void )			{ return IllegalUseOfMethod("HasGivenSequence");	}
    /// ...
	virtual bool AddGivenSequenceNode( void )	    { return IllegalUseOfMethod("AddGivenSequence");	}
    /// ...
	virtual bool HasSysKey( void )					{ return false; }
    /// ...
	virtual bool IsViewToBeReplaced( void )			{ return false; }
    /// ...
    virtual bool IsSpecialJoinFromSelect( void )    { return false; }


    /// ...
    virtual SyntaxTreeNodeNo	SelectListStart( void )							{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetSelectListStart( SyntaxTreeNodeNo Start )	{ IllegalUseOfMethod("SetSelectListStart"); }

    /// ...
    virtual SyntaxTreeNodeNo	SelectIntoStart( void )							{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetSelectIntoStart( SyntaxTreeNodeNo Start )	{ IllegalUseOfMethod("SetSelectIntoStart"); }
    /// ...
    virtual bool				HasSelectInto( void )					     	{ return false; }

    /// ...
    virtual SyntaxTreeNodeNo	FromPartStart( void )							{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetFromPartStart( SyntaxTreeNodeNo Start )		{ IllegalUseOfMethod("SetFromPartStart"); }

    /// ...
    virtual SyntaxTreeNodeNo	SearchConditionStart( void )					{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetSearchConditionStart( SyntaxTreeNodeNo Start ){ IllegalUseOfMethod("SetSearchConditionStart"); }
    /// ...
    virtual bool				HasSearchCondition( void )						{ return false; }
    /// ...
    virtual SyntaxTreeNodeNo	OrderByStart( void )							{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetOrderByStart( SyntaxTreeNodeNo Start )       { IllegalUseOfMethod("SetOrderByStart"); }
    /// ...
    virtual bool				HasOrderBy( void )								{ return false; }
    /// ...
    virtual SyntaxTreeNodeNo	GroupByStart( void )							{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetGroupByStart( SyntaxTreeNodeNo Start )       { IllegalUseOfMethod("SetGroupByStart"); }
    /// ...
    virtual bool				HasGroupBy( void )								{ return false; }
    /// ...
    virtual SyntaxTreeNodeNo	HavingStart( void )								{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetHavingStart( SyntaxTreeNodeNo Start )        { IllegalUseOfMethod("SetHavingStart"); }
    /// ...
    virtual bool				HasHaving( void )								{ return false; }
    /// ...
    virtual SyntaxTreeNodeNo	LimitStart( void )								{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetLimitStart( SyntaxTreeNodeNo Start )         { IllegalUseOfMethod("SetLimitStart"); }
    /// ...
    virtual bool				HasLimit( void )								{ return false; }
	/// ...
    virtual SyntaxTreeNodeNo	UpdateColumnsStart( void )						{ return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetUpdateColumnsStart( SyntaxTreeNodeNo Start ) { IllegalUseOfMethod("SetUpdateColumnsStart"); }
    /// ...
    virtual bool				HasForUpdate( void )							{ return false; }
    /// ...
	virtual bool				IsFromSelect( void )                            { return false; }
    /// ...
	virtual bool                IsSelectOrSet( void )                           { return false; }
    /// ...
    virtual bool                IsSet( void )                                   { return false; }
    /// ...
    virtual bool                HasFromSelects( void )                          { return false; }
    /// ...
    virtual bool				HasForReuse( void )							    { return false; }

    /// ...
    virtual SyntaxTreeNodeNo	LockOptionStart( void )						    { return cak_qrewrite_ref_init; }
    /// ...
    virtual void				SetLockOptionStart( SyntaxTreeNodeNo Start )    { IllegalUseOfMethod("SetLockOptionStart"); }
    /// ...
    virtual bool				HasLockOption( void )							{ return false; }

    /// ...
    virtual bool                IsDeclareCursor( void )                         { return false; }
    /// ...
    virtual void                SetDeclareCursor( bool Decl )                   {  }
    /// ...
    virtual void                SetA631( void )                                 {  }

    /// ...
    virtual void PrintToTrace( Kernel_VTrace& VTrace );
    /// ...
    void PrintChildNodesToTrace( Kernel_VTrace& VTrace );

    /// ...
	virtual bool SelectPrivilegesForAllColumns( void )	{ return true; }

    /// ...
    virtual bool ReplaceComplexViews( void );

    /// ...
    virtual bool SimplifyPredicates( void )     { return true; }
    /// ...
    virtual bool PredicatesSimplified( void )   { return true; }
    /// ...
    virtual bool HasRownoPredicate( void )      { return false; }
    /// ...
    virtual void SetRownoPredicate( void )      { IllegalUseOfMethod("SetRownoPredicate");	}

    /// ...
    virtual bool EliminateOrderBy( void )       { return true; }
    /// ...
    virtual bool OrderByEliminated( void )      { return true; }

    /// ...
    virtual bool PullDownProjectionPossible( void )      { return false; }
    /// ...
    virtual bool PullDownProjection( void )      { return true; }
    /// ...
    virtual bool ProjectionPulledDown( void )     { return true; }

    /*!
        @brief Check if the colums given by LogOutColNr make the output unique
        @param LogOutColNr [in]
        @returns TRUE or FALSE
    */
    virtual bool DefineUniqueOutput( Container_Vector<SAPDB_Int2>& LogOutColNr )  { return false; }


    /// ...
	Query_Node* GetFirstChildNode( SAPDB_Int2& ChildCount );


    /// ...
    Query_Node* AddQuery( SyntaxTreeNodeNo NodeNo, Query_Position Position, bool ComplexViewReplacement );
    /// ...
    Query_Node* AddTable( SyntaxTreeNodeNo NodeNo, bool ComplexViewReplacement );

    /// ...
    bool AddQuantifier ( Query_Quantifier* Q );
    /// ...
    bool AddQuantifier ( Query_Quantifier* Q, SAPDB_UInt2 Position );
    /// ...
    bool AddQuantifier ( Query_Node* Node, Query_DistinctType DistinctType, Query_QuantifierType QuantifierType );

    ///// ...
    inline Container_Vector<Query_Quantifier*>& GetQuantifier( void )
    {
        return mQuantifier;
    }

    /// ...
    inline       void               SetNodeID( SAPDB_UInt2 ID ) { mID = ID; }
    /// ...
    inline const SAPDB_UInt2&       NodeID( void )          { return mID; }
    /// ...
    inline const SAPDB_UInt2&       FQuantifierCnt( void )  { return mFQuantifierCnt; }
    /// ...
    inline       void               DecFQuantifierCnt( void ) { --mFQuantifierCnt; }
    /// ...
    inline const SAPDB_UInt2&       WQuantifierCnt( void )  { return mWQuantifierCnt; }
    /// ...
    inline const SAPDB_UInt2&       LQuantifierCnt( void )  { return mLQuantifierCnt; }
    /// ...
    inline const SyntaxTreeNodeNo&  SyntaxNode( void )      { return mAPNode; };
    /// ...
    virtual      SyntaxTreeNodeNo   GetInternAPNode( void ) { return mAPNode; };
    /// ...
    inline       void               SetSyntaxNode( SyntaxTreeNodeNo NodeNo )   { mAPNode = NodeNo; };
    /// ...
    virtual      void               SetInternAPNode( SyntaxTreeNodeNo NodeNo ) { mAPNode = NodeNo; };
    /// ...
    virtual      void               DetermineAPNode( void ) { };
    /// ...
    inline const Query_Position&    Position( void )        { return mPosition; };
    /// ...
    void         SetPosition( Query_Position Pos );
    /// ...
    inline bool&                    HeadDistinct( void )    { return mHeadDistinct; }
    /// ...
    inline Query_DistinctType&      BodyDistinctType( void ){ return mBodyDistinctType; }
    /// ...
    inline Query_Node*&				FatherNode( void )      { return mFatherNode; }
    /// ...
    inline Query_Quantifier*&       FatherQuantifier( void ){ return mFatherQuantifier; }
    /// ...
    inline Query_QueryGraph&        QueryGraph( void )      { return mQueryGraph; }
    /// ...
    inline SAPDBMem_IRawAllocator&  GetAllocator( void )    { return mAllocator; }
    /// ...
    inline Query_ManipulationContext& Context( void )       { return mContext; }
    /// ...
    inline bool                     SemanticsDone( void )   { return mSemanticsDone; }

    /// ...
	inline void SetViewReplacement( void )	{ mViewReplacement = true; }
    /// ...
	inline bool IsViewReplacement( void )	{ return mViewReplacement; }

    /// ...
    virtual bool Parse( bool ComplexViewReplacement ) { return IllegalUseOfMethod("Parse");	}
    /// ...
    virtual bool Semantics( SQLMan_Surrogate UserId, bool UniqueOutputColumnNames, bool ComplexViewReplacement );

    /// ...
    virtual bool CompatibleAggregation( Query_Node* TargetNode ) { return false; }
    /// ...
    virtual bool PullDownForMerge( 
        Container_Vector<Query_OutputColumn*>*& pOutputColumns, SyntaxTreeNodeNo SelectList_AP,
                                                                SyntaxTreeNodeNo SelectInto_AP,
        Query_Expression& SearchCondition,                      SyntaxTreeNodeNo SearchCond_AP,
        Query_Expression& HavingColumns,                        SyntaxTreeNodeNo Having_AP,
        Container_Vector<Query_ColumnSpec*>*& pGroupByColumns,  SyntaxTreeNodeNo GroupBy_AP,
        Container_Vector<Query_ColumnSpec*>*& pOrderByColumns,  SyntaxTreeNodeNo OrderBy_AP,
        Query_Expression& UpdateColumns,                        SyntaxTreeNodeNo Update_AP,
        Container_Vector<Query_Quantifier*>& Quantifier,        SyntaxTreeNodeNo FromPart_AP,
        SyntaxTreeNodeNo LimitStart, 
		SyntaxTreeNodeNo LockOptionStart,
        bool ForReuse, bool OuterJoinPredicates,
        SAPDB_Int2 QID,
//        SAPDB_Int2 NID,
        Query_MergeType MergeType,
        bool MustCreateCopy
        ) 
    { return false; }
    /// ...
    virtual bool PullDownSearchCond( Query_Expression& SearchCondition, SyntaxTreeNodeNo SearchCond_AP, SAPDB_Int2 QID, bool MustCreateCopy ) { return false; }
    /// ...
    virtual bool QualificationPushedDown( void ) { return false; }

    /// ...
    virtual bool OutputContainsAllColumnsFromQuantifier( Query_Quantifier* Q ) { IllegalUseOfMethod("ContainsAllColumnsFormQuantifier"); return false; }
    /// ...
    virtual bool OutputContainsAllColumnsFromOrderBy( void ) { IllegalUseOfMethod("ContainsAllColumnsFormQuantifier"); return false; }
    /// ...
    virtual void RemoveAllFromSet( void ) { };

    /// ...
	virtual SAPDB_Int2 ExtColNo2LogicalColNo( SAPDB_Int2 ColumnIndex ) { /* only Query_NodeTable must overwrite this*/ return ColumnIndex; };
    /// ...
	virtual SAPDB_Int2 LogicalColNo2ExtColNo( SAPDB_Int2 ColumnIndex ) { /* only Query_NodeTable must overwrite this*/ return ColumnIndex; };

    /// ...
    virtual bool RemoveSubSelectNode( SyntaxTreeNodeNo SubSelNode, Query_Position PosType, bool ReplaceByChildren )
    {
        if ( mFatherNode )
            return mFatherNode->RemoveSubSelectNode(SubSelNode, PosType, ReplaceByChildren);
        return false;
    }
    /// ...
    bool AddSubSelectNode( SyntaxTreeNodeNo SubSelNode, SyntaxTreeNodeNo FatherNode, Query_Position FatherPosType )
    {
        if ( mFatherNode )
            return mFatherNode->AddSubSelectNode(SubSelNode, FatherNode, FatherPosType);
        return false;
    }

    /// ...
    virtual bool OneTupleCondition( void )      { return false; }
    /// ...
    virtual bool OneTupleAggregation( void )    { return false; }   
    /// ...
    virtual bool NoDuplicateCondition( void )   { return false; } 

    /// ...
	virtual bool CreateColRefNamesAndResolveAsterisk( SyntaxTreeNodeNo& RefNameNodes )  { IllegalUseOfMethod("CreateColRefNamesAndResolveAsterisk"); return true; }

    //--

    /// ...
    virtual bool RenewSemanticsForColumnsDueToColumnPrivs( Query_Node* NewNode ) { IllegalUseOfMethod("RenewSemanticsForColumn"); return true; }
    /// ...
    virtual bool RenewSemanticsForCorrelatedColumnsOnMergeForCorrCols( SAPDB_UInt2 OldQID, Query_Node* NewNode ) { IllegalUseOfMethod("RenewSemanticsForColumn"); return true; }

    /// ...
    virtual bool RenewSemanticsForMyColumnsDueToColumnPrivs( Query_Node* NewNode )	    { IllegalUseOfMethod("RenewSemanticsForQuantifier"); return true; }
    /// ...
    virtual bool RenewSemanticsForMyColumnsOnMergeForCorrCols( SAPDB_UInt2 OldQID, Query_Node* NewNode )	{ IllegalUseOfMethod("RenewSemanticsForQuantifier"); return true; }

    /// ...
    virtual bool RenewSemanticsForColumnDueToColumnPrivs( Query_Column* C )             { IllegalUseOfMethod("RenewSemanticsForColumn"); return true; }
    /// ...
    virtual bool RenewSemanticsForColumnOnMergeForCorrCols( Query_Column* C, Query_Position Pos )           { IllegalUseOfMethod("RenewSemanticsForColumn"); return true; }

    //--

    /// ...
    virtual void SetSubQueryType( Query_SubQueryType SubQueryType ) { IllegalUseOfMethod("SetSubqueryType"); }
    /// ...
    virtual Query_SubQueryType GetSubQueryType( void ) { return SQT_None; }

    /// ...
    virtual bool AppendColumn( Query_Expression& pExpression, Query_Column Col ) { return IllegalUseOfMethod("AppendColumn"); }
    /// ...
    virtual bool AppendOutputColumn ( SyntaxTreeNodeNo Node ) { return IllegalUseOfMethod("AppendOutputColumn"); }
    /// ...
    virtual SAPDB_Int2 OutputColumns( void ) { return 0; }
    /// ...
    virtual bool GetOutputColumnInternType( SAPDB_Int2 LogColIndex, Query_OutColType& Type, SyntaxTreeNodeNo& SyntaxNode ) { IllegalUseOfMethod("GetOutputColumnInternType"); return false; }
    /// ...
    virtual SAPDB_Int2 GetOutputColumnSize( SAPDB_Int2 LogColIndex )	{ return false; }
    /// ...
    virtual bool GetOutputColumnName( SAPDB_Int2 LogColIndex, SQLMan_Identifier& ColName, bool& IsNullable )	{ return false; }
    /// ...
    virtual bool GetOutputColumnExtNo( SAPDB_Int2 LogColIndex, SAPDB_Int2& ColumnIndex )	{ return false; }
    /// ...
    virtual bool CheckForColumn( const SQLMan_Identifier& Column, SyntaxTreeNodeNo& QuantifierSyntaxNode, SAPDB_Int2& QuantifierID, SAPDB_Int2& LogColumnIndex, SAPDB_Int2& ExtColNo, bool& IsNullable ) { return false; }
    /// ...
    virtual bool CheckForColumn( const SQLMan_Identifier& Schema, const SQLMan_Identifier& Table, const SQLMan_Identifier& Column, SyntaxTreeNodeNo& QuantifierSyntaxNode, SAPDB_Int2& QuantifierID, SAPDB_Int2& LogColumnIndex, SAPDB_Int2& ExtColNo, bool& IsNullable ) { return false; }
    /// ...
    virtual bool CheckQuantifierName( const SQLMan_Identifier& Schema, const SQLMan_Identifier& Table ) { return false; }
    /// ...
    virtual void GetIdentificationNames(SQLMan_Identifier& Schema, SQLMan_Identifier& Table) { Schema.SetBlank(); Table.SetBlank(); };
    /// ...
	virtual bool HasReferenceName( void )			{ return false; }
    /// ...
    virtual bool IsCorrelatedSubquery( void )		            { return false; }
    /// ...
    virtual bool IncRefCountForOutputColumn( SAPDB_Int2 QId, SAPDB_Int2 ColNo ) { return true; }
    virtual bool DecRefCountForOutputColumn( SAPDB_Int2 QId, SAPDB_Int2 ColNo ) { return true; }
    virtual bool AddRefCountForOutputColumn( SAPDB_Int2 ColNo, SAPDB_Int2 Count ) { return true; }
    virtual bool IncRefCountForOutputColumn( SAPDB_Int2 ColNo ) { return true; }
    virtual bool DecRefCountForOutputColumn( SAPDB_Int2 ColNo ) { return true; }

    /// ...
    virtual bool SetTempFileNameAndCounter( SAPDB_Int1 Level, SAPDB_Int2& Cnt, bool FatherIsUnion, SAPDB_Int2& FromSelCnt, SAPDB_Int2& ParsCnt, bool& ContainsCorrelatedSubquery, bool& ContainsFromSelectInSubquery, SAPDB_Int2& MaxSubqueryLevel );

protected:

    /// ...
    inline Query_QuantifierType DetermineQuantifierType( Query_Position Position, Query_SubQueryType SQT );
    /// ...
	bool GetQuantifierNoFromSyntaxNode( SyntaxTreeNodeNo Node, SAPDB_Int2& QNo );
    /// ...
	bool GetQuantifierNoFromQId( SAPDB_Int2 QID, SAPDB_Int2& QNo );
	/// ...
	bool GetQuantifierIDFromSyntaxNode( SAPDB_Int2 Node, SAPDB_Int2& QID );
	/// ...
	bool GetQuantifierIDAndNoFromSyntaxNode( SAPDB_Int2 Node, SAPDB_Int2& QID, SAPDB_Int2& QNo );

    /// ...
    Query_ManipulationContext&          mContext;           
    /// ...
    SAPDBMem_IRawAllocator&             mAllocator;         

    /// ...
    Query_QueryGraph&                   mQueryGraph;        
    /// ...
    Query_Node*                         mFatherNode;        
    /// ...
    Container_Vector<Query_Quantifier*> mQuantifier;        
    /// ...
    Query_Quantifier*                   mFatherQuantifier;  
    /// ...
    SAPDB_UInt2                         mID;                

    /// ...
    SyntaxTreeNodeNo                    mAPNode;            
    /// ...
    SAPDB_UInt2                         mFQuantifierCnt;    
    /// ...
    SAPDB_UInt2                         mWQuantifierCnt;    
    /// ...
    SAPDB_UInt2                         mLQuantifierCnt;    
    /// ...
    Query_Position                      mPosition;          

    /// ...
    Query_DistinctType                  mBodyDistinctType;  
    /// ...
    bool                                mHeadDistinct;      
    /// ...
    bool                                mSemanticsDone;     
    /// ...
	bool								mViewReplacement;   
};

inline Query_QuantifierType Query_Node::DetermineQuantifierType( Query_Position Position, Query_SubQueryType SQT )
{
    switch ( Position ) 
    {
	case P_Start: 
    case P_FromPart: 
	case P_Union: 
	case P_Difference: 
	case P_Intersect:
        return QT_F;
        break;
    case P_Where: 
    case P_Having: 
        switch ( SQT )
        {
        case SQT_EXISTS:    
            return QT_E;    
            break;
        case SQT_ALL:
        case SQT_ANY:
        case SQT_IN:
            return QT_A;    
            break;
        }
        return QT_S;
        break;
    case P_SelectList:
        return QT_L;
        break;
    default:
        SAPDBERR_ASSERT_STATE( 0 );
        return QT_Unknown;
        break;
    }
    return QT_Unknown;
}

// ------------------------------------------------------------------------------------------------

#endif