/*
        ========== licence begin  GPL
        Copyright (c) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end

*/

#ifndef SDBMSG_SQLMAN_H
#define SDBMSG_SQLMAN_H
/*
This header file was generated by buildmsg.pl
--- Do not edit....
*/
#ifdef __cplusplus
#ifndef MSG_LIST_HPP
#include "SAPDB/Messages/Msg_List.hpp"
#endif
#ifndef MSG_ARG_HPP
#include "SAPDB/Messages/Msg_Arg.hpp"
#endif
#endif

#ifndef SDB_RELEASE_070600  /* don't merge this define - only this date: 2005-11-14 10:16:10 */
#error SDBMsg_SQLMan.h was probably integrated between releases, do not integrate this header file, \
use buildmsg
#endif


#define SDBMSG_SQLMAN_COMPONENT "SQLMan"
/* Begin of all message defines for component SQLMan -> */
/* Begin of defines for message NO_MEMORY: ID = 1, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_NO_MEMORY 1, "SQLMan", __FILE__, __LINE__, "Out of memory", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_NO_MEMORY__MEMREQUEST "MEMREQUEST" /* optional */
/* <- End of defines for message NO_MEMORY */
/* Begin of defines for message STORE_PLAN_FAILED: ID = 2, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_STORE_PLAN_FAILED 2, "SQLMan", __FILE__, __LINE__, "Store Plan failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message STORE_PLAN_FAILED */
/* Begin of defines for message NOT_INITIALIZED: ID = 3, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_NOT_INITIALIZED 3, "SQLMan", __FILE__, __LINE__, "Object not initialized", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message NOT_INITIALIZED */
/* Begin of defines for message UPDSTAT_ADDTOREQUESTFILE_FAILED: ID = 4, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDSTAT_ADDTOREQUESTFILE_FAILED 4, "SQLMan", __FILE__, __LINE__, "Could not add table $FILENO$ to request file $FILENO1$", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTAT_ADDTOREQUESTFILE_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SQLMAN_UPDSTAT_ADDTOREQUESTFILE_FAILED__FILENO1 "FILENO1"
/* <- End of defines for message UPDSTAT_ADDTOREQUESTFILE_FAILED */
/* Begin of defines for message UPDSTATLOG_PREPARE_FAILED: ID = 5, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDSTATLOG_PREPARE_FAILED 5, "SQLMan", __FILE__, __LINE__, "Prepare of internal SQL statement failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDSTATLOG_PREPARE_FAILED */
/* Begin of defines for message UPDSTATLOG_NEWCONTEXT_FAILED: ID = 6, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATLOG_NEWCONTEXT_FAILED 6, "SQLMan", __FILE__, __LINE__, "Could not create new statement context; error $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATLOG_NEWCONTEXT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTATLOG_NEWCONTEXT_FAILED */
/* Begin of defines for message UPDSTATLOG_CREATESTATEMENT_FAILED: ID = 7, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATLOG_CREATESTATEMENT_FAILED 7, "SQLMan", __FILE__, __LINE__, "Creation of internal connection failed; error $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATLOG_CREATESTATEMENT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTATLOG_CREATESTATEMENT_FAILED */
/* Begin of defines for message UPDATESTAT_IGNORE_INSERT_RETURN: ID = 8, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDATESTAT_IGNORE_INSERT_RETURN 8, "SQLMan", __FILE__, __LINE__, "Insert into SYSUPDSTATLOG failed for table $FILENO$; ignoring $RETURNCODE$", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDATESTAT_IGNORE_INSERT_RETURN__FILENO "FILENO"
#define SDBMSGTAG_SQLMAN_UPDATESTAT_IGNORE_INSERT_RETURN__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDATESTAT_IGNORE_INSERT_RETURN */
/* Begin of defines for message UPDSTAT_INSERT_LOCK_COLLISION: ID = 9, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDSTAT_INSERT_LOCK_COLLISION 9, "SQLMan", __FILE__, __LINE__, "Update of SYSUPDSTATLOG failed due to lock collision", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDSTAT_INSERT_LOCK_COLLISION */
/* Begin of defines for message UPDSTAT_STORE_STATISTICS_FAILED: ID = 10, VERSION = 2, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDSTAT_STORE_STATISTICS_FAILED 10, "SQLMan", __FILE__, __LINE__, "Storing of updated statistics for table $FILENO$ failed, error: $ERRORTEXT$", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 2)
#define SDBMSGTAG_SQLMAN_UPDSTAT_STORE_STATISTICS_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDSTAT_STORE_STATISTICS_FAILED__FILENO "FILENO"
/* <- End of defines for message UPDSTAT_STORE_STATISTICS_FAILED */
/* Begin of defines for message UPDSTAT_INVALID_TABLE_TYPE: ID = 11, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDSTAT_INVALID_TABLE_TYPE 11, "SQLMan", __FILE__, __LINE__, "Invalid table type $TABLE_TYPE$ of table $FILENO$ for update statistics", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTAT_INVALID_TABLE_TYPE__FILENO "FILENO"
#define SDBMSGTAG_SQLMAN_UPDSTAT_INVALID_TABLE_TYPE__TABLE_TYPE "TABLE_TYPE"
/* <- End of defines for message UPDSTAT_INVALID_TABLE_TYPE */
/* Begin of defines for message UPDSTAT_LOCK_TABLE_FAILED: ID = 12, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDSTAT_LOCK_TABLE_FAILED 12, "SQLMan", __FILE__, __LINE__, "Locking of statistics record for table $FILENO$ failed; error = $RETURNCODE$", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTAT_LOCK_TABLE_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SQLMAN_UPDSTAT_LOCK_TABLE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTAT_LOCK_TABLE_FAILED */
/* Begin of defines for message UPDSTAT_GET_TABLE_FAILED: ID = 13, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_SQLMAN_UPDSTAT_GET_TABLE_FAILED 13, "SQLMan", __FILE__, __LINE__, "Could not get catalog information for table $FILENO$, error = $ERROR_NUMBER$", (Msg_Has4Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTAT_GET_TABLE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDSTAT_GET_TABLE_FAILED__ERROR_NUMBER "ERROR_NUMBER"
#define SDBMSGTAG_SQLMAN_UPDSTAT_GET_TABLE_FAILED__FILENO "FILENO"
/* <- End of defines for message UPDSTAT_GET_TABLE_FAILED */
/* Begin of defines for message CHECKTABLELOG_NEWCONTEXT_FAILED: ID = 14, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_NEWCONTEXT_FAILED 14, "SQLMan", __FILE__, __LINE__, "Could not create new statement context; error $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_CHECKTABLELOG_NEWCONTEXT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message CHECKTABLELOG_NEWCONTEXT_FAILED */
/* Begin of defines for message CHECKTABLELOG_CREATESTATEMENT_FAILED: ID = 15, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_CREATESTATEMENT_FAILED 15, "SQLMan", __FILE__, __LINE__, "Creation of internal connection failed; error $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_CHECKTABLELOG_CREATESTATEMENT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message CHECKTABLELOG_CREATESTATEMENT_FAILED */
/* Begin of defines for message CHECKTABLELOG_PREPARE_UPDATE_FAILED: ID = 16, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_UPDATE_FAILED 16, "SQLMan", __FILE__, __LINE__, "Could not prepare internal update statement, error $ERRORTEXT$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_CHECKTABLELOG_PREPARE_UPDATE_FAILED__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message CHECKTABLELOG_PREPARE_UPDATE_FAILED */
/* Begin of defines for message CHECKTABLELOG_PREPARE_PARAMS_FAILED: ID = 17, VERSION = 2, TAGS = 1 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_PARAMS_FAILED 17, "SQLMan", __FILE__, __LINE__, "Preparation of parameters for internal statement failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 2)
/* <- End of defines for message CHECKTABLELOG_PREPARE_PARAMS_FAILED */
/* Begin of defines for message CHECKTABLELOG_PREPARE_INSERT_FAILED: ID = 18, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_INSERT_FAILED 18, "SQLMan", __FILE__, __LINE__, "Could not prepare internal insert statement, error $ERRORTEXT$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_CHECKTABLELOG_PREPARE_INSERT_FAILED__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message CHECKTABLELOG_PREPARE_INSERT_FAILED */
/* Begin of defines for message CHECKTABLELOG_SWITCH_USER_FAILED: ID = 19, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_CHECKTABLELOG_SWITCH_USER_FAILED 19, "SQLMan", __FILE__, __LINE__, "Could not switch user, error $ERRORTEXT$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_CHECKTABLELOG_SWITCH_USER_FAILED__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message CHECKTABLELOG_SWITCH_USER_FAILED */
/* Begin of defines for message UPDSTATLOG_INSERT_FAILED: ID = 20, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATLOG_INSERT_FAILED 20, "SQLMan", __FILE__, __LINE__, "Internal insert into SYSUPDSTATLOG failed, error $ERRORTEXT$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATLOG_INSERT_FAILED__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message UPDSTATLOG_INSERT_FAILED */
/* Begin of defines for message UPDSTATWANTED_INSERT_FAILED: ID = 21, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATWANTED_INSERT_FAILED 21, "SQLMan", __FILE__, __LINE__, "Internal insert into SYSUPDSTATWANTED failed, error $ERRORTEXT$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATWANTED_INSERT_FAILED__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message UPDSTATWANTED_INSERT_FAILED */
/* Begin of defines for message UPDSTATWANTED_CREATESTATEMENT_FAILED: ID = 22, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATWANTED_CREATESTATEMENT_FAILED 22, "SQLMan", __FILE__, __LINE__, "Creation of internal connection failed; error $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATWANTED_CREATESTATEMENT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTATWANTED_CREATESTATEMENT_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED: ID = 23, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED 23, "SQLMan", __FILE__, __LINE__, "Creation of internal delete statement failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED: ID = 24, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED 24, "SQLMan", __FILE__, __LINE__, "Creation of internal select statement failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_TABLE_CATALOG_ERR: ID = 25, VERSION = 2, TAGS = 4 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR 25, "SQLMan", __FILE__, __LINE__, "Unexpected error when retrieving table descriptor, error '$ERRORTEXT$'", (Msg_Has4Args*)0, Msg_Arg("_MESSAGEVERSION", 2)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR__RETURNCODE "RETURNCODE"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR__TABID "TABID"
/* <- End of defines for message UPDATECOUNTERWANTED_TABLE_CATALOG_ERR */
/* Begin of defines for message UPDATECOUNTERWANTED_INDEX_CATALOG_ERR: ID = 26, VERSION = 3, TAGS = 5 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR 26, "SQLMan", __FILE__, __LINE__, "Unexpected error when retrieving index descriptor, error '$ERRORTEXT$'", (Msg_Has5Args*)0, Msg_Arg("_MESSAGEVERSION", 3)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR__INDEX "INDEX"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR__RETURNCODE "RETURNCODE"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR__TABID "TABID"
/* <- End of defines for message UPDATECOUNTERWANTED_INDEX_CATALOG_ERR */
/* Begin of defines for message UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR: ID = 27, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR 27, "SQLMan", __FILE__, __LINE__, "Error when binding parameters for internal SQL statement", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR */
/* Begin of defines for message UPDATECOUNTERWANTED_DELETE_FAILED: ID = 28, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_DELETE_FAILED 28, "SQLMan", __FILE__, __LINE__, "Could not delete row in 'SYSUPDATECOUNTERWANTED', error '$ERRORTEXT$'", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_DELETE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_DELETE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDATECOUNTERWANTED_DELETE_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_SELECT_FAILED: ID = 29, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_SELECT_FAILED 29, "SQLMan", __FILE__, __LINE__, "Could not select from 'SYSUPDATECOUNTERWANTED', error '$ERRORTEXT$'", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_SELECT_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_SELECT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDATECOUNTERWANTED_SELECT_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR: ID = 30, VERSION = 3, TAGS = 5 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR 30, "SQLMan", __FILE__, __LINE__, "Unexpected error when retrieving table descriptor in iterator, error '$ERRORTEXT$'", (Msg_Has5Args*)0, Msg_Arg("_MESSAGEVERSION", 3)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR__RETURNCODE "RETURNCODE"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR__SCHEMANAME "SCHEMANAME"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR__TABLENAME "TABLENAME"
/* <- End of defines for message UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR */
/* Begin of defines for message INTERNALTRANS_CREATE_FAILED: ID = 31, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_INTERNALTRANS_CREATE_FAILED 31, "SQLMan", __FILE__, __LINE__, "Could not create internal transaction, basis error '$ERRORTEXT$'", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_INTERNALTRANS_CREATE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_INTERNALTRANS_CREATE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message INTERNALTRANS_CREATE_FAILED */
/* Begin of defines for message INTERNALTRANS_CLOSE_FAILED: ID = 32, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_SQLMAN_INTERNALTRANS_CLOSE_FAILED 32, "SQLMan", __FILE__, __LINE__, "Error during close of internal transaction, base error '$ERRORTEXT$'", (Msg_Has4Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_INTERNALTRANS_CLOSE_FAILED__COMMAND_NAME "COMMAND_NAME"
#define SDBMSGTAG_SQLMAN_INTERNALTRANS_CLOSE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_INTERNALTRANS_CLOSE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message INTERNALTRANS_CLOSE_FAILED */
/* Begin of defines for message UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR: ID = 33, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR 33, "SQLMan", __FILE__, __LINE__, "Unexpected error while retrieving index descriptor in iterator, error '$ERRORTEXT$'", (Msg_Has5Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR__RETURNCODE "RETURNCODE"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR__TABID "TABID"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR__INDEXNAME "INDEXNAME"
/* <- End of defines for message UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR */
/* Begin of defines for message UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR: ID = 34, VERSION = 1, TAGS = 6 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR 34, "SQLMan", __FILE__, __LINE__, "Error when removing broken row, error '$ERRORTEXT$'", (Msg_Has6Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR__RETURNCODE "RETURNCODE"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR__INDEXNAME "INDEXNAME"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR__SCHEMANAME "SCHEMANAME"
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR__TABLENAME "TABLENAME"
/* <- End of defines for message UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR */
/* Begin of defines for message UPDCNT_LOCK_TABLE_FAILED: ID = 35, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_SQLMAN_UPDCNT_LOCK_TABLE_FAILED 35, "SQLMan", __FILE__, __LINE__, "Table '$FILENO$' could not be locked, error '$ERRORTEXT$'", (Msg_Has4Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDCNT_LOCK_TABLE_FAILED__BASIS_ERROR "BASIS_ERROR"
#define SDBMSGTAG_SQLMAN_UPDCNT_LOCK_TABLE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDCNT_LOCK_TABLE_FAILED__FILENO "FILENO"
/* <- End of defines for message UPDCNT_LOCK_TABLE_FAILED */
/* Begin of defines for message UPDCNT_PREPARE_FAILED: ID = 36, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDCNT_PREPARE_FAILED 36, "SQLMan", __FILE__, __LINE__, "Preparation of server task job for table '$FILENO$' failed", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDCNT_PREPARE_FAILED__FILENO "FILENO"
/* <- End of defines for message UPDCNT_PREPARE_FAILED */
/* Begin of defines for message UPDCNT_START_JOB_FAILED: ID = 37, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_START_JOB_FAILED 37, "SQLMan", __FILE__, __LINE__, "Start of update counter job failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_START_JOB_FAILED */
/* Begin of defines for message UPDCNT_STARTED: ID = 38, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_STARTED 38, "SQLMan", __FILE__, __LINE__, "Background initialisation of file directory statistics counters started", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_STARTED */
/* Begin of defines for message UPDCNT_FINISHED: ID = 39, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_FINISHED 39, "SQLMan", __FILE__, __LINE__, "Background initialisation of file directory statistics counters finished successfully", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_FINISHED */
/* Begin of defines for message UPDCNT_CANCELLED: ID = 40, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_CANCELLED 40, "SQLMan", __FILE__, __LINE__, "Background initialisation of file directory statistics counters cancelled", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_CANCELLED */
/* Begin of defines for message UPDCNT_SYSTEM_ERROR: ID = 41, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_SYSTEM_ERROR 41, "SQLMan", __FILE__, __LINE__, "Background initialisation of file directory statistics counters aborted", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_SYSTEM_ERROR */
/* Begin of defines for message UPDCNT_CHECK_TABLE_CANCELLED: ID = 42, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDCNT_CHECK_TABLE_CANCELLED 42, "SQLMan", __FILE__, __LINE__, "Background initialisation of file directory statistics counters for file '$FILENO$' delayed", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDCNT_CHECK_TABLE_CANCELLED__FILENO "FILENO"
/* <- End of defines for message UPDCNT_CHECK_TABLE_CANCELLED */
/* Begin of defines for message UPDCNT_OUT_OF_MEMORY_IGNORED: ID = 43, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDCNT_OUT_OF_MEMORY_IGNORED 43, "SQLMan", __FILE__, __LINE__, "Could not allocate $ALLOC_SIZE$ bytes, trying to go on", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDCNT_OUT_OF_MEMORY_IGNORED__ALLOC_SIZE "ALLOC_SIZE"
/* <- End of defines for message UPDCNT_OUT_OF_MEMORY_IGNORED */
/* Begin of defines for message UPDATECOUNTERWANTED_DELETE_BROKEN_ERR: ID = 44, VERSION = 2, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDATECOUNTERWANTED_DELETE_BROKEN_ERR 44, "SQLMan", __FILE__, __LINE__, "Error when removing broken row", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 2)
#define SDBMSGTAG_SQLMAN_UPDATECOUNTERWANTED_DELETE_BROKEN_ERR__FILENO "FILENO"
/* <- End of defines for message UPDATECOUNTERWANTED_DELETE_BROKEN_ERR */
/* Begin of defines for message UPDCNT_NOTHING_TO_DO: ID = 45, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_NOTHING_TO_DO 45, "SQLMan", __FILE__, __LINE__, "All file directory statistics counters initialized", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_NOTHING_TO_DO */
/* Begin of defines for message UPDCNT_SYSERR_WAITFORJOB: ID = 47, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_SYSERR_WAITFORJOB 47, "SQLMan", __FILE__, __LINE__, "System error occured while waiting for server task to finish", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_SYSERR_WAITFORJOB */
/* Begin of defines for message UPDCNT_SAVEPOINT_ERROR: ID = 48, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDCNT_SAVEPOINT_ERROR 48, "SQLMan", __FILE__, __LINE__, "Unexpected error when trying to write savepoint: $BASIS_ERROR$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDCNT_SAVEPOINT_ERROR__BASIS_ERROR "BASIS_ERROR"
/* <- End of defines for message UPDCNT_SAVEPOINT_ERROR */
/* Begin of defines for message UPDCNT_ERROR_COMMIT_LOGTABLE: ID = 49, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDCNT_ERROR_COMMIT_LOGTABLE 49, "SQLMan", __FILE__, __LINE__, "Unexpected error while committing changes to request table", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDCNT_ERROR_COMMIT_LOGTABLE */
/* Begin of defines for message UPDSTATLOG_INTERNAL_PREPARE_FAILED: ID = 50, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SQLMAN_UPDSTATLOG_INTERNAL_PREPARE_FAILED 50, "SQLMan", __FILE__, __LINE__, "Prepare of internal SQL statement failed, rc = $RETURNCODE$", (Msg_Has2Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATLOG_INTERNAL_PREPARE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTATLOG_INTERNAL_PREPARE_FAILED */
/* Begin of defines for message UPDSTAT_INSERT_FAILED: ID = 51, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDSTAT_INSERT_FAILED 51, "SQLMan", __FILE__, __LINE__, "System error during update of table SYSUPDSTATLOG", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDSTAT_INSERT_FAILED */
/* Begin of defines for message UPDSTATWANTED_DELETE_FAILED: ID = 52, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SQLMAN_UPDSTATWANTED_DELETE_FAILED 52, "SQLMan", __FILE__, __LINE__, "Could not delete row in 'SYSUPDATECOUNTERWANTED', error '$ERRORTEXT$'", (Msg_Has3Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
#define SDBMSGTAG_SQLMAN_UPDSTATWANTED_DELETE_FAILED__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SQLMAN_UPDSTATWANTED_DELETE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message UPDSTATWANTED_DELETE_FAILED */
/* Begin of defines for message UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED: ID = 53, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED 53, "SQLMan", __FILE__, __LINE__, "Creation of internal delete statement for SYSUPDSTATWANTED failed", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED */
/* Begin of defines for message UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR: ID = 54, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SQLMAN_UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR 54, "SQLMan", __FILE__, __LINE__, "Error when binding parameters for internal SQL statement for table SYSUPDSTATWANTED", (Msg_Has1Args*)0, Msg_Arg("_MESSAGEVERSION", 1)
/* <- End of defines for message UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR */
/* <- End of message defines for component SQLMan */

/* some helpful enumerations (created by buildmsg.pl) -> */

#define SDBMSG_SQLMAN_ENUMERATION \
                    SQLMan_NO_MEMORY=1, \
                    SQLMan_STORE_PLAN_FAILED=2, \
                    SQLMan_NOT_INITIALIZED=3, \
                    SQLMan_UPDSTAT_ADDTOREQUESTFILE_FAILED=4, \
                    SQLMan_UPDSTATLOG_PREPARE_FAILED=5, \
                    SQLMan_UPDSTATLOG_NEWCONTEXT_FAILED=6, \
                    SQLMan_UPDSTATLOG_CREATESTATEMENT_FAILED=7, \
                    SQLMan_UPDATESTAT_IGNORE_INSERT_RETURN=8, \
                    SQLMan_UPDSTAT_INSERT_LOCK_COLLISION=9, \
                    SQLMan_UPDSTAT_STORE_STATISTICS_FAILED=10, \
                    SQLMan_UPDSTAT_INVALID_TABLE_TYPE=11, \
                    SQLMan_UPDSTAT_LOCK_TABLE_FAILED=12, \
                    SQLMan_UPDSTAT_GET_TABLE_FAILED=13, \
                    SQLMan_CHECKTABLELOG_NEWCONTEXT_FAILED=14, \
                    SQLMan_CHECKTABLELOG_CREATESTATEMENT_FAILED=15, \
                    SQLMan_CHECKTABLELOG_PREPARE_UPDATE_FAILED=16, \
                    SQLMan_CHECKTABLELOG_PREPARE_PARAMS_FAILED=17, \
                    SQLMan_CHECKTABLELOG_PREPARE_INSERT_FAILED=18, \
                    SQLMan_CHECKTABLELOG_SWITCH_USER_FAILED=19, \
                    SQLMan_UPDSTATLOG_INSERT_FAILED=20, \
                    SQLMan_UPDSTATWANTED_INSERT_FAILED=21, \
                    SQLMan_UPDSTATWANTED_CREATESTATEMENT_FAILED=22, \
                    SQLMan_UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED=23, \
                    SQLMan_UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED=24, \
                    SQLMan_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR=25, \
                    SQLMan_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR=26, \
                    SQLMan_UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR=27, \
                    SQLMan_UPDATECOUNTERWANTED_DELETE_FAILED=28, \
                    SQLMan_UPDATECOUNTERWANTED_SELECT_FAILED=29, \
                    SQLMan_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR=30, \
                    SQLMan_INTERNALTRANS_CREATE_FAILED=31, \
                    SQLMan_INTERNALTRANS_CLOSE_FAILED=32, \
                    SQLMan_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR=33, \
                    SQLMan_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR=34, \
                    SQLMan_UPDCNT_LOCK_TABLE_FAILED=35, \
                    SQLMan_UPDCNT_PREPARE_FAILED=36, \
                    SQLMan_UPDCNT_START_JOB_FAILED=37, \
                    SQLMan_UPDCNT_STARTED=38, \
                    SQLMan_UPDCNT_FINISHED=39, \
                    SQLMan_UPDCNT_CANCELLED=40, \
                    SQLMan_UPDCNT_SYSTEM_ERROR=41, \
                    SQLMan_UPDCNT_CHECK_TABLE_CANCELLED=42, \
                    SQLMan_UPDCNT_OUT_OF_MEMORY_IGNORED=43, \
                    SQLMan_UPDATECOUNTERWANTED_DELETE_BROKEN_ERR=44, \
                    SQLMan_UPDCNT_NOTHING_TO_DO=45, \
                    SQLMan_UPDCNT_SYSERR_WAITFORJOB=47, \
                    SQLMan_UPDCNT_SAVEPOINT_ERROR=48, \
                    SQLMan_UPDCNT_ERROR_COMMIT_LOGTABLE=49, \
                    SQLMan_UPDSTATLOG_INTERNAL_PREPARE_FAILED=50, \
                    SQLMan_UPDSTAT_INSERT_FAILED=51, \
                    SQLMan_UPDSTATWANTED_DELETE_FAILED=52, \
                    SQLMan_UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED=53, \
                    SQLMan_UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR=54
#define SDBMSG_SQLMAN_INITIALIZATIONLIST(x) \
                    x(SDBMSG_SQLMAN_NO_MEMORY, "NO_MEMORY"), \
                    x(SDBMSG_SQLMAN_STORE_PLAN_FAILED, "STORE_PLAN_FAILED"), \
                    x(SDBMSG_SQLMAN_NOT_INITIALIZED, "NOT_INITIALIZED"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_ADDTOREQUESTFILE_FAILED, "UPDSTAT_ADDTOREQUESTFILE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATLOG_PREPARE_FAILED, "UPDSTATLOG_PREPARE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATLOG_NEWCONTEXT_FAILED, "UPDSTATLOG_NEWCONTEXT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATLOG_CREATESTATEMENT_FAILED, "UPDSTATLOG_CREATESTATEMENT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATESTAT_IGNORE_INSERT_RETURN, "UPDATESTAT_IGNORE_INSERT_RETURN"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_INSERT_LOCK_COLLISION, "UPDSTAT_INSERT_LOCK_COLLISION"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_STORE_STATISTICS_FAILED, "UPDSTAT_STORE_STATISTICS_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_INVALID_TABLE_TYPE, "UPDSTAT_INVALID_TABLE_TYPE"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_LOCK_TABLE_FAILED, "UPDSTAT_LOCK_TABLE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_GET_TABLE_FAILED, "UPDSTAT_GET_TABLE_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_NEWCONTEXT_FAILED, "CHECKTABLELOG_NEWCONTEXT_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_CREATESTATEMENT_FAILED, "CHECKTABLELOG_CREATESTATEMENT_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_UPDATE_FAILED, "CHECKTABLELOG_PREPARE_UPDATE_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_PARAMS_FAILED, "CHECKTABLELOG_PREPARE_PARAMS_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_PREPARE_INSERT_FAILED, "CHECKTABLELOG_PREPARE_INSERT_FAILED"), \
                    x(SDBMSG_SQLMAN_CHECKTABLELOG_SWITCH_USER_FAILED, "CHECKTABLELOG_SWITCH_USER_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATLOG_INSERT_FAILED, "UPDSTATLOG_INSERT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATWANTED_INSERT_FAILED, "UPDSTATWANTED_INSERT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATWANTED_CREATESTATEMENT_FAILED, "UPDSTATWANTED_CREATESTATEMENT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED, "UPDATECOUNTERWANTED_INTERNAL_DELETE_STMT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED, "UPDATECOUNTERWANTED_INTERNAL_ITSELECT_STMT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_TABLE_CATALOG_ERR, "UPDATECOUNTERWANTED_TABLE_CATALOG_ERR"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INDEX_CATALOG_ERR, "UPDATECOUNTERWANTED_INDEX_CATALOG_ERR"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR, "UPDATECOUNTERWANTED_INTERNAL_DELETE_PARAM_BIND_ERR"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_DELETE_FAILED, "UPDATECOUNTERWANTED_DELETE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_SELECT_FAILED, "UPDATECOUNTERWANTED_SELECT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR, "UPDATECOUNTERWANTED_IT_TABLE_CATALOG_ERR"), \
                    x(SDBMSG_SQLMAN_INTERNALTRANS_CREATE_FAILED, "INTERNALTRANS_CREATE_FAILED"), \
                    x(SDBMSG_SQLMAN_INTERNALTRANS_CLOSE_FAILED, "INTERNALTRANS_CLOSE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR, "UPDATECOUNTERWANTED_IT_INDEX_CATALOG_ERR"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR, "UPDATECOUNTERWANTED_REMOVE_BROKEN_ERR"), \
                    x(SDBMSG_SQLMAN_UPDCNT_LOCK_TABLE_FAILED, "UPDCNT_LOCK_TABLE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_PREPARE_FAILED, "UPDCNT_PREPARE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_START_JOB_FAILED, "UPDCNT_START_JOB_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_STARTED, "UPDCNT_STARTED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_FINISHED, "UPDCNT_FINISHED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_CANCELLED, "UPDCNT_CANCELLED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_SYSTEM_ERROR, "UPDCNT_SYSTEM_ERROR"), \
                    x(SDBMSG_SQLMAN_UPDCNT_CHECK_TABLE_CANCELLED, "UPDCNT_CHECK_TABLE_CANCELLED"), \
                    x(SDBMSG_SQLMAN_UPDCNT_OUT_OF_MEMORY_IGNORED, "UPDCNT_OUT_OF_MEMORY_IGNORED"), \
                    x(SDBMSG_SQLMAN_UPDATECOUNTERWANTED_DELETE_BROKEN_ERR, "UPDATECOUNTERWANTED_DELETE_BROKEN_ERR"), \
                    x(SDBMSG_SQLMAN_UPDCNT_NOTHING_TO_DO, "UPDCNT_NOTHING_TO_DO"), \
                    x(SDBMSG_SQLMAN_UPDCNT_SYSERR_WAITFORJOB, "UPDCNT_SYSERR_WAITFORJOB"), \
                    x(SDBMSG_SQLMAN_UPDCNT_SAVEPOINT_ERROR, "UPDCNT_SAVEPOINT_ERROR"), \
                    x(SDBMSG_SQLMAN_UPDCNT_ERROR_COMMIT_LOGTABLE, "UPDCNT_ERROR_COMMIT_LOGTABLE"), \
                    x(SDBMSG_SQLMAN_UPDSTATLOG_INTERNAL_PREPARE_FAILED, "UPDSTATLOG_INTERNAL_PREPARE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTAT_INSERT_FAILED, "UPDSTAT_INSERT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATWANTED_DELETE_FAILED, "UPDSTATWANTED_DELETE_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED, "UPDSTATWANTED_INTERNAL_DELETE_STMT_FAILED"), \
                    x(SDBMSG_SQLMAN_UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR, "UPDSTATWANTED_INTERNAL_DELETE_PARAM_BIND_ERR")
/* <- some helpful enumerations */

#endif /* SDBMSG_SQLMAN_H */
