/*!
  @defgroup   IOManagement I/O Management
*/
/*!
  @file     IOMan_Types.hpp
  @author   TorstenS
  @ingroup  IOManagement
  @brief    Basic types of this component
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/


#ifndef IOMAN_TYPES_HPP
#define IOMAN_TYPES_HPP

#include "KernelCommon/Kernel_Common.hpp"
#include "SAPDBCommon/SAPDB_EnhancedTypes.hpp"

#include "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include "SAPDBCommon/Diagnostics/SAPDBDiag_CheckTopic.hpp"


/// external reference of IOManager trace
extern SAPDBTrace_Topic     IOMan_Trace;

/// external reference of IOManager checks
extern SAPDBDiag_CheckTopic IOMan_Check;

/// Logical volume number
typedef SAPDB_Invalidatable<SAPDB_Int2, SAPDB_MAX_INT2> IOMan_DeviceNo;

/// Logical volume number
typedef SAPDB_Invalidatable<SAPDB_Int2, SAPDB_MAX_INT2> IOMan_VolumeNo;

/// Logical block offset on volume

typedef SAPDB_Invalidatable<SAPDB_Int4, SAPDB_MAX_INT4> IOMan_BlockNo;

/// Number of blocks

typedef SAPDB_Int4 IOMan_BlockCount;

/// Number of clusters

typedef SAPDB_UInt4 IOMan_ClusterCount;

/// cluster number

typedef SAPDB_UInt4 IOMan_ClusterNo;

/// ReturnCodes of component I/O Manager

typedef enum
{
    IOMan_Okay = 0,
    IOMan_NotConfigured,
    IOMan_AttachFailed,
    IOMan_ConfigurationCorrupted,
    IOMan_FormatFailed,
    IOMan_BadVolume,
    IOMan_VolumeCapacityMismatch,
    IOMan_ReadError,
    IOMan_WriteError,
    IOMan_BadInfoPage,
    IOMan_NoConverterEntry,
    IOMan_BadDataPage,
    IOMan_NotPreparedForMigration,
    IOMan_NoMoreMemory,
    IOMan_PageNoOutOfRange,
    IOMan_SystemError,
    IOMan_DropCanceled,
    IOMan_DropDBFull,
    IOMan_DropNotPossible,
    IOMan_DropFailed,
    IOMan_LAST_AND_NOT_USEABLE_ENUM
    // 1. do not use
    // 2. do not append after this
    // 3. do update IOMan_ReturnCodeStrings
} IOMan_ReturnCode;

/// string mapping for IOMan return codes / IOMan_ReturnCode
inline const SAPDB_Char*
IOMan_ReturnCodeStrings( const IOMan_ReturnCode  retCode )
{
    switch( retCode )
    {
    case IOMan_Okay:                    return(( SAPDB_Char* )"Okay" );
    case IOMan_NotConfigured:           return(( SAPDB_Char* )"VolumeNotConfigured" );
    case IOMan_AttachFailed:            return(( SAPDB_Char* )"AttachFailed" );
    case IOMan_ConfigurationCorrupted:  return(( SAPDB_Char* )"ConfigurationCorrupted" );
    case IOMan_FormatFailed:            return(( SAPDB_Char* )"FormatFailed" );
    case IOMan_BadVolume:               return(( SAPDB_Char* )"BadVolume" );
    case IOMan_VolumeCapacityMismatch:  return(( SAPDB_Char* )"VolumeCapacityMismatch" );
    case IOMan_ReadError:               return(( SAPDB_Char* )"ReadError" );
    case IOMan_WriteError:              return(( SAPDB_Char* )"WriteError" );
    case IOMan_BadInfoPage:             return(( SAPDB_Char* )"BadInfoPage" );
    case IOMan_NoConverterEntry:        return(( SAPDB_Char* )"NoConverterEntry" );
    case IOMan_BadDataPage:             return(( SAPDB_Char* )"BadDataPage" );
    case IOMan_NotPreparedForMigration: return(( SAPDB_Char* )"NotPreparedForMigration" );
    case IOMan_NoMoreMemory:            return(( SAPDB_Char* )"NoMorememory" );
    case IOMan_PageNoOutOfRange:        return(( SAPDB_Char* )"PageNoOutOfRange" );
    case IOMan_SystemError:             return(( SAPDB_Char* )"SystemError" );
    case IOMan_DropCanceled:            return(( SAPDB_Char* )"DropCanceled" );
    case IOMan_DropDBFull:              return(( SAPDB_Char* )"DropDBFull" );
    case IOMan_DropNotPossible:         return(( SAPDB_Char* )"DropNotPossible" );
    case IOMan_DropFailed:              return(( SAPDB_Char* )"DropFailed" );
    default:                            return(( SAPDB_Char* )"Unknown" );
    }
}

#endif // IOMAN_TYPES_HPP

