/*!**************************************************************************

  module      : Data_PrimPageAccess.hpp

  -------------------------------------------------------------------------

  responsible : Henrik

  special area: Data Base Page
  description : This module is used to encapsulate the data page pascal
                implementaion for the I/O management 
                
  last changed: 2004-04-21  8:43
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 2001-2005 SAP AG

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


#ifndef DATA_BASEPRIMPAGEACCESS_HPP
#define DATA_BASEPRIMPAGEACCESS_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "DataAccess/Data_BasePage.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!*****************************************************************************

   class: Data_PrimPageAccess

   description: This class is the encapsulate the data page pascal 
                implementaion for the I/O management.

                This class is needed to separate the data page I/O properties
                from the data page cache protperties, implemented by the derived
                class Data_Page.
              
*******************************************************************************/

class Data_PrimPageAccess : public Data_BasePage
{
public:

    /* -----------------------------------------------------------------------*/
    /*! chapter: Type definitions                                             */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Type definitions                                          */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Constructors and initialization                              */
    /* -----------------------------------------------------------------------*/

    /*!-------------------------------------------------------------------------
    function:     Data_PrimPageAccess()
    description:  This is the default constructor 
    arguments:    none
    return value: none
    --------------------------------------------------------------------------*/

    Data_PrimPageAccess(){}

    Data_PrimPageAccess( tbd_nodeptr pNode )
    {
        m_Frame.Assign( pNode, sizeof( *pNode ));
    }


    /* -----------------------------------------------------------------------*/
    /*! endchapter: Constructors and initialization                           */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Data Base Page I/O management access                         */
    /* -----------------------------------------------------------------------*/

    /// The root page no is returned.
    Data_PageNo RootPageNo () const
    {
        SAPDBERR_ASSERT_STATE(IsAssigned());
        return STATIC_CAST(Data_PageNo,NodePtr()->nd_root());
    }

    /// The frames page no is returned.
    Data_PageNo PageNo () const
    {
        SAPDBERR_ASSERT_STATE(IsAssigned());

        return STATIC_CAST(Data_PageNo, NodePtr()->nd_id());
    }

    /*!-------------------------------------------------------------------------
    function:     GetRecordCount()
    description:  This method returns the number of records stored on the page
    arguments:    none
    return value: Data_RecordCount
    --------------------------------------------------------------------------*/

    Data_RecordCount GetRecordCount() const
    {
        SAPDBERR_ASSERT_STATE( IsAssigned() );

        return( static_cast< Data_RecordCount >( NodePtr()->nd_record_cnt() ));
    }

    /*!-------------------------------------------------------------------------
    function:     GetRecord()
    description:  This method returns a pointer to the record specified by
                  the given record index.
    arguments:    recordIndex [in]
    return value: tgg00_Rec*
    --------------------------------------------------------------------------*/

    tgg00_Rec* GetRecord( const Data_RecordIndex recordIndex ) 
    {
        SAPDBERR_ASSERT_STATE( recordIndex < GetRecordCount());

        const Data_PageOffset recordPosition =
            NodePtr()->nd_pointer_list()[ MAX_POINTERINDEX_BD00 - recordIndex - POS_OFF_DIFF_BD00 ];

        return( reinterpret_cast< tgg00_Rec* >( FramePtr() + recordPosition - POS_OFF_DIFF_BD00 ));
    }

    const tgg00_Rec* GetRecord( const Data_RecordIndex recordIndex ) const
    {
        SAPDBERR_ASSERT_STATE( recordIndex < GetRecordCount());

        const Data_PageOffset recordPosition =
            NodePtr()->nd_pointer_list()[ MAX_POINTERINDEX_BD00 - recordIndex - POS_OFF_DIFF_BD00 ];

        return reinterpret_cast< const tgg00_Rec* >( FramePtr() + recordPosition - POS_OFF_DIFF_BD00 );
    }

    /*!-------------------------------------------------------------------------
    function:     GetFirstRecord()
    description:  This method returns a pointer to the record which contains
                  the smallest key. It is assumed that at least one record 
                  exist.
    arguments:    none
    return value: tgg00_Rec*
    --------------------------------------------------------------------------*/

    tgg00_Rec* GetFirstRecord() 
    {
        SAPDBERR_ASSERT_STATE( 0 != GetRecordCount());

        return GetRecord( FIRST_REC_INDEX_BD00 );
    }

    /*!-------------------------------------------------------------------------
    function:     GetLevel()
    description:  This method returns the tree level of the page
    arguments:    none
    return value: tsp00_Int2
    --------------------------------------------------------------------------*/
    tsp00_Int2 GetLevel()
    {
        return NodePtr()->nd_level();
    }

};

/*!*****************************************************************************

   endclass: Data_PrimPageAccess

*******************************************************************************/

#endif  /* DATA_BASEPRIMPAGEACCESS_HPP */
