/*!
  -----------------------------------------------------------------------------
  module: error.hpp
  -----------------------------------------------------------------------------
  responsible:  MartinR
  special area: DBanalyzer - The performance analyse tool for SAPDB
  description:  dbanalyzer error handling
  version:      7.4 and higher 
  -----------------------------------------------------------------------------

  Copyright (c) 2002-2005 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




  -----------------------------------------------------------------------------
*/

#ifndef _ERROR_HPP_
#define _ERROR_HPP_

#include "SAPDB/DBanalyzer/types.hpp"

#define DBA_ERRTXT_OK           "OK"
#define DBA_ERRTXT_ERR          "Common error."
#define DBA_ERRTXT_ARGS         "Invalid/incomplete program arguments."
#define DBA_ERRTXT_OPENFILE     "Cannot open file '%s'."
#define DBA_ERRTXT_CONNECT      "Cannot connect to database."
#define DBA_ERRTXT_EXECUTE      "Cannot execute SQL statement."
#define DBA_ERRTXT_INVCONFIGKEY "Invalid key in configuration (Line %s)."
#define DBA_ERRTXT_NOMEM        "Cannot allocate memory."
#define DBA_ERRTXT_PARSE        "Cannot parse expression for %s."
#define DBA_ERRTXT_CALC         "Cannot calculate expression for %s."
#define DBA_ERRTXT_TYPE         "Expression result type do not match for %s."
#define DBA_WRNTXT_CALC         "Cannot calculate expression for %s."
#define DBA_ERRTXT_CREATEDIR    "Cannot create directory %s."
#define DBA_ERRTXT_ACTIVE       "Database Analyzer active in directory \"%s\"."
#define DBA_ERRTXT_OTHERDB      "Data for database %s exist in directory \"%s\"."
#define DBA_ERRTXT_UNKNOWNOBJ   "Unknown object %s."
#define DBA_ERRTXT_DUPLICATE    "Duplicate object identifier %s (Line %s)."
#define DBA_ERRTXT_FORMTAB      "Formula and Table property not allowed for parameter %s (Line %s)."
#define DBA_ERRTXT_KILL         "Cannot stop process."
#define DBA_ERRTXT_UNKNOWNVAL   "Cannot find value %s in object %s."
#define DBA_ERRTXT_NOTACTIVE    "Database Analyzer not active in directory \"%s\"."
#define DBA_ERRTXT_PREPARE      "Cannot prepare SQL statement."

#define DBA_ERRTXT_UNKNOWN  "Unknown error."

typedef enum {
  DBA_OK            = 0,
  DBA_ERR,
  DBA_ERR_ARGS,
  DBA_ERR_OPENFILE,
  DBA_ERR_CONNECT,
  DBA_ERR_EXECUTE,
  DBA_ERR_INVCONFIGKEY,
  DBA_ERR_NOMEM,
  DBA_ERR_PARSE,
  DBA_ERR_CALC,
  DBA_ERR_TYPE,
  DBA_WRN_CALC,
  DBA_ERR_CREATEDIR,
  DBA_ERR_ACTIVE,
  DBA_ERR_OTHERDB,
  DBA_ERR_UNKNOWNOBJ,
  DBA_ERR_DUPLICATE,
  DBA_ERR_FORMTAB,
  DBA_ERR_KILL,
  DBA_ERR_UNKNOWNVAL,
  DBA_ERR_NOTACTIVE,
  DBA_ERR_PREPARE,
  DBA_ERR_UNKOWN
} DBA_errornum;

// forward declaration
class DBA_protocol;

class DBA_error {
  public:
  DBA_error ();
  ~DBA_error ();

  DBA_void Clear ();

  DBA_errornum GetError() { return m_nNumber;}

  DBA_void SetError(const DBA_errornum nNumber);
  DBA_void SetError(const DBA_errornum nNumber, 
                    const DBA_string & sValue1);
  DBA_void SetError(const DBA_errornum nNumber, 
                    const DBA_string & sValue1,
                    const DBA_string & sValue2);
  DBA_void SetError(const DBA_errornum nNumber, 
                    const DBA_string & sValue1,
                    const DBA_string & sValue2,
                    const DBA_string & sValue3);

  DBA_void SetExtText(const DBA_string & sExtText); 

  DBA_string GetErrorMsg();
  DBA_void ShowErrorMsg( DBA_protocol * pProtocol, DBA_bool bInfo = false );

  DBA_void SetReconnect(const DBA_bool bReconnect);
  DBA_bool GetReconnect();

  DBA_void SetIgnore(const DBA_bool bIgnore);
  DBA_bool GetIgnore();

  private:
  DBA_errornum m_nNumber;
  DBA_int      m_nValues;
  DBA_string   m_sValue1;
  DBA_string   m_sValue2;
  DBA_string   m_sValue3;
  DBA_string   m_sExtText;
  DBA_bool     m_bReconnect;
  DBA_bool     m_bIgnore;
};


#endif