/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.udeserver.ClassLoaderError;
import com.sap.dbtech.udeserver.TypeDirectory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodFromString {
    private ClassLoader classLoader;
    private String prototype;
    private String className;
    private String methodName;
    private Vector parameterClassnames;
    private Class clazz;
    private boolean hasParameterPrototypes;

    public MethodFromString(ClassLoader classLoader, String string) {
        this.classLoader = classLoader;
        this.prototype = string.trim();
    }

    public MethodFromString(String string) {
        this(ClassLoader.getSystemClassLoader(), string);
    }

    public Method findMethod() throws ClassLoaderError {
        this.parsePrototype();
        try {
            this.clazz = this.classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassLoaderError("Class '" + this.className + "' not found");
        }
        if (this.hasParameterPrototypes) {
            return this.findMethodByNameAndParameters();
        }
        return this.findMethodByName();
    }

    protected Method findMethodByNameAndParameters() throws ClassLoaderError {
        Method method;
        Class[] classArray = new Class[this.parameterClassnames.size()];
        for (int i = 0; i < classArray.length; ++i) {
            String string = (String)this.parameterClassnames.get(i);
            if (string.charAt(string.length() - 1) == ']') {
                string = this.arrayclassName(string);
            }
            classArray[i] = (Class)TypeDirectory.byName.get(string);
            if (classArray[i] != null) continue;
            try {
                classArray[i] = this.classLoader.loadClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassLoaderError("Class '" + string + "' of parameter " + i + " not found");
            }
        }
        try {
            method = this.clazz.getMethod(this.methodName, classArray);
            if (!this.isValidSQLJ(method)) {
                throw new ClassLoaderError("methods must be public and static");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClassLoaderError("no matching method found for " + this.methodName);
        }
        return method;
    }

    protected Method findMethodByName() throws ClassLoaderError {
        Method method = null;
        Method[] methodArray = this.clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!this.isValidSQLJ(method2, this.methodName)) continue;
            if (method == null) {
                method = method2;
                continue;
            }
            throw new ClassLoaderError("multiple methods named " + this.methodName);
        }
        if (method == null) {
            throw new ClassLoaderError("no method named " + this.methodName);
        }
        return method;
    }

    protected boolean isValidSQLJ(Method method) {
        int n = method.getModifiers();
        if (!Modifier.isStatic(n)) {
            return false;
        }
        return Modifier.isPublic(n);
    }

    protected boolean isValidSQLJ(Method method, String string) {
        if (!method.getName().equals(string)) {
            return false;
        }
        return this.isValidSQLJ(method);
    }

    protected void parsePrototype() throws ClassLoaderError {
        int n;
        char[] cArray = this.prototype.toCharArray();
        int n2 = -1;
        for (n = 0; n < cArray.length && cArray[n] != '('; ++n) {
            if (cArray[n] != '.') continue;
            n2 = n;
        }
        if (n2 == -1) {
            throw new ClassLoaderError("definition string must be of the form <classname>.<methodname>");
        }
        this.className = this.prototype.substring(0, n2);
        this.methodName = this.prototype.substring(n2 + 1, n).trim();
        if (n >= cArray.length) {
            this.hasParameterPrototypes = false;
        } else {
            String string;
            this.hasParameterPrototypes = true;
            this.parameterClassnames = new Vector();
            int n3 = ++n;
            while (n < cArray.length && cArray[n] != ')') {
                if (cArray[n] == ',') {
                    string = this.prototype.substring(n3, n);
                    this.parameterClassnames.add(string.trim());
                    n3 = n + 1;
                }
                ++n;
            }
            string = this.prototype.substring(n3, n);
            this.parameterClassnames.add(string.trim());
        }
    }

    protected String arrayclassName(String string) {
        char[] cArray = string.toCharArray();
        int n = -1;
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] != '[') continue;
            n = i;
            break;
        }
        if (n != -1) {
            string = string.substring(0, n).trim();
        }
        String string2 = "[L" + string + ";";
        return string2;
    }

    public Method[] findCandidates() {
        Method[] methodArray = this.clazz.getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(this.methodName)) continue;
            methodArray2[n] = method;
            ++n;
        }
        Method[] methodArray3 = new Method[n];
        System.arraycopy(methodArray2, 0, methodArray3, 0, n);
        return methodArray3;
    }

    public Method[] allMethods() {
        Method[] methodArray = this.clazz.getMethods();
        return methodArray;
    }

    public static void main(String[] stringArray) throws ClassLoaderError {
        System.out.println(new String[0].getClass());
        for (int i = 0; i < stringArray.length; ++i) {
            MethodFromString methodFromString = new MethodFromString(ClassLoader.getSystemClassLoader(), stringArray[i]);
            Method method = methodFromString.findMethod();
            System.out.println(method);
        }
    }
}

