/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.util.Traceable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.Date;

public class Log {
    private static Thread lastThread = null;
    private static boolean useLog = false;
    public static final String defaultLogName = "ude.log";
    public static final String prefixC = "javaude ";
    public static boolean tee2stdout = false;

    private Log() {
    }

    public static void open() throws IOException {
        useLog = new File(defaultLogName).exists();
    }

    private static PrintStream getStream() {
        PrintStream printStream;
        try {
            printStream = new PrintStream(new FileOutputStream(defaultLogName, true));
        }
        catch (IOException iOException) {
            return null;
        }
        String string = prefixC + new Date().toString() + ':';
        Thread thread = Thread.currentThread();
        if (thread != lastThread) {
            lastThread = thread;
            printStream.println("");
            printStream.print(string);
            printStream.println("---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()));
        }
        printStream.print(string);
        return printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void println(String string) {
        string = "**** " + string;
        if (useLog) {
            PrintStream printStream = Log.getStream();
            try {
                printStream.println(string);
            }
            finally {
                printStream.close();
            }
        }
        if (tee2stdout) {
            System.out.println(string);
        }
    }

    public static synchronized void log(String string) {
        Log.println(string);
    }

    public static synchronized void logErr(String string) {
        Log.println("ERR:  " + string);
    }

    public static synchronized void logTodo(String string) {
        Log.println("TODO: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void trace(Traceable traceable) {
        if (useLog) {
            PrintStream printStream = Log.getStream();
            try {
                traceable.traceOn(printStream);
            }
            finally {
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void traceException(Throwable throwable) {
        if (useLog) {
            PrintStream printStream = Log.getStream();
            try {
                printStream.println("Timestamp: " + new Timestamp(System.currentTimeMillis()));
                throwable.printStackTrace(printStream);
            }
            finally {
                printStream.close();
            }
        }
        if (tee2stdout) {
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void whereAmI() {
        if (useLog) {
            PrintStream printStream = Log.getStream();
            try {
                Log.log("whereAmI in Log");
                Throwable throwable = new Throwable();
                throwable.printStackTrace(printStream);
            }
            finally {
                printStream.close();
            }
        }
    }
}

