#
# @(#)ulookup  1997-11-18
#
# G. Gromann, SAP AG
#
# ermittelt aus einem Benutzer-Klarname (oder Fragment) den DUser oder umgekehrt
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

package UserLookup;
use DUser;
use Getopt::Std;

if ( !getopts ('uh') or $opt_h or @ARGV == 0) {
    print "\nusage: ulookup [-u] username\n\n";
    print "       -u ::= exit with error if name is not unique\n";
    exit (1);
}

@duser = DUser::userlookup($ARGV[0]);

if (($opt_u and @duser > 1) or (@duser < 1)) {
    exit (-1);
}

print join "\n", @duser;
