#!/usr/bin/perl -w
#
# checkmake.pl Script
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#
use strict;
use Getopt::Long;
use qadbtool;
use Make::CheckMake;

select(STDERR); $| = 1;
select(STDOUT); $| = 1;

my $ProgramName = "checktoolmake";
my $Version     = "1.00";
my $VerDate     = "2003-05-28";

my %Opts;
my @Protocols;
my @ErrorLines;
my $ErrProt;
my $ErrRef;
my $UserTargets;
my $ProtName;
my $ProtLink;
my $qah;
my $Msg;
my $To = "";
my $Cc = "";
my @ToList;

#-----------------------------------------------------------------------------

print "\n$ProgramName v$Version ($VerDate)\n\n";

if (!GetOptions( \%Opts, 'qaid=i', 'chlist=i', 'email=s'))
{
    Usage();
}

@Protocols = @ARGV;

#-----------------------------------------------------------------------------

print "QAID       = $Opts{'qaid'}\n"   if ($Opts{'qaid'});
print "CHANGELIST = $Opts{'chlist'}\n" if ($Opts{'chlist'});
print "EMAIL      = $Opts{'email'}\n"  if ($Opts{'email'});
print "TARGETS:\n";
foreach (@Protocols) { print "  - $_\n"; }
print "\n";

#-----------------------------------------------------------------------------

@ErrorLines = ParseProtocols(@Protocols);

if (@ErrorLines)
{
    print "\n*** ERRORS FOUND IN PROTOCOLS ***\n\n";
    $ErrRef = GetModListFromErrProt (@ErrorLines);
}
else
{
    print "\nNo errors found in protocols. Exiting...\n";
    exit(0);
}

#-----------------------------------------------------------------------------

$Msg  = "OWN         = $ENV{'OWN'}\n";
$Msg .= "CHANGE LIST = $Opts{'chlist'}\n" if ($Opts{'chlist'});
$Msg .= "MACHINE CFG = $ENV{'MACHINE_CONFIG'}\n" if ($ENV{'MACHINE_CONFIG'});
$Msg .= "MAKE ID     = $Opts{'qaid'}\n" if ($Opts{'qaid'});
$Msg .= "USER EMAIL  = $Opts{'email'}\n" if ($Opts{'email'});

$ProtName = GenerateProtName("TOOL");
$ErrProt  = "@ErrorLines";

if ($Opts{'qaid'})
{
    $qah = qadbtool->new({'ID' => "$Opts{'qaid'}" });

    if ($qah->{'error_code'} == 0)
    {
        $ProtLink = $qah->write_prot("$ProtName", $ErrProt, "Error Protocol (.e0 file summary)");

        if ($qah->{'error_code'} != 0)
        {
            print "ERROR: Can't write protocol to QADB!\n$qah->{'error_text'}\n";
            $Opts{'qaid'} = 0;
        }
    }
}

unless ($Opts{'qaid'})
{
    $ProtLink = WriteProtToWebDav($ProtName, $ErrProt);
}

$Msg .= TargetsToString($ErrRef);
$Msg .= "\n\nError Protocol : $ProtLink\n";
$Msg .= "Make Details   : http://pts:1081/TestMonitor/ToolMake_Details.jsp?id=$Opts{'qaid'}\n" if ($Opts{'qaid'});
$Msg .= "\n\nMail created by $ProgramName v$Version ($VerDate)\n";

foreach my $trg (keys %{$ErrRef->{'USER_TARGETS'}})
{
    if ($ErrRef->{'USER_TARGETS'}->{$trg})
    {
        push @ToList, $ErrRef->{'USER_TARGETS'}->{$trg} . '@exchange.sap.corp';
    }
}

if ($Opts{'email'})
{
    @ToList = ($Opts{'email'});
}
else
{
    unless (@ToList)
    {
        push @ToList, ('ulrich.jansen@sap.com', 'falko.flessner@sap.com', 'gerald.arnold@sap.com');
    }
}

$To = join(",", @ToList);
$Cc = 'ulrich.jansen@sap.com';

my $sent_mail = SendErrorMail("TOOL", $Msg, $To, $Cc, $ErrRef);

if ($Opts{'qaid'})
{
    my $ename = "EMail_" . $ProtName;

    if ($qah->{'error_code'} == 0)
    {
        $qah->write_prot("$ename", $sent_mail, "Copy of sent automake mail");
        if ($qah->{'error_code'} != 0)
        {
            print "ERROR: Can't write protocol to QADB!\n$qah->{'error_text'}\n";
        }
    }
    else
    {
        print "ERROR: Can't write protocol to QADB!\n$qah->{'error_text'}\n";
    }
}

##############################################################################
# Usage() - Shows program usage and exits.
##############################################################################

sub Usage
{
    print <<USAGE_END;

Usage:  checktoolmake   [-qaid <QA_ID>] [-chlist <CHLIST_NUM>]
                        [-email <ADDR>] <PROTOCOL_LIST>

Where:
        -qaid <QA_ID>
                Sets the QA-ID to be used. If this option is set, this program
                will also log into QADB.

        -chlist <CHLIST_NUM>
                Sets the change list number for this make. If this option is
                given, the change list number is shown in the header of sent
                error mail.

        -email <ADDR>
                If this option is given, emails will only be sent to the given
                address.

        <PROTOCOL_LIST>
                At the end, you can give a list of all protocols to be parsed.
                These protocols must be given with a fully qualified path!

USAGE_END

    exit(0);
}
