/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.StructuredBytes;

public class FullswapMem
extends StructuredBytes {
    public FullswapMem(byte[] data) {
        super(data);
    }

    public FullswapMem(byte[] data, int offset) {
        super(data, offset);
    }

    public FullswapMem(int size) {
        super(size);
    }

    public int getInt2(int offset) {
        int lowerByte = this.data[offset + this.ptrOffs];
        if (lowerByte < 0) {
            lowerByte += 256;
        }
        int result = this.data[offset + this.ptrOffs + 1] * 256 + lowerByte;
        return result;
    }

    public int getInt4(int offset) {
        byte[] d = this.data;
        int result = 0;
        int ofs = offset + this.ptrOffs;
        for (int i = 3; i >= 0; --i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256 + oneByte;
        }
        return result;
    }

    public void putInt2(int value, int offset) {
        this.data[offset + this.ptrOffs + 1] = (byte)(value / 256);
        this.data[offset + this.ptrOffs] = (byte)(value % 256);
    }

    public void putInt4(int value, int offset) {
        for (int i = 0; i < 3; ++i) {
            this.data[offset + this.ptrOffs + i] = (byte)(value % 256);
            value /= 256;
        }
        this.data[offset + this.ptrOffs] = (byte)value;
    }
}

