/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechdev.tools.jdiagnose;

import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtechdev.tools.jdiagnose.ByteUtil;
import com.sap.dbtechdev.tools.jdiagnose.LongDesc;
import java.io.FileWriter;
import java.io.IOException;

public class LongDescViewer {
    public static final int swapnormal = 1;
    public static final int swapfull = 2;
    LongDesc lDesc = new LongDesc();
    public String comment = null;

    public LongDescViewer(byte[] byArray, int n, String string) {
        this(byArray, n);
        this.comment = string;
    }

    public LongDescViewer(byte[] byArray, int n) {
        this.lDesc.wholeDescriptor = byArray;
        StructuredMem structuredMem = null;
        switch (n) {
            case 1: {
                structuredMem = new StructuredBytes(byArray);
                break;
            }
            case 2: {
                structuredMem = new FullswapMem(byArray);
            }
        }
        if (structuredMem.size() >= 41) {
            this.lDesc.UndefSignal = structuredMem.getInt1(0);
            this.lDesc.Descriptor = structuredMem.getBytes(1, 8);
            this.lDesc.Tabid = structuredMem.getBytes(9, 8);
            this.lDesc.MaxLen = structuredMem.getInt4(17);
            this.lDesc.InternPos = structuredMem.getInt4(21);
            this.lDesc.Infoset = structuredMem.getInt1(25);
            this.lDesc.ld_state = structuredMem.getInt1(26);
            this.lDesc.ld_used_in_ak = structuredMem.getInt1(26);
            this.lDesc.Valmode = structuredMem.getInt1(28);
            this.lDesc.Valind = structuredMem.getInt2(29);
            this.lDesc.ld_unused_2 = structuredMem.getBytes(31, 2);
            this.lDesc.Valpos = structuredMem.getInt4(33);
            this.lDesc.Vallen = structuredMem.getInt4(37);
        }
    }

    void dumpToStream(FileWriter fileWriter) throws IOException {
        fileWriter.write(this.comment + "\n");
        for (int i = 0; i < this.comment.length(); ++i) {
            fileWriter.write("=");
        }
        fileWriter.write("\nUndefSignal: " + this.lDesc.getUndefSignal());
        fileWriter.write("\nDescriptor:  " + this.lDesc.getDescriptor());
        fileWriter.write("\nTabid:       " + this.lDesc.getTabid());
        fileWriter.write("\nMaxLen:      " + Integer.toString(this.lDesc.MaxLen));
        fileWriter.write("\nInternPos:   " + Integer.toString(this.lDesc.InternPos));
        fileWriter.write("\nInfoset:     " + this.lDesc.getInfoSet());
        fileWriter.write("\nLDState:     " + this.lDesc.getLDState());
        fileWriter.write("\nUsedInAK:    " + this.lDesc.getUsedInAK());
        fileWriter.write("\nValmode:     " + this.lDesc.getValmode());
        fileWriter.write("\nValind:      " + Integer.toString(this.lDesc.Valind));
        fileWriter.write("\nUnused:      " + this.lDesc.getUnused2());
        fileWriter.write("\nValpos:      " + Integer.toString(this.lDesc.Valpos));
        fileWriter.write("\nVallen:      " + Integer.toString(this.lDesc.Vallen));
        fileWriter.write("\nHexDump:\n");
        fileWriter.write(ByteUtil.printasHexPattern(this.lDesc.wholeDescriptor, '|'));
        fileWriter.write("\n");
    }

    public static void main(String[] stringArray) {
        String string = "00000000 0000002B 69000000 00000020 AC0004B0 0000007A 4002007E  00020000 00000000 2A00003D 37787878 78787878 78787878 78787878";
        LongDescViewer longDescViewer = new LongDescViewer(ByteUtil.parseBytes(string, 42), 1);
        System.out.println(longDescViewer.lDesc);
    }

    public String toString() {
        if (this.comment != null) {
            return this.comment;
        }
        return super.toString();
    }
}

