/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechdev.tools.jdiagnose;

import com.sap.dbtech.util.VDNNumber;
import com.sap.dbtechdev.tools.jdiagnose.ByteUtil;
import com.sap.dbtechdev.tools.jdiagnose.LongDesc;
import com.sap.dbtechdev.tools.jdiagnose.LongDescViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableModel;

public class JDiagGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    long londescCount = 0L;
    JComboBox ldwHistoryLB = new JComboBox();
    String inputBuffer;
    JTabbedPane tabPane = new JTabbedPane();
    JPanel longDescPanel = new JPanel();
    JPanel VDNNumberPanel = new JPanel();
    JPanel menu = new JPanel();
    JPanel status = new JPanel();
    JComboBox SwapKind = new JComboBox<Object>(new Object[]{"non-swap", "full-swap"});
    JButton Analyze = new JButton("Analyze");
    JPanel jPanel2 = new JPanel();
    JScrollPane scrolli = new JScrollPane();
    JEditorPane longval = new JEditorPane();
    JSplitPane jSplitPane1 = new JSplitPane(0);
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout(0, 3, 1);
    GridLayout gridLayout1 = new GridLayout(11, 2);
    GridLayout gridLayout2 = new GridLayout();
    GridBagLayout VDNLayout = new GridBagLayout();
    JLabel lineal = new JLabel("|01|02|03|04| |05|06|07|08| |09|10|11|12| |13|14|15|16|");
    JTextField comment = new JTextField("Descriptor " + this.ldwHistoryLB.getItemCount() + 1);
    TitledBorder titledBorder1;
    JButton ButtonVDNnative2VDN = new JButton("VDN -> Native");
    JButton ButtonVDN2Native = new JButton("Native -> VDN");
    JLabel labelNativeNumber = new JLabel("Native Number Value");
    JLabel LabelVDNNumber = new JLabel("VDN Number Value");
    JTextField textFieldVDNnativeValue = new JTextField();
    JTextField textFieldVDNNumberValue = new JTextField();
    JButton jButtonSave = new JButton(new ImageIcon((class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI == null ? (class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI = JDiagGUI.class$("com.sap.dbtechdev.tools.jdiagnose.JDiagGUI")) : class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI).getResource("JDiag_save.gif")));
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabelStatus = new JLabel();
    private JTable jTableLongDescProps = null;
    private JScrollPane jScrollPaneLongDescProps = null;
    private DefaultTableModel TableModelLongDescProps = null;
    static /* synthetic */ Class class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI;

    public JDiagGUI() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        this.setTitle("JDiagnose");
        ImageIcon imageIcon = new ImageIcon((class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI == null ? (class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI = JDiagGUI.class$("com.sap.dbtechdev.tools.jdiagnose.JDiagGUI")) : class$com$sap$dbtechdev$tools$jdiagnose$JDiagGUI).getResource("JDiag.gif"));
        this.setIconImage(imageIcon.getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDiagGUI.this.this_windowClosing(windowEvent);
            }
        });
        this.Analyze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDiagGUI.this.Analyze_actionPerformed(actionEvent);
            }
        });
        this.jSplitPane1.setPreferredSize(new Dimension(415, 320));
        this.jPanel2.setLayout(this.borderLayout3);
        this.lineal.setFont(new Font("Monospaced", 0, 12));
        this.lineal.setBorder(new TitledBorder(""));
        this.comment.setFont(new Font("Monospaced", 0, 12));
        this.comment.setBorder(new TitledBorder(""));
        this.ButtonVDN2Native.setPreferredSize(new Dimension(120, 27));
        this.ButtonVDN2Native.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDiagGUI.this.native2VDN_actionPerformed(actionEvent);
            }
        });
        this.textFieldVDNnativeValue.setPreferredSize(new Dimension(370, 21));
        this.labelNativeNumber.setPreferredSize(new Dimension(80, 17));
        this.labelNativeNumber.setText("Native Number Value: ");
        this.LabelVDNNumber.setAlignmentX(0.5f);
        this.LabelVDNNumber.setPreferredSize(new Dimension(130, 17));
        this.LabelVDNNumber.setHorizontalTextPosition(10);
        this.LabelVDNNumber.setText("VDN Number Value: ");
        this.textFieldVDNNumberValue.setPreferredSize(new Dimension(370, 21));
        this.ButtonVDNnative2VDN.setPreferredSize(new Dimension(120, 27));
        this.ButtonVDNnative2VDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDiagGUI.this.VDN2native_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().setFont(new Font("Monospaced", 0, 12));
        this.longval.setFont(new Font("Monospaced", 0, 12));
        this.ldwHistoryLB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDiagGUI.this.ldwHistoryLB_actionPerformed(actionEvent);
            }
        });
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDiagGUI.this.jButtonSave_actionPerformed(actionEvent);
            }
        });
        this.status.setLayout(this.borderLayout2);
        this.getContentPane().add(this.tabPane);
        this.tabPane.add("Long Descriptor", this.longDescPanel);
        this.tabPane.add("VDN Number", this.VDNNumberPanel);
        this.VDNNumberPanel.setLayout(this.VDNLayout);
        this.VDNNumberPanel.add((Component)this.LabelVDNNumber, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.textFieldVDNnativeValue, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.labelNativeNumber, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.textFieldVDNNumberValue, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.ButtonVDNnative2VDN, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.ButtonVDN2Native, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.longDescPanel.setLayout(this.borderLayout1);
        this.longDescPanel.add((Component)this.menu, "North");
        this.menu.setLayout(this.flowLayout1);
        this.menu.add((Component)this.SwapKind, null);
        this.menu.add((Component)this.Analyze, null);
        this.menu.add((Component)this.ldwHistoryLB, null);
        this.menu.add((Component)this.jButtonSave, null);
        this.longDescPanel.add((Component)this.jSplitPane1, "Center");
        this.longDescPanel.add((Component)this.status, "South");
        this.status.add((Component)this.jLabelStatus, "Center");
        this.status.setPreferredSize(new Dimension(300, 25));
        this.jSplitPane1.add((Component)this.jPanel2, "top");
        this.jPanel2.add((Component)this.lineal, "North");
        this.jPanel2.add((Component)this.scrolli, "Center");
        this.jPanel2.add((Component)this.comment, "South");
        this.scrolli.getViewport().add((Component)this.longval, null);
        this.pack();
        this.setVisible(true);
        this.jSplitPane1.setDividerLocation(135);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setBottomComponent(this.getJScrollPaneLongDescProps());
        this.tabPane.setPreferredSize(new Dimension(420, 450));
        this.tabPane.setSize(420, 450);
    }

    void this_windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    private JTable getJTableLongDescProps() {
        if (this.jTableLongDescProps == null) {
            this.jTableLongDescProps = new JTable();
            this.jTableLongDescProps.setModel(this.getTableModelLongDescProps());
            this.jTableLongDescProps.setAutoResizeMode(4);
            this.jTableLongDescProps.setPreferredSize(new Dimension(225, 350));
        }
        return this.jTableLongDescProps;
    }

    private JScrollPane getJScrollPaneLongDescProps() {
        if (this.jScrollPaneLongDescProps == null) {
            this.jScrollPaneLongDescProps = new JScrollPane();
            this.jScrollPaneLongDescProps.setViewportView(this.getJTableLongDescProps());
        }
        return this.jScrollPaneLongDescProps;
    }

    private DefaultTableModel getTableModelLongDescProps() {
        if (this.TableModelLongDescProps == null) {
            String[] stringArray = LongDesc.getLongdescProps();
            this.TableModelLongDescProps = new DefaultTableModel();
            this.TableModelLongDescProps.setColumnCount(3);
            this.TableModelLongDescProps.setRowCount(stringArray.length);
            Vector<String> vector = new Vector<String>(3);
            vector.add("Offset");
            vector.add("Property");
            vector.add("Value");
            this.TableModelLongDescProps.setColumnIdentifiers(vector);
            int[] nArray = LongDesc.getLongDescOffsets();
            for (int i = 0; i < stringArray.length; ++i) {
                this.TableModelLongDescProps.setValueAt(String.valueOf(nArray[i]), i, 0);
                this.TableModelLongDescProps.setValueAt(stringArray[i], i, 1);
            }
        }
        return this.TableModelLongDescProps;
    }

    public static void main(String[] stringArray) {
        JDiagGUI jDiagGUI = new JDiagGUI();
        try {
            if (stringArray.length > 0) {
                jDiagGUI.longval.setText(stringArray[0]);
            }
            jDiagGUI.Analyze_actionPerformed(null);
        }
        catch (Exception exception) {
            JDiagGUI.logError(exception);
        }
    }

    void renderLongDesc(LongDescViewer longDescViewer) {
        String[] stringArray = longDescViewer.lDesc.getLongDescValues();
        for (int i = 0; i < stringArray.length; ++i) {
            this.jTableLongDescProps.setValueAt(stringArray[i], i, 2);
        }
        this.longval.setText(ByteUtil.printasHexPattern(longDescViewer.lDesc.wholeDescriptor, '|'));
        this.comment.setText(longDescViewer.comment);
    }

    void Analyze_actionPerformed(ActionEvent actionEvent) {
        try {
            this.inputBuffer = this.longval.getText();
            LongDescViewer longDescViewer = new LongDescViewer(ByteUtil.parseBytes(this.inputBuffer, 42), this.SwapKind.getSelectedIndex() == 1 ? 2 : 1, this.comment.getText());
            this.ldwHistoryLB.addItem(longDescViewer);
            this.ldwHistoryLB.setSelectedIndex(this.ldwHistoryLB.getItemCount() - 1);
            this.renderLongDesc(longDescViewer);
        }
        catch (Exception exception) {
            JDiagGUI.logError(exception);
        }
    }

    void native2VDN_actionPerformed(ActionEvent actionEvent) {
        try {
            BigDecimal bigDecimal = new BigDecimal(this.textFieldVDNnativeValue.getText());
            this.textFieldVDNNumberValue.setText(ByteUtil.printasHex(VDNNumber.bigDecimal2number(bigDecimal)));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            JDiagGUI.logError(exception);
        }
    }

    void VDN2native_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.textFieldVDNNumberValue.getText().equals("")) {
                this.textFieldVDNnativeValue.setText("0");
                return;
            }
            byte[] byArray = ByteUtil.parseBytes(this.textFieldVDNNumberValue.getText(), 20);
            this.textFieldVDNnativeValue.setText(VDNNumber.number2BigDecimal(byArray).toString());
        }
        catch (Exception exception) {
            JDiagGUI.logError(exception);
        }
    }

    public static void showInfo(String string) {
        JOptionPane.showMessageDialog(null, string, "Information", 1);
    }

    public static void logError(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        JDiagGUI.logError(stringWriter.toString());
    }

    public static void logError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    void native2VDN_performed(ActionEvent actionEvent) {
    }

    void ldwHistoryLB_actionPerformed(ActionEvent actionEvent) {
        this.renderLongDesc((LongDescViewer)this.ldwHistoryLB.getSelectedItem());
    }

    void jButtonSave_actionPerformed(ActionEvent actionEvent) {
        FileWriter fileWriter = null;
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showDialog(null, "Save");
        if (n != 0) {
            JDiagGUI.logError("Save long descriptors to file failed");
        }
        try {
            fileWriter = new FileWriter(jFileChooser.getSelectedFile());
            for (int i = 0; i < this.ldwHistoryLB.getItemCount(); ++i) {
                LongDescViewer longDescViewer = (LongDescViewer)this.ldwHistoryLB.getItemAt(i);
                longDescViewer.dumpToStream(fileWriter);
                fileWriter.write("\n--------------------------------------------------\n");
            }
            this.jLabelStatus.setText("Data saved to " + jFileChooser.getSelectedFile());
            fileWriter.close();
        }
        catch (Exception exception) {
            JDiagGUI.logError(exception);
            this.jLabelStatus.setText("Save date failed");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

