/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

import com.sap.dbtech.util.*;
/**
 * creates a packet to connect to db on RTE level
 */
class ConnectPacket extends StructuredBytes
{
    private int writePos = RteC.Connect_VarPart_O;
    /**
     * ConnectPacket constructor comment.
     * @param data byte[]
     * @throws ConversionExceptionSapDB 
     */
    public ConnectPacket(
            byte [] buf,
            String serverdb,
            PacketLayout layout,
            int port,
            int serviceType
            ) 
    {
        super(buf, RteC.Header_END_O_C);
        this.putInt1 (RteC.asciiClient_C, RteC.Connect_sMessCode_O);
        this.putInt1 (RteC.notSwapped_C, RteC.Connect_sMessCode_O + 1);
        this.putInt2 (RteC.Connect_END_O_C, RteC.Connect_ConnectLength_O);
//        this.putInt1 (RteC.SQL_USER_C, RteC.Connect_ServiceType_O);
        this.putInt1 (serviceType, RteC.Connect_ServiceType_O);
        this.putInt1 (RteC.RSQL_JAVA_C, RteC.Connect_OSType_O);
        this.putInt1 (0, RteC.Connect_Filler1_O);
        this.putInt1 (0, RteC.Connect_Filler2_O);
        this.putInt4 (layout.maxSegmentSize (), RteC.Connect_MaxSegmentSize_O);
        this.putInt4 (layout.maxDataLength(), RteC.Connect_MaxDataLen_O);
        this.putInt4 (layout.packetSize (), RteC.Connect_PacketSize_O);
        this.putInt4 (layout.minReplySize (), RteC.Connect_MinReplySize_O);
        this.putString (serverdb, RteC.Connect_ReceiverServerDB_O, RteC.Connect_Dbname_Size_C);
        this.putString ("        ", RteC.Connect_SenderServerDB_O, RteC.Connect_Dbname_Size_C);
        this.addConnectInt (0, RteC.ARGID_REM_PID_C);
        this.addPort (port, RteC.ARGID_PORT_NO_C);
        this.addConnectBool (false, RteC.ARGID_ACKNOWLEDGE_C);
        this.addFlagOmitReplyPart(RteC.ARGID_OMIT_REPLY_PART);
    }
    /**
     * add a boolean value.
     * @param value int
     * @param tag char
     */
    public void  addConnectBool (
            boolean ack,
            int tag)
    {
        int boolAsInt;

        if (ack) {
            boolAsInt = 1;
        }
        else {
            boolAsInt = 0;
        }
        this.putInt1 (3, this.writePos);
        this.putInt1 (tag, this.writePos + 1);
        this.putInt1 (boolAsInt, this.writePos + 2);
        this.writePos += 3;
    }
    /**
     * add an integer value.
     * @param value int
     * @param tag char
     * @throws ConversionExceptionSapDB 
     */
    public void
    addConnectInt(
            int value,
            int tag) 
    {
        this.addConnectString (String.valueOf (value), tag);
    }
    /**
     * add a String value
     * @param value java.lang.String
     * @param tag char
     * @throws ConversionExceptionSapDB 
     */
    public void
    addConnectString(
            String value,
            int tag)
    {
        int fullLength;

        fullLength = value.length () + 3; // len + tag + '\0'
        this.putInt1 (fullLength, this.writePos);
        this.putInt1 (tag, this.writePos + 1);
        this.putString (value, this.writePos + 2);
        this.putInt1 (0, this.writePos + fullLength - 1);
        this.writePos += fullLength;
    }
    /**
     * add a socket port.
     * @param port int
     * @param tag char
     */
    public void
    addPort(
            int port,
            int tag)
    {
        this.putInt1 (4, this.writePos);
        this.putInt1 (tag, this.writePos + 1);
        this.putInt1 (port / 256, this.writePos + 2);
        this.putInt1 (port % 256, this.writePos + 3);
        this.writePos += 4;
    }
    /**
     * add a socket port.
     * @param port int
     * @param tag char
     */
    public void
    addFlagOmitReplyPart(int tag)
    {
        this.putInt1 (3, this.writePos);
        this.putInt1 (tag, this.writePos + 1);
        this.putInt1 (1, this.writePos + 2);
        this.writePos += 3;
    }
    /**
     * returns the current length.
     * @return int
     */
    public int length ()
    {
        return this.writePos;
    }
    /**
     *
     */
    void
    close ()
    {
        int currentLength = this.length ();
        final int requiredLength = RteC.Connect_MinSize_C - RteC.Header_END_O_C;

        if (currentLength < requiredLength) {
            this.writePos += requiredLength - currentLength;
        }
        this.putInt2 (this.writePos, RteC.Connect_ConnectLength_O);
        //this.dump ();
    }
    /**
     *
     */
/*************************************************************************************************************************
*     public void                                                                                                        *
*     dump ()                                                                                                            *
*     {                                                                                                                  *
*         System.out.println ("Connect_sMessCode_O: " + this.getInt1 (RteC.Connect_sMessCode_O));                        *
*         System.out.println ("Connect_sMessCode_O: " + this.getInt1 (RteC.Connect_sMessCode_O + 1));                    *
*         System.out.println ("Connect_ConnectLength_O: " + this.getInt2 (RteC.Connect_ConnectLength_O));                *
*         System.out.println ("Connect_ServiceType_O: " + this.getInt1 (RteC.Connect_ServiceType_O));                    *
*         System.out.println ("Connect_OSType_O: " + this.getInt1 (RteC.Connect_OSType_O));                              *
*         System.out.println ("Connect_MaxSegmentSize_O: " + this.getInt4 (RteC.Connect_MaxSegmentSize_O));              *
*         System.out.println ("Connect_MaxDataLen_O: " + this.getInt4 (RteC.Connect_MaxDataLen_O));                      *
*         System.out.println ("Connect_PacketSize_O: " + this.getInt4 (RteC.Connect_PacketSize_O));                      *
*         System.out.println ("Connect_MinReplySize_O: " + this.getInt4 (RteC.Connect_MinReplySize_O));                  *
*         // System.out.println (this.putString (serverdb, RteC.Connect_ReceiverServerDB_O, RteC.Connect_Dbname_Size_C); *
*         // System.out.println (this.putString ("        ", RteC.Connect_SenderServerDB_O, RteC.Connect_Dbname_Size_C); *
*     }                                                                                                                  *
*************************************************************************************************************************/
}
