/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.StructuredMem;

public class DataPartBase
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPartBase(StructuredMem structuredMem, RequestPacket requestPacket) {
        super(structuredMem);
        this.originalMem = structuredMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public void addArg(int n, int n2) {
        ++this.argCount;
        this.extent = Math.max(this.extent, n + n2);
    }

    public void close() {
        int n = -14;
        this.originalMem.putInt2(this.argCount, n);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int n) {
        int n2 = -14;
        this.originalMem.putInt2(n, n2);
        this.requestPacket.closePart(this.massExtent + this.extent * n, n);
    }

    protected int getMaxDataSize() {
        return this.size() - this.extent - 8;
    }

    public boolean hasRoomFor(int n, int n2) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n + n2;
    }

    public boolean hasRoomFor(int n) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n;
    }

    public void putNull(int n, int n2) {
        this.putInt1(-1, n - 1);
        this.putBytes(new byte[n2], n);
        this.addArg(n, n2);
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }
}

