/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.ConnectionException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.trace.Connection;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.NiCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SecureCommunication;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.VersionInfo;
import java.io.IOException;
import java.security.AccessControlException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class DriverSapDB
implements Driver {
    static DriverSapDB driver = new DriverSapDB();
    static JdbcCommFactory commFactory;
    public static boolean isJDBC20;
    static VersionInfo jdbcDriverVersion;
    static final String protocolName_C = "jdbc:sapdb:";
    public static final String nativeCommunication_dllName_C = "sapdbcbin";
    static final String loadbinProperty_C = "com.sap.dbtech.jdbc.loadbin";
    static final String osNameProperty_C = "os.name";
    static final String osLinuxString_C = "Linux";
    static final String driverName_C = "SAP DB";
    public static final String sapdbEncodingC = "ISO8859_1";
    public static final int JAVA_1_1 = 1001999;
    public static final int JAVA_1_2 = 1002999;
    public static final int JAVA_1_3 = 1003999;
    public static final int currentVMVersion;
    static final String userName_C = "user";
    static final String passwordName_C = "password";
    static final String urlName_C = "url";
    static final String sqlmodeName_C = "sqlmode";
    static final String cachelimitName_C = "cachelimit";
    static final String timeoutName_C = "timeout";
    static final String isolationName_C = "isolation";
    static final String autocommitName_C = "autocommit";
    static final String traceName_C = "trace";
    static final String traceSize_C = "tracesize";
    static final String transportName_C = "transport";
    static final String cacheName_C = "cache";
    static final String cacheSizeName_C = "cachesize";
    static final String unicodeName_C = "unicode";
    static final String reconnect_C = "reconnect";
    static final String spaceoption_C = "spaceoption";
    static final String application_C = "application";
    static final String appversion_C = "appversion";
    static final String communicationtimeout_C = "communicationtimeout";
    static final String authentication_C = "authentication";
    static final String encrytption_C = "encryption";
    static final String useDefaultValueForUpdatableRS_C = "useDefaultValueForUpdatableRS";
    static final String connecttype_C = "connecttype";
    static final String dburlName_C = "dburl";
    static final String dbName_C = "dbname";
    static final String sqlmodeOracle_C = "oracle";
    static final String niconnect_C = "niconnect";
    public static final boolean catchAllNotImplemented_C = false;
    private static final String[] trueStrings;
    public static final int nativeCommunication_notInit = 1;
    public static final int nativeCommunication_enabled = 2;
    public static final int nativeCommunication_disabled = 3;
    private static int nativeCommunication;

    static int getVMVersion() {
        try {
            String string = System.getProperty("java.version");
            int n = string.indexOf(49);
            if (n == -1) {
                return 1003999;
            }
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                return 1003999;
            }
            int n3 = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
            if ((n2 = string.indexOf(46, n)) == -1) {
                return 1003999;
            }
            int n4 = Integer.parseInt(string.substring(n, n2));
            return n3 * 1000000 + n4 * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            return 1003999;
        }
        catch (AccessControlException accessControlException) {
            return 1002999;
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = string.startsWith(protocolName_C);
        return bl;
    }

    public static final String buildURL(String string, String string2) {
        return "jdbc:sapdb://" + string + "/" + string2;
    }

    public static final java.sql.Connection connect(String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6 = DriverSapDB.buildURL(string3, string4);
        if (string5 != null && string5.length() > 0) {
            string6 = string6 + "?" + string5;
        }
        Properties properties = new Properties();
        properties.put(userName_C, string);
        properties.put(passwordName_C, string2);
        return DriverSapDB.singleton().connect(string6, properties);
    }

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        JdbcCommunication jdbcCommunication = null;
        if (!this.acceptsURL(string)) {
            return null;
        }
        string = this.parseURLProperties(string, properties);
        boolean bl = DriverSapDB.openTrace(string, properties);
        Tracer.print("new Connection '" + string + "'", properties);
        try {
            jdbcCommunication = this.openByURL(string, properties);
        }
        catch (RTEException rTEException) {
            if (bl) {
                Tracer.println("using " + jdbcCommunication);
                Tracer.println("=> FAILED");
            }
            throw new JDBCDriverException(MessageTranslator.translate("error.connect.rteexception", string, rTEException.getMessage()), this);
        }
        java.sql.Connection connection = new ConnectionSapDB(jdbcCommunication, properties);
        if (bl) {
            Tracer.println("using " + jdbcCommunication);
            Tracer.println("=> " + connection);
            connection = new Connection(connection);
        }
        return connection;
    }

    public static final boolean openTrace(String string, Properties properties) {
        long l;
        boolean bl = false;
        String string2 = properties.getProperty(traceName_C);
        if (string2 == null) {
            try {
                string2 = System.getProperty("sapdbctrace");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        try {
            l = Long.parseLong(properties.getProperty(traceSize_C));
        }
        catch (NumberFormatException numberFormatException) {
            l = Long.MAX_VALUE;
        }
        if (string2 != null) {
            bl = true;
            try {
                Tracer.forceNewLog(string2, true, l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Tracer.println("==================================");
            String string3 = "<unknown>";
            try {
                string3 = System.getProperty("java.version", "<unknown>");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            Tracer.println(DriverSapDB.getVersionString() + " on Java " + string3);
        }
        if ((string2 = properties.getProperty("extendedTrace")) != null) {
            TimeoutException.addExtendedTrace(string2);
        }
        return bl;
    }

    public static final boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            bl2 = false;
            for (int i = 0; i < trueStrings.length; ++i) {
                if (!string2.equalsIgnoreCase(trueStrings[i])) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public static final int getIntProperty(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public final int getMajorVersion() {
        return jdbcDriverVersion.getMajorVersion();
    }

    public final int getMinorVersion() {
        return jdbcDriverVersion.getMinorVersion();
    }

    final String getName() {
        return driverName_C;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo driverPropertyInfo = null;
        DriverPropertyInfo driverPropertyInfo2 = null;
        int n = 0;
        int n2 = 0;
        if (properties.getProperty(userName_C) == null) {
            driverPropertyInfo = new DriverPropertyInfo(userName_C, null);
            driverPropertyInfo.required = true;
            ++n;
        }
        if (properties.getProperty(passwordName_C) == null) {
            driverPropertyInfo2 = new DriverPropertyInfo(passwordName_C, null);
            driverPropertyInfo2.required = true;
            ++n;
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[n];
        if (driverPropertyInfo != null) {
            driverPropertyInfoArray[n2] = driverPropertyInfo;
            ++n2;
        }
        if (driverPropertyInfo2 != null) {
            driverPropertyInfoArray[n2] = driverPropertyInfo2;
            ++n2;
        }
        return driverPropertyInfoArray;
    }

    public static final String getProtocol() {
        return protocolName_C;
    }

    public static final String getVersionString() {
        return DriverSapDB.getStaticVersion();
    }

    public static String getStaticVersion() {
        return jdbcDriverVersion.toString();
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    public static void load() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-V") || stringArray[0].equals("--version")) {
                System.out.println(DriverSapDB.getStaticVersion());
            } else {
                Object object;
                Properties properties = new Properties();
                boolean bl = false;
                boolean bl2 = false;
                properties.put("host", "");
                properties.put("options", "");
                properties.put("cmd", "Select 'successfully connected' as \"connect test\" from dual");
                block9: for (int i = 0; i < stringArray.length && ((String)(object = stringArray[i])).charAt(0) == '-'; ++i) {
                    char c = ((String)object).charAt(1);
                    switch (c) {
                        case 'u': {
                            object = stringArray[++i];
                            int n = ((String)object).indexOf(44);
                            properties.put(userName_C, ((String)object).substring(0, n));
                            properties.put(passwordName_C, ((String)object).substring(n + 1));
                            bl = true;
                            continue block9;
                        }
                        case 'd': {
                            properties.put(dbName_C, stringArray[++i]);
                            bl2 = true;
                            continue block9;
                        }
                        case 'n': {
                            properties.put("host", stringArray[++i]);
                            continue block9;
                        }
                        case 'o': {
                            properties.put("options", "?" + stringArray[++i]);
                            continue block9;
                        }
                        case 'c': {
                            properties.put("cmd", stringArray[++i]);
                            continue block9;
                        }
                        default: {
                            System.err.println("invalid option " + c);
                        }
                    }
                }
                if (bl2 && bl) {
                    try {
                        java.sql.Connection connection = new DriverSapDB().connect(DriverSapDB.buildURL((String)properties.get("host"), (String)properties.get(dbName_C)) + properties.get("options"), properties);
                        object = connection.createStatement();
                        if (object.execute((String)properties.get("cmd"))) {
                            ResultSet resultSet = object.getResultSet();
                            if (!resultSet.next()) {
                                System.out.println("row not found");
                            } else {
                                int n;
                                int n2;
                                String string;
                                int n3;
                                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                                StringBuffer stringBuffer = new StringBuffer(50);
                                stringBuffer.append("| ");
                                for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                                    string = resultSetMetaData.getColumnName(n3);
                                    n2 = resultSetMetaData.getPrecision(n3);
                                    if (string.length() > n2) {
                                        stringBuffer.append(string.substring(0, n2));
                                    } else {
                                        stringBuffer.append(string);
                                        for (n = 0; n < n2 - string.length(); ++n) {
                                            stringBuffer.append(" ");
                                        }
                                    }
                                    stringBuffer.append(" | ");
                                }
                                System.out.println(stringBuffer.toString());
                                for (n3 = 1; n3 < stringBuffer.length(); ++n3) {
                                    System.out.print("-");
                                }
                                System.out.println("");
                                do {
                                    stringBuffer = new StringBuffer(stringBuffer.capacity());
                                    stringBuffer.append("| ");
                                    for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                                        string = resultSet.getString(n3);
                                        n2 = resultSetMetaData.getPrecision(n3);
                                        if (string.length() > n2) {
                                            stringBuffer.append(string.substring(0, n2));
                                        } else {
                                            stringBuffer.append(string);
                                            for (n = 0; n < n2 - string.length(); ++n) {
                                                stringBuffer.append(" ");
                                            }
                                        }
                                        stringBuffer.append(" | ");
                                    }
                                    System.out.println(stringBuffer.toString());
                                } while (resultSet.next());
                            }
                        } else {
                            System.out.println(object.getUpdateCount() + " row(s) affected");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    static String mapIsolation(String string) throws JDBCDriverException {
        String string2;
        int n;
        block14: {
            n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string.startsWith("ADABAS")) {
                    try {
                        n = Integer.parseInt(string.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException numberFormatException2) {}
                }
                if (!string.startsWith("TRANSACTION_")) break block14;
                String string3 = string.substring("TRANSACTION_".length());
                if (string3.equals("READ_UNCOMMITTED")) {
                    n = 1;
                }
                if (string3.equals("READ_COMMITTED")) {
                    n = 2;
                }
                if (string3.equals("REPEATABLE_READ")) {
                    n = 4;
                }
                if (!string3.equals("SERIALIZABLE")) break block14;
                n = 8;
            }
        }
        switch (n) {
            case 1: {
                string2 = "0";
                break;
            }
            case 2: {
                string2 = "1";
                break;
            }
            case 4: {
                string2 = "2";
                break;
            }
            case 8: {
                string2 = "3";
                break;
            }
            default: {
                throw new JDBCDriverException(MessageTranslator.translate("error.invalid.transactionisolation", string));
            }
        }
        return string2;
    }

    static int isolevelString2Jdbc(String string) {
        int n;
        block8: {
            n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string.startsWith("ADABAS")) {
                    try {
                        n = Integer.parseInt(string.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException numberFormatException2) {}
                }
                if (!string.startsWith("TRANSACTION_")) break block8;
                String string2 = string.substring("TRANSACTION_".length());
                if (string2.equals("READ_UNCOMMITTED")) {
                    n = 1;
                }
                if (string2.equals("READ_COMMITTED")) {
                    n = 2;
                }
                if (string2.equals("REPEATABLE_READ")) {
                    n = 4;
                }
                if (!string2.equals("SERIALIZABLE")) break block8;
                n = 8;
            }
        }
        return n;
    }

    static String isolevelJdbc2native(int n) throws SQLException {
        String string;
        switch (n) {
            case 0: 
            case 1: {
                string = "0";
                break;
            }
            case 2: {
                string = "1";
                break;
            }
            case 4: {
                string = "2";
                break;
            }
            case 8: {
                string = "3";
                break;
            }
            default: {
                throw new JDBCDriverException(MessageTranslator.translate("error.invalid.transactionisolation", Integer.toString(n)));
            }
        }
        return string;
    }

    private final JdbcCommunication openByURL(String string, Properties properties) throws RTEException, SQLException {
        String string2;
        String string3;
        int n;
        int n2 = string.length();
        if (n2 >= (n = protocolName_C.length()) + 3 && string.substring(n, n + 2).equals("//")) {
            String string4 = string.substring(n + 2);
            if (string4.startsWith("sapni:")) {
                int n3 = string4.indexOf(":inpas", 6);
                if (-1 == n3) {
                    throw new ConnectionException(new SQLExceptionSapDB(MessageTranslator.translate("error.host.wrongconnecturl", "closing token \":inpas\" not found for SAP routerstring"), "0800", -709));
                }
                string3 = string4.substring(6, n3);
                string2 = string4.substring(n3 + 7, string4.length());
                properties.put(niconnect_C, "true");
                if (commFactory == SocketComm.factory) {
                    commFactory = NiCommunication.factory;
                }
            } else {
                int n4 = string4.indexOf(47);
                string3 = string4.substring(0, n4);
                string2 = string4.substring(n4 + 1, string4.length());
            }
        } else {
            string3 = "";
            string2 = string.substring(n, n2).trim();
        }
        string2 = string2.toUpperCase();
        String string5 = DriverSapDB.buildURL(string3, string2);
        properties.put(dburlName_C, string5);
        properties.put(dbName_C, string2);
        return this.openConnection(string3, string2, properties);
    }

    private final String parseURLProperties(String string, Properties properties) {
        int n = string.indexOf(63);
        if (n >= 0) {
            this.parsePropertiesString(string.substring(n + 1), properties);
            string = string.substring(0, n);
        }
        return string;
    }

    public final JdbcCommunication openConnection(String string, String string2, Properties properties) throws RTEException {
        JdbcCommunication jdbcCommunication;
        JdbcCommFactory jdbcCommFactory;
        String string3 = DriverSapDB.getBooleanProperty(properties, encrytption_C, false) ? "secure" : properties.getProperty(transportName_C, "socket");
        if (string3.equals("native")) {
            try {
                if (DriverSapDB.loadNativeCommunication() == 2) {
                    jdbcCommFactory = NativeComm.factory;
                } else {
                    string3 = "socket";
                }
            }
            catch (Error error) {
                throw new RTEException(MessageTranslator.translate("error.library.notloaded", nativeCommunication_dllName_C, error.toString()), -10899);
            }
            jdbcCommFactory = NativeComm.factory;
        } else if (string3.equals("socket")) {
            jdbcCommFactory = DriverSapDB.getBooleanProperty(properties, niconnect_C, false) ? NiCommunication.factory : SocketComm.factory;
        } else if (string3.equals("secure")) {
            jdbcCommFactory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate("error.invalid.transport", string3), -10899);
        }
        try {
            jdbcCommunication = jdbcCommFactory.open(string, string2, properties);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RTEException(MessageTranslator.translate("error.library.notloaded", nativeCommunication_dllName_C, unsatisfiedLinkError.toString()), -10899);
        }
        return jdbcCommunication;
    }

    public static boolean parseBooleanProperty(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    private void parsePropertiesString(String string, Properties properties) {
        String[] stringArray = StringUtil.split(string, "&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            properties.put(string2.substring(0, n), string2.substring(n + 1));
        }
    }

    public static DriverSapDB singleton() {
        return driver;
    }

    private static void switchTraces(String string, String string2) {
        if (string != null) {
            try {
                Tracer.setVerbosity(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            try {
                Tracer.openLog(string2);
            }
            catch (IOException iOException) {
                System.err.println("SAP DBTech JDBC: Cannot open log " + string2);
            }
        }
    }

    private static void switchTracesByProperties(Properties properties) {
        DriverSapDB.switchTraces(properties.getProperty("traceVerbosity"), properties.getProperty("traceFile"));
    }

    private static void loadDriver() {
        jdbcDriverVersion = new VersionInfo("com.sap.dbtech.jdbc", "package com.sap.dbtech.jdbc, SAP DB JDBC Driver, SAP AG, ");
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static int loadNativeCommunication() {
        if (nativeCommunication != 1) {
            return nativeCommunication;
        }
        try {
            System.loadLibrary(nativeCommunication_dllName_C);
            nativeCommunication = 2;
        }
        catch (AccessControlException accessControlException) {
            nativeCommunication = 3;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary("sapdbcbin32");
                nativeCommunication = 2;
            }
            catch (Error error) {
                nativeCommunication = 3;
                throw error;
            }
        }
        catch (Error error) {
            nativeCommunication = 3;
            throw error;
        }
        return nativeCommunication;
    }

    private static boolean detectJDBC20() {
        boolean bl;
        try {
            Class.forName("java.sql.Clob");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static JdbcCommFactory getCommunicationFactory() {
        return commFactory;
    }

    static {
        isJDBC20 = DriverSapDB.detectJDBC20();
        DriverSapDB.loadDriver();
        currentVMVersion = DriverSapDB.getVMVersion();
        trueStrings = new String[]{"true", "yes", "on"};
        nativeCommunication = 1;
    }
}

