package com.sap.sapdb.DBMTest;
/*!
  -----------------------------------------------------------------------------
  module: DBOnline.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.driver.*;
import java.util.*;

/**
 * DBMServer
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        DBOnline
 * -----------------------------------------------------------------------------
 * responsible:  ChristianH
 * special area: DBMServer Java Test
 * description:  DBMServer db_online command tests
 * version:      7.4.*
 * copyright:    (c) 2000-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */

public class DBOnline extends BackupState
{
  public DBOnline() throws SQLException, TestDatabaseException
  {
    super();
  }
  /**
   * run() contains the test implementation
   */
  public void run()
  {
    DBMUtility oDBM = new  DBMUtility(getDatabase(), this);
    boolean fastKernel = false;
    boolean slowKernel = false;
    boolean quickKernel = false;
    boolean testKernel = false;
    //  create one global try-catch block to handle exceptions
    try
    {
      oDBM.execCmd("db_enum", DBMUtility.OK_OK);
      String param = oDBM.getAnswer();

      //Creating vector for param
      Vector ParamArray = new Vector();

      //Checking what kernel is registerable
      StringTokenizer st_param = new StringTokenizer(param,"\n");
      while (st_param.hasMoreTokens()) {

        String ParamLine = st_param.nextToken().trim();

        if (ParamLine.indexOf(getDatabase().getName()) >= 0) {

          StringTokenizer st_st = new StringTokenizer(ParamLine,"\t");

          while (st_st.hasMoreTokens()) {

            String DBSpeed = st_st.nextToken().trim();

            if (DBSpeed.indexOf("fast") >= 0) {

              fastKernel = true;
              break;
            }
            if (DBSpeed.indexOf("slow") >= 0) {
              slowKernel = true;
              break;
            }
            if (DBSpeed.indexOf("quick") >= 0) {
              quickKernel = true;
              break;
            }
            if (DBSpeed.indexOf("test") >= 0) {
              testKernel = true;
              break;
            }
          }
        }
      }

      //db_online
      oDBM.execCmd("db_offline", DBMUtility.OK_OK);
      Thread.sleep(5000);
      oDBM.execCmd("db_online", DBMUtility.OK_OK);
      Thread.sleep(5000);
      oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

      if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
        addMessage("'db_online' - in default mode", TestProtocol.INFO, oDBM.getAnswer());
      } else {
        addMessage("'db_online' - in default mode", TestProtocol.ERROR, oDBM.getAnswer());
      }
      
      if (fastKernel == true) {
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -f", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -f' - in fast mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -f' - in fast mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -fast", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -fast' - in fast mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -fast' - in fast mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
      } // end if

      if (quickKernel == true) {
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -q", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -q' - in quick mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -q' - in quick mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -quick", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -quick' - in quick mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -quick' - in quick mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
      }

      if (slowKernel == true) {
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -s", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -s' - in slow mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -s' - in slow mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -slow", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -slow' - in slow mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -slow' - in slow mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
      }

      if ((testKernel == true) && (oDBM.getSrvProperty("dbmversion.sysname").compareTo("Linux") != 0)) {
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -t", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -t' - in test mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -t' - in test mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
        //db_online, option
        oDBM.execCmd("db_offline", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_online -test", DBMUtility.OK_OK);
        Thread.sleep(5000);
        oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

        if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
          addMessage("'db_online -test' - in test mode", TestProtocol.INFO, oDBM.getAnswer());
        } else {
          addMessage("'db_online -test' - in test mode", TestProtocol.ERROR, oDBM.getAnswer());
        }
      }

      //db_restart, option
      oDBM.execCmd("db_offline", DBMUtility.OK_OK);
      oDBM.execCmd("db_online", DBMUtility.OK_OK);
      oDBM.execCmd("db_state", DBMUtility.OK_OK, false);

      if (oDBM.getAnswer().indexOf("ONLINE") >= 0) {
        addMessage("'db_online' - in default mode", TestProtocol.INFO, oDBM.getAnswer());
      } else {
        addMessage("'db_online' - in default mode", TestProtocol.ERROR, oDBM.getAnswer());
      }
    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler

      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
        // do nothing
      } // end try catch
    } // end finally
  } // end run
  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "DBOnline";
  } // end getTestClassId
} //end of class MediumGet