/*
* @(#) rendlos.cpc	7.X



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/

#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <ctype.h>

#ifdef   _WIN32
#include <windows.h>
#define  getpid    GetCurrentProcessId
#define  sleep(x)  Sleep (x * 1000)
/*#define  DBPROCS_IMPLEMENTED*/
#endif

void check_long_raw () ;
void alt_tab1_dynamic () ;
void alt_tab1_nondynamic () ;
void update100000 () ;
void dbproc_oms1 () ;
void pe () ;
void createManySchemas () ;
void dropManySchemas () ;
void Sqldump () ;
void prot () ;
void release_connect () ;
void ins_upd_tab1 () ;
void del_intersect_superu () ;
void select_sessions () ;
void select_and_check_superu_tab1sl () ;
void update_superu_tab1sl () ;
void count_tab1 () ;
void delete_tab1 () ;
void sel_upd_sup () ;
void manycurs () ;
void union_all_tab1 () ;
void sel_ins_sup () ;
void check_lr_su () ;
void del_sup () ;
void update_stat_sample () ;
void update_stat () ;
void ins_tabu2 () ;
void upd_tabv1 () ;
void sel_distinct_tab1 () ;
void sel_temp_inv_tab1 () ;
void sel_first_stab1_ins_tab1 () ;
void ins_stab1_sel_first_tab1 () ;
void complex_select () ;
void c_ins_sel_upd () ;
void between_sbview_16 () ;
void equal_sbview_16 () ;
void like_bview_16 () ;
void equal_bview_only_index_16 () ;
void insert_array_tab1 () ;
void insert_tab20k () ;
void ins_except_tab1 () ;
void delete_tab20k () ;
void delete_tab20k_2 () ;
void del_avg_tab1 () ;
void delete_between_tab20k () ;
void update_key_tab20k_1 () ;
void update_key_tab20k_2 () ;
void insert_tab04sk () ;
void delete_tab04sk () ;
void delete_range_tab04sk () ;
void update_tab04sk () ;
void show_trim_serverdb () ;
void cre_idx_tab1 () ;
void drop_idx_tab1 () ;
void CreateList () ;
void DeleteElememtsFromList () ;
void DelCreListInVersion () ;
void AddElementToList () ;
void TraversePartList () ;
void CreateVarobjList () ;
void AddVarobj () ;
void UpdateVarobjList () ;
void DeleteVarobjList () ;
void CreateKeyList () ;
void DeleteElememtsFromKeyList () ;
void UpdateKeyList () ;
void UpdateVersionKeyList () ;
void DropVersionUpdateVersionKeyList () ;
void Create100Versions () ;
void Drop100Versions () ;
void CreateDummyVersion () ;
void DropDummyVersion () ;
void addKeyToSchema () ;
void DropPrivateVersions () ;
void print_f () ;
void rollback () ;
void commit () ;
void movep () ;

long	TraverseList (long Lno, int RelOids,
					  long Ntt, int ReadLocked,
					  char *TravString ) ;
void	DebugOmsOn () ;


EXEC SQL INCLUDE "endlos.h" ;

EXEC SQL BEGIN DECLARE SECTION;

typedef char    c20 [21] ;
typedef char    c40 [41] ;
typedef char	c100 [101] ;

long    k1 , k2 , k3 ;
long    k1m [10] ;
c20     c1 , c2 , c3, c4 ;
int     c1ind   , c2ind  , c3ind  ;
c20     c1m [10] , c2m [10] ;
c100	c5 ;
long    i1 , i2 , i3 , i4 , i5 , i6 ;
int     i1ind , i2ind , i3ind ;
long    i1m [10] , i2m [10] , i3m [10] ;
long    ii ;
long    nr , avg ;
c40     id , pw  ;
int     cnt ;
int		maxlongraw ;
int		cllen , icllen ;
VARCHAR cll [MAXLONGRAW] ;
int		icll ;
char    k0 [240] ;
char    c6 [1501] ;
char	char1a [2], char1b [2], char1c [2];
char	char5 [6] ;
char	char400 [401] ;
char	char400_2 [401] ;
int		rc ;
int		ResultCount ;
struct  {long len; char arr[100000];} scl;
EXEC SQL VAR scl IS LONG VARCHAR(100000);

long    lnll , nrll ;

long	listno ;
long	del_elements ;
long	elements ;
char    FiOidIn [9] ;
char    FiOidOut [9] ;
/*char	VerString  [23] ;*/
char	VerString1 [23] ;
char	VerString2 [23] ;
char	VerString3 [23] ;
char	VerString4 [23] ;
char	VerStringDelCre [23] ;
int		vrc ;
int		mytime, mypid ;
char	schemaName [32] ;
long    schemaNo ;
int		scnt ;
long	addKey ;
EXEC SQL END DECLARE SECTION;

EXEC SQL INCLUDE SQLCA;

#ifdef DBPROCS_IMPLEMENTED
int		DbProcUsed = 1 ;
#else
int		DbProcUsed = 0 ;
#endif

int		OmsDebug = 1 ;

#ifdef _WIN32
char    buf [256] ;
#else
FILE    *fo = NULL;
#endif
FILE	*fout ;
int     line , col ;
int     pid ;
int     rolled_back = 0 ;
int     rows = 1000 ;
int     durch ;
int     protocol ;
int     user_c = 0 ;
int     ignore [20] ;
int		check_longs = 0 ;
int		UseOms = 0 ;
int		MaxListNo = 20 ;
int		UseKeys = 0 ;
int		UseOids = 0 ;
int		UpdateVersionIsCreated = 0 ;
int		DummyVersionWasCreated = 0 ;
int		UserWithDummyVersion = 0 ;
int		schemaOpen = 0 ;
void	cwr_ok (int sig) ;
void	cwr () ;

enum	ObjType { OID , KEY } ;
char	*sObjType [] = { "OID" , "KEY" } ;
long	schemaIds [MAXMAXSCHEMAS] ;
int		mSchemas ;
int		maxRuntime = 0 ;
long	endTime = 0 ;
int		endTimeReached = 0 ;

main (argc , argv)
int     argc ;
char    **argv ;
{
    int     i ;
    int     maxdurch ;
    char    head_line [80] ;
    char    **argp ;
    int     ign = 0 ;

#ifndef _WIN32
    fo = fopen ( "/dev/tty" , "w" ) ;
    if ( fo )
      if ( ! isatty(fileno(fo)) )
      {
        fclose(fo);
        fo = NULL ;
      }
#endif
    col = 1 ;

    mypid = pid = getpid () ;

    for ( argp = argv ; *++argp && **argp == '-' ; )
    {
		switch ( (*argp)[1] )
		{
		case 'Z' :
			line = atoi ( *++argp ) ;
			break ;
		case 'z' :
			rows = atoi ( *++argp ) ;
			break ;
		case 'U' :
			sscanf ( *++argp , "%[A-Za-z0-9]%*[,]%[A-Za-z0-9]" , id , pw ) ;
			break ;
		case 'D' :
			maxdurch = atoi ( *++argp ) ;
			break ;
		case 'l' :
			check_longs = 1 ;
			break ;
		case 'o' :
			UseOms = 1 ;
			UseKeys = 1 ;
			UseOids = 1 ;
			break ;
		case 'O' :
			UseOms = 1 ;
			UseKeys = 0 ;
			UseOids = 1 ;
			break ;
		case 'k' :
			UseOms = 1 ;
			UseKeys = 1 ;
			UseOids = 0 ;
			break ;
		case 'N' :
			OmsDebug = 0 ;
			break ;
		case 'i' :
			while ( *++argp && **argp != '-' )
				ignore [ign++] = atoi ( *argp ) ;
			ignore [ign] = 0 ;
			argp-- ;
			break ;
		case 'T' :
			maxRuntime = atoi ( *++argp ) ;
			break ;
		default :

			fprintf ( stderr , "Illegal option '%s'\n" , *argv ) ;
			exit (1) ;
		}
    }

#ifdef OLD
    strcpy (id , argv [1] ) ;
    strcpy (pw , argv [2] ) ;
    line = atoi ( argv [3] ) ;
    rows = atoi ( argv [4] ) ;
    maxdurch = atoi ( argv [5] ) ;
#endif

	if ( maxRuntime > 0 )
	{
		endTime = (long) time ((time_t *) 0 ) + maxRuntime  ;
		maxdurch = 0x7fffffff ;
	}

	{
		char filename [100] ;
		sprintf ( filename , "endlos%s.prot" , id ) ;

		if ( ( fout = fopen ( filename , "a" ) ) == NULL )
		{
			char outtext [100] ;
			sprintf ( outtext , "Error opening file '%s'\n" , filename ) ;
			perror ( outtext ) ;
			exit (-99) ;
		}
	}

    prot ("===== User   = %s =====\n" , id ) ;
    sprintf ( head_line,
		"===== %s = %s =====\n" , ENV_DBNAME, getenv ( ENV_DBNAME ) ) ;
    prot ( head_line, "" ) ;
    prot ("Rows = %d\n" , rows ) ;

	if ( maxRuntime > 0 )
		prot ("Max. Runtime : %d sec\n" , maxRuntime ) ;
	else
		prot ("Max. Durchgaenge : %d\n" , maxdurch ) ;

	del_elements = rows / 50 ;

    EXEC SQL CONNECT :id IDENTIFIED BY :pw KEY SQLOPT ;

    movep ( line , col , "CONNECT , ERR = %d" , SQLC ) ;
    CE ("CONNECT" , 1 ) ;

    signal ( SIGTERM , cwr_ok ) ;

    user_c = ( id[0] == 'C' ) ;

	UserWithDummyVersion = ( ( toupper ( id[0] ) == 'A' ) && id[1] == '1' ) ;

	{
		int *ignp ;
		for ( ignp = ignore ; *ignp ; ignp++ )
			prot ("No Dump Request for Fatal Error = %d\n" , *ignp ) ;
    }

    EXEC SQL SELECT maxr INTO :maxlongraw FROM superu.maxraw WHERE rowno <= 1 ;

    CE ("SELECT MAXRAW ... " , 1 ) ;

    prot ("maxlongraw = %d\n" , maxlongraw ) ;

    memset ( k0 , 'x' , 240 ) ;
    k0[239] = 0 ;
    memset ( c6 , 'y' , 1500 ) ;
    c6 [1499] = 0 ;

    /*srand ( getpid () ) ;*/
	srand( (unsigned)time( NULL ) );

	if ( UseOms )
	{
		char pidString [20] ;
		sprintf ( pidString , "%ld" , (long) pid ) ;

		memset ( VerString1 , 'a' , 22 ) ;
		VerString1 [22] = 0 ;
		memcpy ( VerString1 , pidString , strlen (pidString) ) ;

		memset ( VerString2 , 'b' , 22 ) ;
		VerString2 [22] = 0 ;
		memcpy ( VerString2 , pidString , strlen (pidString) ) ;

		memset ( VerString3 , 'c' , 22 ) ;
		VerString3 [22] = 0 ;
		memcpy ( VerString3 , pidString , strlen (pidString) ) ;

		memset ( VerStringDelCre , 'e' , 22 ) ;
		VerStringDelCre [22] = 0 ;
		memcpy ( VerStringDelCre , pidString , strlen (pidString) ) ;

		memset ( VerString4 , 'd' , 22 ) ;
		VerString4 [22] = 0 ;
		memcpy ( VerString4 , pidString , strlen (pidString) ) ;

		commit () ;

		DropPrivateVersions () ;
/*
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString1, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString2, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString3, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerStringDelCre, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
*/
		if ( OmsDebug )
			DebugOmsOn () ;
	}


	if ( DbProcUsed )
	{
		EXEC SQL CREATE PACKAGE MUTDB_PACK FILE 'MutDbProcsd' INPROC;
		if ( SQLC && SQLC != -6006 )
			CE ( "CREATE PACKAGE MUTDB_PACK: sqlcode %d" , 1) ;

		EXEC SQL CREATE DBPROC MUTUPD100000 IN MUTDB_PACK EXECUTE INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ("CREATE DBPROC MUTUPD100000" , 1 ) ;
		EXEC SQL GRANT EXECUTE ON MUTUPD100000 TO PUBLIC ;
		EXEC SQL COMMIT ;

		EXEC SQL CREATE DBPROC MUTUPDTAB1 IN MUTDB_PACK EXECUTE INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ("CREATE DBPROC MUTUPDTAB1" , 1 ) ;
		EXEC SQL GRANT EXECUTE ON MUTUPDTAB1 TO PUBLIC ;
		EXEC SQL COMMIT ;
	}

	for ( durch = 1 ; durch <= maxdurch && endTimeReached == 0 ; durch++ )
    {

		sprintf ( head_line , "RESOURCE loc '%s', user '%s' : Durchlauf %d" ,
			getenv (ENV_DBNAME) , id , durch ) ;
		movep (line-1 , col , "%s" , head_line ) ;

		if ( ! UseOms )
		{
			switch ( durch % 5 )
			{
			case 0 :
				drop_idx_tab1 () ;
				del_avg_tab1 (0) ;
				alt_tab1_dynamic () ;
				break ;
			case 1 :
				cre_idx_tab1 () ;
				del_avg_tab1 (1) ;
				break ;
			case 2 :
				drop_idx_tab1 () ;
				del_avg_tab1 (0) ;
				update_stat () ;
				break ;
			case 3 :
				update100000 () ;
				alt_tab1_nondynamic () ;
				break ;
			case 4 :
				cre_idx_tab1 () ;
				del_avg_tab1 (1) ;
				break ;
			}
		}
		else if ( UserWithDummyVersion )
		{
			if ( durch % 6 == 2 )
				CreateDummyVersion () ;
			if ( durch % 6 == 3 )
				DropDummyVersion () ;
		}

		if ( UseOms )
		{
			if ( durch % 4 == 1 )
				createManySchemas (id) ;
			if ( durch % 4 == 2 )
				dropManySchemas () ;
		}

		for ( i = 1 ; ( i < 400) && ( endTimeReached == 0 ) ; i++ )
		{
			movep ( line-1 , 60 , "%d" , i ) ;

			if ( UseOms )
			{

				if ( UseOids )
				{
					AddElementToList () ;

					if ( ( pid % 2 == 0 ) && ( i == 300 ) )
						Create100Versions () ;

					if ( ( pid % 2 == 0 ) && ( i == 390 ) )
						Drop100Versions () ;

					if ( ( rand () % 2 ) == 0 )
						DeleteElememtsFromList (1) ;

					if ( ( rand () % 5 ) == 0 )
						TraversePartList (0) ; /* read unlocked*/


					if ( ( rand () % 19 ) == 0 )
						DeleteElememtsFromList (0) ;

					if ( ( rand () % 64 ) == 0 )
						addKeyToSchema () ;

					if ( ( rand () % 87 ) == 0 )
						TraversePartList (1) ; /* read locked*/

					if ( ( rand () % 89 ) == 0 )
						CreateList (0,0) ;

					if ( ( rand () % 189 ) == 0 )
						CreateVarobjList () ;

					if ( ( rand () % 8 ) == 0 )
						AddVarobj () ;

					if ( ( rand () % 29 ) == 0 )
						UpdateVarobjList () ;

					if ( ( rand () % 289 ) == 0 )
						DeleteVarobjList (0,0) ;

					if ( ( rand () % 480 ) == 0 )
						DelCreListInVersion (OID) ;

				}

				if ( UseKeys )
				{
					if ( i % 100 == 1 )
						UpdateVersionKeyList (-9999) ;

					if ( i % 100 == 10 )
						DropVersionUpdateVersionKeyList () ;

					DeleteElememtsFromKeyList (1) ;

					if ( ( rand () % 3 ) == 0 )
						UpdateKeyList (CHL,0) ;

					if ( ( rand () % 5) == 0 )
						UpdateKeyList (OMS1,0) ;

					if ( ( rand () % 9) == 0 )
						UpdateKeyList (CHL,0) ;

					if ( ( rand () % 19 ) == 0 )
						DeleteElememtsFromKeyList (8) ;

					if ( ( rand () % 56 ) == 0 )
						DeleteElememtsFromKeyList (0) ;

					if ( ( rand () % 103 ) == 0 )
						CreateKeyList (CHL,0) ;

					if ( ( rand () % 113 ) == 0 )
						CreateKeyList (OMS1,0) ;

					if ( ( rand () % 143 ) == 0 )
						DeleteKeyList (OMS1,0) ;

					if ( ( rand () % 400 ) == 0 )
						DelCreListInVersion (KEY) ;

				}
			}
			else
			{
				ins_upd_tab1 (i) ;

				if ( ( rand ()  % 2 ) == 0 )
					delete_tab1 () ;

				if ( ( rand ()  % 3 ) == 0 )
					insert_tab20k () ;

				if ( ( rand ()  % 4 ) == 0 )
					insert_tab04sk () ;

				if ( ( rand ()  % 5 ) == 0 )
					sel_upd_sup () ;

				if ( ( rand ()  % 5 ) == 0 )
					sel_ins_sup () ;

				if ( ( rand ()  % 5 ) == 0 )
					del_sup () ;

				if ( ( rand ()  % 7 ) == 0 )
					select_sessions () ;

				if ( ( rand ()  % 6 ) == 0 )
					delete_tab20k_2 () ;

				if ( ( rand ()  % 8 ) == 0 )
					delete_tab20k () ;

				if ( ( rand ()  % 9 ) == 0 )
					ins_tabu2 () ;

				if ( ( rand ()  % 12 ) == 0 )
					check_lr_su () ;

				if ( ( rand ()  % 13 ) == 0 )
					sel_distinct_tab1 () ;

				if ( ( rand ()  % 15 ) == 0 )
					sel_temp_inv_tab1 () ;

				if ( ( rand ()  % 17 ) == 0 )
					sel_first_stab1_ins_tab1 () ;

				if ( ( rand ()  % 18 ) == 0 )
					delete_tab04sk () ;

				if ( ( rand ()  % 19 ) == 0 )
					dbproc_oms1 () ;

				if ( ( rand ()  % 21 ) == 0 )
					update_key_tab20k_1 () ;

				if ( ( rand ()  % 23 ) == 0 )
					update_superu_tab1sl () ;

				if ( ( rand ()  % 29 ) == 0 )
					update_key_tab20k_2 () ;

				if ( ( rand ()  % 35 ) == 0 )
					ins_except_tab1 () ;

				if ( ( rand ()  % 21 ) == 0 )
					update_tab04sk() ;

				if ( ( rand ()  % 37 ) == 0 )
					ins_stab1_sel_first_tab1 () ;

				if ( ( rand ()  % 37 ) == 0 )
				{
					int iii ;
					for ( iii = 0 ; iii < 4 ; iii++ )
					{
						union_all_tab1 () ;
					}
				}

				if ( ( rand ()  % 51 ) == 0 )
					update_stat_sample () ;

				if ( ( rand ()  % 59 ) == 0 )
					insert_array_tab1 ( durch + 2 ) ;

/* now show commands supportes anymore
				if ( ( rand ()  % 63 ) == 0 )
					show_trim_serverdb () ;
*/
				if ( ( rand ()  % 71 ) == 0 )
					upd_tabv1 () ;

				if ( ( rand ()  % 73 ) == 0 )
					complex_select () ;

				if ( ( rand ()  % 79 ) == 0 )
					manycurs () ;

				if ( ( rand ()  % 90 ) == 0 )
					count_tab1 () ;

				if ( ( rand () % 93 ) == 0 )
					select_and_check_superu_tab1sl  ()  ;

				if ( ( rand () % 97 ) == 0 )
					delete_between_tab20k () ;

				if ( ( rand () % 117 ) == 0 )
					delete_range_tab04sk () ;

#ifdef JOIN64
				if ( ( rand ()  % 171 ) == 0 )
					between_sbview () ;

				if ( ( rand ()  % 172 ) == 0 )
					like_bview () ;

				if ( ( rand ()  % 173) == 0 )
					equal_sbview () ;

				if ( ( rand ()  % 174) == 0 )
					equal_bview_only_index () ;

#else
				if ( ( rand ()  % 121 ) == 0 )
					between_sbview_16 () ;

				if ( ( rand ()  % 122 ) == 0 )
					like_bview_16 () ;

				if ( ( rand ()  % 123) == 0 )
					equal_sbview_16 () ;

				if ( ( rand ()  % 124) == 0 )
					equal_bview_only_index_16 () ;
#endif
				if ( i == 1 && durch > 2 )
					del_intersect_superu () ;

				if ( user_c && ( rand ()  % 97 ) == 0 )
					c_ins_sel_upd () ;

				if ( ( rand ()  % 117 ) == 0 )
					release_connect () ;
			}

			if ( maxRuntime > 0 && endTime < (long) time ((time_t *) 0 ) )
			{
				prot ("Endtime reached: %ld\n", (long) time ((time_t *)0) );
				endTimeReached = 1 ;
				/* break ; */
			}
		}

		/*if ( maxRuntime > 0 && endTime < (long) time ((time_t *) 0 ) )
				break ;*/
    }
    movep ( line , col , "***** ENDE *****" , "" ) ;

	if ( UseOms )
	{
		DropDummyVersion () ;
		DropPrivateVersions () ;
	}

	cwr () ;
}

/*------------------------------------------------------------------------*/

void release_connect ()
{
    EXEC SQL
		COMMIT WORK RELEASE  ;

    movep ( line , col , "COMMIT WORK RELEASE , ERR = %d" , SQLC ) ;

    CE ("COMMIT WORK RELEASE " , 1 ) ;

    sleep ( rand () % 5 ) ;

    do
    {
		EXEC SQL CONNECT :id IDENTIFIED BY :pw KEY SQLOPT ;

		movep ( line , col , "CONNECT , ERR = %d" , SQLC ) ;

		CE ("CONNECT" , 0 ) ;

    } while ( rollberr (0) ) ;

    CE ("CONNECT" , 1 ) ;

	if ( UseOms && OmsDebug )
		DebugOmsOn () ;

}

/*------------------------------------------------------------------------*/

void ins_upd_tab1 (ii)
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int     i ;
    EXEC SQL END DECLARE SECTION ;
    i = ii ;
    k1 = rand () % rows ;
    i1 = ( i * 133 ) % 1113 ;
    i2 = ( k1 % 13 ) * 47 + ( i % 10 ) * 9 ;
    sprintf ( c1 , "Name_%s_%d" , id , k1 ) ;
    sprintf ( c2 , "Name.%s_%d" , id , k1 / 10 ) ;
    i3 = i / 10 ;

    movep ( line , col , "INSERT TAB1 , K1 = %d\r" , k1 ) ;

    do
    {
	EXEC SQL
	  INSERT TAB1 VALUES ( :k1 , ( :i * 133 ) MOD 1113  ,
	    ( :k1 MOD 13 ) * 47 + ( :i MOD 10 ) * 9 , :c1 ,
	    :c2 , :i3 ) ;
/*
	'Name.' || substr (:id,1,2) || '_' || chr ( :k1 ) ,
	'Name.' || substr (:id,1,2) || '.' || chr ( :k1 DIV 10 ) ,
*/
	CE ( "INSERT TAB1 (ins_upd_tab1)" , 0 ) ;
    }	while ( rollberr (1) ) ;

    if ( SQLC == 200 )  /* duplicate primary key */
	{
		if ( DbProcUsed == 0 || ( rand () % 5 ) )
		{
			movep ( line , col , "UPDATE TAB1 , K1 = %d\r" , k1 ) ;
			do
			{
				EXEC SQL
					UPDATE TAB1 SET I1 = :i1 , I2 = :i2 ,
					C1 = :c1 , C2 = :c2 WHERE K1 = :k1 ;

				CE ("UPDATE TAB1",0) ;
			}		while ( rollberr (1) ) ;
		}
		else
		{
			movep ( line , col , "UPDATE TAB1 (DBPROC), K1 = %d\r" , k1 ) ;
			do
			{
				EXEC SQL DBPROC MUTUPDTAB1 (:i1,:i2,:c1,:c2,:k1,:rc) ;
				CE ("UPDATE TAB1 (DBPROC)",0) ;
				/* prot ( "UPDATE TAB1 (DBPROC), sqlcode = %d",SQLC); */
			}	while (rollberr (1) ) ;
		}
	}

	CE ("UPDATE TAB1",0) ;
    commit () ;
}

/*------------------------------------------------------------------------*/

void dbproc_oms1 ()
{
	return ;
	i1 = 20 ;
	if ( DbProcUsed )
	{
		movep ( line , col , "DBPROC TEST" , 0) ;
		EXEC SQL DBPROC TEST (:i1,:rc) ;
		CE ("DBPROC TEST",1) ;
	}
}

/*------------------------------------------------------------------------*/

void update100000 ()
{
	long i ;

    if ( ( rand ()  % 6 ) != 0 )
		return ;

	if ( DbProcUsed && ( rand () % 2 == 0 ) )
	{
		movep ( line , col , "UPDATE 100000 TABSMALL (DBPROC)") ;
		EXEC SQL DBPROC MutUpd100000 (:rc) ;
		/*prot ( "UPDATE 100000 TABSMALL (DBPROC), sqlcode = %d",SQLC);*/
		CE ("UPDATE TABSMALL (DBPROC)",1) ;
	}
	else
	{
		movep ( line , col , "UPDATE 100000 TABSMALL") ;
		for ( i = 0 ; i < 100000 ; i++ )
		{
			EXEC SQL
				UPDATE TABSMALL SET S = '2' ;
			CE ("UPDATE TABSMALL",1) ;
		}
	}

    commit () ;
}

/*------------------------------------------------------------------------*/

void del_intersect_superu ()
{
    do
    {
		movep ( line , col , "DELETE ... INTERSECT ... SUPERU.TAB1",0);

		EXEC SQL
			DELETE FROM TAB1
			WHERE K1 IN
			( SELECT K1 FROM superu.TAB1 INTERSECT
			SELECT K1 FROM TAB1 ) ;

		if ( SQLC == -6000 )
		{
			prot ( "DELETE ... INTERSECT ... SUPERU.TAB1 %d",SQLC);
			rollback () ;
		}

		CE ( "DELETE ... INTERSECT ... SUPERU.TAB1",0);

    }	while ( rollberr (1) ) ;

    if ( SQLC == -3009 )
    {
		CE ( "DELETE ... INTERSECT ... SUPERU.TAB1",1);
    }

    if ( rand () % 2 )
    {
		commit () ;
    }
    else
    {
		movep ( line , col , "DELETE ... INTERSECT ... SUPERU.TAB1 (ROLLBACK)",0);
		rollback () ;
    }

}

/*------------------------------------------------------------------------*/

void select_sessions  ()
{
        movep ( line ,col , "SELECT SESSIONS" , 0 ) ;

        EXEC SQL
            SELECT * 
            FROM   sysinfo.sessions;

        CE ("SELECT SESSIONS" ,0) ;

        if ( SQLC != 0 )
        {
            print_f ("** calling sqldump at sessions select**") ;
            Sqldump () ;
        }

}

/*------------------------------------------------------------------------*/

void select_and_check_superu_tab1sl  ()
{
    int loclen ;
    char loclong [100001] ;

    loclong [100000] = (char) 0 ;

    nrll = rand () % 20 ;

    do
    {
        movep ( line ,col , "====== SELECT TAB1SK, nr = %d" , nrll ) ;

        EXEC SQL
            SELECT lnll , clll
            FROM   superu.tab1sl
            WHERE  nrll = :nrll  WITH LOCK ISOLATION LEVEL 1;

        CE ("SELECT TAB1SK" ,0) ;

        if ( SQLC == 0 )
        {
            scl.len = 100000 ;

            EXEC SQL FETCH INTO :lnll , :scl ;

            CE ("FETCH TAB1SK" ,0) ;

            /* In error situations no 0 delimiter is returned by DB. */
            /* So first copy to local array, then perform strlen()  */
            memcpy ( loclong , scl.arr , 100000 ) ;
            loclen = strlen ( scl.arr ) ;

            if ( loclen != lnll )
            {
                prot ( "=== Longlong Table TAB1SL ===\n"             ) ;
                prot ( "Illegal length : nr = %d\n" , nrll ) ;
                prot ( "stored length       = %d\n" , lnll ) ;
                prot ( "strlen (result)     = %d\n" , loclen   ) ;
            }

        }

    } while ( rollberr (1) ) ;

}

/*------------------------------------------------------------------------*/


void  update_superu_tab1sl  ()
{

    nrll = rand () % 20 ;

    do
    {
        movep ( line ,col , "====== UPDATE TAB1SK, nr = %d" , nrll ) ;

        lnll = 50000 + ( rand () % 6 ) * 10000 - 1 ;

        memset ( scl.arr , 's' , lnll ) ;
        scl.arr[0] = scl.arr[lnll-2] = 't' ;
        scl.arr[lnll-1]= (char) 0 ;
        scl.len = lnll = strlen ( scl.arr ) ;


        EXEC SQL
            UPDATE superu.tab1sl
            SET CLLL = :scl , LNLL = :lnll
            WHERE  nrll = :nrll ;

        CE ("UPDATE TAB1SL" ,0) ;

    } while ( rollberr (1) ) ;

    if ( SQLC == 0 )
    {
	if ( rand () % 2 == 0 )
	    EXEC SQL COMMIT ;
	else
	    EXEC SQL ROLLBACK ;
    }
}

/*------------------------------------------------------------------------*/

void ins_except_tab1 ()
{

    if ( rand () % 3 )
		return ;

    do
    {
		movep ( line , col , "INSERT ... EXCEPT ... SUPERU.TAB1",0);

		EXEC SQL
			INSERT TAB1
			SELECT * FROM
			( SELECT K1 , I1 , I2 , C1 , C2 , I3
			FROM SUPERU.TAB1 EXCEPT
			SELECT K1 , I1 , I2 , C1 , C2 , I3 FROM TAB1 )
			IGNORE DUPLICATES ;

		CE ( "INSERT ... EXCEPT ... SUPERU.TAB1",0 );

    } while ( rollberr (1) ) ;

    commit () ;

}
/*------------------------------------------------------------------------*/

void count_tab1 ()
{
    movep (line,col,"SELECT COUNT(*) FROM TAB1",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*)
			FROM TAB1 ;

		CE ("SELECT COUNT(*) FROM TAB1",0) ;
    } while ( rollberr (1) ) ;

    EXEC SQL FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB1, cnt = %d",cnt) ;

    sleep (1) ;

    prot ( "SELECT COUNT(*) FROM TAB1, cnt = %d\n" , cnt ) ;

    CE ("FETCH COUNT(*) TAB1",0) ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void delete_tab1 ()
{
    k1 = rand () % rows ;

    movep ( line , col , "DELETE TAB1 , K1 = %d\r" , k1 ) ;

    do
    {
		EXEC SQL
			DELETE TAB1 KEY K1 = :k1 ;

		CE ( "DELETE TAB1 KEY = :k1" , 0 ) ;

    }	while ( rollberr (1) ) ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void sel_upd_sup ()
{

    k1 = rand () % rows ;

    movep (line,col,"SELECT FROM TAB1" ,0) ;

    do
    {
		EXEC SQL SELECT I1 , I2 , C1 , C2
			INTO :i1 :i1ind , :i2 :i2ind , :c1 :c1ind , :c2 :c2ind
			FROM TAB1
			WHERE K1 = :k1 ;

		CE ("SELECT TAB1" ,0) ;
    }	while ( rollberr (0) ) ;

    SE ("SELECT DIRECT FROM TAB1" ,0) ;

    if (SQLC == 0 && c1ind == 0 && c2ind == 0 && i1ind == 0 && i2ind ==0)
    {
		movep (line,col,"==== UPDATE SUPERU.TAB1 , K1 = %d\r" ,k1);

		do
		{
			EXEC SQL
				UPDATE SUPERU.TAB1
				SET I1 = :i1 , I2 = :i2 , C1 = :c1 , C2 = :c2
				WHERE K1 = :k1 ;

			CE ("UPDATE SUPERU.TAB1",0) ;

		}		while ( rollberr (1) ) ;

		if ( SQLC )
			movep(line,col,"===== UPDATE SUPERU.TAB1 , ERR = %d\r" ,
			SQLC ) ;
		else
		{
			commit () ;
		}
    }

    check_long_raw ( "UPDATE SUPERU.TAB1" , k1 , -1 , -1) ;
}

/*------------------------------------------------------------------------*/

void manycurs ()
{
    movep (line,col,"DECLARE CURSOR C00" ,0) ;
    exec sql declare c00 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C00" ,0) ;
    movep (line,col,"DECLARE CURSOR C01" ,0) ;
    exec sql declare c01 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C01" ,0) ;
    movep (line,col,"DECLARE CURSOR C02" ,0) ;
    exec sql declare c02 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C02" ,0) ;
    movep (line,col,"DECLARE CURSOR C03" ,0) ;
    exec sql declare c03 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C03" ,0) ;
    movep (line,col,"DECLARE CURSOR C04" ,0) ;
    exec sql declare c04 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C04" ,0) ;
    movep (line,col,"DECLARE CURSOR C05" ,0) ;
    exec sql declare c05 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C05" ,0) ;
    movep (line,col,"DECLARE CURSOR C06" ,0) ;
    exec sql declare c06 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C06" ,0) ;
    movep (line,col,"DECLARE CURSOR C07" ,0) ;
    exec sql declare c07 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C07" ,0) ;
    movep (line,col,"DECLARE CURSOR C08" ,0) ;
    exec sql declare c08 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C08" ,0) ;
    movep (line,col,"DECLARE CURSOR C09" ,0) ;
    exec sql declare c09 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C09" ,0) ;
    movep (line,col,"DECLARE CURSOR C10" ,0) ;
    exec sql declare c10 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C10" ,0) ;
    movep (line,col,"DECLARE CURSOR C11" ,0) ;
    exec sql declare c11 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C11" ,0) ;
    movep (line,col,"DECLARE CURSOR C12" ,0) ;
    exec sql declare c12 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C12" ,0) ;
    movep (line,col,"DECLARE CURSOR C13",0) ;
    exec sql declare c13 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C13" ,0) ;
    movep (line,col,"DECLARE CURSOR C14" ,0) ;
    exec sql declare c14 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C14" ,0) ;
    movep (line,col,"DECLARE CURSOR C15" ,0) ;
    exec sql declare c15 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C15" ,0) ;
    movep (line,col,"DECLARE CURSOR C16" ,0) ;
    exec sql declare c16 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C16" ,0) ;
    movep (line,col,"DECLARE CURSOR C17" ,0) ;
    exec sql declare c17 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C17" ,0) ;
    movep (line,col,"DECLARE CURSOR C18" ,0) ;
    exec sql declare c18 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C18" ,0) ;
    movep (line,col,"DECLARE CURSOR C19" ,0) ;
    exec sql declare c19 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C19" ,0) ;
    movep (line,col,"DECLARE CURSOR C20" ,0) ;
    exec sql declare c20 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C20" ,0) ;
    movep (line,col,"DECLARE CURSOR C21" ,0) ;
    exec sql declare c21 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C21" ,0) ;
    movep (line,col,"DECLARE CURSOR C22" ,0) ;
    exec sql declare c22 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C22" ,0) ;
    movep (line,col,"DECLARE CURSOR C23" ,0) ;
    exec sql declare c23 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C23" ,0) ;
    movep (line,col,"DECLARE CURSOR C24" ,0) ;
    exec sql declare c24 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C24" ,0) ;
    movep (line,col,"DECLARE CURSOR C25" ,0) ;
    exec sql declare c25 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C25" ,0) ;
    movep (line,col,"DECLARE CURSOR C26" ,0) ;
    exec sql declare c26 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C26" ,0) ;
    movep (line,col,"DECLARE CURSOR C27" ,0) ;
    exec sql declare c27 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C27" ,0) ;
    movep (line,col,"DECLARE CURSOR C28" ,0) ;
    exec sql declare c28 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C28" ,0) ;
    movep (line,col,"DECLARE CURSOR C29" ,0) ;
    exec sql declare c29 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C29" ,0) ;
    movep (line,col,"DECLARE CURSOR C30" ,0) ;
    exec sql declare c30 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C30" ,0) ;
    movep (line,col,"DECLARE CURSOR C31" ,0) ;
    exec sql declare c31 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C31" ,0) ;
    movep (line,col,"DECLARE CURSOR C32" ,0) ;
    exec sql declare c32 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C32" ,0) ;
    movep (line,col,"DECLARE CURSOR C33" ,0) ;
    exec sql declare c33 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C33" ,0) ;
    movep (line,col,"DECLARE CURSOR C34" ,0) ;
    exec sql declare c34 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C34" ,0) ;
    movep (line,col,"DECLARE CURSOR C35" ,0) ;
    exec sql declare c35 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C35" ,0) ;
    movep (line,col,"DECLARE CURSOR C36" ,0) ;
    exec sql declare c36 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C36" ,0) ;
    movep (line,col,"DECLARE CURSOR C37" ,0) ;
    exec sql declare c37 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C37" ,0) ;
    movep (line,col,"DECLARE CURSOR C38" ,0) ;
    exec sql declare c38 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C38" ,0) ;
    movep (line,col,"DECLARE CURSOR C39" ,0) ;
    exec sql declare c39 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C39" ,0) ;
    movep (line,col,"DECLARE CURSOR C40" ,0) ;
    exec sql declare c40 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C40" ,0) ;
    movep (line,col,"DECLARE CURSOR C41" ,0) ;
    exec sql declare c41 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C41" ,0) ;
    movep (line,col,"DECLARE CURSOR C42" ,0) ;
    exec sql declare c42 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C42" ,0) ;
    movep (line,col,"DECLARE CURSOR C43" ,0) ;
    exec sql declare c43 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C43" ,0) ;
    movep (line,col,"DECLARE CURSOR C44" ,0) ;
    exec sql declare c44 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C44" ,0) ;
    movep (line,col,"DECLARE CURSOR C45" ,0) ;
    exec sql declare c45 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C45" ,0) ;
    movep (line,col,"DECLARE CURSOR C46" ,0) ;
    exec sql declare c46 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C46" ,0) ;
    movep (line,col,"DECLARE CURSOR C47" ,0) ;
    exec sql declare c47 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C47" ,0) ;
    movep (line,col,"DECLARE CURSOR C48" ,0) ;
    exec sql declare c48 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C48" ,0) ;
    movep (line,col,"DECLARE CURSOR C49" ,0) ;
    exec sql declare c49 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C49" ,0) ;
    movep (line,col,"DECLARE CURSOR C50" ,0) ;
    exec sql declare c50 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C50" ,0) ;
    movep (line,col,"DECLARE CURSOR C51" ,0) ;
    exec sql declare c51 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C51" ,0) ;
    movep (line,col,"DECLARE CURSOR C52" ,0) ;
    exec sql declare c52 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C52" ,0) ;
    movep (line,col,"DECLARE CURSOR C53" ,0) ;
    exec sql declare c53 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C53" ,0) ;
    movep (line,col,"DECLARE CURSOR C54" ,0) ;
    exec sql declare c54 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C54" ,0) ;
    movep (line,col,"DECLARE CURSOR C55" ,0) ;
    exec sql declare c55 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C55" ,0) ;
    movep (line,col,"DECLARE CURSOR C56" ,0) ;
    exec sql declare c56 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C56" ,0) ;
    movep (line,col,"DECLARE CURSOR C57" ,0) ;
    exec sql declare c57 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C57" ,0) ;
    movep (line,col,"DECLARE CURSOR C58" ,0) ;
    exec sql declare c58 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C58" ,0) ;
    movep (line,col,"DECLARE CURSOR C59" ,0) ;
    exec sql declare c59 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C59" ,0) ;
    movep (line,col,"DECLARE CURSOR C60" ,0) ;
    exec sql declare c60 cursor for SELECT * FROM SUPERU.TAB1 ;
    SE ("DECLARE CURSOR C60" ,0) ;
    movep (line,col,"DECLARE CURSOR C61" ,0) ;
    exec sql declare c61 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C61" ,0) ;
    movep (line,col,"DECLARE CURSOR C62" ,0) ;
    exec sql declare c62 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C62" ,0) ;
    movep (line,col,"DECLARE CURSOR C63" ,0) ;
    exec sql declare c63 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C63" ,0) ;
    movep (line,col,"DECLARE CURSOR C64" ,0) ;
    exec sql declare c64 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C64" ,0) ;
    movep (line,col,"DECLARE CURSOR C65" ,0) ;
    exec sql declare c65 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C65" ,0) ;
    movep (line,col,"DECLARE CURSOR C66" ,0) ;
    exec sql declare c66 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C66" ,0) ;
    movep (line,col,"DECLARE CURSOR C67" ,0) ;
    exec sql declare c67 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C67" ,0) ;
    movep (line,col,"DECLARE CURSOR C68" ,0) ;
    exec sql declare c68 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C68" ,0) ;
    movep (line,col,"DECLARE CURSOR C69" ,0) ;
    exec sql declare c69 cursor for SELECT * FROM TAB1 ;
    SE ("DECLARE CURSOR C69" ,0) ;


    movep (line,col,"OPEN CURSOR C00" ,0) ;
    exec sql open c00 ;
    SE ("OPEN CURSOR C00" ,0) ;
    movep (line,col,"OPEN CURSOR C01" ,0) ;
    exec sql open c01 ;
    SE ("OPEN CURSOR C01" ,0) ;
    movep (line,col,"OPEN CURSOR C02" ,0) ;
    exec sql open c02 ;
    SE ("OPEN CURSOR C02" ,0) ;
    movep (line,col,"OPEN CURSOR C03" ,0) ;
    exec sql open c03 ;
    SE ("OPEN CURSOR C03" ,0) ;
    movep (line,col,"OPEN CURSOR C04" ,0) ;
    exec sql open c04 ;
    SE ("OPEN CURSOR C04" ,0) ;
    movep (line,col,"OPEN CURSOR C05" ,0) ;
    exec sql open c05 ;
    SE ("OPEN CURSOR C05" ,0) ;
    movep (line,col,"OPEN CURSOR C06" ,0) ;
    exec sql open c06 ;
    SE ("OPEN CURSOR C06" ,0) ;
    movep (line,col,"OPEN CURSOR C07" ,0) ;
    exec sql open c07 ;
    SE ("OPEN CURSOR C07" ,0) ;
    movep (line,col,"OPEN CURSOR C08" ,0) ;
    exec sql open c08 ;
    SE ("OPEN CURSOR C08" ,0) ;
    movep (line,col,"OPEN CURSOR C09" ,0) ;
    exec sql open c09 ;
    SE ("OPEN CURSOR C09" ,0) ;
    movep (line,col,"OPEN CURSOR C10" ,0) ;
    exec sql open c10 ;
    SE ("OPEN CURSOR C10" ,0) ;
    movep (line,col,"OPEN CURSOR C11" ,0) ;
    exec sql open c11 ;
    SE ("OPEN CURSOR C11" ,0) ;
    movep (line,col,"OPEN CURSOR C12" ,0) ;
    exec sql open c12 ;
    SE ("OPEN CURSOR C12" ,0) ;
    movep (line,col,"OPEN CURSOR C13" ,0) ;
    exec sql open c13 ;
    SE ("OPEN CURSOR C13" ,0) ;
    movep (line,col,"OPEN CURSOR C14" ,0) ;
    exec sql open c14 ;
    SE ("OPEN CURSOR C14" ,0) ;
    movep (line,col,"OPEN CURSOR C15" ,0) ;
    exec sql open c15 ;
    SE ("OPEN CURSOR C15" ,0) ;
    movep (line,col,"OPEN CURSOR C16" ,0) ;
    exec sql open c16 ;
    SE ("OPEN CURSOR C16" ,0) ;
    movep (line,col,"OPEN CURSOR C17" ,0) ;
    exec sql open c17 ;
    SE ("OPEN CURSOR C17" ,0) ;
    movep (line,col,"OPEN CURSOR C18" ,0) ;
    exec sql open c18 ;
    SE ("OPEN CURSOR C18" ,0) ;
    movep (line,col,"OPEN CURSOR C19" ,0) ;
    exec sql open c19 ;
    SE ("OPEN CURSOR C19" ,0) ;
    movep (line,col,"OPEN CURSOR C20" ,0) ;
    exec sql open c20 ;
    SE ("OPEN CURSOR C20" ,0) ;
    movep (line,col,"OPEN CURSOR C21" ,0) ;
    exec sql open c21 ;
    SE ("OPEN CURSOR C21" ,0) ;
    movep (line,col,"OPEN CURSOR C22" ,0) ;
    exec sql open c22 ;
    SE ("OPEN CURSOR C22" ,0) ;
    movep (line,col,"OPEN CURSOR C23" ,0) ;
    exec sql open c23 ;
    SE ("OPEN CURSOR C23" ,0) ;
    movep (line,col,"OPEN CURSOR C24" ,0) ;
    exec sql open c24 ;
    SE ("OPEN CURSOR C24" ,0) ;
    movep (line,col,"OPEN CURSOR C25" ,0) ;
    exec sql open c25 ;
    SE ("OPEN CURSOR C25" ,0) ;
    movep (line,col,"OPEN CURSOR C26" ,0) ;
    exec sql open c26 ;
    SE ("OPEN CURSOR C26" ,0) ;
    movep (line,col,"OPEN CURSOR C27" ,0) ;
    exec sql open c27 ;
    SE ("OPEN CURSOR C27" ,0) ;
    movep (line,col,"OPEN CURSOR C28" ,0) ;
    exec sql open c28 ;
    SE ("OPEN CURSOR C28" ,0) ;
    movep (line,col,"OPEN CURSOR C29" ,0) ;
    exec sql open c29 ;
    SE ("OPEN CURSOR C29" ,0) ;
    movep (line,col,"OPEN CURSOR C30" ,0) ;
    exec sql open c30 ;
    SE ("OPEN CURSOR C30" ,0) ;
    movep (line,col,"OPEN CURSOR C31" ,0) ;
    exec sql open c31 ;
    SE ("OPEN CURSOR C31" ,0) ;
    movep (line,col,"OPEN CURSOR C32" ,0) ;
    exec sql open c32 ;
    SE ("OPEN CURSOR C32" ,0) ;
    movep (line,col,"OPEN CURSOR C33" ,0) ;
    exec sql open c33 ;
    SE ("OPEN CURSOR C33" ,0) ;
    movep (line,col,"OPEN CURSOR C34" ,0) ;
    exec sql open c34 ;
    SE ("OPEN CURSOR C34" ,0) ;
    movep (line,col,"OPEN CURSOR C35" ,0) ;
    exec sql open c35 ;
    SE ("OPEN CURSOR C35" ,0) ;
    movep (line,col,"OPEN CURSOR C36" ,0) ;
    exec sql open c36 ;
    SE ("OPEN CURSOR C36" ,0) ;
    movep (line,col,"OPEN CURSOR C37" ,0) ;
    exec sql open c37 ;
    SE ("OPEN CURSOR C37" ,0) ;
    movep (line,col,"OPEN CURSOR C38" ,0) ;
    exec sql open c38 ;
    SE ("OPEN CURSOR C38" ,0) ;
    movep (line,col,"OPEN CURSOR C39" ,0) ;
    exec sql open c39 ;
    SE ("OPEN CURSOR C39" ,0) ;
    movep (line,col,"OPEN CURSOR C40" ,0) ;
    exec sql open c40 ;
    SE ("OPEN CURSOR C40" ,0) ;
    movep (line,col,"OPEN CURSOR C41" ,0) ;
    exec sql open c41 ;
    SE ("OPEN CURSOR C41" ,0) ;
    movep (line,col,"OPEN CURSOR C42" ,0) ;
    exec sql open c42 ;
    SE ("OPEN CURSOR C42" ,0) ;
    movep (line,col,"OPEN CURSOR C43" ,0) ;
    exec sql open c43 ;
    SE ("OPEN CURSOR C43" ,0) ;
    movep (line,col,"OPEN CURSOR C44" ,0) ;
    exec sql open c44 ;
    SE ("OPEN CURSOR C44" ,0) ;
    movep (line,col,"OPEN CURSOR C45" ,0) ;
    exec sql open c45 ;
    SE ("OPEN CURSOR C45" ,0) ;
    movep (line,col,"OPEN CURSOR C46" ,0) ;
    exec sql open c46 ;
    SE ("OPEN CURSOR C46" ,0) ;
    movep (line,col,"OPEN CURSOR C47" ,0) ;
    exec sql open c47 ;
    SE ("OPEN CURSOR C47" ,0) ;
    movep (line,col,"OPEN CURSOR C48" ,0) ;
    exec sql open c48 ;
    SE ("OPEN CURSOR C48" ,0) ;
    movep (line,col,"OPEN CURSOR C49" ,0) ;
    exec sql open c49 ;
    SE ("OPEN CURSOR C49" ,0) ;
    movep (line,col,"OPEN CURSOR C50" ,0) ;
    exec sql open c50 ;
    SE ("OPEN CURSOR C50" ,0) ;
    movep (line,col,"OPEN CURSOR C51" ,0) ;
    exec sql open c51 ;
    SE ("OPEN CURSOR C51" ,0) ;
    movep (line,col,"OPEN CURSOR C52" ,0) ;
    exec sql open c52 ;
    SE ("OPEN CURSOR C52" ,0) ;
    movep (line,col,"OPEN CURSOR C53" ,0) ;
    exec sql open c53 ;
    SE ("OPEN CURSOR C53" ,0) ;
    movep (line,col,"OPEN CURSOR C54" ,0) ;
    exec sql open c54 ;
    SE ("OPEN CURSOR C54" ,0) ;
    movep (line,col,"OPEN CURSOR C55" ,0) ;
    exec sql open c55 ;
    SE ("OPEN CURSOR C55" ,0) ;
    movep (line,col,"OPEN CURSOR C56" ,0) ;
    exec sql open c56 ;
    SE ("OPEN CURSOR C56" ,0) ;
    movep (line,col,"OPEN CURSOR C57" ,0) ;
    exec sql open c57 ;
    SE ("OPEN CURSOR C57" ,0) ;
    movep (line,col,"OPEN CURSOR C58" ,0) ;
    exec sql open c58 ;
    SE ("OPEN CURSOR C58" ,0) ;
    movep (line,col,"OPEN CURSOR C59" ,0) ;
    exec sql open c59 ;
    SE ("OPEN CURSOR C59" ,0) ;
    movep (line,col,"OPEN CURSOR C60" ,0) ;
    exec sql open c60 ;
    SE ("OPEN CURSOR C60" ,0) ;
    movep (line,col,"OPEN CURSOR C61" ,0) ;
    exec sql open c61 ;
    SE ("OPEN CURSOR C61" ,0) ;
    movep (line,col,"OPEN CURSOR C62" ,0) ;
    exec sql open c62 ;
    SE ("OPEN CURSOR C62" ,0) ;
    movep (line,col,"OPEN CURSOR C63" ,0) ;
    exec sql open c63 ;
    SE ("OPEN CURSOR C63" ,0) ;
    movep (line,col,"OPEN CURSOR C64" ,0) ;
    exec sql open c64 ;
    SE ("OPEN CURSOR C64" ,0) ;
    movep (line,col,"OPEN CURSOR C65" ,0) ;
    exec sql open c65 ;
    SE ("OPEN CURSOR C65" ,0) ;
    movep (line,col,"OPEN CURSOR C66" ,0) ;
    exec sql open c66 ;
    SE ("OPEN CURSOR C66" ,0) ;
    movep (line,col,"OPEN CURSOR C67" ,0) ;
    exec sql open c67 ;
    SE ("OPEN CURSOR C67" ,0) ;
    movep (line,col,"OPEN CURSOR C68" ,0) ;
    exec sql open c68 ;
    SE ("OPEN CURSOR C68" ,0) ;
    movep (line,col,"OPEN CURSOR C69" ,0) ;
    exec sql open c69 ;
    SE ("OPEN CURSOR C69" ,0) ;

    movep (line,col,"SELECT * FROM DOMAIN.TABLES" ,0) ;
    EXEC SQL SELECT * FROM domain.tables WHERE tablename LIKE 'T*' ;
    SE ("SELECT * FROM DOMAIN.TABLES" , 0 ) ;

    if ( rand () % 2 )
	rollback () ;
}

/*------------------------------------------------------------------------*/

void union_all_tab1 ()
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int u1,u2,u3,u4,u5,u6,u7,u8,u9,u10;
    int u11,u12,u13,u14,u15,u16,u17,u18,u19,u20;
    EXEC SQL END DECLARE SECTION ;

    u1 = rand () % rows ;
    u2 = rand () % rows ;
    u3 = rand () % rows ;
    u4 = rand () % rows ;
    u5 = rand () % rows ;
    u6 = rand () % rows ;
    u7 = rand () % rows ;
    u8 = rand () % rows ;
    u9 = rand () % rows ;
    u10 = rand () % rows ;
    u11 = rand () % rows ;
    u12 = rand () % rows ;
    u13 = rand () % rows ;
    u14 = rand () % rows ;
    u15 = rand () % rows ;
    u16 = rand () % rows ;
    u17 = rand () % rows ;
    u18 = rand () % rows ;
    u19 = rand () % rows ;
    u20 = rand () % rows ;

    do
    {
    movep (line,col,"SELECT ... FROM TAB1 UNION ALL ..." ,0) ;

    EXEC SQL
      SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u1
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u2
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u3
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u4
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u5
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u6
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u7
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u8
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u9
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u10
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u11
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u12
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u13
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u14
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u15
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u16
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u17
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u18
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u19
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u20
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u2
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u3
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u4
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u5
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u6
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u7
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u8
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u9
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u10
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u11
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u12
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u13
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u14
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u15
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u16
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u17
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u18
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u19
      UNION ALL SELECT I1 , I2 , C1 , C2 , I3 FROM TAB1 WHERE K1 = :u20 ;

      CE ("SELECT ... FROM TAB1 UNION ALL ...",0);

      if ( SQLC == 0 )
      {
	  while ( SQLC == 0 )
	  {
		EXEC SQL FETCH INTO :i1,:i2,:c1,:c2,:i3 ;
		CE ("FETCH ... SELECT ... FROM TAB1 UNION ALL ...",0);
	  }
      }
      else if ( ROLLBERR )
      {
	  CE ("SELECT ... FROM TAB1 UNION ALL ...",0) ;
      }
      else if ( SQLC != 100 )
      {
	  CE ("SELECT ... FROM TAB1 UNION ALL ...",1) ;
      }
   } while ( rollberr (1) ) ;
}

/*------------------------------------------------------------------------*/

void sel_ins_sup ()
{

    k1 = rand () % rows ;

    movep (line,col,"SELECT DIRECT FROM TAB1" ,0) ;

    cll.len = 17000 + 2 ;

    EXEC SQL
		SELECT  I1 , I2 , C1 , C2 , I3
		INTO :i1 :i1ind , :i2 :i2ind , :c1 :c1ind , :c2 :c2ind , :i3 :i3ind
		FROM TAB1 WHERE  K1 = :k1 ;

    CE ("SELECT FROM TAB1" ,0) ;
    SE ("SELECT FROM TAB1" ,0) ;

    if ( SQLC == 0 && c1ind == 0 && c2ind == 0 && i1ind == 0
		&& i2ind == 0 && i3ind == 0 && icllen == 0 )
    {
		movep (line,col,"==== INSERT SUPERU.TAB1 , K1 = %d\r" ,k1);

		cll.len = rand () % maxlongraw + 4 ;
		cllen = cll.len ;
		memset ( cll.arr , '1' , cll.len ) ;

        memset ( c6 , 'y' , 1500 ) ;
        c6 [(rand()%1250)+250] = 0 ;

		cll.arr[0] = ( cll.len >> 8 ) & 0x7f  ;
		cll.arr[1] = cll.len & 0x7f ;
		cll.arr[2] = '+' ;
		cll.arr[cll.len-1] = '+' ;

		EXEC SQL
			INSERT SUPERU.TAB1
				SET K0 = :k0 , K1 = :k1 ,
				I1 = :i1 , I2 = :i2 , C1 = :c1 , C2 = :c2 ,
				I3 = :i3 , CLLEN = :cllen , CF0 = :c6 , CLB = :cll ;
				/* BI_16 = 'aaaaa', BI_201 = 'a' ; */
		/*
			VALUES ( :k0 , :k1 , :i1 , :i2 , :c1 , :c2 ,
			:i3 , :cllen , :c6 , :cll ) ;
		*/

		CE ("INSERT SUPERU.TAB1",0) ;

		if ( SQLC )
		{
			movep (line,col,"===== INSERT SUPERU.TAB1 , ERR = %d\r" ,
				SQLC ) ;
			rollback () ;
		}
		else
		{
			if ( rand () % 3 )
				commit () ;
			else
				rollback () ;
		}
    }

    check_long_raw ( "INSERT SUPERU.TAB1" , k1 , -1 , -1) ;
}

/*------------------------------------------------------------------------*/

void check_long_raw (c,k1,i1,i2)
char	*c ;
int	k1 ;
int	i1 ;
int	i2 ;
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int	kk1 ;
    int	ii1 ;
    int	ii2 ;
    EXEC SQL END DECLARE SECTION ;

    if ( check_longs == 0 ) return ;

    movep (line,col,"===== CHECK long raw >%s<" ,c) ;

    cll.len = MAXLONGRAW ;

    if ( k1 >= 0 )
    {
	kk1 = k1 ;
	EXEC SQL
	  SELECT K1 , CLLEN , CLB
	  FROM superu.TAB1
	  WHERE K1 = :kk1 WITH LOCK ISOLATION LEVEL 1 ;

	SE ("SELECT CLLEN , CLB FROM TAB1, K1 =" ,0) ;
    }
    else
    {
	ii1 = i1 ;
	ii2 = i2 ;
	EXEC SQL
	  SELECT K1 , CLLEN , CLB
	  FROM superu.TAB1
	  WHERE I1 BETWEEN :ii1 AND :ii2 WITH LOCK ISOLATION LEVEL 1 ;

	SE ("SELECT CLLEN , CLB FROM TAB1, BETWEEN ..." ,0) ;
    }

    while ( SQLC == 0 )
    {
	cll.len = MAXLONGRAW ;

        EXEC SQL FETCH INTO :kk1 , :cllen :icllen , :cll  :icll ;

	if ( SQLC == 100 )
	    return ;

	if ( SQLC == 0 && icllen == 0 )
	{
	    if ( cll.len != cllen )
	    {
		prot ( "=== %s ===\n" 		    , c ) ;
		prot ( "Illegal length : k1 = %d\n" , kk1 ) ;
		prot ( "cll.len             = %d\n" , cll.len ) ;
		prot ( "cllen               = %d\n" , cllen ) ;
        if ( DumpOnLongCheck )
		{
		    print_f ("** calling sqldump **") ;
		    Sqldump () ;
		    exit ( 1 ) ;
		}
	    }
	    else if  ( cllen > 1000 )
	    {
		int	i ;

		if ( cll.arr [2] != cll.arr[cllen-1] )
		{
		    prot ( "=== %s ===\n" 		    , c ) ;
		    prot ( "Illegal start/endmark of long raw : k1 = %d\n" , kk1 ) ;
            if ( DumpOnLongCheck )
		    {
		        print_f ("** calling sqldump **") ;
		        Sqldump () ;
		        exit ( 1 ) ;
		    }
		}

		for ( i = 3 ; i < cllen - 2 ; i++ )
		{
		    if ( cll.arr[3] != cll.arr[i] )
		    {
			prot ( "=== %s ===\n" 		    , c ) ;
			prot ( "Illegal char in long raw : k1 = %d\n" , kk1 ) ;
	        	if ( DumpOnLongCheck )
			{
			    print_f ("** calling sqldump **") ;
			    Sqldump () ;
			    exit ( 1 ) ;
			}
		    }
		}
	    }
	}
    }
}

/*------------------------------------------------------------------------*/

void check_lr_su ()
{

    k1 = rand () % rows ;

    movep (line,col,"===== SELECT NEXT long raw FROM TAB1" ,0) ;

    cll.len = MAXLONGRAW ;

	/*ADIS 1000700 */

    EXEC SQL
      SELECT CLLEN , CLB
      INTO :cllen :icllen , :cll :icll
      FROM superu.TAB1
      WHERE K1 = :k1 AND K0 = :k0 ;

    CE ("SELECT DIRECT CLLEN , CLB FROM TAB1" ,0) ;
    SE ("SELECT DIRECT CLLEN , CLB FROM TAB1" ,0) ;

    if ( SQLC == 0 && icllen == 0 )
    {
	movep (line,col,"===== CHECK long raw SUPERU.TAB1 , K1 = %d\r" ,k1);

	if ( cll.len != cllen )
	{
	    prot ( "Illegal length : k1 = %d\n" , k1 ) ;
	    prot ( "cll.len             = %d\n" , cll.len ) ;
	    prot ( "cllen               = %d\n" , cllen ) ;
	    if ( DumpOnLongCheck )
	    {
	        print_f ("** calling sqldump **") ;
	        Sqldump () ;
	        exit ( 1 ) ;
	    }
	}
	else if  ( cllen > 4 )
	{
	    int	i ;

	    if ( ( cllen > 1000 ) && ( cll.arr [2] != cll.arr[cllen-1]) )
	    {
		prot ( "Illegal start/endmark of long raw : k1 = %d\n" , k1 ) ;
	        if ( DumpOnLongCheck )
		{
		    print_f ("** calling sqldump **") ;
		    Sqldump () ;
		    exit ( 1 ) ;
		}
	    }

	    for ( i = 3 ; i < cllen-1 ; i++ )
	    {
		if ( cll.arr[3] != cll.arr[i] )
		{
		    prot ( "Illegal char in long raw : k1 = %d\n" , k1 ) ;
	            if ( DumpOnLongCheck )
		    {
		        print_f ("** calling sqldump **") ;
		        Sqldump () ;
		        exit ( 1 ) ;
		    }
		}
	    }
	}
    }
}

/*------------------------------------------------------------------------*/

void del_sup ()
{
 	int udb ;
	k1 = rand () % rows ;

	udb = ( DbProcUsed && ( rand () % 2 ) ) ;

	if ( udb )
		movep ( line , col , "===== DELETE SUPERU.TAB1 , K1 = %d (DBPROC)\r" , k1 ) ;
	else
		movep ( line , col , "===== DELETE SUPERU.TAB1 , K1 = %d\r" , k1 ) ;

    do
    {
		if ( udb )
		{
			EXEC SQL DBPROC MUTDELSUPTAB1 ( :k1 , :ResultCount, :rc) ;
			CE ( "===== DELETE SUPERU.TAB1 (DBPROC)" , 0 ) ;
		}
		else
		{
			EXEC SQL
				DELETE SUPERU.TAB1
				WHERE K1 = :k1 ;
			CE ( "===== DELETE SUPERU.TAB1" , 0 ) ;
		}

    } while ( rollberr (1) ) ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void update_stat_sample ()
{
    movep (line,col,"UPDATE STATISTICS ... SAMPLE \n",0) ;

    do
    {
	EXEC SQL UPDATE STATISTICS TAB1 ESTIMATE SAMPLE 1000 ROWS  ;
	CE ("UPDATE STATISTICS ... SAMPLE" , 0 ) ;

    } while ( rollberr (2) ) ;

    CE ("UPDATE STATISTICS ... SAMPLE" , 1 ) ;

    commit () ;

    movep (line,col,"UPDATE STATISTICS COLUMN ... SAMPLE \n",0) ;

    do
    {
	EXEC SQL UPDATE STATISTICS COLUMN (*) FOR TAB1 ESTIMATE SAMPLE
		1000 ROWS  ;
	CE ("UPDATE STATISTICS COLUMN ... SAMPLE" , 0 ) ;

    } while ( rollberr (2) ) ;

    CE ("UPDATE STATISTICS COLUMN ... SAMPLE" , 1 ) ;

    commit () ;

}
/*------------------------------------------------------------------------*/

void update_stat ()
{
    movep (line,col,"UPDATE STATISTICS *\n",0) ;

    do
    {
	EXEC SQL UPDATE STATISTICS * ;
	CE ("UPDATE STATISTICS *" , 0 ) ;

    } while ( rollberr (2) ) ;

    CE ("UPDATE STATISTICS *" , 1 ) ;

    commit () ;

}

/*------------------------------------------------------------------------*/

void del_avg_tab1 (rollback_request)
int     rollback_request ;
{
    if ( rand () % 2 )
		return ;

    movep ( line , col , "DELETE TAB1 WHERE ... SELECT AVG ()","" ) ;

    do
    {
		EXEC SQL
			DELETE TAB1
			WHERE ( I1 + I2 ) >
			( SELECT AVG ( I1 + I2 )
			FROM PUBVIEW ) ;

		CE ( "DELETE TAB1 WHERE ... SELECT AVG ()",0 ) ;
		SE ( "DELETE TAB1 WHERE ... SELECT AVG ()",0 ) ;
    }	while ( rollberr (1) ) ;

    if ( rollback_request )
    {
		CE ( "DELETE TAB1 WHERE ... SELECT AVG : ROLLBACK (ok)",0) ;
		rollback () ;
    }
    else
    {
		commit () ;
    }
}

/*------------------------------------------------------------------------*/

void ins_tabu2 ()
{
    k1 = rand () % rows ;
    i1 = rand () % rows ;
    i2 = rand () % rows ;
    i3 = ( rand () % rows ) / 10 ;
    i4 = ( rand () % rows ) / 100 ;
    sprintf ( c1 , "ins_%s_%d" , id , i1 ) ;
    sprintf ( c2 , "ins_%s_%d" , id , i2 / 10 ) ;
    sprintf ( c3 , "abu_%s_%d" , id , i2 / 10 ) ;

    do
    {
		movep ( line , col ,"===== INSERT TABU14","" ) ;

		EXEC SQL
			INSERT TABU14
			VALUES ( :k1 , :i1 , :i2 , :c1 , :c2 , :i3 , :i4 , :c3 ) ;

		if ( SQLC != 360 )
			CE ("INSERT TABU14",0) ;
    }	while ( rollberr (1) ) ;

    if ( SQLC == 0 )
		commit () ;
    else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void upd_tabv1 ()
{
    nr = rand () % rows ;

    do
    {
	EXEC SQL
	  SELECT K1 , I1
	  FROM TABV1
	  WHERE K1 = :nr ;

	CE ("SELECT K1 , I1 FROM TABV1 (upd_tabv1)" , 0 ) ;

    }		while ( rollberr (2) ) ;

    if ( SQLC == 0 )
    {
	EXEC SQL
	  FETCH INTO :k1 , :i1 ;

	movep ( line , col ,"SELECT DIRECT I3 ","" ) ;

	EXEC SQL
	  SELECT  I3
	  INTO :i3 FROM TAB1 WHERE K1 = :k1 ;

	CE ("SELECT DIRECT I3 ",0) ;
	SE ("SELECT DIRECT I3 ",0) ;

	if ( SQLC )
	{
	    movep ( line , col ,"UPDATE TABV1","" ) ;
	    do
	    {
		EXEC SQL
		  UPDATE TABV1
		  SET I1 = 100
		  WHERE I3 = :i3 ;

		CE ("UPDATE TABV1",0) ;
	    }			while ( rollberr (1) ) ;

	    commit () ;
	}
	else
	    rollback () ;
    }
    else
	pe ("SELECT TABV1",0);
}

/*------------------------------------------------------------------------*/

void sel_distinct_tab1 ()
{
    sprintf ( c1 , "*%s*" , id ) ;

    movep ( line , col , "===== SELECT DISTINCT C1,I3 FROM SUPERU.TAB1","");

    EXEC SQL
      SELECT DISTINCT C1 , I3
      FROM SUPERU.TAB1
      WHERE C1 LIKE :c1 ;

    CE ( "SELECT DISTINCT C1,I3 FROM SUPERU.TAB1",0);
    SE ( "SELECT DISTINCT C1,I3 FROM SUPERU.TAB1",0);

}

/*------------------------------------------------------------------------*/

void sel_temp_inv_tab1 ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	char k00 [240] ;
	long k01,i01;
	EXEC SQL END DECLARE SECTION ;

	nr = rand () % rows ;

    movep ( line , col , "===== SELECT temp inv FROM SUPERU.TAB1","");

	do
	{
		EXEC SQL
		SELECT K0,K1,I1 FROM SUPERU.TAB1
		WHERE K1 BETWEEN :nr and (:nr + 100)
		ORDER BY K0,K1 ;

	} while ( rollberr (1) ) ;

    CE ( "SELECT temp inv FROM SUPERU.TAB1",0);

	while ( SQLC == 0 )
	{
		EXEC SQL FETCH INTO :k00,:k01,:i01 ;

		if ( SQLC )
			break ;
	}

    CE ( "FETCH temp inv FROM SUPERU.TAB1",0);
}
/*------------------------------------------------------------------------*/

void sel_first_stab1_ins_tab1 ()
{

    nr = rand () % rows ;

    movep (line,col,"===== SELECT * FROM SUPERU.TAB1 WHERE ... ROWNO <= 1",0);

    do
    {
	EXEC SQL
	  SELECT K1 , I1 , I2 , C1 , C2 , I3
	  INTO  :k1 , :i1 , :i2 , :c1 , :c2 , :i3
	  FROM SUPERU.TAB1
	  WHERE I1  > :nr AND ROWNO <= 1 ;

	CE ( "SELECT ... FROM SUPERU.TAB1 WHERE ... ROWNO <= 1" ,0) ;
    }	while ( rollberr (1) ) ;

    SE ( "SELECT ... FROM SUPERU.TAB1 WHERE ... ROWNO <= 1" ,0) ;

    if ( SQLC != 100 )
    {
	movep ( line , col , "INSERT TAB1 ... " ,0) ;

	do
	{
	    EXEC SQL
	      INSERT TAB1 VALUES ( :k1 , :i1 , :i2 , :c1 ,
			:c2 , :i3 );

	    CE ("INSERT TAB1 (sel_first_stab1_ins_tab1) " , 0 ) ;
	}			while ( rollberr (0) ) ;

	commit () ;
    }
    else
    {
	rollback () ;
    }

}

/*------------------------------------------------------------------------*/

void ins_stab1_sel_first_tab1 ()
{
    nr = rand () % rows ;

    movep(line,col,"===== INSERT SUPERU.TAB1 SELECT ... UPDATE DUPL.",0);

    do
    {
	EXEC SQL
	  INSERT INTO  SUPERU.TAB1
	    ( K0 , K1 , I1 , I2 , C1 , C2 , I3 )
	    SELECT :k0 , K1 , I1 , I2 , C1 , C2 , I3
	  FROM TAB1
	  WHERE K1 = ( SELECT MIN (K1) FROM TAB1
	               WHERE I1 > :nr )
	  UPDATE DUPLICATES ;

	CE ( "===== INSERT SUPERU.TAB1 SELECT ... UPDATE DUPL.",0);
    }	while ( rollberr (1) ) ;

    commit () ;

    check_long_raw ( "INSERT SUPERU.TAB1 SELECT ..." , -1 , 1  , rows ) ;
}

/*------------------------------------------------------------------------*/

void complex_select ()
{

    nr = rand () % rows ;

    if ( rand () % 2 )
    {

	movep (line,col,"===== SELECT FROM SUPERU.TAB1 WHERE ... SELECT ... AND","") ;

	do
	{
	    EXEC SQL
	      SELECT K1 , I1
	      FROM SUPERU.TAB1
	      WHERE ( K1 >
	        ( SELECT MIN (K1)
	        FROM TAB1
	        WHERE K1 > :nr AND I3 IS NOT NULL )
	      AND I1 >
	        ( SELECT AVG (I1)
	        FROM PUBVIEW
	        WHERE PUBVIEW.K1 > :nr )) ;

	    CE ("===== SELECT FROM SUPERU.TAB1 WHERE ..." , 0 ) ;
	}	while ( rollberr (1) ) ;

    }
    else
    {

	movep (line,col,"===== SELECT FROM PUBVIEW WHERE ... SELECT ... AND","") ;

	do
	{
	    EXEC SQL
	      SELECT K1 , I1  , I3
	      FROM PUBVIEW
	      WHERE ( K1 >
	        ( SELECT MIN (K1)
	        FROM TAB1
	        WHERE K1 > :nr AND I3 IS NOT NULL
	          AND I1 >
	          ( SELECT AVG (I1)
	            FROM TAB1
	            WHERE ( K1 BETWEEN :nr AND 99999 )
	            AND C1 IS NOT NULL )))
	      AND I1 IS NOT NULL ;

	    CE ("===== SELECT FROM PUBVIEW WHERE ..." , 0 ) ;

	    /*
	    if ( SQLC == -1 )
	    {
		  CE ("===== SELECT FROM PUBVIEW WHERE ..." , 1 ) ;
	    }
	    */

	}    while ( rollberr (1) ) ;
    }
    commit () ;
}

/*------------------------------------------------------------------------*/

void c_ins_sel_upd ()
{
    do
    {
		movep ( line , col , "INSERT ... SELECT A2.TABU14 , SUPERU.TAB1",0);

		EXEC SQL
			INSERT TAB1
			SELECT K1,I1,I2,C1,C2,I3
			FROM A2.TABU14,SUPERU.TAB1
			WHERE A2.TABU14.I1 = SUPERU.TAB1.I1
			IGNORE DUPLICATES ;

			/* 3.0.1M : Big Problems with UPDATE (log full, templimit ...)
			/*
			/*                   UPDATE DUPLICATES ;
			*/

		CE ( "INSERT ... SELECT A2.TABU14 , SUPERU.TAB1" , 0 )
    } while ( rollberr (1) ) ;

    if ( SQLC && SQLC != 100 && SQLC != 350 )
		CE ( "INSERT ... SELECT A2.TABU14 , SUPERU.TAB1" , 1 )
	else
		CE ( "INSERT ... SELECT A2.TABU14 , SUPERU.TAB1" , 0 )

	if ( rand () % 2 )
		{
			commit () ;
		}
	else
		{
			movep ( line , col , "INSERT ... SELECT A2.TABU14 ... (ROLLBACK)",0);
			rollback () ;
		}
}

/*------------------------------------------------------------------------*/

void between_sbview ()
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int v1,v2 ;
    EXEC SQL END DECLARE SECTION ;

    v1 = ( rand () % rows ) / 10 ;
    v2 = v1 + 10 ;

    do
    {
        movep ( line , col , "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P, BETWEEN" ,0);

        EXEC SQL SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P WHERE I3 BETWEEN :v1 and :v2 ;

        CE ( "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P, BETWEEN",0 ) ;

    } while ( rollberr (1) ) ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void equal_sbview ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows )  ;

    do
    {
		movep ( line , col , "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P, EQUAL" ,0);

		EXEC SQL SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P WHERE K1 = :v1 ;

		CE ( "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P, EQUAL",0 ) ;

	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void like_bview ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows ) / 10 ;

    do
    {
		movep ( line , col , "SELECT I6, C5 FROM SUPERU.BVIEW_I_P, LIKE" ,0);
		EXEC SQL SELECT I6, C5 FROM SUPERU.BVIEW_I_P WHERE I5 = :v1 AND C4 like 'tab%'  ;
		CE ( "SELECT I6, C5 FROM SUPERU.BVIEW_I_P, LIKE",0 ) ;

	} while ( rollberr (1) ) ;

	if ( SQLC == 0 )
    do
    {
		movep ( line , col , "FETCH I6, C5 FROM SUPERU.BVIEW_I_P, LIKE" ,0);
		EXEC SQL FETCH INTO :i6, :c5 ;
		CE ( "FETCH I6, C5 FROM SUPERU.BVIEW_I_P WHERE, LIKE",0 ) ;
	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void equal_bview_only_index ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows ) / 10 ;
	sprintf ( c4 , "tab2%d" , v1 ) ;

    do
    {
		movep ( line , col , "SELECT C4 FROM SUPERU.BVIEW_I_P, EQUAL" ,0);
		EXEC SQL SELECT C4  FROM SUPERU.BVIEW_I_P WHERE C4 = :c4 ;
		CE ( "SELECT C4  FROM SUPERU.BVIEW_I_P WHERE C4 = :c4",0 ) ;
	} while ( rollberr (1) ) ;

	if ( SQLC == 0 )
    do
    {
		movep ( line , col , "FETCH C4 FROM SUPERU.BVIEW_I_P, EQUAL" ,0);
		EXEC SQL FETCH INTO :c4 ;
		CE ( "FETCH C4 FROM SUPERU.BVIEW_I_P WHERE C4 = :c4",0 ) ;
	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void between_sbview_16 ()
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int v1,v2 ;
    EXEC SQL END DECLARE SECTION ;

    v1 = ( rand () % rows ) / 10 ;
    v2 = v1 + 10 ;

    do
    {
        movep ( line , col , "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16, BETWEEN" ,0);

        EXEC SQL SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16 WHERE I3 BETWEEN :v1 and :v2 ;

        CE ( "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16, BETWEEN",0 ) ;

    } while ( rollberr (3) ) ; /* TS 2003-10-21 Change rollberr from 1 to 3, because of -8 errorss */

    commit () ;
}

/*------------------------------------------------------------------------*/

void equal_sbview_16 ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows )  ;

    do
    {
		movep ( line , col , "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16, EQUAL" ,0);

		EXEC SQL SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16 WHERE K1 = :v1 ;

		CE ( "SELECT count (*) INTO :cnt FROM SUPERU.SBVIEW_I_P_16, EQUAL",0 ) ;

	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void like_bview_16 ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows ) / 10 ;

    do
    {
		movep ( line , col , "SELECT I6, C5 FROM SUPERU.BVIEW_I_P_16, LIKE" ,0);
		EXEC SQL SELECT I6, C5 FROM SUPERU.BVIEW_I_P_16 WHERE I5 = :v1 AND C4 like 'tab%'  ;
		CE ( "SELECT I6, C5 FROM SUPERU.BVIEW_I_P_16, LIKE",0 ) ;

	} while ( rollberr (1) ) ;

	if ( SQLC == 0 )
    do
    {
		movep ( line , col , "FETCH I6, C5 FROM SUPERU.BVIEW_I_P_16, LIKE" ,0);
		EXEC SQL FETCH INTO :i6, :c5 ;
		CE ( "FETCH I6, C5 FROM SUPERU.BVIEW_I_P_16 WHERE, LIKE",0 ) ;
	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void equal_bview_only_index_16 ()
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int	v1 ;
	EXEC SQL END DECLARE SECTION ;

	v1 = ( rand () % rows ) / 10 ;
	sprintf ( c4 , "tab2%d" , v1 ) ;

    do
    {
		movep ( line , col , "SELECT C4 FROM SUPERU.BVIEW_I_P_16, EQUAL" ,0);
		EXEC SQL SELECT C4  FROM SUPERU.BVIEW_I_P_16 WHERE C4 = :c4 ;
		CE ( "SELECT C4  FROM SUPERU.BVIEW_I_P_16 WHERE C4 = :c4",0 ) ;
	} while ( rollberr (1) ) ;

	if ( SQLC == 0 )
    do
    {
		movep ( line , col , "FETCH C4 FROM SUPERU.BVIEW_I_P_16, EQUAL" ,0);
		EXEC SQL FETCH INTO :c4 ;
		CE ( "FETCH C4 FROM SUPERU.BVIEW_I_P_16 WHERE C4 = :c4",0 ) ;
	} while ( rollberr (1) ) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void insert_array_tab1 ( rws )
int     rws ;
{
    EXEC SQL BEGIN  DECLARE SECTION ;
    int     rows_to_insert ;
    EXEC SQL END   DECLARE SECTION ;
    int i ;

    rows_to_insert = rws > 10 ? 10 : rws ;

    movep ( line , col , "ARRAY INSERT TAB1 (%d rows)" , rows_to_insert ) ;

again_insert_tab1:

    rolled_back = 0 ;

    for ( i = 1 ; i < rows_to_insert ; i++ )
    {

		k1m[i] = rand () % rows ;
		i1m[i] = ( rand () % rows ) * 100 ;
		i2m[i] = ( rand () % rows ) % 10 ;
		sprintf ( c1m [i] , "Name%s_%d" , id , ( rand () % rows )  ) ;
		sprintf ( c2m [i] , "Name%s.%d" , id , ( rand () % rows )  / 10 ) ;
		i3m [i] = ( rand () % rows )  / 10 ;
    }

    do
    {
		EXEC SQL
			FOR :rows_to_insert
			INSERT TAB1
			VALUES ( :k1m , :i1m , :i2m , :c1m , :c2m , :i3m )
			UPDATE DUPLICATES ;

		CE ("ARRAY INSERT TAB1" , 0 ) ;

    } while ( rollberr (1) && rolled_back == 0 ) ;

    CE ("ARRAY INSERT TAB1" , 0 ) ;

    commit () ;

}

/*------------------------------------------------------------------------*/

void insert_tab20k ()
{
	int i,l ;

	movep (line,col,"INSERT SUPERU.TAB20K", 0 ) ;


	i = rand () % rows ;
	i3 = i ;
	i4 = rows - i ;
	sprintf ( char5 , "%d" , i3 ) ;


	l = rand () % 400 ;

	memset ( char400 , 'a'+ (rand() % 25) , l ) ;
	char400 [l] = 0 ;
	char400 [100] = (char) ( 'a' + (rand() % 26) ) ;

	memset ( char400_2 , 'a'+ (rand() % 25) , l ) ;
	char400_2 [399] = 0 ;
	char400_2[(l/2)] = (char) ( 'a' + (rand() % 26) ) ;


    mytime = (int) time ( (time_t *) 0) ;

	do
	{
		EXEC SQL
			INSERT SUPERU.TAB20K
			set
			VC1 = :char5, C2  = :char5, I3  = :i3,
			VC4  = :char5, C5  = :char5, I6  = :i4,
			VC7  = :char5, C8  = :char5, I9  = :i3,
			VC10  = :char5, C11  = :char5, I12  = :i4,
			VC13  = :char5, C14  = :char5, I15  = :i3,
			VC16  = :char5, C17  = :char5, I18  = :i4,
			VC19  = :char400, C20  = :char400_2 ,
			MYPID = :mypid , MYTIME = :mytime ,
			I21 = :i3, C22 = :char5, VC23 = :char5, C24 = :char5, C25 = :char5,
			I26 = :i4, C27 = :char400, VC28 = :char400_2, C29 = :char5, C30 = :char5,
			I31 = :i4, C32 = :char5, VC33 = :char5, C34 = :char5, C35 = :char5,
			I36 = :i4, C37 = :char5, VC38 = :char5,	C39 = :char5, C40 = :char5;

		if ( SQLC != 250 )
			{ CE ("INSERT TAB20K",0) ; }

	} while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void delete_tab20k ()
{
    k1 = rand () % rows ;
	sprintf ( char5 , "%d" , k1 ) ;

    movep ( line , col , "DELETE SUPERU.TAB20K WHERE VC1 = " , 0 ) ;

    do
    {
		EXEC SQL
			DELETE SUPERU.TAB20K WHERE VC1 = :char5 ;

		CE ( "DELETE SUPERU.TAB20K WHERE VC1=" , 0 ) ;

    }	while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void delete_tab20k_2 ()
{
    k1 = rand () % rows ;

    movep ( line , col , "DELETE SUPERU.TAB20K WHERE I36 = " , 0 ) ;

    do
    {
		EXEC SQL
			DELETE SUPERU.TAB20K WHERE I36 = :k1 ;

		CE ( "DELETE SUPERU.TAB20K WHERE I36 =" , 0 ) ;

    }	while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void delete_between_tab20k ()
{
	i4 = rows - ( rand () % rows ) ;
	i3 = i4 + 10 ;

    movep ( line , col , "DELETE SUPERU.TAB20K WHERE I36 between ... " , 0 ) ;

    do
    {
		EXEC SQL
			DELETE SUPERU.TAB20K WHERE I36 between :i4 and :i3 ;

		CE ( "DELETE SUPERU.TAB20K WHERE I36 between ... " , 0 ) ;

    }	while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void update_key_tab20k_1 ()
{
	int l ;

	movep (line,col,"UPDATE KEY SUPERU.TAB20K 1", 0 ) ;

	l = rand () % 400 ;
	memset ( char400 , 'a'+ (rand() % 25) , l ) ;
	char400 [l] = 0 ;
	char400 [100] = (char) ( 'a' + (rand() % 26) ) ;

	memset ( char400_2 , 'a'+ (rand() % 25) , l ) ;
	char400_2 [399] = 0 ;
	char400_2[(l/2)] = (char) ( 'a' + (rand() % 26) ) ;

	i3 = rand () % rows ;
	i4 = rows - ( rand () % rows ) / 10 ;
    mytime = (int) time ( (time_t *) 0) ;

	do
	{
		EXEC SQL
			UPDATE SUPERU.TAB20K
			SET I18  = :i3, MYPID = :mypid , MYTIME = :mytime, VC19 = :char400, C20 = :char400_2 ,
			vc28 = :char400
		WHERE I36 =  :i4 ;

		CE ("UPDATE SUPERU.TAB20K 2",0) ;
	} while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void update_key_tab20k_2 ()
{
	int l , i ;
	int	updated  ;
	char mychar ;
	char mychar400 [401] ;

    mytime = (int) time ( (time_t *) 0) ;
	movep (line,col,"UPDATE KEY SUPERU.TAB20K 2", 0 ) ;

	i3 = rand () % rows ;
	i4 = rows - ( rand () % rows ) ;
	sprintf ( char5 , "%d" , i3 ) ;

	l = 1 + ( rand () % 399 ) ;
	mychar = '0' + (char)( mypid % 10 ) ;

	memset ( char400 , (char)('a' + (rand () % 4)) , l ) ;
	char400 [l] = 0 ;
	char400 [0] = char400 [l-1] = mychar ;

	memset ( char400_2 , 'a'+ (rand() % 25) , l ) ;
	char400_2 [399] = 0 ;
	char400_2[(l/2)] = (char) ( 'a' + (rand() % 26) ) ;

	strcpy ( mychar400 , char400 ) ;

	do
	{
		EXEC SQL
			UPDATE SUPERU.TAB20K
			SET VC19 = :char400 , C20 = :char400 , C40 = :char5, MYPID = :mypid , MYTIME = :mytime , VC28 = :char400_2
			WHERE I21 BETWEEN :i4 AND ( :i4 + 10 ) ;
		CE ("UPDATE KEY SUPERU.TAB20K 2",0) ;
	} while ( rollberr (1) ) ;

	updated = sqlca.sqlerrd [2] ;

	if ( updated > 0 )
	{
		EXEC SQL SELECT I21, VC19, C20 FROM SUPERU.TAB20K
			WHERE I21 BETWEEN :i4 AND ( :i4 + 10 )
			AND MYPID = :mypid and MYTIME = :mytime ;

		CE ("SELECT VC19 , VC20 WHERE I21 ...",0) ;

		for ( i = 0 ; sqlca.sqlcode == 0 ; i++ )
		{
			EXEC SQL FETCH INTO :i3, :char400, :char400_2 ;
			CE ("FETCH VC19 FROM TAB20K WHERE I21 ...",0) ;

			if ( sqlca.sqlcode )
				break ;

			if ( strcmp (mychar400,char400) )
			{
				char myline [600] ;
				sprintf ( myline,"SELECT TAB20K, I21= %d, corrupted VC19 : %s",i3,char400 ) ;
				print_f ( myline) ;
				sprintf ( myline,"should be: %s",mychar400 ) ;
				print_f ( myline) ;
				print_f ("** calling sqldump **") ;
				Sqldump () ;
			}

			if ( strcmp (mychar400,char400_2) )
			{
				char myline [600] ;
				sprintf ( myline,"SELECT TAB20K, I21= %d, corrupted C20 : %s",i3,char400 ) ;
				print_f ( myline) ;
				sprintf ( myline,"should be: %s",mychar400 ) ;
				print_f ( myline) ;
				print_f ("** calling sqldump **") ;
				Sqldump () ;
			}
		}

		if ( i != updated )
		{
			char myline [200] ;
			sprintf ( myline,"SELECT TAB20K, updated (%d) <> (%d) selected",updated,i) ;
			print_f ( myline) ;
			print_f ("** calling sqldump **") ;
			Sqldump () ;
		}
	}

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void insert_tab04sk ()
{
	int i,l ;

	i = rand () % rows ;
	i3 = ( i >> 16 ) & 0xff ;
	i4 = rows - i ;

	char1a[1] = char1b[1] = char1c[1] = (char) 0 ;

	char1a[0] = ( i ) & 0xff ;
	char1b[0] = ( ( i >> 8 ) ) & 0xff ;
	char1c[0] = ( 'a' + (char) (rand()%13) ) ;

	sprintf ( char5 , "%d" , i ) ;

	movep (line,col,"INSERT SUPERU.TAB04SK", 0 ) ;

	l = rand () % 400 ;

    mytime = (int) time ( (time_t *) 0) ;

	do
	{
		EXEC SQL
			INSERT SUPERU.TAB04SK
			set
			VC1  = :char1a, C2  = :char1b, I3  = :i3,
			VC4  = :char1c, C5  = :char5, I6  = :i4,
			VC7  = :char5, C8  = :char5, I9  = :i3,
			VC10  = :char5, C11  = :char5, I12  = :i4,
			VC13  = :char5, C14  = :char5, I15  = :i3,
			VC16  = :char5, C17  = :char5, I18  = :i4,
			VC19  = :char5, C20  = :char5 ,
			MYPID = :mypid , MYTIME = :mytime ,
			I21 = :i3, C22 = :char5, VC23 = :char5, C24 = :char5, C25 = :char5,
			I26 = :i4, C27 = :char5, VC28 = :char5, C29 = :char5, C30 = :char5,
			I31 = :i4, C32 = :char5, VC33 = :char5, C34 = :char5, C35 = :char5,
			I36 = :i4, C37 = :char5, VC38 = :char5,	C39 = :char5, C40 = :char5;

		CE ("INSERT tab04sk",0) ;
	} while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void delete_tab04sk ()
{
    i3 = rand () % 256 ;
	char1a[0] = (char) i3 ;

    movep ( line , col , "DELETE SUPERU.TAB04SK WHERE VC1 = " , 0 ) ;

    do
    {
		EXEC SQL
			DELETE SUPERU.TAB04SK WHERE VC1 = :char1a ;

		CE ( "DELETE SUPERU.TAB04SK WHERE VC1 = " , 0 ) ;

    }	while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void delete_range_tab04sk ()
{
	char1c[0] = ( 'a' + (char) (rand()%13) ) ;
	char1c[1] = 0 ;

	movep ( line , col , "DELETE SUPERU.TAB04SK WHERE VC4 = ... " , 0 ) ;

    do
    {
		EXEC SQL
			DELETE SUPERU.TAB04SK WHERE VC4 = :char1c ;

		CE ( "DELETE SUPERU.TAB04SK WHERE VC4 = ..." , 0 ) ;

    }	while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void update_tab04sk ()
{
	movep (line,col,"UPDATE KEY SUPERU.TAB04SK 1", 0 ) ;

	i3 = rand () % rows ;
	i4 = rows - ( rand () % rows ) / 10 ;

    mytime = (int) time ( (time_t *) 0) ;

	do
	{
		EXEC SQL
			UPDATE SUPERU.TAB04SK
			SET I18  = :i3, MYPID = :mypid , MYTIME = :mytime
		WHERE I36 =  :i4 ;

		CE ("UPDATE SUPERU.TAB04SK 2",0) ;
	} while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void show_trim_serverdb ()
{
    EXEC SQL BEGIN  DECLARE SECTION ;
    char	serverdb [19] ;
    char	servernode [65] ;
    EXEC SQL END   DECLARE SECTION ;

    movep ( line , col , "SHOW SERVERDB ... TRIM" , 0 ) ;

    do
    {
	EXEC SQL SHOW SERVERDB ;
        CE ("SHOW SERVERDB" , 0 ) ;
    } while ( rollberr (1) ) ;

    if ( SQLC && SQLC != 100 )
        CE ("SHOW SERVERDB" , 1 ) ;

    do
    {
	EXEC SQL
	SELECT TRIM(serverdb), TRIM(servernode) into :serverdb, :servernode
	   from show ;
        CE ("SHOW SERVERDB, SELECT TRIM ... FROM SHOW" , 0 ) ;
    } while ( rollberr (1)) ;

    if ( SQLC && SQLC != 100 )
	CE ("SHOW SERVERDB, SELECT TRIM ... FROM SHOW" , 1 ) ;

/*
    do
    {
        EXEC SQL SHOW USER CONNECTED ;
        CE ("SHOW USER CONNECTED" , 0 ) ;
    } while ( rollberr (1) ) ;

    if ( SQLC && SQLC != 100 )
        CE ("SHOW USER CONNECTED" , 1 ) ;
*/

}

/*------------------------------------------------------------------------*/

void cre_idx_tab1 ()
{

    do
    {
		movep ( line , col , "CREATE INDEX TAB1_I1 ON TAB1(I1)","" ) ;

		EXEC SQL
			CREATE INDEX TAB1_I1 ON TAB1(I1)  ;

		CE ( "CREATE INDEX ON TAB1 (I1)",0);
    }		while ( rollberr (1) ) ;

    commit () ;

}

/*------------------------------------------------------------------------*/

void alt_tab1_dynamic ()
{
    do
    {
        movep ( line , col , "ALTER TABLE TAB1 DYNAMIC","" ) ;
        EXEC SQL ALTER TABLE TAB1 DYNAMIC ;
        CE ("ALTER TABLE TAB1 DYNAMIC", 0 ) ;
    } while ( rollberr (1) ) ;
}

/*------------------------------------------------------------------------*/

void alt_tab1_nondynamic ()
{
    do
    {
        movep ( line , col , "ALTER TABLE TAB1 NOT DYNAMIC","" ) ;
        EXEC SQL ALTER TABLE TAB1 NOT DYNAMIC ;
        CE ("ALTER TABLE TAB1 NOT DYNAMIC", 0 );
    } while ( rollberr (1) ) ;
}

/*------------------------------------------------------------------------*/

void drop_idx_tab1 ()
{

    do
    {
		movep ( line , col , "DROP INDEX TAB1(I1)","" ) ;

		EXEC SQL
			DROP INDEX TAB1_I1 ON TAB1 ;

		CE ( "DROP INDEX TAB1_I1 ON TAB1",0);

    } while ( rollberr (1) ) ;

    commit () ;

}

/*------------------------------------------------------------------------*/

void DebugOmsOn ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long iIn, iOut ;
	EXEC SQL END DECLARE SECTION ;

	EXEC SQL DBPROC CHL_DEBUG ( 1 , :iOut ) ;
}

/*------------------------------------------------------------------------*/

void CreateList (int nObjs, int AlwaysCommit )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long cre_elements ;
	EXEC SQL END DECLARE SECTION ;

    movep ( line , col , "DBPROC: CREATELIST", "" ) ;

	cre_elements = nObjs ? nObjs : (MinOmsElemsInList + ( rand () % rows ))  ;

	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		EXEC SQL DBPROC CREATELIST ( :cre_elements, 0 , :listno ) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ();
	else
	{
		if ( AlwaysCommit || ( rand () % 4 ))
			commit ();
		else
			rollback () ;
	}
}


/*------------------------------------------------------------------------*/

void  DeleteElememtsFromList (int n)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsToDelete ;
	EXEC SQL END DECLARE SECTION ;

	ElementsToDelete = n ? n : del_elements ;

	listno = ( rand () % MaxListNo )  + 1;
	elements = 0 ;

    movep ( line , col , "DBPROC: DELETE_ELEMENT_FROM_LIST, listno = %d", listno ) ;
	do
	{
		EXEC SQL DBPROC DELETE_ELEMENT_FROM_LIST ( :listno , :ElementsToDelete ,
			0, :elements ) ;

		CE ("DBPROC: DELETE_ELEMENT_FROM_LIST",0) ;
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}


/*------------------------------------------------------------------------*/

void 	DelCreListInVersion (enum ObjType ListKind)
{
	long anz1 , anz2 , anz3 ;
	char protline [100] ;
	int	 committed = 0 ;

	do
	{
		movep ( line , col, "DBPROC: Create Version VerStringDelCre",0) ;
		EXEC SQL DBPROC CHL_CREATE_VERSION (:VerStringDelCre , :vrc ) ;
		CE ("Create Version VerStringDelCre",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("Create Version VerStringDelCre",1) ;

	commit () ;

	anz1 = DeleteAndRecreateList (ListKind,0,&committed) ;

	if ( anz1 > 0 && rand () % 2 )
		commit () ;
	else
	{
		do
		{
			rollback () ;
			anz1 = DeleteAndRecreateList (ListKind,0,&committed) ;
		} while ( anz1 <= 0 ) ;

		commit () ;
	}

	if ( rand () % 4 == 0 )
	{
		anz2 = DeleteAndRecreateList (ListKind,anz1,&committed) ;

		if ( anz1 != anz2 && SQLC != -28815 )
		{
			if ( ListKind == OID ) /* OIDs*/
				sprintf (protline,"DeleteAndRecreateList (Oid), anz1 %d <> anz2 %d" , anz1 , anz2 ) ;
			else
				sprintf (protline,"DeleteAndRecreateList (Key), anz1 %d <> anz2 %d" , anz1 , anz2 ) ;

			print_f (line) ;
			print_f ("** calling sqldump **") ;
			Sqldump () ;
		}

		if ( ! committed )
			( rand () % 2 ) ? commit () : rollback () ;
		else
			commit () ;
	}

	do
	{
		movep ( line , col, "DBPROC: Close Version VerStringDelCre",0) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerStringDelCre , :vrc ) ;
		CE ("Close Version VerStringDelCre",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("Close Version VerStringDelCre",1) ;

	commit () ;

	if ( rand () % 5 == 0 ) /* Sessionwechsel */
		release_connect () ;

	do
	{
		movep ( line , col, "DBPROC: Open Version VerStringDelCre",0) ;
		EXEC SQL DBPROC CHL_OPEN_VERSION (:VerStringDelCre , :vrc ) ;
		CE ("Open Version VerStringDelCre",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("Open Version VerStringDelCre",1) ;

	commit () ;

	anz3 = DeleteAndRecreateList (ListKind,anz1,&committed) ;

	if ( anz1 != anz3 && SQLC != -28815 )
	{
		if ( ListKind == OID ) /* OIDs*/
			sprintf (protline,"DeleteAndRecreateList (Oid), anz1 %d <> anz3 %d" , anz1 , anz3 ) ;
		else
			sprintf (protline,"DeleteAndRecreateList (Key), anz1 %d <> anz3 %d" , anz1 , anz3 ) ;

		print_f (protline) ;
	    print_f ("** calling sqldump **") ;
		Sqldump () ;
	}

	( rand () % 2 ) ? commit () : rollback () ;

	do
	{
		movep ( line , col, "DBPROC: Close Version VerStringDelCre",0) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerStringDelCre , :vrc ) ;
		CE ("Close Version VerStringDelCre",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("Close Version VerStringDelCre",1) ;

	commit () ;

	do
	{
		movep ( line , col, "DBPROC: Drop Version VerStringDelCre",0) ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerStringDelCre , :vrc ) ;
		CE ("Drop Version VerStringDelCre",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("Drop Version VerStringDelCre",1) ;

	commit () ;

}

/*------------------------------------------------------------------------*/

DeleteAndRecreateList (enum ObjType ListKind, long anz, int *committed)
{

	EXEC SQL BEGIN DECLARE SECTION ;
	long NoOfElements = 0 ;
	EXEC SQL END DECLARE SECTION ;

	char protline [100] ;
	*committed = 0 ;

	do
	{
		if ( ListKind == OID ) /* Oids*/
		{
			movep ( line , col, "DBPROC: Delete List in Version (oid)",0) ;
			EXEC SQL DBPROC DELETE_LIST(1, 0, :NoOfElements, 0 ) ;
			CE ("Delete List in Version (oid)",0) ;
			/*sprintf (protline,"Delete List in Version, deleted: NoOfElements = %d" , NoOfElements ) ;*/
			/*print_f (protline) ;*/
		}
		else /* Key*/
		{
			movep ( line , col, "DBPROC: Delete List in Version (key)",0) ;
			EXEC SQL DBPROC DELETE_KEYOID_LIST(1, :NoOfElements ) ;
			CE ("Delete List in Version (key)",0) ;
		}

	}
	while ( rollberr (1) ) ;

	if ( ListKind == OID ) /* Oids*/
	{
		CE ("Delete List in Version (oid)", ((SQLC==100) ? 0 : 1 )) ;
	}
	else /* keys*/
	{
		CE ("Delete List in Version (key)", ((SQLC==100) ? 0 : 1 )) ;
	}

	if ( anz && anz != NoOfElements && SQLC != -28815 )
	{
		if ( ListKind == OID ) /* Oids*/
			sprintf (protline,"Delete List in Version (oid), anz %d <> anz1 %d" , anz , NoOfElements ) ;
		else
			sprintf (protline,"Delete List in Version (key), anz %d <> anz1 %d" , anz , NoOfElements ) ;

		print_f (protline) ;
	    print_f ("** calling sqldump **") ;
		Sqldump () ;
	}

	if ( anz == 0 && ( rand () % 2 ) )
	{
		rollback () ;
		*committed = 1 ;
		return -1 ;
	}
	else if ( ( rand () % 3 ) == 0 )
	{
		commit () ;
		*committed = 1 ;
	}

	if ( NoOfElements == 0 )  /* empty list, so give it some elements*/
		NoOfElements = rows / 2 ;

	do
	{
		if ( ListKind == OID ) /* Oids*/
		{
			movep ( line , col, "DBPROC: Create List in Version (oid)",0) ;
			/*sprintf (protline,"Delete List in Version (oid), bef. cre: NoOfElements = %d" , NoOfElements ) ;*/
			/*print_f (protline) ;*/
			EXEC SQL DBPROC CREATELIST ( :NoOfElements , 0 , :listno ) ;
			CE ("Create List in Version (oid)",0) ;
		}
		else
		{
			movep ( line , col, "DBPROC: Create List in Version (key)",0) ;
			/*sprintf (protline,"Delete List in Version (key), bef. cre: NoOfElements = %d" , NoOfElements ) ;*/
			/*print_f (protline) ;*/
			EXEC SQL DBPROC CREATE_KEYOID_LIST ( :NoOfElements , :listno ) ;
			CE ("Create List in Version (key)",0) ;
		}
	}
	while ( rollberr (1) ) ;

	CE ("Create List in Version",1) ;

	return NoOfElements ;
}
/*------------------------------------------------------------------------*/

void  AddElementToList ()
{
	listno = ( rand () % MaxListNo ) + 1 ;

    movep ( line , col , "DBPROC: ADD ELEMENT TO LIST, listno = %d", listno ) ;

	do
	{
		EXEC SQL DBPROC ADD_ELEMENT_TO_LIST ( :listno , :FiOidIn , :FiOidOut ) ;

		CE ("DBPROC: ADD_ELEMENT_TO_LIST",0) ;
	}
	while ( rollberr (4) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}

/*------------------------------------------------------------------------*/

void TraversePartList (int ReadLocked)
{
	long	ElemsToRead ;
	long	ListNo = 1 + ( rand () % MaxListNo ) ;

	ElemsToRead = rand () % rows ;

	if ( ReadLocked )
		movep ( line , col , "DBPROC: TraversePartList Locked, lno = %d", ListNo ) ;
	else
		movep ( line , col , "DBPROC: TraversePartList Unlocked, lno = %d", ListNo ) ;

	do
	{
		TraverseList ( ListNo , 1 , ElemsToRead , ReadLocked, "TRAV REL") ;

		if ( ReadLocked )
			CE ("TraversePartList locked",0)
		else
			CE ("TraversePartList unlocked",0)

	} while ( rollberr (1) ) ;

	if ( ReadLocked )
		CE ("TraversePartList locked",0)
	else
		CE ("TraversePartList unlocked",0)

	commit () ;
}

/*------------------------------------------------------------------------*/

long TraverseList (/*long lno ,		// List number (just for output protocol)*/
				   long Lno,		/* List number; 0: use start OID of last traverse*/
				   int	RelOids ,	/* 1: Release OIDs after reading*/
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	ReadLocked, /* 1: lock OIDs when reading */
				   char *TravString )
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int		ReleaseOids ;
    long	NoToTraverse ;
	int		ReadOidsLocked ;
	long	sum ;
	EXEC SQL END DECLARE SECTION ;

	sum = 0 ;
	ReleaseOids = RelOids ;
	NoToTraverse = Ntt ;
	elements = 0 ;
	listno = Lno ;
	ReadOidsLocked = ReadLocked ;

	if ( Lno == 0 )
		memcpy ( FiOidIn , FiOidOut , sizeof FiOidIn ) ;
	else
		strcpy ( FiOidIn , "12345678" ) ; /* Debug*/


	EXEC SQL DBPROC TRAVERSE_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :ReadOidsLocked, :FiOidIn , :FiOidOut ) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

void  CreateVarobjList ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int cre_elements ;
	int maxlen ;
	EXEC SQL END DECLARE SECTION ;

    movep ( line , col , "DBPROC: OMS_CREATE_VAROBJ_LIST", "" ) ;

	cre_elements = (MinOmsElemsInList + ( rand () % rows ) / 10 ) ;

	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		EXEC SQL DBPROC OMS_CREATE_VAROBJ_LIST ( :cre_elements, :maxlen , 0,  :listno ) ;
		CE ("DBPROC: OMS_CREATE_VAROBJ_LIST",0) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ();
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}

/*------------------------------------------------------------------------*/

void  AddVarobj ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int rc ;
	EXEC SQL END DECLARE SECTION ;

	movep ( line , col , "DBPROC: OMS_ADD_VAROBJ", "" ) ;

	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		EXEC SQL DBPROC OMS_ADD_VAROBJ ( :listno, :rc ) ;
		CE ("DBPROC: OMS_ADD_VAROBJ",0) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ();
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}

/*------------------------------------------------------------------------*/

void  UpdateVarobjList ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int upd_elements ;
	int maxlen ;
	EXEC SQL END DECLARE SECTION ;

    movep ( line , col , "DBPROC: OMS_UPDATE_VAROBJ_LIST", "" ) ;

	upd_elements = ( rand () % rows ) / 30 ;

	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		EXEC SQL DBPROC OMS_UPDATE_VAROBJ_LIST ( :listno, 0 , :upd_elements ) ;
		CE ("DBPROC: OMS_UPDATE_VAROBJ_LIST",0) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ();
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}

/*------------------------------------------------------------------------*/

void  DeleteVarobjList (int nObjs, int AlwaysCommit )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int elements ;
	int maxlen ;
	EXEC SQL END DECLARE SECTION ;

    movep ( line , col , "DBPROC: CREATELIST", "" ) ;

	listno = ( rand () % MaxListNo ) + 1 ;


	do
	{
		EXEC SQL DBPROC OMS_DELETE_VAROBJ_LIST (:listno , 0 ,:elements  ) ;
		CE ("DBPROC: OMS_DELETE_VAROBJ_LIST",0) ;

	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ();
	else
	{
		if ( AlwaysCommit || ( rand () % 4 ))
			commit ();
		else
			rollback () ;
	}
}


/*------------------------------------------------------------------------*/

void  CreateKeyList (enum Projects prj , int AlwaysCommit )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long cre_elements ;
	EXEC SQL END DECLARE SECTION ;

	if ( prj == CHL )
		movep ( line , col , "DBPROC: CREATE_KEYOID_LIST", "" ) ;
	else if ( prj == OMS1 )
	    movep ( line , col , "DBPROC: OMS1_CREATE_KEYOID_LIST", "" ) ;

	cre_elements = MinOmsElemsInList + ( rand () % rows )  ;
	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		if ( prj == CHL )
		{
			EXEC SQL DBPROC CREATE_KEYOID_LIST ( :cre_elements, :listno ) ;
			CE ("DBPROC: CREATE_KEYOID_LIST",0) ;
		}
		else if ( prj == OMS1 )
		{
			EXEC SQL DBPROC OMS1_CREATE_KEYOID_LIST ( :cre_elements, :listno ) ;
			CE ("DBPROC: OMS1_CREATE_KEYOID_LIST",0) ;
		}
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( AlwaysCommit || rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}


/*------------------------------------------------------------------------*/

int DeleteKeyList (enum Projects prj , int AlwaysCommit )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long no_of_elements ;
	EXEC SQL END DECLARE SECTION ;

	if ( prj == CHL )
		movep ( line , col , "DBPROC: DELETE_KEYOID_LIST", "" ) ;
	else if ( prj == OMS1 )
	    movep ( line , col , "DBPROC: OMS1_DELETE_KEYOID_LIST", "" ) ;

	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		if ( prj == CHL )
		{
			EXEC SQL DBPROC DELETE_KEYOID_LIST ( :listno, :no_of_elements  ) ;
			CE ("DBPROC: DELETE_KEYOID_LIST",0) ;
		}
		else if ( prj == OMS1 )
		{
			EXEC SQL DBPROC OMS1_DELETE_KEYOID_LIST ( :listno, :no_of_elements  ) ;
			CE ("DBPROC: OMS1_DELETE_KEYOID_LIST",0) ;
		}
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( AlwaysCommit || rand () % 4 )
			commit ();
		else
			rollback () ;
	}

	return no_of_elements ;
}


/*------------------------------------------------------------------------*/

void  DeleteElememtsFromKeyList (int n)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsToDelete ;
	EXEC SQL END DECLARE SECTION ;

	ElementsToDelete = n ? n : del_elements ;

	listno = 1 + ( rand () % MaxListNo ) ;
	elements = 0 ;

    movep ( line , col , "DBPROC: DELETE_FROM_KEYOID_LIST, listno = %d", listno ) ;
	do
	{
		EXEC SQL DBPROC DELETE_FROM_KEYOID_LIST ( :listno , :ElementsToDelete ,
			:elements ) ;

		CE ("DBPROC: DELETE_FROM_KEYOID_LIST",0) ;
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
}


/*------------------------------------------------------------------------*/

void  UpdateKeyList (enum Projects prj , int v)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsIn ;
	int	 sIndex ;
	long oldSum, newSum ;
	int	 newValue ;
	EXEC SQL END DECLARE SECTION ;
    long sumStart , sum1 , sum2 , willSum ;
	newValue = v ;

	ElementsIn = 1 + ( rand () % del_elements )  ;

	listno = 1 + ( rand () % MaxListNo ) ;

	if ( prj == CHL )
		movep ( line , col , "DBPROC: CHL UPDATE KEY LIST, listno = %d", listno ) ;
	else
		movep ( line , col , "DBPROC: OMS1 UPDATE KEY LIST, listno = %d", listno ) ;

	do
	{
		if ( prj == CHL )
		{
			EXEC SQL DBPROC UPDATE_KEYOID_LIST ( :listno, :ElementsIn ,
				:elements, :oldSum , :newSum, :newValue ) ;
			CE ("DBPROC: UPDATE_KEYOID_LIST",0) ;
		}
		else
		{
			EXEC SQL DBPROC OMS1_UPDATE_KEYOID_LIST ( :listno, :ElementsIn ,
				:elements, :oldSum , :newSum, :newValue ) ;
			CE ("DBPROC: OMS1 UPDATE_KEYOID_LIST",0) ;
		}

		sumStart = newSum ;

		if ( ( sqlca.sqlcode == 0 ) && ( rand () % 2 == 0 ))
		{
			EXEC SQL DBPROC CHL_START_SUBTRANS (:sIndex , :rc ) ;

			if ( sqlca.sqlcode == 0 )
			{
				if ( prj == CHL )
				{
					EXEC SQL DBPROC UPDATE_KEYOID_LIST ( :listno, :ElementsIn , :elements,
						:oldSum , :newSum, :newValue) ;
					CE ("DBPROC: UPDATE_KEYOID_LIST IN SUBTRANS",0) ;
				}
				else
				{
					EXEC SQL DBPROC OMS1_UPDATE_KEYOID_LIST ( :listno, :ElementsIn , :elements,
						:oldSum , :newSum, :newValue) ;
					CE ("DBPROC: OMS1_UPDATE_KEYOID_LIST IN SUBTRANS",0) ;
				}
			}

			sum1 = newSum ;

			if ( sqlca.sqlcode == 0 )
			{
				if ( prj == CHL )
				{
					EXEC SQL DBPROC UPDATE_KEYOID_LIST ( :listno, :ElementsIn ,
						:elements, :oldSum , :newSum, :newValue ) ;
					CE ("DBPROC: UPDATE_KEYOID_LIST IN SUBTRANS",0) ;
				}
				else
				{
					EXEC SQL DBPROC OMS1_UPDATE_KEYOID_LIST ( :listno, :ElementsIn ,
						:elements, :oldSum , :newSum, :newValue ) ;
					CE ("DBPROC: OMS1UPDATE_KEYOID_LIST IN SUBTRANS",0) ;
				}

			}

			sum2 = newSum ;

			/* Da ist noch was zu tun !!! */

			if ( rand () % 2 == 0 )
			{
				willSum = newSum ;
				EXEC SQL DBPROC CHL_COMMIT_SUBTRANS (-1 , :rc ) ;
			}
			else
			{
				willSum = oldSum ;
				EXEC SQL DBPROC CHL_ROLLBACK_SUBTRANS (-1 , :rc ) ;
			}
/*
			if ( rand () % 2 == 0 )
			{
				willSum = newSum ;
				EXEC SQL DBPROC CHL_COMMIT_SUBTRANS (-1 , :rc ) ;
			}
			else
			{
				willSum = oldSum ;
				EXEC SQL DBPROC CHL_ROLLBACK_SUBTRANS (-1 , :rc ) ;
			}
*/
		}
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}

}

/*------------------------------------------------------------------------*/

void  UpdateVersionKeyList (v)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsIn ;
	int	 sIndex ;
	long oldSum, newSum ;
	int	 newValue ;
	EXEC SQL END DECLARE SECTION ;
    long sumStart , sum1 , sum2 , willSum ;
	newValue = v ;

	ElementsIn = 1 + ( rand () % del_elements )  ;

	listno = 1 + ( rand () % MaxListNo ) ;

	commit () ; /* sicher ist sicher wegen -9214*/

	if ( UpdateVersionIsCreated )
	{
		do
		{
			movep ( line , col, "DBPROC: Open Version VerString1, lno = %d" , listno ) ;
			EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString1 , :vrc ) ;
			CE ("Open Version VerString1",0) ;
		}
		while ( rollberr (1) ) ;

		CE ("Open Version VerString1",1) ;
	}
	else
	{
		do
		{
			movep ( line , col, "DBPROC: Create Version VerString1, lno = %d" , listno ) ;
			EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString1 , :vrc ) ;
			CE ("Create Version VerString1",0) ;
		}
		while ( rollberr (1) ) ;

		CE ("Create Version VerString1",1) ;

		if ( SQLC == 0 )
			UpdateVersionIsCreated = 1 ;
	}

	commit () ;

    movep ( line , col , "DBPROC: UPDATE KEY LIST in Version, listno = %d", listno ) ;

	if ( sqlca.sqlcode == 0 )
	{
		EXEC SQL DBPROC UPDATE_KEYOID_LIST ( :listno, :ElementsIn ,
			:elements, :oldSum , :newSum, :newValue ) ;
		CE ("DBPROC: UPDATE_KEYOID_LIST",0) ;

		if ( SQLC )
			rollback () ;
		else
		{
			if ( rand () % 4 )
				commit ();
			else
				rollback () ;
		}

		movep ( line , col, "DBPROC: Close Version VerString1, lno = %d" , listno ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString1 , :vrc ) ;
		CE ("Close Version VerString1",0) ;

		commit () ;
	}
}

/*------------------------------------------------------------------------*/

void DropVersionUpdateVersionKeyList ()
{
	movep ( line , col, "DBPROC: Drop Version VerString1" ) ;
	commit () ;

	EXEC SQL DBPROC CHL_DROP_VERSION (:VerString1 , :vrc ) ;
	CE ("Drop Version VerString1",0) ;
	if ( SQLC == 0 )
		UpdateVersionIsCreated = 0 ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void Create100Versions ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	char VerString [23] ;
	EXEC SQL END DECLARE SECTION ;

	int  i ;

	char pidString [20] ;

	commit () ; /* sicher ist sicher wegen -9214*/

	for ( i = 0 ; i < 100 ; i++ )
	{
		sprintf ( pidString , "%ld%d" , (long) pid , i ) ;

		memset ( VerString , 'a' , 22 ) ;
		VerString [22] = 0 ;
		memcpy ( VerString , pidString , strlen (pidString) ) ;

		movep ( line , col, "DBPROC: Open Version 100Versions" , 0 ) ;
		EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString , :vrc ) ;
		CE ("Open Version VerString",0) ;

		commit () ;

		AddElementToList () ;

		movep ( line , col, "DBPROC: Close Version 100Versions" , 0 ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;

		if (SQLC == -1 || SQLC == -5001 )
			{CE ("Close Version 100Versions",1) ;}
		else
			{CE ("Close Version 100Versions",0) ;}

		commit () ;
	}
}

/*------------------------------------------------------------------------*/

void Drop100Versions ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	char VerString [23] ;
	EXEC SQL END DECLARE SECTION ;

	int  i ;

	char pidString [20] ;

	for ( i = 0 ; i < 100 ; i++ )
	{

		sprintf ( pidString , "%ld%d" , (long) pid , i ) ;
		memset ( VerString , 'a' , 22 ) ;
		VerString [22] = 0 ;
		memcpy ( VerString , pidString , strlen (pidString) ) ;

		movep ( line , col, "DBPROC: Drop Version 100Versions" ,0 ) ;

		commit () ;

		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString , :vrc ) ;

		if (SQLC == -1 || SQLC == -5001 )
			{CE ("Drop Version 100Versions",1) ;}
		else
			{CE ("Drop Version 100Versions",0) ;}

		commit () ;
	}
}
/*------------------------------------------------------------------------*/

void CreateDummyVersion ()
{
	/* Diese Version wird lngere Zeit nicht gelscht. Damit knnen ltere Objekte nicht */
	/* freigegeben werden. Auer etwas zustzlichem Platzverbrauch sollten */
	/* keine weiteren Effekte eintreten. */

	if ( DummyVersionWasCreated )
	{
		commit () ;
		movep ( line , col, "DBPROC: Drop Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Drop Dummy Version; sqlcode = %d\n" , SQLC ) ;
		if ( SQLC != -9205 )
			CE ("Create/Drop Dummy Version",0) ;
		commit () ;
	}

	movep ( line , col, "DBPROC: Open Dummy Version" , 0 ) ;
	EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString4 , :vrc ) ;
	prot ( "Open Dummy Version; sqlcode = %d\n" , SQLC ) ;
	CE ("Open Dummy Version",0) ;
	commit () ;

	if ( sqlca.sqlcode == 0 )
	{
		DummyVersionWasCreated = 1 ;
		movep ( line , col, "DBPROC: Close Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Close Dummy Version; sqlcode = %d\n" , SQLC ) ;
		CE ("Close Dummy Version",0) ;
		commit () ;
	}
}
/*------------------------------------------------------------------------*/

void DropDummyVersion ()
{
	if ( DummyVersionWasCreated )
	{
		commit () ;
		movep ( line , col, "DBPROC: Drop Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Drop Dummy Version; sqlcode = %d\n" , SQLC ) ;
		if ( SQLC != -9205 )
			CE ("Drop Dummy Version",0) ;
		commit () ;
	}
}
/*------------------------------------------------------------------------*/

void checkAndDeleteManySchemas (char *id)
{
	int i ;

	movep ( line , col, "DBPROC: CheckAndDelete %d Schemas" , MAXMAXSCHEMAS) ;

	for ( i = 0 ; i < MAXMAXSCHEMAS ; i++ )
	{
		sprintf ( schemaName , "schema%s%d" , id , i ) ;

		EXEC SQL DBPROC OMS_CHDEL_PRIVATE_SCHEMA (:schemaName , :schemaNo , :vrc ) ;
		commit () ;
	}

	schemaOpen = 0 ;
}


/*------------------------------------------------------------------------*/

void createManySchemas (char *id)
{
	/* Diese Version wird lngere Zeit nicht gelscht. Damit knnen ltere Objekte nicht */
	/* freigegeben werden. Auer etwas zustzlichem Platzverbrauch sollten */
	/* keine weiteren Effekte eintreten. */

	int i ;
	scnt = 0 ;

	mSchemas = ( (rand () % 10) == 0 ) ? MAXMAXSCHEMAS : MAXSCHEMAS ;


	if ( mSchemas == MAXMAXSCHEMAS )
	{
		movep ( line , col, "EXEC SQL SELECT COUNT (*) FROM SCHEMAS" , 0 ) ;
		EXEC SQL SELECT COUNT (*) INTO :scnt FROM SCHEMAS ;
		CE ("SELECT COUNT (*) FROM SCHEMAS",0) ;
		if ( scnt > 3*MAXMAXSCHEMAS )
			mSchemas = MAXSCHEMAS ;
	}

	for ( i = 0 ; i < mSchemas ; i++ )
	{
		sprintf ( schemaName , "schema%s%d" , id , i ) ;
		movep ( line , col, "DBPROC: Create Schema, cnt = %d" , mSchemas ) ;
		do
		{
			EXEC SQL DBPROC OMS_CREATE_PRIVATE_SCHEMA (:schemaName , :schemaNo , :vrc ) ;
			CE ("Create Schema",0) ;
		}
		while ( rollberr (2) ) ;
		CE ("Create Schema",1) ;
		schemaIds[i] = schemaNo ;
		commit () ;
	}

	schemaOpen = 1 ;
	addKey = 1000 ;
}

/*------------------------------------------------------------------------*/

void dropManySchemas ()
{
	/* Diese Version wird lngere Zeit nicht gelscht. Damit knnen ltere Objekte nicht */
	/* freigegeben werden. Auer etwas zustzlichem Platzverbrauch sollten */
	/* keine weiteren Effekte eintreten. */

	int i ;


	for ( i = 0 ; i < mSchemas ; i++ )
	{
		movep ( line , col, "DBPROC: DROP Schema" , 0) ;
		schemaNo = schemaIds[i] ;
		do
		{
			EXEC SQL DBPROC OMS_DROP_PRIVATE_SCHEMA ( :schemaNo , :vrc ) ;
			CE ("DROP Schema",0) ;
		}
		while ( rollberr (2) ) ;
		schemaIds[i] = -1 ;
		commit () ;
	}

	schemaOpen = 0 ;
}

/*------------------------------------------------------------------------*/

void addKeyToSchema ()
{
	int i ;

	if ( schemaOpen == 0 )
		return ;

	for ( i = 0 ; i < mSchemas ; i++ )
	{
		movep ( line , col, "DBPROC: OMS_ADDKEY_PRIVATE_SCHEMA" , 0) ;
		schemaNo = schemaIds[i] ;
		addKey++ ;
		EXEC SQL DBPROC OMS_ADDKEY_PRIVATE_SCHEMA ( :schemaNo , :addKey, :vrc ) ;
		CE ("OMS_ADDKEY_PRIVATE_SCHEMA",0) ;
	}

	if ( rand () % 2 )
		commit ();
	else
		rollback () ;
}

/*------------------------------------------------------------------------*/

void DropPrivateVersions ()
{

		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString1, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString2, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString3, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerStringDelCre, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
}

/*------------------------------------------------------------------------*/

void pe (s , leave )
char    *s ;
int     leave ;
{
    char    zeile [200] ;

#ifdef DEBUG
    fprintf ( stderr , "pid %d , %s :  ERR = %d\n" , pid , s , SQLC ) ;
#endif

    sprintf ( zeile , "%s :  ERR = %d" , s , sqlca.sqlcode ) ;
    movep ( line , col , zeile , "" ) ;

    if ( ( SQLC != 100 ) && ( SQLC != 200 ) )
		print_f ( s ) ;

    if ( SQLC == 650 || SQLC == 710 )      /* Location down / Shutdown */
		cwr () ;

    /*
	if ( SQLC == -8 / * || SQLC == -9405 * /)
		return ;
	*/

    if ( leave || SQLC == -108 || SQLC == -106 || SQLC == -6000 ||
		( SQLC <= -9000 && SQLC >= -10000 ) || SQLC == -7500 ||
		SQLC == -8 || ( SQLC <= -980 && SQLC > -999 ) ||
		( SQLC != -809 && ( SQLC <= -800 && SQLC > -900 ) ) )
    {
		print_f ( s ) ;
		{
			int     *ip ;
			for ( ip = ignore ; *ip ; ip++ )
			{
				if ( *ip == -SQLC )
				{
					print_f ("** sqldump ignored ==> release ") ;
					cwr() ;
				}
			}
		}
		print_f ("** calling sqldump **") ;
		Sqldump () ;
		exit ( 1 ) ;
    }
}

/*------------------------------------------------------------------------*/


void print_f (s )
char    *s ;
{
    char    da [40] ;
    time_t    tm ;
    tm = time ( (time_t *) 0) ;
    strncpy ( da , ctime ( &tm ) , 39 ) ;
    da [ 39 ] = 0 ;

    fprintf ( fout , "pid %d , %.19s , durch %3d , %s :  ERR = %d\n" ,
      pid , da , durch , s , SQLC ) ;
}

/*------------------------------------------------------------------------*/

rollberr ( kind )
int kind ;
{
    int sqlc ;
	int oi = 0 ;

    if ( ROLLBERR )
	{
		switch ( kind )
		{
		case 0 :
			sleep (3) ;
			return 1 ;
			break ;
		case 1 :
			if ( ( rand () % 4 ) == 0 /*|| UseOms && SQLC == -7067 */ )
			{
				rollback () ;
				prot ("Transaction rolled back, loop again\n","") ;
				rolled_back = 1 ;
				sleep ( 1 ) ;
			}
			else if ( SQLC == -1000 )
				sleep ( 3 ) ;
#ifdef _WIN32
			Sleep (100 * ( rand () % 10 ) ) ;
#else
			sleep (1) ;
#endif
			return 1 ;
			break ;
		case 2 :
			rollback () ;
			if ( SQLC == -1000 )
				sleep ( 3 ) ;
			else
				sleep ( 1 ) ;
#ifdef _WIN32
			Sleep (100) ;
#else
			sleep (1) ;
#endif
			prot ("Transaction rolled back, loop again\n","") ;
			rolled_back = 1 ;
			return 1;
			break ;
		case 3 :
			sqlc = SQLC ;
			rollback () ;
			prot ("Transaction rolled back, no more loop\n","") ;
			SQLC = sqlc ;
			rolled_back = 1 ;
			return 0 ;
			break ;
		case 4 :
			rollback () ;
			prot ("Transaction rolled back, loop again\n","") ;
			sleep (1) ;
			return 1 ;
			break ;
		default:
			return -2 ;
		}
	}
    else
		return (0) ;
}

/*------------------------------------------------------------------------*/

void rollback ()
{
    EXEC SQL
      ROLLBACK WORK ;

    CE ("ROLLBACK WORK" , 1 ) ;
}

/*------------------------------------------------------------------------*/

void commit ()
{
    EXEC SQL
      COMMIT WORK ;

    CE ("COMMIT WORK" , 1 ) ;
}

/*------------------------------------------------------------------------*/

void cwr_ok (int sig)
{
    print_f ("Terminated (SIGTERM), O.K.\n") ;
    cwr () ;
}

/*------------------------------------------------------------------------*/

void cwr()
{

	if ( fout )
		fclose ( fout ) ;

	EXEC SQL
      COMMIT WORK RELEASE;

    exit (0) ;
}

/*------------------------------------------------------------------------*/

void movep (line,col,s1,s2)
int     line,col;
char    *s1 , *s2  ;
{
    char    zeile [200] ;

    sprintf ( zeile , s1 , s2 ) ;

    if ( line > 22 ) line = 22 ;

#ifdef _WIN32
    sprintf (buf , "\033[%d;%dH\033[K%s\r",line,col,zeile);
    sflushf (buf) ;
    sprintf (buf , "\033[21;1H") ;
    sflushf (buf) ;
#else
    if ( fo )
    {
      fflush (fo) ;
      fprintf (fo , "\033[%d;%dH\033[K%s\r",line,col,zeile);
      fflush (fo) ;
      fprintf (fo , "\033[21;1H") ;
      fflush (fo) ;
    }
#endif
}

/*------------------------------------------------------------------------*/

void prot ( s1 , s2 )
char    *s1 ;
char    *s2 ;
{
    char    da [40] ;
    time_t    tm ;
    tm = time ( (time_t *) 0) ;

    strncpy ( da , ctime ( &tm ) , 39 ) ;
    da [ 39 ] = 0 ;

    fprintf ( fout , "pid %d , %.19s , durch %3d , " , pid , da , durch ) ;
    fprintf ( fout , s1 , s2 ) ;
    fflush ( fout ) ;
}

/*------------------------------------------------------------------------*/

void Sqldump ()
{
    if ( ( SQLC != -709 ) && ( SQLC != -807 ) && ( SQLC != 800 ) )
	{
	    /* only if kernel is alive, because if not the precompiler crashes */
    	EXEC SQL SQLDUMP ; /* to find dumping task in vtrace */
	}
	fopen ("dmp.file","a") ;
	sqladump () ;
	exit (1) ;
}
