# -----------------------------------------------------------------------------
#
# PURPOSE
# Handling Description for SAP Database Connectivty Library
#
# RELEASE:  SAP DB 8.0
#
# -----------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

* inc=:SAPDB/Interfaces/SQLDBC/tests/SQLDBCTestUtils.h

&ifdebug
* -DCATCH_ALL
&endif

&if $OS = WIN32
*-d -MD
&endif

&if $MACH in [ SUN ]
regex(\w+\.cpp) -features=tmplife
&endif

SQLDBCTestUtils.h inc=\
        :SAPDB/Interfaces/SQLDBC/SQLDBC.h,\
        :SAPDB/Container/Container_Vector.hpp,\
        :SAPDB/Interfaces/SQLDBC/tests/SQLDBCTestMain.h


SQLDBCTestUtils*.cpp inc=\
        SQLDBCTestUtils.h,\
        :SAPDB/RunTime/MemoryManagement/RTEMem_Allocator.hpp,\
        :SAPDB/Container/Container_Vector.hpp,\
        hsp77.h,\
        hsp81.h,\
        hsp78_0.h


SQLDBCTestMain.h inc=

allsqldbc.cpp inc=+SAPDB_sprintf.h

convertUCS2.cpp inc=+SAPDB_sprintf.h

unterm.cpp inc=+SAPDB_sprintf.h

allrowset.cpp inc=+SAPDBMem_Alloca.h

blobsingleinsert.cpp inc=+SAPDBMem_Alloca.h

proxyconnect.cpp inc=:SAPDB/Interfaces/SQLDBC/SQLDBC.h,\
    :SAPDB/Interfaces/SQLDBC/SQLDBC_Proxy.h

clienttrace.cpp inc=+:SAPDB/Interfaces/SQLDBC/SQLDBC_ClientTrace.h

datatrunc.cpp inc=+hsp78_0.h

oomtest.cpp inc=+SQLDBC_IRuntime.h,SAPDBMem_IRawAllocator.hpp

blobsingleinsert.cpp inc=+SAPDBMem_Alloca.h

errorCheck.cpp inc=+SAPDB_sprintf.h,IFR_ErrorHndl.h

canceltest.cpp inc=+heo07.h,+heo02.h

allsqldbc_c.c inc=:SAPDB/Interfaces/SQLDBC/SQLDBC-sqldbc_c.h,\
                  :SAPDB/Interfaces/SQLDBC/SQLDBC_Types.h

piecewise.cpp inc=SAPDB_sprintf.h

streamtest.cpp inc=+:precom/lcstream.h

testbincompat.cpp -DVMAKE <-$WRK/src/SAPDB/Interfaces/SQLDBC/tests/ \
	inc=:SAPDB/Interfaces/SQLDBC/SQLDBC.h \
	dep=:SAPDB/Interfaces/SQLDBC/SQLDBC-testbincompat.h

#----------------------------------------------------------------------
&if $OS = WIN32
bincompat.mk NMAKE ascii concom=yes ->$OWN/test/sqldbc/bincompat.mk
&else
bincompat.mk ascii concom=yes ->$OWN/test/sqldbc/bincompat.mk
&endif

# Do not remove this marker, the test generator depends on it!
#!testbincompat
testbincompat_92742.cpp ascii ->$(OWN)/test/sqldbc/testbincompat_92742.cpp 
testbincompat_92168.cpp ascii ->$(OWN)/test/sqldbc/testbincompat_92168.cpp 
testbincompat_89660.cpp ascii ->$(OWN)/test/sqldbc/testbincompat_89660.cpp 

