#!/usr/bin/perl
# pcmktest
#
# @(#)pcmktstpkg
#
# Generate car archive for the given intrerfacetest
#
# Burkhard Diesing
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

package pcmktest;
use Env;
use PCTest;
sub AddFilesFromParfile;
sub CreateStd;
sub DropCar;

$USAGE ="USAGE: pcmktstpkg <arcivename> <sourcedir> <paramfile>\n";
if (@ARGV < 3 ) {
  print <DATA>;
  exit;
}

&if $OSSPEC in [ WIN32 ]
$EXEC_EXT=".exe";
&else
$EXEC_EXT="";
&endif

my ($ARCHIVE, $SOURCEDIR, $PARFILE, $PARFILE2) = @ARGV;
$pref=PCTest::GetPrefix($SOURCEDIR);
die "Sourcelayer not found." if ($pref eq "");

my ( $TEST_ROOT ) = PCTest::GetOWN;

$TEST_ROOT="$TEST_ROOT/test";

chdir $TEST_ROOT;

my ( $CARFILE ) = "./tr_$ARCHIVE.sar";
my ( $CMD_CREATECAR ) = "SAPCAR -cvf $CARFILE";
my ( $CMD_ADDCAR )    = "SAPCAR -avf $CARFILE";
my ( $error ) = 0;
$error = CreateStd;
if (!$error) {
    $error = AddFilesFromParfile ($PARFILE);
}
if (!$error) {
    if (@ARGV > 3) {
        $error = AddFilesFromParfile ($PARFILE2);
    }
}
if ($error) {
    DropCar;
    exit -1;
}

sub CreateStd
{
    system ("$CMD_CREATECAR ./pc/bin/*");
    return -1 if ($?);
    system ("$CMD_ADDCAR $PARFILE");
    return -1 if ($?);
    system ("$CMD_ADDCAR ./pc/incl/*.*");
    return -1 if ($?);
&if $OSSPEC in [ WIN32 ]
    system ("$CMD_ADDCAR ./pc/lib/cpct.lib");
&else
    system ("$CMD_ADDCAR ./pc/lib/cpct.a");
&endif
    return -1 if ($?);
    return 0;
}


sub AddFilesFromParfile
{
    local($FILE) = $_[0];
    my @ext = ("c", "C", "cpp", "cpc", "CPC", "h", "hpp");

    if (!open (PARF, $FILE)) {
        print STDERR "ERROR: No paramfile '$FILE' found.";
        return -1;
    }
    while (<PARF>) {
#       ignore comments
        s/\/\/.*|\#.*//g;
        if (/$SOURCEDIR\/(\w+-?\w+)/) {
            my $found = 0;
            foreach my $ext (@ext) {
                if ( -f "./pc/$SOURCEDIR/$1.$ext") {
                    $found = 1;
                    system ("$CMD_ADDCAR ./pc/$SOURCEDIR/$1.*");
                    return -1 if ($?);
                    last;
                }
            }
            if (!$found) {
                print STDERR "ERROR: Testsource ./pc/$SOURCEDIR/$1.* not found.";
                return -1;
            }
            if ( -f "./pc/old/$pref.$1.cpo" ) {
                system ("$CMD_ADDCAR ./pc/old/$pref.$1.cpo");
                return -1 if ($?);
            }
        }
    }
    close (PARF);

    if ($ENV{PCNOEXE} eq "y") {
        if (!open (PARF, $FILE)) {
            print STDERR "ERROR: No paramfile '$FILE' found.";
            return -1;
        }
        while (<PARF>) {
#           ignore comments
            s/\/\/.*|\#.*|.*-nobind.*//g;
            if (/$SOURCEDIR\/(\w+-?\w+)/) {
                if ( -f "./pc/wrk/$1$EXEC_EXT") {
                    system ("$CMD_ADDCAR ./pc/wrk/$1$EXEC_EXT");
                    return -1 if ($?);
                } else {
                    print STDERR "ERROR: Testexecutable ./pc/wrk/$1$EXEC_EXT not found.";
                    return -1;
                }
            }
        }
    }
    close (PARF);

    return 0;
}

sub DropCar
{
    unlink "$CARFILE";
}
