#!/usr/bin/perl
# cpct 
#
# @(#)cpct  6.2  1997-10-15 
#
# Generate and start all C-Precompiler Testfiles
# 
# Burkhard Diesing & other members of SAPDB Interfaces
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2003-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

package cpct;
use Env;
use PCTestTools;
&if $OSSPEC in [ WIN32 ]
use OLE;
&endif
sub ShowProt;
sub RunTest;
sub CheckLink;
sub CheckSQLVer;
sub DynTraceTest;

do $TOOLVARS;

if ( !defined $OWN ) {
    $OWN = PCTest::GetOWN;
}

if ($ENV{PCNOCOMP} eq "y") {
    $NOCOMP = 1;
} else {
    $NOCOMP = 0;
}

foreach $_ (@ARGV) {
    if ( /-prot/ ) {
      $pfad="$OWN/test/pc/wrk/pctest.prot.html";
      ShowProt;
      exit (0);
    }
    next;
}

$TESTSCRIPT="C-Precompiler Tests";
$ENV{SQLOPT}="";
$OPT="";
$CALL_INIT = TRUE; # flag if PCTEST::INIT should be called

$MAIL="Yes";
$PARFILE="$OWN/test/jtest/tests/parameters/Precompiler.par";
#regular expression list of servers who will send mails to the reciever
@sender = ( ".*", "P26325", "P26326", "P26327" );

#list of users who will receive a mail about the testresults
@receiver = ( "D025086" );

$START=0;
$END=0;

$USAGE ="USAGE: cpct [options]\n";
$USAGE.="   \noptions  :\n";
$USAGE.="      -cleanup          : Cleans the output from previous runs.\n";
$USAGE.="      -nocore           : Switch to the debugger in case of a core.\n";
$USAGE.="      -debug            : Include debug information.\n";
$USAGE.="      -purify           : runs all programs under Purify.\n";
$USAGE.="      -keep             : Keeps all intermediate files.\n";
$USAGE.="      -nomail           : Do not send a mail with the testresults to @receiver.\n";
$USAGE.="      -only cpc/<prog>  : Runs only test program <prog> (without extension).\n";
$USAGE.="      -parfile \"<file>\" : Use parameter file <file> instead of default file.\n";
$USAGE.="                          Default parameter file is '$PARFILE'.\n";

foreach $_ (@ARGV) {
    if ( /-cleanup/ ) { 
        $CLEANUP="YES";
  $OPT.=$_;
  $MAIL="No";
    }
    if ( /-nocore/ ) { 
  $OPT.=$_;
    }
    if ( /-debug/ ) { 
  $OPT.=$_;
    }
    if ( /-norun/ ) {
  $OPT.=$_;
    }
    if ( /-purify/ ) {
  $OPT.=$_."-debug";
    }
    if ( /-keep/ ) { 
  $OPT.=$_;
    }
    if ( /-nomail/ ) { 
  $MAIL="No";
    }
    if ( /-\?|-h/ ) {
  print $USAGE;
  exit;
    }
    if (/-only/ ) {
        $ONLY="INIT";
        $OPT.=" ";
        $OPT.=$_;
    } elsif (defined $ONLY && $ONLY eq "INIT") {
        $ONLY="YES";
        if ($_ ne "cpc/initcpc") {
          $CALL_INIT=FALSE;
        }  
        $OPT.=" ";
        $OPT.=$_;     
    }
    if ( /-parfile/ ) {
        $PARFLAG = "INIT";        
    } elsif (defined $PARFLAG && $PARFLAG eq "INIT") {
        $PARFLAG="YES";
        $PARFILE = $_;
    }
    if ( /-range/ ) {
        $RANGEFLAG = "INIT";
    } elsif (defined $RANGEFLAG && $RANGEFLAG eq "INIT") {
        $RANGEFLAG="YES";
        ($START,$END) = split /:/,$_;
    }
    next;
}

if ( ! -e $PARFILE ) {
  PCTest::WriteProt(PCTest::date()." $PARFILE not found.");
    exit -1;
}

if ($CLEANUP ne "YES") {
  PCTest::PCTest_init("init") if ($CALL_INIT);      
  PCTest::WriteProt(PCTest::date()." Start $TESTSCRIPT");
  CPCTest::XUserMakeData( "cpc", "cpc" );
  CPCTest::MapDB(PCTest::GetOWN."/test/pc/incl/cpchead.h");
    if ($ONLY ne "YES" && $NOCOMP == 0) {
      cpct::CheckLink;
      cpct::CheckSQLVer;
    }

  cpct::RunTest;
  cpct::DynTraceTest;
    
    if ( $MAIL =~ /Yes/ ) {
#   do not send a mail to the user who is logged in
        foreach $receiver (@receiver) {
            if ( uc($USERNAME) =~ /$receiver/ ) {
                $receiver = "";
            }
            next;
        }
      CPCTest::MailProt("@sender", "@receiver", $TESTSCRIPT, PCTest::GetPCProtFile);
    }
}
else {
# only cleanup   
  PCTest::PCTest_init("init");      
  PCTest::WriteProt(PCTest::date()." Cleanup $TESTSCRIPT");
  cpct::RunTest;
}
1; 

sub RunTest
{
    if ($OPT =~ /purify/)  {
&if $OSSPEC in [ WIN32 ]
      Purify::WriteResultHeader ();
&else
      Purify::WriteResultValgrindHeader ();
&endif
    }

    open (PARF, $PARFILE);

    PCTest::pctest ( "-u $SUPERUID,$SUPERPWD", "-c", "cpc/initcpc", $OPT);
    $CNT=0;
    while (<PARF>) {
        s/\/\/.*|\#.*//g;
        if (/cpc\/\w+-?\w*/ && $CNT>=$START) {
            if (($END != 0 && $CNT <= $END) || $END == 0){
#              print "$`, $&, (split ' ', $') $OPT";
#              print "\n";
              PCTest::pctest ($`, $&, (split ' ', $'), $OPT);
            }
        }
        $CNT++; 
    }
    close (PARF);

    if ($OPT =~ /purify/)  {
&if $OSSPEC in [ WIN32 ]
      Purify::WriteResultFooter ();
&else
      Purify::WriteResultValgrindFooter ();
&endif
    }

    Purify::Rename ("cpc");
}

sub CheckLink
{
  $OPTIONEN  = " -keep -norun ";
  PCTest::pctest ( "-u cpc,cpc -X", "-c", "cpc/conrel", $OPTIONEN );
  if ($ENV{PCNOEXE} ne "y") {
&if $OSSPEC in [ WIN32 ]
    @cmd = ("cpclnk -MD conrel", 
      "cpclnk -MT conrel", 
      "cpclnk -SMT conrel");
&else
    @cmd = ("cpclnk conrel");
&endif
    
    foreach $cmd (@cmd) {
      PCTest::_system ($cmd);
  if ($? != 0) {
    PCTest::WriteProt(PCTest::date()." ERROR: Linking with $cmd");
  } 
    }
  }
}

sub CheckSQLVer
{
    $sqlvfile = ".sqlver";
    $cmd = "sqlver conrel.exe > $sqlvfile";
  PCTest::_system ($cmd);    
    open(temp, "< $sqlvfile") || PCTest::WriteProt (PCTest::date()."Can't open $sqlvfile (input): $!");
    while(<temp>) {
      PCTest::WriteProt(PCTest::date()." $_");
    }            
}

sub DynTraceTest
{
    if ( defined $ENV{OS} && ($ENV{OS} eq "WIN32" || $ENV{OS} eq "Windows_NT") ) 
    { 
        $ENV{SQLOPT}="-X";
        PCTest::pctest ( "-u cpc,cpc -X", "-c ", "cpc/traceoption", $OPT );
        $ENV{SQLOPT}="";
    }
}

sub ShowProt
{
  unless (-f $pfad) {
    print "Protokollfile does not exist: $pfad\n";
    exit(0);
  }
&if $OSSPEC in [ WIN32 ]
  if ( defined $ENV{OS} && ($ENV{OS} eq "WIN32" || $ENV{OS} eq "Windows_NT") ) { 
    #  -----------------------------------------------------------------------------
    #  start internet explorer
    #  -----------------------------------------------------------------------------
    local $explorer ;
    $explorer = GetObject OLE 'InternetExplorer.Application';
    if (! defined($explorer)) {
      $explorer = CreateObject OLE 'InternetExplorer.Application'
      or die "Couldn't create new instance of Explorer App!!";
    }
    split (/\./, $source);
    $explorer->Navigate("file://$pfad");
    $explorer->{'Visible'} = 1;
    $explorer->{'Active'}  = 1;
  }
&else
    system("netscape $pfad &") ;
&endif
}
