/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.AbstractXMLDocumentParser;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractDOMParser
extends AbstractXMLDocumentParser {
    protected static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    protected static final String DOCUMENT_CLASS_NAME = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    private static final boolean DEBUG_ENTITY_REF = false;
    protected boolean fCreateEntityRefNodes;
    protected boolean fIncludeIgnorableWhitespace;
    protected Document fDocument;
    protected DocumentImpl fDocumentImpl;
    protected String fDocumentClassName;
    protected DocumentType fDocumentType;
    protected Node fCurrentNode;
    protected CDATASection fCurrentCDATASection;
    protected String fCurrentEntityName;
    protected String fCurrentEntityNode;
    protected boolean fDeferNodeExpansion;
    protected boolean fNamespaceAware;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected int fCurrentCDATASectionIndex;
    protected boolean fInDocument;
    protected boolean fInCDATASection;
    private QName fAttrQName = new QName();
    static /* synthetic */ Class class$org$w3c$dom$Document;

    protected AbstractDOMParser(XMLParserConfiguration config) {
        super(config);
        String[] recognizedFeatures = new String[]{CREATE_ENTITY_REF_NODES, INCLUDE_IGNORABLE_WHITESPACE, DEFER_NODE_EXPANSION};
        this.fConfiguration.addRecognizedFeatures(recognizedFeatures);
        this.fConfiguration.setFeature(CREATE_ENTITY_REF_NODES, true);
        this.fConfiguration.setFeature(INCLUDE_IGNORABLE_WHITESPACE, true);
        this.fConfiguration.setFeature(DEFER_NODE_EXPANSION, true);
        String[] recognizedProperties = new String[]{DOCUMENT_CLASS_NAME};
        this.fConfiguration.addRecognizedProperties(recognizedProperties);
        this.fConfiguration.setProperty(DOCUMENT_CLASS_NAME, DEFAULT_DOCUMENT_CLASS_NAME);
    }

    protected void setDocumentClassName(String documentClassName) {
        if (documentClassName == null) {
            documentClassName = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> _class = Class.forName(documentClassName);
            if (!(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = AbstractDOMParser.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).isAssignableFrom(_class)) {
                throw new IllegalArgumentException("PAR002 Class, \"" + documentClassName + "\", is not of type org.w3c.dom.Document.\n" + documentClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("PAR003 Class, \"" + documentClassName + "\", not found.\n" + documentClassName);
        }
        this.fDocumentClassName = documentClassName;
        if (!documentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.fDeferNodeExpansion = false;
        }
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public void reset() throws XNIException {
        super.reset();
        this.fCreateEntityRefNodes = this.fConfiguration.getFeature(CREATE_ENTITY_REF_NODES);
        this.fIncludeIgnorableWhitespace = this.fConfiguration.getFeature(INCLUDE_IGNORABLE_WHITESPACE);
        this.fDeferNodeExpansion = this.fConfiguration.getFeature(DEFER_NODE_EXPANSION);
        this.fNamespaceAware = this.fConfiguration.getFeature(NAMESPACES);
        this.setDocumentClassName((String)this.fConfiguration.getProperty(DOCUMENT_CLASS_NAME));
        this.fDocument = null;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fDocumentTypeIndex = -1;
        this.fDeferredDocumentImpl = null;
        this.fCurrentNode = null;
        this.fInDocument = false;
        this.fInDTD = false;
        this.fInCDATASection = false;
        this.fCurrentCDATASection = null;
        this.fCurrentCDATASectionIndex = -1;
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        if (this.fInDocument && !this.fInDTD && this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                EntityReference er = this.fDocument.createEntityReference(name);
                this.fCurrentNode.appendChild(er);
                this.fCurrentNode = er;
            } else {
                int er = this.fDeferredDocumentImpl.createDeferredEntityReference(name);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, er);
                this.fCurrentNodeIndex = er;
            }
        }
    }

    public void comment(XMLString text) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            Comment comment = this.fDocument.createComment(text.toString());
            this.fCurrentNode.appendChild(comment);
        } else {
            int comment = this.fDeferredDocumentImpl.createDeferredComment(text.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, comment);
        }
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            ProcessingInstruction pi = this.fDocument.createProcessingInstruction(target, data.toString());
            this.fCurrentNode.appendChild(pi);
        } else {
            int pi = this.fDeferredDocumentImpl.createDeferredProcessingInstruction(target, data.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, pi);
        }
    }

    public void startDocument(XMLLocator locator, String encoding) throws XNIException {
        this.fInDocument = true;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
                this.fDocument = new DocumentImpl();
                this.fDocumentImpl = (DocumentImpl)this.fDocument;
                this.fDocumentImpl.setErrorChecking(false);
            } else {
                try {
                    Class<?> documentClass = Class.forName(this.fDocumentClassName);
                    this.fDocument = (Document)documentClass.newInstance();
                    Class<?> defaultDocClass = Class.forName(DEFAULT_DOCUMENT_CLASS_NAME);
                    if (defaultDocClass.isAssignableFrom(documentClass)) {
                        this.fDocumentImpl = (DocumentImpl)this.fDocument;
                        this.fDocumentImpl.setErrorChecking(false);
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create document object of class: " + this.fDocumentClassName);
                }
            }
            this.fCurrentNode = this.fDocument;
        } else {
            this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fNamespaceAware);
            this.fDocument = this.fDeferredDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDeferredDocument();
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentType = this.fDocumentImpl.createDocumentType(rootElement, publicId, systemId);
                this.fCurrentNode.appendChild(this.fDocumentType);
            }
        } else {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDeferredDocumentType(rootElement, publicId, systemId);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, this.fDocumentTypeIndex);
        }
    }

    public void startElement(QName element, XMLAttributes attributes) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            Element el = this.fNamespaceAware ? this.fDocument.createElementNS(element.uri, element.rawname) : this.fDocument.createElement(element.rawname);
            int attrCount = attributes.getLength();
            int i = 0;
            while (i < attrCount) {
                attributes.getName(i, this.fAttrQName);
                Attr attr = this.fNamespaceAware ? this.fDocument.createAttributeNS(this.fAttrQName.uri, this.fAttrQName.rawname) : this.fDocument.createAttribute(this.fAttrQName.rawname);
                String attrValue = attributes.getValue(i);
                attr.setNodeValue(attrValue);
                el.setAttributeNode(attr);
                ++i;
            }
            this.fCurrentNode.appendChild(el);
            this.fCurrentNode = el;
        } else {
            int el = this.fDeferredDocumentImpl.createDeferredElement(this.fNamespaceAware ? element.uri : null, element.rawname, attributes);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, el);
            this.fCurrentNodeIndex = el;
        }
    }

    public void characters(XMLString text) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fInCDATASection) {
                if (this.fCurrentCDATASection == null) {
                    this.fCurrentCDATASection = this.fDocument.createCDATASection(text.toString());
                    this.fCurrentNode.appendChild(this.fCurrentCDATASection);
                    this.fCurrentNode = this.fCurrentCDATASection;
                } else {
                    this.fCurrentCDATASection.appendData(text.toString());
                }
            } else if (!this.fInDTD) {
                Node child = this.fCurrentNode.getLastChild();
                if (child != null && child.getNodeType() == 3) {
                    Text textNode = (Text)child;
                    textNode.appendData(text.toString());
                } else {
                    Text textNode = this.fDocument.createTextNode(text.toString());
                    this.fCurrentNode.appendChild(textNode);
                }
            }
        } else if (this.fInCDATASection) {
            if (this.fCurrentCDATASectionIndex == -1) {
                int cs = this.fDeferredDocumentImpl.createDeferredCDATASection(text.toString());
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, cs);
                this.fCurrentCDATASectionIndex = cs;
                this.fCurrentNodeIndex = cs;
            } else {
                int txt = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), false);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
            }
        } else if (!this.fInDTD) {
            int txt = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
        }
    }

    public void ignorableWhitespace(XMLString text) throws XNIException {
        if (!this.fIncludeIgnorableWhitespace) {
            return;
        }
        if (!this.fDeferNodeExpansion) {
            Node child = this.fCurrentNode.getLastChild();
            if (child != null && child.getNodeType() == 3) {
                Text textNode = (Text)child;
                textNode.appendData(text.toString());
            } else {
                Text textNode = this.fDocument.createTextNode(text.toString());
                if (this.fDocumentImpl != null) {
                    TextImpl textNodeImpl = (TextImpl)textNode;
                    textNodeImpl.setIgnorableWhitespace(true);
                }
                this.fCurrentNode.appendChild(textNode);
            }
        } else {
            int txt = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
        }
    }

    public void endElement(QName element) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            this.fCurrentNode = this.fCurrentNode.getParentNode();
        } else {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
        }
    }

    public void endPrefixMapping(String prefix) throws XNIException {
    }

    public void startCDATA() throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA() throws XNIException {
        this.fInCDATASection = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fCurrentCDATASection != null) {
                this.fCurrentNode = this.fCurrentNode.getParentNode();
                this.fCurrentCDATASection = null;
            }
        } else if (this.fCurrentCDATASectionIndex != -1) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            this.fCurrentCDATASectionIndex = -1;
        }
    }

    public void endDocument() throws XNIException {
        this.fInDocument = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentImpl.setErrorChecking(true);
            }
            this.fCurrentNode = null;
        } else {
            this.fCurrentNodeIndex = -1;
        }
    }

    public void endEntity(String name) throws XNIException {
        if (this.fInDocument && !this.fInDTD && this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                NamedNodeMap entities;
                NodeImpl entity;
                if (this.fDocumentImpl != null && this.fDocumentType != null && (entity = (NodeImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) != null && entity.getFirstChild() == null) {
                    entity.setReadOnly(false, true);
                    Node child = this.fCurrentNode.getFirstChild();
                    while (child != null) {
                        Node copy = child.cloneNode(true);
                        entity.appendChild(copy);
                        child = child.getNextSibling();
                    }
                    entity.setReadOnly(true, true);
                    entities.setNamedItem(entity);
                }
                this.fCurrentNode = this.fCurrentNode.getParentNode();
            } else {
                int entityIndex = -1;
                int dtChildIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (dtChildIndex != -1) {
                    String nodeName;
                    short nodeType = this.fDeferredDocumentImpl.getNodeType(dtChildIndex, false);
                    if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(dtChildIndex, false)).equals(name)) {
                        entityIndex = dtChildIndex;
                        break;
                    }
                    dtChildIndex = this.fDeferredDocumentImpl.getRealPrevSibling(dtChildIndex, false);
                }
                if (entityIndex != -1) {
                    int prevIndex = -1;
                    int childIndex = this.fDeferredDocumentImpl.getLastChild(this.fCurrentNodeIndex, false);
                    while (childIndex != -1) {
                        int cloneIndex = this.fDeferredDocumentImpl.cloneNode(childIndex, true);
                        this.fDeferredDocumentImpl.insertBefore(entityIndex, cloneIndex, prevIndex);
                        prevIndex = cloneIndex;
                        childIndex = this.fDeferredDocumentImpl.getRealPrevSibling(childIndex, false);
                    }
                }
                this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            }
        }
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            Text textNode = this.fDocumentImpl.createTextNode(text.toString());
            entity.appendChild(textNode);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getRealPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, null, null, null);
                int textIndex = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), false);
                this.fDeferredDocumentImpl.appendChild(entityIndex, textIndex);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            entity.setPublicId(publicId);
            entity.setSystemId(systemId);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getRealPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, publicId, systemId, null);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            entity.setPublicId(publicId);
            entity.setSystemId(systemId);
            entity.setNotationName(notation);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getRealPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, publicId, systemId, notation);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws XNIException {
        NamedNodeMap notations;
        if (this.fDocumentType != null && (notations = this.fDocumentType.getNotations()).getNamedItem(name) == null) {
            NotationImpl notation = (NotationImpl)this.fDocumentImpl.createNotation(name);
            notation.setPublicId(publicId);
            notation.setSystemId(systemId);
            notations.setNamedItem(notation);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 12 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int notationIndex = this.fDeferredDocumentImpl.createDeferredNotation(name, publicId, systemId);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, notationIndex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

