/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSWildcardDecl;

public class XSAttributeGroupDecl {
    public String fName = null;
    public String fTargetNamespace = null;
    int fAttrUseNum = 0;
    private static final int INITIAL_SIZE = 5;
    XSAttributeUse[] fAttributeUses = new XSAttributeUse[5];
    public XSWildcardDecl fAttributeWC = null;
    public String fIDAttrName = null;

    public String addAttributeUse(XSAttributeUse attrUse) {
        if (this.fAttrUseNum == this.fAttributeUses.length) {
            this.fAttributeUses = XSAttributeGroupDecl.resize(this.fAttributeUses, this.fAttrUseNum * 2);
        }
        this.fAttributeUses[this.fAttrUseNum++] = attrUse;
        if (attrUse.fUse == 2) {
            return null;
        }
        if (attrUse.fAttrDecl.fType instanceof IDDatatypeValidator) {
            if (this.fIDAttrName == null) {
                this.fIDAttrName = attrUse.fAttrDecl.fName;
            } else {
                return this.fIDAttrName;
            }
        }
        return null;
    }

    public XSAttributeUse getAttributeUse(String uri, String localpart) {
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fAttrDecl.fTargetNamespace == uri && this.fAttributeUses[i].fAttrDecl.fName == localpart) {
                return this.fAttributeUses[i];
            }
            ++i;
        }
        return null;
    }

    public void removeProhibitedAttrs() {
        int pCount = 0;
        XSAttributeUse[] pUses = new XSAttributeUse[this.fAttrUseNum];
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fUse == 2) {
                pUses[this.fAttrUseNum - ++pCount] = this.fAttributeUses[i];
            }
            ++i;
        }
        int newCount = 0;
        if (pCount > 0) {
            int i2 = 0;
            while (i2 < this.fAttrUseNum) {
                if (this.fAttributeUses[i2].fUse != 2) {
                    int j = 1;
                    while (j <= pCount) {
                        if (this.fAttributeUses[i2].fAttrDecl.fName != pUses[this.fAttrUseNum - pCount].fAttrDecl.fName || this.fAttributeUses[i2].fAttrDecl.fTargetNamespace == pUses[this.fAttrUseNum - pCount].fAttrDecl.fTargetNamespace) {
                            // empty if block
                        }
                        ++j;
                    }
                    pUses[newCount++] = this.fAttributeUses[i2];
                }
                ++i2;
            }
            this.fAttributeUses = pUses;
            this.fAttrUseNum = newCount;
        }
    }

    public XSAttributeUse[] getAttributeUses() {
        if (this.fAttrUseNum < this.fAttributeUses.length) {
            this.fAttributeUses = XSAttributeGroupDecl.resize(this.fAttributeUses, this.fAttrUseNum);
        }
        return this.fAttributeUses;
    }

    public String validRestrictionOf(XSAttributeGroupDecl baseGroup) {
        String errorCode = null;
        XSAttributeUse attrUse = null;
        XSAttributeDecl attrDecl = null;
        XSAttributeUse baseAttrUse = null;
        XSAttributeDecl baseAttrDecl = null;
        int i = 0;
        while (i < this.fAttrUseNum) {
            attrUse = this.fAttributeUses[i];
            attrDecl = attrUse.fAttrDecl;
            baseAttrUse = baseGroup.getAttributeUse(attrDecl.fTargetNamespace, attrDecl.fName);
            if (baseAttrUse != null) {
                short thisConstType;
                if (baseAttrUse.fUse == 1 && attrUse.fUse != 1) {
                    errorCode = "derivation-ok-restriction.2.1.1";
                    return errorCode;
                }
                baseAttrDecl = baseAttrUse.fAttrDecl;
                if (!XSConstraints.checkSimpleDerivationOk(attrDecl.fType, baseAttrDecl.fType, baseAttrDecl.fType.getFinalSet())) {
                    errorCode = "derivation-ok-restriction.2.1.2";
                    return errorCode;
                }
                short baseConsType = baseAttrUse.fConstraintType != 0 ? baseAttrUse.fConstraintType : baseAttrDecl.fConstraintType;
                short s = thisConstType = attrUse.fConstraintType != 0 ? attrUse.fConstraintType : attrDecl.fConstraintType;
                if (baseConsType == 2) {
                    String thisFixedValue;
                    if (thisConstType != 2) {
                        errorCode = "derivation-ok-restriction.2.1.3";
                        return errorCode;
                    }
                    String baseFixedValue = (String)(baseAttrUse.fDefault != null ? baseAttrUse.fDefault : baseAttrDecl.fDefault);
                    if (!baseFixedValue.equals(thisFixedValue = (String)(attrUse.fDefault != null ? attrUse.fDefault : attrDecl.fDefault))) {
                        errorCode = "derivation-ok-restriction.2.1.3";
                        return errorCode;
                    }
                }
            } else if (baseGroup.fAttributeWC == null || !baseGroup.fAttributeWC.allowNamespace(attrDecl.fTargetNamespace)) {
                errorCode = "derivation-ok-restriction.2.2";
                return errorCode;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < baseGroup.fAttrUseNum) {
            baseAttrUse = baseGroup.fAttributeUses[i2];
            if (baseAttrUse.fUse == 1) {
                baseAttrDecl = baseAttrUse.fAttrDecl;
                XSAttributeUse thisAttrUse = this.getAttributeUse(baseAttrDecl.fTargetNamespace, baseAttrDecl.fName);
                if (thisAttrUse == null) {
                    errorCode = "derivation-ok-restriction.3";
                    return errorCode;
                }
            }
            ++i2;
        }
        if (this.fAttributeWC != null) {
            if (baseGroup.fAttributeWC == null) {
                errorCode = "derivation-ok-restriction.4";
                return errorCode;
            }
            if (!this.fAttributeWC.isSubsetOf(baseGroup.fAttributeWC)) {
                errorCode = "derivation-ok-restriction.4";
                return errorCode;
            }
        }
        return null;
    }

    static final XSAttributeUse[] resize(XSAttributeUse[] oldArray, int newSize) {
        XSAttributeUse[] newArray = new XSAttributeUse[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }
}

