/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.util.HexBin;

public class HexBinaryDatatypeValidator
extends AbstractStringValidator {
    public HexBinaryDatatypeValidator() {
        super(null, null, false, null);
    }

    public HexBinaryDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        String msg = "hexBinary datatype, facet " + key + " with value " + (String)facets.get(key);
        throw new InvalidDatatypeFacetException(msg);
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
        if (this.getLength(content) < 0) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is not encoded in Hex");
        }
    }

    protected int getLength(String content) {
        int x = 0;
        try {
            try {
                x = HexBin.getDecodedDataLength(content.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Object var5_4 = null;
                return x;
            }
            Object var5_3 = null;
            return x;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            return x;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HexBinaryDatatypeValidator newObj = null;
        newObj = new HexBinaryDatatypeValidator();
        newObj.fLocale = this.fLocale;
        newObj.fBaseValidator = this.fBaseValidator;
        newObj.fLength = this.fLength;
        newObj.fMaxLength = this.fMaxLength;
        newObj.fMinLength = this.fMinLength;
        newObj.fPattern = this.fPattern;
        newObj.fRegex = this.fRegex;
        newObj.fEnumeration = this.fEnumeration;
        newObj.fFacetsDefined = this.fFacetsDefined;
        return newObj;
    }

    public int compare(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return -1;
        }
        if (value1 == value2 || value1.equals(value2)) {
            return 0;
        }
        byte[] data1 = HexBin.decode(value1.getBytes());
        byte[] data2 = HexBin.decode(value2.getBytes());
        if (data1 == null || data2 == null) {
            return -1;
        }
        int i = 0;
        while (i < Math.min(data1.length, data2.length)) {
            if (data1[i] < data2[i]) {
                return -1;
            }
            if (data1[i] > data2[i]) {
                return 1;
            }
            ++i;
        }
        if (data1.length == data2.length) {
            return 0;
        }
        return data1.length > data2.length ? 1 : -1;
    }
}

