/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class BooleanDatatypeValidator
extends AbstractDatatypeValidator {
    private static final String[] fValueSpace = new String[]{"false", "true", "0", "1"};

    public BooleanDatatypeValidator() {
        this(null, null, false, null);
    }

    public BooleanDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        this.fErrorReporter = reporter;
        this.fBaseValidator = base;
        if (derivedByList) {
            return;
        }
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals(SchemaSymbols.ELT_PATTERN)) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)facets.get(key);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                String msg = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.ILLEGAL_BOOLEAN_FACET], new Object[]{key});
                if (this.fErrorReporter == null) {
                    throw new RuntimeException("InternalDatatype error BDV.");
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{msg}, (short)1);
            }
        }
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        this.checkContent(content, false);
        return null;
    }

    public int compare(String content1, String content2) {
        Boolean b2;
        if (content1.equals(content2)) {
            return 0;
        }
        Boolean b1 = Boolean.valueOf(content1);
        return b1.equals(b2 = Boolean.valueOf(content2)) ? 0 : 1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    protected void checkContent(String content, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null && !(this.fBaseValidator instanceof AnySimpleType)) {
            ((BooleanDatatypeValidator)this.fBaseValidator).checkContent(content, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value'" + content + "does not match regular expression facet" + this.fPattern);
        }
        if (asBase) {
            return;
        }
        boolean isContentInDomain = false;
        int i = 0;
        while (i < fValueSpace.length) {
            if (content.equals(fValueSpace[i])) {
                isContentInDomain = true;
            }
            ++i;
        }
        if (!isContentInDomain) {
            String msg = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_BOOLEAN], new Object[]{content});
            throw new InvalidDatatypeValueException(msg);
        }
    }
}

