/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.interpreter;

import com.sap.sapdb.sqltest.interpreter.Cache;
import com.sap.sapdb.sqltest.interpreter.Catalog;
import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCallableStatement;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sapdb.testframe.testcase.VerificationDataSubset;
import com.sap.sapdb.testframe.utilities.TestCaseDBVersionScope;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class TestCasesInterpreter
extends TestCase {
    protected Connection myConnection = null;
    protected TestStatement myStatement = null;
    protected TestCallableStatement myCallableStatement = null;
    protected TreeMap cases = null;
    protected String currentXMLFileName;
    protected TestCaseBean testCase;
    protected boolean traceMode;
    protected boolean errorTraceMode;
    protected boolean autoCommit;
    protected String testSqlMode;
    protected String runningStage;
    private Catalog catalog;
    private Cache cache;
    private int numberOfStartedTestCases = 0;
    private int numberOfFailedTestCases = 0;
    private int numberOfExcludedTestCases = 0;
    protected boolean isCurrentTestCaseFailed;
    private boolean isInfoIgnored;
    private int statementCounter = 0;
    private int cellLengthForPrintedResultSet = 25;
    private Vector mDatabaseParameter = new Vector();
    private Hashtable userConnections = new Hashtable();
    private Properties conProps;
    private boolean mDoConsistencyCheck = false;
    public static final String[] knownConnectionProperties = new String[]{"sqlmode", "timeout", "isolation", "reconnect", "autocommit", "spaceoption", "unicode", "trace", "application", "applversion"};
    private boolean stopOnFirstError = false;
    private boolean mAnErrorOccured = false;
    private String mErrorDescription = "";
    private String sVersion = "4.2";

    public void setInfoIgnored(boolean infoIgnored) {
        this.isInfoIgnored = infoIgnored;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnFirstError = stopOnError;
    }

    protected void printTrace(String str) {
        if (this.traceMode) {
            System.out.println(str);
            System.out.flush();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeStatement(StatementBean st) {
        callString = st.getCallString().trim();
        mess = "";
        verify = st.isVerify() != false ? "verifying " : "";
        if (st.isIgnoreErrors()) {
            res = true;
            typeOfMess = 'I';
            mess = "Error ignored: ";
        } else {
            res = false;
            typeOfMess = 'E';
            mess = "";
        }
        try {
            try {
                block84: {
                    block81: {
                        statementHasErrorElements = st.getErrorBeans().isEmpty() == false;
                        try {
                            if (callString.toLowerCase().startsWith("dbm:")) {
                                try {
                                    callString = callString.substring(4);
                                    TestCase.getDatabase().executeDBMcmd(callString);
                                    this.myStatement = new TestStatement((TestCase)this, this.myConnection);
                                    break block81;
                                }
                                catch (TestDatabaseException tdbe) {
                                    throw new SQLException(tdbe.getMessage());
                                }
                            }
                            user = st.getUser();
                            if (user != null && !user.matches("\\s*")) {
                                if (user.endsWith("#1")) {
                                    user = user.substring(0, user.length() - 2);
                                }
                                if (this.userConnections.containsKey(user) == false) throw new SQLException("Session not connected", "", -821);
                                myConnection = (Connection)this.userConnections.get(user);
                            } else {
                                myConnection = this.myConnection;
                            }
                            if (st.isCallable()) {
                                this.myCallableStatement = new TestCallableStatement((TestCase)this, myConnection, callString);
                                p = null;
                                ct = 1;
                                if (st.getParams() != null) {
                                    params = st.getParams().elements();
                                    while (params.hasMoreElements()) {
                                        p = (StatementBean.Param)params.nextElement();
                                        if (p.paramType.equals("IN")) {
                                            this.myCallableStatement.setInParam(ct, p.dataType, p.inValue);
                                            ++ct;
                                        }
                                        if (p.paramType.equals("OUT")) {
                                            this.myCallableStatement.registerOutParameter(ct, p.dataType);
                                            ++ct;
                                        }
                                        if (!p.paramType.equals("INOUT")) continue;
                                        this.myCallableStatement.setInParam(ct, p.dataType, p.inValue);
                                        this.myCallableStatement.registerOutParameter(ct, p.dataType);
                                        ++ct;
                                    }
                                }
                                this.printTrace("Executing: " + verify + "statement: " + callString);
                                this.myCallableStatement.enableExplain(false);
                                this.myCallableStatement.execute();
                                this.printTrace("Executed.");
                                ct = 1;
                                if (st.getParams() != null) {
                                    params = st.getParams().elements();
                                    while (params.hasMoreElements()) {
                                        p = (StatementBean.Param)params.nextElement();
                                        if (p.paramType.equals("OUT") || p.paramType.equals("INOUT")) {
                                            outP = this.myCallableStatement.getOutParam(ct, p.dataType);
                                            if (outP == null) {
                                                if (p.outValue != null) throw new SQLException("Unexpected value of OUT/INOUT parameter #" + ct + ": " + outP + " (expected: " + p.outValue + ")");
                                            }
                                            if (outP != null && !outP.equals(p.outValue)) {
                                                throw new SQLException("Unexpected value of OUT/INOUT parameter #" + ct + ": " + outP + " (expected: " + p.outValue + ")");
                                            }
                                        }
                                        ++ct;
                                    }
                                }
                                break block81;
                            }
                            trimmedCallString = callString.replaceAll("/\\*[^(\\*)]*\\*/", "");
                            trimmedCallString = trimmedCallString.trim().replaceAll("\\s+", " ");
                            trimmedLowerCallString = trimmedCallString.toLowerCase();
                            isReleaseFound = false;
                            if (trimmedLowerCallString.matches("connect .+ identified by .+")) {
                                try {
                                    block82: {
                                        block83: {
                                            props = new Properties(this.conProps);
                                            tokens = trimmedCallString.split(" ");
                                            props.setProperty("user", tokens[1]);
                                            props.setProperty("password", tokens[4]);
                                            propertyWasAlraedyFound = new boolean[TestCasesInterpreter.knownConnectionProperties.length];
                                            i = 5;
                                            while (true) {
                                                if (i >= tokens.length) {
                                                    con = null;
                                                    con = TestCase.getDatabase().connect(props);
                                                    newUser = props.getProperty("user");
                                                    if (!this.userConnections.containsKey(newUser)) break block82;
                                                    break block83;
                                                }
                                                token1 = tokens[i].toLowerCase();
                                                isProperty = false;
                                                j = 0;
                                                while (j < TestCasesInterpreter.knownConnectionProperties.length) {
                                                    if (token1.equalsIgnoreCase(TestCasesInterpreter.knownConnectionProperties[j])) {
                                                        isProperty = true;
                                                        if (propertyWasAlraedyFound[j]) {
                                                            throw new SQLException("[-828] Duplicate variable name: " + token1, "", -828);
                                                        }
                                                        propertyWasAlraedyFound[j] = true;
                                                        break;
                                                    }
                                                    ++j;
                                                }
                                                if (!isProperty) break;
                                                if (tokens.length <= i + 1) throw new SQLException("Invalids end of SQL statement", "", -3014);
                                                token2 = tokens[i + 1];
                                                props.setProperty(token1, token2);
                                                i += 2;
                                            }
                                            possibleProperties = "";
                                            j = 0;
                                            while (true) {
                                                if (j >= TestCasesInterpreter.knownConnectionProperties.length) {
                                                    possibleProperties = possibleProperties.substring(0, possibleProperties.length() - 2);
                                                    throw new SQLException("[-843] Invalid parameter name. Expect: " + possibleProperties, "", -843);
                                                }
                                                possibleProperties = String.valueOf(possibleProperties) + TestCasesInterpreter.knownConnectionProperties[j].toUpperCase() + ", ";
                                                ++j;
                                            }
                                        }
                                        i = 2;
                                        while (true) {
                                            if (!this.userConnections.containsKey(String.valueOf(newUser) + "#" + i)) {
                                                newUser = String.valueOf(newUser) + "#" + i;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (con != null) {
                                        this.userConnections.put(newUser, con);
                                    }
                                    break block81;
                                }
                                catch (TestDatabaseException tde) {
                                    erroCode = 0;
                                    message = tde.getMessage();
                                    try {
                                        erroCode = Integer.parseInt(message.substring(message.indexOf("[") + 1, message.indexOf("]")));
                                        throw new SQLException(message, "", erroCode);
                                    }
                                    catch (NumberFormatException var16_26) {
                                        // empty catch block
                                    }
                                    throw new SQLException(message, "", erroCode);
                                }
                            }
                            if (trimmedLowerCallString.matches("((commit)|(rollback)) (work )?release")) {
                                callString = trimmedLowerCallString.substring(0, trimmedLowerCallString.indexOf("release"));
                                isReleaseFound = true;
                            }
                            this.myStatement = new TestStatement((TestCase)this, myConnection);
                            this.myStatement.enableExplain(false);
                            if (callString != null) {
                                this.printTrace("Executing: " + verify + "statement: " + callString);
                                this.myStatement.execute(callString);
                                callString = this.myStatement.getSqlString();
                                this.printTrace("Executed.");
                            }
                            if (isReleaseFound && user != null) {
                                myConnection.close();
                                this.userConnections.remove(user);
                            }
                        }
                        catch (SQLException se) {
                            if (statementHasErrorElements) {
                                if (!st.checkErrorCodes(se.getErrorCode())) {
                                    if (typeOfMess != 'I' || !this.isInfoIgnored) {
                                        this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "mismatching error code ( " + se.getErrorCode() + " ) instead of " + st.getListOfExpectedErrorCodes() + " during " + verify + "statement.");
                                        if (this.errorTraceMode) {
                                            this.addMessage("", 'T', this.testCase.statementsToString());
                                        }
                                        if (this.stopOnFirstError) {
                                            this.mAnErrorOccured = true;
                                            this.mErrorDescription = "First error in 'checkErrorCodes': " + this.currentXMLFileName + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "an unexpected error (" + se.getErrorCode() + ") occured during " + verify + "error code verification\ntypeOfMess = " + typeOfMess;
                                        }
                                    }
                                    var24_39 = res;
                                    var22_45 = null;
                                    try {
                                        this.myStatement.close();
                                        return var24_39;
                                    }
                                    catch (Exception var25_54) {
                                        // empty catch block
                                    }
                                    return var24_39;
                                }
                                var22_46 = null;
                                ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl179:
                                // 1 sources

                                this.myStatement.close();
                                return true;
lbl181:
                                // 1 sources

                                catch (Exception var25_55) {
                                    // empty catch block
                                }
                                return true;
                            }
                            if (typeOfMess != 'I' || !this.isInfoIgnored) {
                                this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "unexpected error occured during " + verify + "statement\n" + se.getClass() + "\n" + se.getMessage() + "\nSee below for exception details.");
                                if (this.errorTraceMode) {
                                    this.addMessage("", 'T', this.testCase.statementsToString());
                                }
                                this.handleExceptions(se);
                                se.printStackTrace();
                                if (this.stopOnFirstError) {
                                    this.mAnErrorOccured = true;
                                    this.mErrorDescription = "First error in 'checkErrorCodes': " + this.currentXMLFileName + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "an unexpected error (" + se.getErrorCode() + ") occured during " + verify + "error code verification\ntypeOfMess = " + typeOfMess;
                                }
                            }
                            var24_40 = res;
                            var22_47 = null;
                            ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl197:
                            // 1 sources

                            this.myStatement.close();
                            return var24_40;
lbl199:
                            // 1 sources

                            catch (Exception var25_56) {
                                // empty catch block
                            }
                            return var24_40;
                        }
                    }
                    if (statementHasErrorElements) {
                        if (typeOfMess != 'I' || !this.isInfoIgnored) {
                            this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "no errors occured during " + verify + "statement\n" + "expected errors: " + st.getListOfExpectedErrorCodes());
                            if (this.errorTraceMode) {
                                this.addMessage("", 'T', this.testCase.statementsToString());
                            }
                        }
                        var24_41 = res;
                        var22_48 = null;
                        ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl212:
                        // 1 sources

                        this.myStatement.close();
                        return var24_41;
lbl214:
                        // 1 sources

                        catch (Exception var25_57) {
                            // empty catch block
                        }
                        return var24_41;
                    }
                    if (st.getVerificationData() != null) {
                        try {
                            verifyDataIsOK = false;
                            st.getVerificationData().setTheCellLengthOfTheResultset(this.cellLengthForPrintedResultSet);
                            lastErrorMessage = "n/a";
                            myResultSetToCheck = null;
                            myVeriToCheck = null;
                            switch (st.getVerificationData().getOperatorType()) {
                                case 'c': {
                                    myVeriToCheck = new VerificationDataComplete();
                                    break;
                                }
                                case 's': {
                                    myVeriToCheck = new VerificationDataSorted();
                                    break;
                                }
                                case 'u': {
                                    myVeriToCheck = new VerificationDataSubset();
                                    break;
                                }
                            }
                            if (st.isCallable()) {
                                myResultSetToCheck = this.myCallableStatement.getResultSet();
                                myVeriToCheck.add(myResultSetToCheck);
                                verifyDataIsOK = st.getVerificationData().equals((VerificationData)myVeriToCheck);
                                lastErrorMessage = st.getVerificationData().getErrorMessage();
                            } else {
                                myResultSetToCheck = this.myStatement.getResultSet();
                                myVeriToCheck.add(myResultSetToCheck);
                                verifyDataIsOK = st.getVerificationData().equals((VerificationData)myVeriToCheck);
                                lastErrorMessage = st.getVerificationData().getErrorMessage();
                            }
                            if (verifyDataIsOK) break block84;
                            if (typeOfMess != 'I' || !this.isInfoIgnored) {
                                this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "an error occured during " + verify + "statement verification\n" + lastErrorMessage);
                                this.addMessage("", 'I', "Expected resultset by the TestCasesInterpreter:\n" + st.getVerificationData().toString());
                                myVeriToCheck.setTheCellLengthOfTheResultset(this.cellLengthForPrintedResultSet);
                                this.addMessage("", 'I', "Received resultset by the database:\n" + myVeriToCheck.toString());
                                if (this.errorTraceMode) {
                                    this.addMessage("", 'T', this.testCase.statementsToString());
                                }
                            }
                            if (this.stopOnFirstError) {
                                this.mAnErrorOccured = true;
                                this.mErrorDescription = "First error in '!verifyDataIsOK': " + this.currentXMLFileName + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "an error occured during " + verify + "statement verification\n" + lastErrorMessage + "\ntypeOfMess = " + typeOfMess;
                            }
                            var24_42 = res;
                            var22_49 = null;
                        }
                        catch (RuntimeException tce) {
                            if (typeOfMess != 'I' || !this.isInfoIgnored) {
                                this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "error occured during " + verify + "statement verification\n" + tce.getClass() + "\n" + tce.getMessage());
                                if (this.errorTraceMode) {
                                    this.addMessage("", 'T', this.testCase.statementsToString());
                                }
                                if (this.stopOnFirstError) {
                                    this.mAnErrorOccured = true;
                                    this.mErrorDescription = "First error in 'RuntimeException' during verification: " + this.currentXMLFileName + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "error occured during " + verify + "statement verification\n" + tce.getClass() + "\n" + tce.getMessage() + "\ntypeOfMess = " + typeOfMess;
                                }
                            }
                            var24_43 = res;
                            var22_50 = null;
                            ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl271:
                            // 1 sources

                            this.myStatement.close();
                            return var24_43;
lbl273:
                            // 1 sources

                            catch (Exception var25_59) {
                                // empty catch block
                            }
                            return var24_43;
                        }
                        ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl277:
                        // 1 sources

                        this.myStatement.close();
                        return var24_42;
lbl279:
                        // 1 sources

                        catch (Exception var25_58) {
                            // empty catch block
                        }
                        return var24_42;
                    }
                }
                var22_51 = null;
                ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl285:
                // 1 sources

                this.myStatement.close();
                return true;
lbl287:
                // 1 sources

                catch (Exception var25_60) {
                    // empty catch block
                }
                return true;
            }
            catch (Exception e) {
                if (typeOfMess != 'I' || !this.isInfoIgnored) {
                    this.addMessage("", typeOfMess, String.valueOf(this.currentXMLFileName) + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "unexpected error occured\n" + e.getClass() + "\n" + e.getMessage());
                    this.handleExceptions(e);
                }
                if (this.stopOnFirstError) {
                    this.mAnErrorOccured = true;
                    this.mErrorDescription = "First error in 'Exception' during test execution: " + this.currentXMLFileName + ", test: " + String.valueOf(this.testCase.getTestCaseNumber()) + ", phase: " + this.runningStage + ", statement: " + this.statementCounter + "\n" + callString + "\n" + mess + "unexpected error occured\n" + e.getClass() + "\n" + e.getMessage() + "\ntypeOfMess = " + typeOfMess;
                }
                e.printStackTrace();
                var24_44 = res;
                var22_52 = null;
                ** try [egrp 7[TRYBLOCK] [14 : 3408->3418)] { 
lbl302:
                // 1 sources

                this.myStatement.close();
                return var24_44;
lbl304:
                // 1 sources

                catch (Exception var25_61) {
                    // empty catch block
                }
                return var24_44;
            }
        }
        catch (Throwable var23_63) {
            var22_53 = null;
            try {}
            catch (Exception var25_62) {
                throw var23_63;
            }
            this.myStatement.close();
            throw var23_63;
        }
    }

    public boolean executeSomeStatements(Iterator it) {
        while (it.hasNext()) {
            StatementBean sb = (StatementBean)it.next();
            ++this.statementCounter;
            if (this.executeStatement(sb)) continue;
            if (!this.isCurrentTestCaseFailed) {
                ++this.numberOfFailedTestCases;
                this.isCurrentTestCaseFailed = true;
            }
            return false;
        }
        return true;
    }

    public void setNewDatabaseParameter(String pParameter) {
        if (pParameter == null || pParameter.length() == 0) {
            return;
        }
        StringTokenizer stz = new StringTokenizer(pParameter, ",;");
        String curVal = null;
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)TestCase.getDatabase();
            while (stz.hasMoreTokens()) {
                String dbpOldValue;
                curVal = stz.nextToken().trim();
                String dbpName = curVal.substring(0, curVal.indexOf(":"));
                String dbpNewValue = curVal.substring(curVal.indexOf(":") + 1, curVal.length());
                if (dbpNewValue.compareTo(dbpOldValue = thisDB.getParameter(dbpName)) == 0) continue;
                this.mDatabaseParameter.add(new String(String.valueOf(dbpName) + "," + dbpNewValue + "," + dbpOldValue));
            }
            if (this.mDatabaseParameter.size() > 0) {
                System.out.println("Set new database parameter from parameter file...");
                thisDB.executeDBMcmd("db_cold");
                thisDB.executeDBMcmd("param_startsession");
                int i = 0;
                while (i < this.mDatabaseParameter.size()) {
                    curVal = (String)this.mDatabaseParameter.get(i);
                    stz = new StringTokenizer(curVal, ",");
                    thisDB.executeDBMcmd("param_put " + stz.nextToken() + " " + stz.nextToken());
                    ++i;
                }
                thisDB.executeDBMcmd("param_checkall");
                thisDB.executeDBMcmd("param_commitsession");
                thisDB.executeDBMcmd("db_offline");
                thisDB.restart();
            }
        }
        catch (TestDatabaseException tbe) {
            this.addMessage("setNewDatabaseParameter", 'E', "Tried to set: " + pParameter + "\nas new database parameter and got: " + tbe.getLocalizedMessage());
            this.mDatabaseParameter.clear();
        }
    }

    public void restoreOldDatabaseParameters() {
        if (this.mDatabaseParameter.size() == 0) {
            return;
        }
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)TestCase.getDatabase();
            System.out.println("Restore old database parameter...");
            thisDB.executeDBMcmd("db_cold");
            thisDB.executeDBMcmd("param_startsession");
            int i = 0;
            while (i < this.mDatabaseParameter.size()) {
                String curVal = (String)this.mDatabaseParameter.get(i);
                StringTokenizer stz = new StringTokenizer(curVal, ",");
                String dbpName = stz.nextToken();
                stz.nextToken();
                String dbpValue = stz.nextToken();
                thisDB.executeDBMcmd("param_put " + dbpName + " " + dbpValue);
                ++i;
            }
            thisDB.executeDBMcmd("param_checkall");
            thisDB.executeDBMcmd("param_commitsession");
            thisDB.executeDBMcmd("db_offline");
            thisDB.restart();
        }
        catch (TestDatabaseException tbe) {
            this.addMessage("restoreOldDatabaseParameters", 'E', "Tried to restore old database parameter and got: " + tbe.getLocalizedMessage());
        }
    }

    public static String getTestClassId() {
        return "TestCasesInterpreter";
    }

    public void setTraceMode(boolean b) {
        this.traceMode = b;
    }

    public void setTestCase(TestCaseBean t) {
        this.testCase = t;
    }

    public void setConnection(Connection conn) {
        this.myConnection = conn;
    }

    public void setDefaultConnectionProperties(Properties props) {
        this.conProps = props;
    }

    public void setUserConnections(Hashtable conn) {
        this.userConnections = conn;
    }

    public void reset() {
        this.statementCounter = 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        System.out.println(String.valueOf(TestCasesInterpreter.getTestClassId()) + " - Version: " + this.sVersion);
        this.addMessage(TestCasesInterpreter.getTestClassId(), 'I', "Version: " + this.sVersion);
        String catalogFileName = TestCase.getParameterString((String)"catalogFileName", (String)"");
        this.mDoConsistencyCheck = TestCase.getParameterBoolean((String)"DoConsistencyCheck", (boolean)false);
        this.isInfoIgnored = TestCase.getParameterBoolean((String)"IGNORE_INFO", (boolean)true);
        this.errorTraceMode = TestCase.getParameterBoolean((String)"ERRORTRACE", (boolean)false);
        boolean dropTestUser = TestCase.getParameterBoolean((String)"dropTestUser", (boolean)true);
        boolean testUserisDBA = TestCase.getParameterBoolean((String)"DBATestUser", (boolean)false);
        boolean testUserisSYSDBA = TestCase.getParameterBoolean((String)"SYSDBATestUser", (boolean)false);
        this.traceMode = TestCase.getParameterBoolean((String)"TRACE", (boolean)false);
        if (this.traceMode) {
            this.isInfoIgnored = false;
            this.errorTraceMode = true;
        }
        String URIPrefix = "file:///" + this.getDataInputPath() + File.separator;
        this.autoCommit = TestCase.getParameterBoolean((String)"AUTOCOMMIT", (boolean)false);
        this.testSqlMode = TestCase.getParameterString((String)"SQLMODE", (String)"INTERNAL");
        String testUser = TestCase.getParameterString((String)"testUser", (String)"");
        String testPassword = TestCase.getParameterString((String)"testPassword", (String)"");
        this.stopOnFirstError = TestCase.getParameterBoolean((String)"StopOnFirstError", (boolean)false);
        if (testUserisSYSDBA) {
            testUser = TestCase.getDatabase().getDBAUser();
            testPassword = TestCase.getDatabase().getDBAPassword();
            dropTestUser = false;
            testUserisDBA = false;
        }
        if (testUser.equals("")) {
            this.addMessage("", 'W', "Parameter testUser not set in parameter file, using default: TESTUSER");
            testUser = "TESTUSER";
        }
        if (testPassword.equals("")) {
            this.addMessage("", 'W', "Parameter testPassword not set in parameter file, using default: TESTUSER");
            testPassword = "TESTUSER";
        }
        this.cellLengthForPrintedResultSet = TestCase.getParameterInt((String)"RESULTSETLENGTH", (int)25);
        int maxExcludeRulesInProtocol = TestCase.getParameterInt((String)"MAXEXCLUDERULESINPROTOCOL", (int)-1);
        boolean disableAllExcludeRules = TestCase.getParameterBoolean((String)"DISABLEALLEXCLUDERULES", (boolean)false);
        String DataBaseParameter = TestCase.getParameterString((String)"DB_PARAMETER", (String)"");
        File catalogFile = new File(String.valueOf(this.getDataInputPath()) + File.separator + catalogFileName);
        int numberOfSelectedTestCases = 0;
        String Scope_charEncType = null;
        String Scope_sqlmode = this.testSqlMode;
        String Scope_version = null;
        try {
            try {
                block49: {
                    String qry;
                    boolean errorInConsistencyCheck;
                    TestDatabaseSap myDb = (TestDatabaseSap)TestCase.getDatabase();
                    String sqlMode = myDb.getSqlMode();
                    this.setNewDatabaseParameter(DataBaseParameter);
                    Scope_charEncType = myDb.getParameter("_UNICODE").equalsIgnoreCase("YES") ? (myDb.getParameter("DEFAULT_CODE").equalsIgnoreCase("UNICODE") ? "unicode" : "mixed") : "ascii";
                    Scope_version = myDb.getVersion();
                    if (dropTestUser) {
                        this.myConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                        TestStatement stmt = new TestStatement((TestCase)this, this.myConnection);
                        if (sqlMode.equals("ORACLE")) {
                            stmt.executeUpdateIgnoreErrors("DROP USER " + testUser + " CASCADE");
                            if (testUserisDBA) {
                                stmt.executeUpdate("CREATE USER " + testUser + " IDENTIFIED BY " + testPassword);
                            } else {
                                stmt.executeUpdate("CREATE USER " + testUser + " IDENTIFIED BY " + testPassword);
                            }
                        } else {
                            stmt.executeUpdateIgnoreErrors("DROP USER " + testUser);
                            if (testUserisDBA) {
                                stmt.executeUpdate("CREATE USER " + testUser + " PASSWORD " + testPassword + " DBA NOT EXCLUSIVE");
                            } else {
                                stmt.executeUpdate("CREATE USER " + testUser + " PASSWORD " + testPassword + " RESOURCE NOT EXCLUSIVE");
                            }
                        }
                        this.myConnection.commit();
                        stmt.close();
                        this.myConnection.close();
                    }
                    this.conProps = new Properties();
                    this.conProps.put("user", testUser);
                    this.conProps.put("password", testPassword);
                    if (this.autoCommit) {
                        this.conProps.put("autocommit", "on");
                    } else {
                        this.conProps.put("autocommit", "off");
                    }
                    this.conProps.put("sqlmode", this.testSqlMode);
                    this.addMessage("Parameterfile", 'T', "The following parameter file was used:\n" + this.getParameterFileLocation());
                    TestCase.printParametersToProtocol();
                    this.myConnection = TestCase.getDatabase().connect(this.conProps);
                    this.addMessage("Testcontext", 'T', "The context for these tests is: \nRelease     : " + Scope_version + "\nCharEncType : " + Scope_charEncType + "\nSQLMode     : " + Scope_sqlmode + "\n\ndb parameter:" + "\n _UNICODE      = " + myDb.getParameter("_UNICODE") + "\n DEFAULT_CODE  = " + myDb.getParameter("DEFAULT_CODE") + "\n _PACKET_SIZE  = " + myDb.getParameter("_PACKET_SIZE"));
                    this.catalog = new Catalog(catalogFile);
                    this.cache = new Cache(URIPrefix);
                    Iterator itRef = this.catalog.iterator();
                    int numberOfPlannedTestCases = this.catalog.getNumberOfReferences();
                    while (true) {
                        TestCaseDBVersionScope t;
                        if (!itRef.hasNext() || this.mAnErrorOccured) {
                            int numberOfSuccessfulTestCases = this.numberOfStartedTestCases - this.numberOfFailedTestCases;
                            if (numberOfSelectedTestCases * 3 < this.numberOfExcludedTestCases * 10) {
                                this.addMessage("Tests not executed!", 'W', "At least 30% of the selected tests are excluded through the exclude rules.");
                            }
                            this.addMessage("\nCatalog file " + catalogFileName + " has been interpreted.", 'I', " Test Cases in Catalog  : " + numberOfPlannedTestCases + "\n" + " Test Cases Selected    : " + numberOfSelectedTestCases + "\n" + " Test Cases Excluded    : " + this.numberOfExcludedTestCases + "\n" + " Test Cases Started     : " + this.numberOfStartedTestCases + "\n" + " Test Cases Successful  : " + numberOfSuccessfulTestCases + "\n" + " Test Cases Failed      : " + this.numberOfFailedTestCases + "\n" + " Total Errors           : " + TestCase.getErrorCounter() + "\n" + " Total Warnings         : " + TestCase.getWarningCounter() + "\n" + " Total Infos            : " + TestCase.getInfoCounter());
                            if (this.mAnErrorOccured) {
                                this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Because the parameter 'StopOnFirstError' is set to TRUE and an error is occurred, the test stopped too early. It is possible that further errors exist.");
                                this.addMessage(TestCasesInterpreter.getTestClassId(), 'W', "An error occured, the parameter 'StopOnFirstError' is set to TRUE and the consistency check and the restore of old database parameter will not be executed.");
                                this.addMessage(TestCasesInterpreter.getTestClassId(), 'W', "The error description: \n" + this.mErrorDescription);
                            }
                            if (this.mDoConsistencyCheck && !this.mAnErrorOccured) {
                                errorInConsistencyCheck = false;
                                this.myConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                                TestStatement stmt = new TestStatement((TestCase)this, this.myConnection);
                                qry = "select * from files f where (type = 'INDEX' or type = 'SHORT COLUMN FILE') and not exists (select * from files f1 where f1.fileid = f.primaryfileid) and f.FILESTATE <> 'DELETED'";
                                VerificationDataComplete myVeri = null;
                                ResultSet myRS = null;
                                myRS = stmt.executeQuery(qry);
                                myVeri = new VerificationDataComplete(myRS);
                                if (myVeri.getRowCounter() != 0) {
                                    errorInConsistencyCheck = true;
                                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for\n" + qry + "\n" + myVeri.toString());
                                }
                                if ((myVeri = new VerificationDataComplete(myRS = stmt.executeQuery(qry = "select * from files f where type = 'TABLE' and fileid < x'8000000000000000' and fileid <> x'0000000000000064' and fileid <> x'0000000000000065' and not exists (select * from sysdd.tables where objectid = f.fileid) and f.FILESTATE <> 'DELETED'"))).getRowCounter() != 0) {
                                    errorInConsistencyCheck = true;
                                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for " + qry + "\n" + myVeri.toString());
                                }
                                if ((myVeri = new VerificationDataComplete(myRS = stmt.executeQuery(qry = "select * from files f where type = 'INDEX' and not exists (select * from sysdd.indexes i where i.fileid = f.fileid) and f.FILESTATE <> 'DELETED'"))).getRowCounter() != 0) {
                                    errorInConsistencyCheck = true;
                                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for\n" + qry + "\n" + myVeri.toString());
                                }
                                int myRowCount = 0;
                                try {
                                    qry = "check catalog";
                                    myRowCount = stmt.executeUpdate(qry);
                                    if (myRowCount == 0) break;
                                    errorInConsistencyCheck = true;
                                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myRowCount + ") fails.\nResult for\n" + qry + "\n" + myRowCount);
                                }
                                catch (SQLException sqle) {
                                    errorInConsistencyCheck = true;
                                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myRowCount + ") fails.\nExecption for\n" + qry + "\n" + sqle.getErrorCode() + "\n" + sqle.getLocalizedMessage());
                                }
                                break;
                            }
                            break block49;
                        }
                        Reference currentRef = (Reference)itRef.next();
                        if (!currentRef.getSelected()) continue;
                        ++numberOfSelectedTestCases;
                        this.testCase = this.cache.getCaseForReference(currentRef);
                        if (this.testCase == null) {
                            this.addMessage("File = " + currentRef.getFileName(), 'W', "the test case for this " + currentRef.toString() + " does not exist.");
                            continue;
                        }
                        if (!disableAllExcludeRules && this.testCase.getExcludeProperty() != null && this.testCase.getExcludeProperty().length() != 0 && !(t = new TestCaseDBVersionScope(this.testCase.getExcludeProperty())).isInScope(Scope_charEncType, Scope_sqlmode, Scope_version)) {
                            if (this.numberOfExcludedTestCases <= maxExcludeRulesInProtocol || maxExcludeRulesInProtocol == -1) {
                                this.addMessage("Exclude rule", 'T', "Test " + currentRef.toString() + " \nwas not executed because exclude rule \"" + this.testCase.getExcludeProperty() + "\" matched.");
                            }
                            ++this.numberOfExcludedTestCases;
                            continue;
                        }
                        ++this.numberOfStartedTestCases;
                        if (this.numberOfStartedTestCases % 100 == 0) {
                            this.setStatus(String.valueOf(this.numberOfStartedTestCases) + " of " + numberOfPlannedTestCases);
                        }
                        this.isCurrentTestCaseFailed = false;
                        this.printTrace("-----------------------------------------------------------------------------");
                        this.printTrace("-----------------------------------------------------------------------------");
                        this.printTrace("Current reference: " + currentRef + "\n");
                        this.printTrace("Execute:\n" + this.testCase);
                        this.printTrace("-----------------------------------------------------------------------------");
                        this.printTrace("Statements executed:\n\n");
                        boolean result = true;
                        this.currentXMLFileName = String.valueOf(currentRef.getStructurePath()) + "\n   file: " + currentRef.getFileName();
                        this.statementCounter = 0;
                        if (!this.testCase.getPrepareStatemets().isEmpty()) {
                            this.runningStage = "Prepare";
                            this.printTrace("Prepare phase:");
                            result = this.executeSomeStatements(this.testCase.getPrepareStatemets().iterator());
                            if (!result) {
                                this.printTrace("Prepare phase failed.\n");
                            } else {
                                this.printTrace("Prepare phase successful.\n");
                            }
                        }
                        if (result) {
                            this.runningStage = "Run";
                            this.printTrace("Run phase:");
                            if (!this.executeSomeStatements(this.testCase.getRunStatements().iterator())) {
                                this.printTrace("Run phase failed.\n");
                            } else {
                                this.printTrace("Run phase successful.\n");
                            }
                        }
                        this.runningStage = "CleanUp";
                        this.printTrace("CleanUp phase:");
                        if (!this.testCase.getCleanUpStatements().isEmpty()) {
                            this.executeSomeStatements(this.testCase.getCleanUpStatements().iterator());
                        }
                        this.myConnection.commit();
                    }
                    try {
                        qry = "db_execute check data";
                        String dbmresult = TestCase.getDatabase().executeDBMcmd(qry);
                        if (dbmresult.trim().length() != 0 && !dbmresult.trim().startsWith("OK")) {
                            errorInConsistencyCheck = true;
                            this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check fails.\nResult for executeDBMcmd(" + qry + ")\n" + dbmresult);
                        }
                    }
                    catch (TestDatabaseException tdbe) {
                        errorInConsistencyCheck = true;
                        this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check fails.\nExecption for executeDBMcmd(" + qry + ")\n" + tdbe.getLocalizedMessage());
                    }
                    if (errorInConsistencyCheck) {
                        this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "There are errors in the database consistency check.");
                    } else {
                        this.addMessage(TestCasesInterpreter.getTestClassId(), 'I', "There are no errors in the database consistency check.");
                    }
                }
                if (!this.mAnErrorOccured) {
                    this.restoreOldDatabaseParameters();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var28_35 = null;
            try {
                this.myConnection.commit();
                this.myConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var28_36 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.myConnection.commit();
        this.myConnection.close();
    }
}

