/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class QueryRewrite_Test
extends TestCase {
    static final String lastUpdate = "2006/01/20 12:30";
    String ProtocolStrg = null;
    String CurrentQuery = null;
    private long executedStatements = 0L;
    private long executedAllStatements = 0L;
    BufferedReader InputReader = null;
    int TableCount = 10;

    public static String getTestClassId() {
        return "QueryRewrite Test";
    }

    public static long getTimeout() {
        return 18000000L;
    }

    public void AddProtocolLine(String Line) throws TestCaseException {
        this.ProtocolStrg = String.valueOf(this.ProtocolStrg) + Line + "\n";
    }

    public String ReadNextStatement() throws TestCaseException {
        String Line = null;
        String QueryStr = "";
        boolean complete = false;
        try {
            while ((Line = this.InputReader.readLine()) != null && !complete) {
                if (Line.indexOf("#") >= 0) {
                    Line = Line.substring(0, Line.indexOf("#"));
                }
                if (Line.indexOf("!") >= 0) {
                    Line = Line.substring(0, Line.indexOf("!"));
                    complete = true;
                }
                if ((Line = Line.trim()).length() <= 0) continue;
                QueryStr = String.valueOf(QueryStr) + " " + Line;
            }
            if (!complete) {
                QueryStr = null;
            }
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
        return QueryStr;
    }

    public void compareResults(String QueryString, String H1, String H2, int ResultCode1, String ResultErrorMessage1, int ResultCode2, String ResultErrorMessage2, ResultSet Result1, ResultSet Result2) throws TestCaseException {
        VerificationDataComplete Veri = null;
        boolean err = false;
        try {
            this.AddProtocolLine("+-------------------------------------------------------------------------------------");
            this.AddProtocolLine("Testing: " + QueryString + "\n");
            if (ResultCode1 == 0 && ResultCode2 == 0) {
                Veri = new VerificationDataComplete(Result1);
                if (!Veri.equals(Result2)) {
                    err = true;
                    this.AddProtocolLine("  Wrong result: " + Veri.getErrorMessage());
                }
            } else {
                err = true;
                this.AddProtocolLine("  ResultCode without QueryRewrite : " + ResultCode1);
                if (ResultErrorMessage1 != null) {
                    this.AddProtocolLine("  ResultCode without QueryRewrite : " + ResultErrorMessage1);
                }
                this.AddProtocolLine("  ResultCode with QueryRewrite    : " + ResultCode2);
                if (ResultErrorMessage2 != null) {
                    this.AddProtocolLine("  ResultCode without QueryRewrite : " + ResultErrorMessage2);
                }
            }
            if (H1 != null) {
                this.AddProtocolLine("  Info: " + H1);
            }
            if (H2 != null) {
                this.AddProtocolLine("  Info: " + H2);
            }
            if (err) {
                this.addMessage("", 'E', this.ProtocolStrg);
            }
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    public void prepareTest() throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        int i = 0;
        int col = 0;
        int rcount = 0;
        int k = 0;
        int a = 0;
        String StmtStr = null;
        String InputFile = null;
        try {
            Properties conProps = new Properties();
            conProps.put("user", TestCase.getUser());
            conProps.put("password", TestCase.getPassword());
            conProps.put("sqlmode", "internal");
            mConnection = TestCase.getDatabase().connect(conProps);
            mConnection.setAutoCommit(true);
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdateIgnoreErrors("DROP SCHEMA QRW");
            mStmt.executeUpdateIgnoreErrors("CREATE SCHEMA QRW");
            mStmt.executeUpdate("SET CURRENT_SCHEMA=QRW");
            i = 1;
            while (i <= this.TableCount) {
                StmtStr = "CREATE TABLE T" + i + " (K INTEGER PRIMARY KEY";
                col = 1;
                while (col <= i) {
                    StmtStr = String.valueOf(StmtStr) + ", A" + col + " INTEGER";
                    ++col;
                }
                StmtStr = String.valueOf(StmtStr) + ")";
                mStmt.executeUpdate(StmtStr);
                ++i;
            }
            InputFile = String.valueOf(this.getDataInputPath()) + File.separator + "QueryRewriteViews.sql";
            this.InputReader = new BufferedReader(new FileReader(InputFile));
            while ((StmtStr = this.ReadNextStatement()) != null) {
                mStmt.executeUpdate(StmtStr);
            }
            i = 1;
            while (i <= this.TableCount) {
                rcount = RandomGenerator.randomInteger((int)50, (int)250);
                while (rcount > 0) {
                    k = RandomGenerator.randomInteger((int)0, (int)2000);
                    StmtStr = "INSERT INTO T" + i + " VALUES(" + k;
                    col = 1;
                    while (col <= i) {
                        a = RandomGenerator.randomInteger((int)-1, (int)100);
                        StmtStr = a == -1 ? String.valueOf(StmtStr) + ", NULL" : String.valueOf(StmtStr) + "," + a;
                        ++col;
                    }
                    StmtStr = String.valueOf(StmtStr) + ") IGNORE DUPLICATES";
                    try {
                        mStmt.executeUpdate(StmtStr);
                        --rcount;
                    }
                    catch (Exception e) {
                        if (((SQLException)e).getErrorCode() == -1) continue;
                        throw new TestCaseException(e.getMessage());
                    }
                }
                ++i;
            }
            mConnection.close();
            mConnection = null;
        }
        catch (Exception e) {
            System.out.println("Exception with: " + StmtStr);
            e.printStackTrace();
            throw new TestCaseException(e.getMessage());
        }
    }

    public static void cleanUp() throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdateIgnoreErrors("DROP SCHEMA QRW");
            mConnection.commit();
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
        System.out.println("End of " + QueryRewrite_Test.getTestClassId());
    }

    public String GetNot(int not) {
        if (not == 1) {
            return "NOT ";
        }
        return "";
    }

    public String GetOperator(int op, int col) {
        String ColName;
        switch (col) {
            case 1: {
                ColName = "A1";
                break;
            }
            case 2: {
                ColName = "A2";
                break;
            }
            default: {
                ColName = "K";
            }
        }
        switch (op) {
            case 1: {
                return String.valueOf(ColName) + " = 45";
            }
            case 2: {
                return String.valueOf(ColName) + " < 45";
            }
            case 3: {
                return String.valueOf(ColName) + " > 45";
            }
            case 4: {
                return String.valueOf(ColName) + " <> 45";
            }
            case 5: {
                return String.valueOf(ColName) + " IS NULL";
            }
            case 6: {
                return String.valueOf(ColName) + " BETWEEN 10 AND 30";
            }
            case 7: {
                return String.valueOf(ColName) + " IN (10,20,30,40,50)";
            }
        }
        return String.valueOf(ColName) + " IS NOT NULL";
    }

    public String GetQualification(int booleanterm, int op, int not) {
        switch (booleanterm) {
            case 1: {
                return "WHERE " + this.GetNot(not) + this.GetOperator(op, 1);
            }
            case 2: {
                return "WHERE " + this.GetNot(not) + "( " + this.GetOperator(op, 1) + " AND " + this.GetOperator(op, 2) + " )";
            }
            case 3: {
                return "WHERE " + this.GetNot(not) + "( " + this.GetOperator(op, 1) + " OR " + this.GetOperator(op, 2) + " )";
            }
            case 4: {
                return "WHERE " + this.GetNot(not) + this.GetOperator(op, 0);
            }
            case 5: {
                return "WHERE " + this.GetNot(not) + "( " + this.GetOperator(op, 1) + " AND " + this.GetOperator(op, 0) + " )";
            }
            case 6: {
                return "WHERE " + this.GetNot(not) + "( " + this.GetOperator(op, 1) + " OR " + this.GetOperator(op, 0) + " )";
            }
        }
        return "";
    }

    public void testQualifications(TestStatement Stmt1, TestStatement Stmt2) throws TestCaseException {
        String QueryStr = null;
        try {
            int q1 = 0;
            while (q1 < 7) {
                int op1 = 0;
                while (op1 < 8) {
                    int n1 = 0;
                    while (n1 < 2) {
                        int q2 = 0;
                        while (q2 < 7) {
                            int op2 = 0;
                            while (op2 < 8) {
                                int n2 = 0;
                                while (n2 < 2) {
                                    QueryStr = "SELECT @ k, a1, a2 FROM ( SELECT a2, a1, k FROM T2 " + this.GetQualification(q1, op1, n1) + " ) " + this.GetQualification(q2, op2, n2);
                                    this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                                    QueryStr = "SELECT @ k, a2, a1 FROM ( SELECT a1, a2, k FROM T2 " + this.GetQualification(q1, op1, n1) + " UNION " + "SELECT a2, a3,k  FROM T3 " + this.GetQualification(q2, op2, n2) + " ) " + this.GetQualification(q2, op2, n2);
                                    this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                                    ++n2;
                                }
                                ++op2;
                            }
                            ++q2;
                        }
                        ++n1;
                    }
                    ++op1;
                }
                ++q1;
            }
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    public String GetAggregateName(int i, String colname) {
        switch (i) {
            case 0: {
                return "COUNT(*) ";
            }
            case 1: {
                return "COUNT(" + colname + ") ";
            }
            case 2: {
                return "COUNT(DISTINCT " + colname + ") ";
            }
            case 3: {
                return "SUM(" + colname + ") ";
            }
            case 4: {
                return "SUM(DISTINCT " + colname + ") ";
            }
            case 5: {
                return "AVG(" + colname + ") ";
            }
            case 6: {
                return "AVG(DISTINCT " + colname + ") ";
            }
            case 7: {
                return "MAX(" + colname + ") ";
            }
        }
        return "SUM(ALL " + colname + ") ";
    }

    public void testAggregates(TestStatement Stmt1, TestStatement Stmt2) throws TestCaseException {
        String QueryStr = null;
        try {
            int x1 = 0;
            while (x1 < 8) {
                int x2 = 0;
                while (x2 < 8) {
                    int d1 = 0;
                    while (d1 <= 1) {
                        int d2 = 0;
                        while (d2 <= 1) {
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + this.GetAggregateName(x2, "a3") + "a3 FROM T8 )";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1)";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1)" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a2") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1, a2)" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1, a2)" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, a3 FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1, a2)" + " GROUP BY a1, a3";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, a3 FROM T8 )" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, a3 FROM T8 GROUP BY a1, a2, a3 )" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, a2, a3 FROM T8 GROUP BY a1, a2, a3 )" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "a1, " + this.GetAggregateName(x1, "a3") + "FROM " + "( SELECT " + this.GetDistinct(d2) + "a1, " + this.GetAggregateName(x2, "a2") + "a2, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1)" + " GROUP BY a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "X.a1, T7.a1, " + this.GetAggregateName(x1, "X.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + "a1, " + this.GetAggregateName(x2, "a2") + "a2, " + this.GetAggregateName(x2, "a3") + "a3 FROM T8 GROUP BY a1) X" + " GROUP BY X.a1, T7.a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + "X.a1, T7.a1, " + this.GetAggregateName(x1, "T7.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + "a1, " + this.GetAggregateName(x2, "a2") + "a2, " + this.GetAggregateName(x1, "a3") + "a3 FROM T8 GROUP BY a1) X" + " GROUP BY X.a1, T7.a1";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "X.a2") + ", " + this.GetAggregateName(x1, "T7.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + this.GetAggregateName(x2, "a2") + "a2 FROM T8) X";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "X.a2") + ", " + this.GetAggregateName(x1, "T7.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + "a2 FROM T8) X";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "T7.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + "a2 FROM T8) X";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            QueryStr = "SELECT @ " + this.GetDistinct(d1) + this.GetAggregateName(x1, "X.a2") + ", " + this.GetAggregateName(x1, "T7.a3") + "FROM T7, " + "( SELECT " + this.GetDistinct(d2) + this.GetAggregateName(x2, "a2") + "a2 FROM T8 GROUP BY a1) X";
                            this.testQuery(Stmt1, Stmt2, QueryStr, null, null);
                            ++d2;
                        }
                        ++d1;
                    }
                    ++x2;
                }
                ++x1;
            }
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    public String GetSetName(int i) {
        switch (i) {
            case 1: {
                return "UNION";
            }
            case 2: {
                return "UNION ALL";
            }
            case 3: {
                return "EXCEPT";
            }
            case 4: {
                return "EXCEPT ALL";
            }
            case 5: {
                return "INTERSECT";
            }
            case 6: {
                return "INTERSECT ALL";
            }
        }
        return "UNION";
    }

    public String GetDistinct(int i) {
        if (i == 0) {
            return " ";
        }
        return "DISTINCT ";
    }

    public String GetViewDef(int v, int d1, int d2, int t) {
        return "CREATE VIEW X" + v + " AS SELECT " + this.GetDistinct(d1) + "A1,A2 FROM QRW.T2" + " " + this.GetSetName(v) + " SELECT " + this.GetDistinct(d2) + "A2,A1 FROM QRW.T" + t;
    }

    public void testSets(TestStatement Stmt1, TestStatement Stmt2) throws TestCaseException {
        String QueryStr = null;
        try {
            Stmt1.executeUpdateIgnoreErrors("DROP SCHEMA QRWSET");
            Stmt1.executeUpdateIgnoreErrors("CREATE SCHEMA QRWSET");
            Stmt1.executeUpdate("SET CURRENT_SCHEMA=QRWSET");
            Stmt2.executeUpdate("SET CURRENT_SCHEMA=QRWSET");
            int t = 2;
            while (t < 4) {
                int d1 = 0;
                while (d1 <= 1) {
                    int d2 = 0;
                    while (d2 <= 1) {
                        int v = 1;
                        while (v <= 6) {
                            QueryStr = "DROP VIEW X" + v;
                            Stmt1.executeUpdateIgnoreErrors(QueryStr);
                            QueryStr = this.GetViewDef(v, d1, d2, t);
                            Stmt1.executeUpdate(QueryStr);
                            ++v;
                        }
                        int v1 = 1;
                        while (v1 <= 6) {
                            int v2 = 1;
                            while (v2 <= 6) {
                                int s = 1;
                                while (s <= 6) {
                                    int d3 = 0;
                                    while (d3 <= 1) {
                                        int d4 = 0;
                                        while (d4 <= 1) {
                                            QueryStr = "SELECT @ " + this.GetDistinct(d3) + "A1 FROM X" + v1 + " " + this.GetSetName(s) + " SELECT " + this.GetDistinct(d4) + "A1 FROM X" + v2;
                                            this.testQuery(Stmt1, Stmt2, QueryStr, this.GetViewDef(v1, d1, d2, t), this.GetViewDef(v2, d1, d2, t));
                                            QueryStr = "SELECT @ " + this.GetDistinct(d3) + "A1,A2 FROM X" + v1 + " " + this.GetSetName(s) + " SELECT " + this.GetDistinct(d4) + "A1,A2 FROM X" + v2;
                                            this.testQuery(Stmt1, Stmt2, QueryStr, this.GetViewDef(v1, d1, d2, t), this.GetViewDef(v2, d1, d2, t));
                                            ++d4;
                                        }
                                        ++d3;
                                    }
                                    ++s;
                                }
                                ++v2;
                            }
                            ++v1;
                        }
                        ++d2;
                    }
                    ++d1;
                }
                ++t;
            }
            Stmt1.executeUpdate("SET CURRENT_SCHEMA=QRW");
            Stmt2.executeUpdate("SET CURRENT_SCHEMA=QRW");
            Stmt1.executeUpdateIgnoreErrors("DROP SCHEMA QRWSET");
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    public void testQuery(TestStatement Stmt1, TestStatement Stmt2, String QueryString, String H1, String H2) throws TestCaseException {
        ResultSet ResultSet1 = null;
        ResultSet ResultSet2 = null;
        int OrgSQLReturnCode = 0;
        int SQLReturnCode = 0;
        String OrgSQLReturnMessage = null;
        String SQLReturnMessage = null;
        this.ProtocolStrg = "";
        try {
            block7: {
                block6: {
                    OrgSQLReturnCode = 0;
                    this.CurrentQuery = QueryString.replaceFirst("@", "/*+queryrewrite_no*/");
                    try {
                        ResultSet1 = Stmt1.executeQuery(this.CurrentQuery);
                        ++this.executedStatements;
                    }
                    catch (Exception e) {
                        OrgSQLReturnCode = ((SQLException)e).getErrorCode();
                        OrgSQLReturnMessage = e.getLocalizedMessage();
                        if (!Stmt1.getConnection().isClosed()) break block6;
                        throw new TestCaseException("Connection to database lost; " + e.getMessage());
                    }
                }
                SQLReturnCode = 0;
                this.CurrentQuery = QueryString.replaceFirst("@", "/*+queryrewrite_op*/");
                try {
                    ResultSet2 = Stmt2.executeQuery(this.CurrentQuery);
                    ++this.executedStatements;
                }
                catch (Exception e) {
                    SQLReturnCode = ((SQLException)e).getErrorCode();
                    SQLReturnMessage = e.getLocalizedMessage();
                    if (!Stmt2.getConnection().isClosed()) break block7;
                    throw new TestCaseException("Connection to database lost ; " + e.getMessage());
                }
            }
            this.compareResults(QueryString, H1, H2, OrgSQLReturnCode, OrgSQLReturnMessage, SQLReturnCode, SQLReturnMessage, ResultSet1, ResultSet2);
            this.CurrentQuery = null;
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection Connection2 = null;
        TestStatement Stmt1 = null;
        TestStatement Stmt2 = null;
        String QueryString = null;
        String InputFile = null;
        long TimeStartValue = 0L;
        long TimeEndValue = 0L;
        SimpleDateFormat myStartDate = new SimpleDateFormat("HH:mm:ss.S");
        try {
            try {
                System.out.println(String.valueOf(QueryRewrite_Test.getTestClassId()) + " - last update: " + lastUpdate);
                this.addMessage("", 'I', "Test version: 2006/01/20 12:30");
                this.prepareTest();
                InputFile = String.valueOf(this.getDataInputPath()) + File.separator + "QueryRewriteQueries.sql";
                this.InputReader = new BufferedReader(new FileReader(InputFile));
                Properties conProps = new Properties();
                conProps.put("user", TestCase.getUser());
                conProps.put("password", TestCase.getPassword());
                conProps.put("sqlmode", "internal");
                Connection2 = TestCase.getDatabase().connect(conProps);
                Connection2.setAutoCommit(true);
                Stmt1 = new TestStatement((TestCase)this, Connection2, 1005, 1007);
                Stmt2 = new TestStatement((TestCase)this, Connection2, 1005, 1007);
                Stmt1.enableExplain(false);
                Stmt2.enableExplain(false);
                TimeStartValue = System.currentTimeMillis();
                System.out.println("(1) test sets                   start at : " + myStartDate.format(new Date(TimeStartValue)));
                this.testSets(Stmt1, Stmt2);
                TimeEndValue = System.currentTimeMillis();
                this.executedAllStatements += this.executedStatements;
                System.out.println("(1) test sets                 finshed at : " + myStartDate.format(new Date(TimeEndValue)) + " ( Runtime: " + (TimeEndValue - TimeStartValue) / 60000L + " min ) after " + this.executedStatements + " executed statememts.");
                this.addMessage("", 'I', "testSets finished after " + (TimeEndValue - TimeStartValue) / 60000L + " min. " + this.executedStatements + " executed statememts.");
                this.executedStatements = 0L;
                Stmt1.executeUpdate("SET CURRENT_SCHEMA=QRW");
                Stmt2.executeUpdate("SET CURRENT_SCHEMA=QRW");
                TimeStartValue = System.currentTimeMillis();
                System.out.println("(2) test aggregations           start at : " + myStartDate.format(new Date(TimeStartValue)));
                this.testAggregates(Stmt1, Stmt2);
                TimeEndValue = System.currentTimeMillis();
                this.executedAllStatements += this.executedStatements;
                System.out.println("(2) test aggregations         finshed at : " + myStartDate.format(new Date(TimeEndValue)) + " ( Runtime: " + (TimeEndValue - TimeStartValue) / 60000L + " min ) after " + this.executedStatements + " executed statememts.");
                this.addMessage("", 'I', "testAggregates finished after " + (TimeEndValue - TimeStartValue) / 60000L + " min. " + this.executedStatements + " executed statememts.");
                this.executedStatements = 0L;
                TimeStartValue = System.currentTimeMillis();
                System.out.println("(3) test qualifications         start at : " + myStartDate.format(new Date(TimeStartValue)));
                this.testQualifications(Stmt1, Stmt2);
                TimeEndValue = System.currentTimeMillis();
                this.executedAllStatements += this.executedStatements;
                System.out.println("(3) test qualifications       finshed at : " + myStartDate.format(new Date(TimeEndValue)) + " ( Runtime: " + (TimeEndValue - TimeStartValue) / 60000L + " min ) after " + this.executedStatements + " executed statememts.");
                this.addMessage("", 'I', "testQualifications finished after " + (TimeEndValue - TimeStartValue) / 60000L + " min. " + this.executedStatements + " executed statememts.");
                this.executedStatements = 0L;
                TimeStartValue = System.currentTimeMillis();
                System.out.println("(4) test QueryRewriteQueries    start at : " + myStartDate.format(new Date(TimeStartValue)));
                while (true) {
                    if ((QueryString = this.ReadNextStatement()) == null) {
                        TimeEndValue = System.currentTimeMillis();
                        this.executedAllStatements += this.executedStatements;
                        System.out.println("(4) test QueryRewriteQueries  finshed at : " + myStartDate.format(new Date(TimeEndValue)) + " ( Runtime: " + (TimeEndValue - TimeStartValue) / 60000L + " min ) after " + this.executedStatements + " executed statememts.");
                        this.addMessage("", 'I', "testQuery with 'QueryRewriteQueries.sql' finished after " + (TimeEndValue - TimeStartValue) / 60000L + " min. " + this.executedStatements + " executed statememts.");
                        this.executedStatements = 0L;
                        System.out.println("Executed " + this.executedAllStatements + " statements.");
                        this.addMessage("", 'I', "Executed " + this.executedAllStatements + " statements.");
                    }
                    this.testQuery(Stmt1, Stmt2, QueryString, null, null);
                }
            }
            catch (Exception e) {
                this.executedAllStatements += this.executedStatements;
                System.out.println("Excpetion in run() method \n" + e.getMessage());
                System.out.println("Executed " + this.executedAllStatements + " statements.");
                this.addMessage("", 'T', "Executed " + this.executedAllStatements + " statements.");
                this.addMessage(QueryRewrite_Test.getTestClassId(), 'E', "Excpetion in run() method \n" + e.getMessage());
                e.printStackTrace();
                if (this.CurrentQuery != null) {
                    this.addMessage("", 'T', "CurrentQuery: " + this.CurrentQuery);
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                Stmt1.close();
                Stmt2.close();
                Connection2.close();
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("Error in finally while closing statments and connection: " + e.getMessage());
                e.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var12_13 = null;
        }
        try {}
        catch (Exception e) {
            System.out.println("Error in finally while closing statments and connection: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        Stmt1.close();
        Stmt2.close();
        Connection2.close();
    }
}

