/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DynamicTablesMultiUser
extends TestCase {
    private static int USERCOUNT = 3;
    private static final String TESTUSERNAME = "TESTUSER";
    private static String SCHEMANAME = "TESTSCHEMA";
    private String testrunname;
    private static int TABLECOUNT = 100;
    private static int MAXCOLUMNCOUNT = 15;
    private static int MAXDATACOUNT = 500;
    private boolean USEPREPAREDSTATEMENTS;
    private static Properties DBAConnectionInternalProperties = new Properties();
    private static Properties DBAConnectionOracleProperties = new Properties();
    private static boolean UNICODE;
    private static String DATABASEVERSION;
    private static Vector TestUserList;
    private Vector tableList = new Vector();
    private QueryTests tests;
    private String stopOnError = "0";

    static {
        DATABASEVERSION = null;
        TestUserList = new Vector();
    }

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + DynamicTablesMultiUser.getTestClassId());
        DBAConnectionInternalProperties.put("user", TestCase.getUser());
        DBAConnectionInternalProperties.put("password", TestCase.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", TestCase.getUser());
        DBAConnectionOracleProperties.put("password", TestCase.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block29: {
            DatabaseConnection = null;
            runStatement = null;
            testThreadGroup = null;
            fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = String.valueOf(this.getTestId()) + "_Log_" + fmt.format(new Date());
            try {
                try {
                    System.out.println("Run of " + DynamicTablesMultiUser.getTestClassId());
                    DynamicTablesMultiUser.DATABASEVERSION = String.valueOf(((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion()) + "." + ((TestDatabaseSap)TestCase.getDatabase()).getKernelBuild().substring(0, 3);
                    DynamicTablesMultiUser.UNICODE = TestCase.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes") != false;
                    WARNINGONLY = TestCase.getParameterString((String)"WARNINGONLY", (String)"");
                    st = new StringTokenizer(WARNINGONLY, ";,");
                    WARNINGONLYLIST = new Properties();
                    while (true) {
                        if (!st.hasMoreTokens()) {
                            DynamicTablesMultiUser.TABLECOUNT = Integer.parseInt(TestCase.getParameterString((String)"TABLECOUNT", (String)Integer.toString(DynamicTablesMultiUser.TABLECOUNT)));
                            DynamicTablesMultiUser.USERCOUNT = Integer.parseInt(TestCase.getParameterString((String)"UserCount", (String)Integer.toString(DynamicTablesMultiUser.USERCOUNT)));
                            this.USEPREPAREDSTATEMENTS = Boolean.valueOf(TestCase.getParameterString((String)"USEPREPARESTATEMENTS", (String)"true"));
                            this.stopOnError = TestCase.getParameterString((String)"StopOnError", (String)"0");
                            if (!this.stopOnError.equals("0")) {
                                TestCase.getDatabase().executeDBMcmd("util_connect");
                                TestCase.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                                TestCase.getDatabase().executeDBMcmd("util_release");
                            }
                            System.out.println("Testrun: \t" + this.testrunname);
                            System.out.println("Usercount: \t" + DynamicTablesMultiUser.USERCOUNT + "(Parameter: USERCOUNT)");
                            System.out.println("Unicode: \t" + DynamicTablesMultiUser.UNICODE);
                            System.out.println("Tablecount: \t" + DynamicTablesMultiUser.TABLECOUNT + "(Parameter: TABLECOUNT)");
                            System.out.println("MaxColumns: \t" + DynamicTablesMultiUser.MAXCOLUMNCOUNT);
                            System.out.println("MaxDatasets: \t" + DynamicTablesMultiUser.MAXDATACOUNT);
                            System.out.println("Stop on Error: \t" + TestCase.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
                            System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
                            System.out.println("Use Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + DynamicTablesMultiUser.USERCOUNT + "(Parameter: USERCOUNT)" + "\nUnicode: \t" + DynamicTablesMultiUser.UNICODE + "\nTablecount: \t" + DynamicTablesMultiUser.TABLECOUNT + "(Parameter: TABLECOUNT)" + "\nMaxColumns: \t" + DynamicTablesMultiUser.MAXCOLUMNCOUNT + "\nMaxDatasets: \t" + DynamicTablesMultiUser.MAXDATACOUNT + "\nStop on Error: \t" + TestCase.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)" + "\nUse Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                            DatabaseConnection = TestCase.getDatabase().connect(DynamicTablesMultiUser.DBAConnectionInternalProperties);
                            runStatement = new TestStatement(null, DatabaseConnection);
                            System.out.println("Data generation started");
                            this.tableList = TestDriver.compareRelease((String)DynamicTablesMultiUser.DATABASEVERSION, (String)"<", (String)"7.6") != false ? this.createTables("DBA", "TAB", "COL", DynamicTablesMultiUser.TABLECOUNT, DynamicTablesMultiUser.MAXCOLUMNCOUNT, DynamicTablesMultiUser.MAXDATACOUNT, DynamicTablesMultiUser.UNICODE) : this.createTables(DynamicTablesMultiUser.SCHEMANAME, "TAB", "COL", DynamicTablesMultiUser.TABLECOUNT, DynamicTablesMultiUser.MAXCOLUMNCOUNT, DynamicTablesMultiUser.MAXDATACOUNT, DynamicTablesMultiUser.UNICODE);
                        }
                        WARNINGONLYLIST.setProperty(st.nextToken(), "");
                    }
                    System.out.println("Data generation completed");
                    runStatement.execute("update stat *");
                    i = 1;
                    while (true) {
                        block30: {
                            if (i <= DynamicTablesMultiUser.USERCOUNT) break block30;
                            dropUser = "Drop user ";
                            itu = DynamicTablesMultiUser.TestUserList.iterator();
                            if (true) ** GOTO lbl66
                        }
                        DynamicTablesMultiUser.TestUserList.add("TESTUSER" + i);
                        ++i;
                    }
                }
                catch (Exception e) {
                    testThreadGroup.stop();
                    this.handleExceptions(e);
                }
                do {
                    runStatement.executeUpdateIgnoreErrors(String.valueOf(dropUser) + itu.next());
lbl66:
                    // 2 sources

                } while (itu.hasNext());
                it = DynamicTablesMultiUser.TestUserList.iterator();
                while (it.hasNext()) {
                    username = (String)it.next();
                    runStatement.execute("create user " + username + " Password " + username + " DBA not exclusive");
                }
                runStatement.close();
                DatabaseConnection.close();
                this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)TestCase.getDatabase(), this.tableList, DynamicTablesMultiUser.DBAConnectionInternalProperties, DynamicTablesMultiUser.USERCOUNT, true, WARNINGONLYLIST);
                this.tests.createViews(0, null);
                testThreadGroup = new ThreadGroup("testThreadGroup");
                it1 = DynamicTablesMultiUser.TestUserList.iterator();
                testThreadArray = new Thread[DynamicTablesMultiUser.USERCOUNT];
                i = 0;
                while (it1.hasNext()) {
                    testuser = (String)it1.next();
                    testThreadArray[i] = new DynamicTablesMultiUSerThread(testThreadGroup, i, testuser, testuser, this);
                    ++i;
                }
                j = 0;
                while (j < testThreadArray.length) {
                    testThreadArray[j].start();
                    ++j;
                }
                var16_19 = testThreadGroup;
                synchronized (var16_19) {
                    while (true) {
                        if (testThreadGroup.activeCount() <= 0) {
                            break;
                        }
                        testThreadGroup.wait(10L);
                    }
                }
                var17_22 = null;
                break block29;
            }
            catch (Throwable var18_20) {
                var17_21 = null;
                try {
                    DatabaseConnection = TestCase.getDatabase().connect(DynamicTablesMultiUser.DBAConnectionInternalProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    dropUser = "Drop user ";
                    it1 = DynamicTablesMultiUser.TestUserList.iterator();
                    while (true) {
                        if (!it1.hasNext()) {
                            DatabaseConnection.commit();
                            DatabaseConnection.close();
                            throw var18_20;
                        }
                        try {
                            runStatement.executeUpdate(String.valueOf(dropUser) + it1.next());
                        }
                        catch (Exception e) {
                            this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                        }
                    }
                }
                catch (Exception var19_24) {
                    // empty catch block
                }
            }
            throw var18_20;
        }
        ** try [egrp 3[TRYBLOCK] [6 : 1268->1413)] { 
lbl129:
        // 1 sources

        DatabaseConnection = TestCase.getDatabase().connect(DynamicTablesMultiUser.DBAConnectionInternalProperties);
        runStatement = new TestStatement(null, DatabaseConnection);
        dropUser = "Drop user ";
        it1 = DynamicTablesMultiUser.TestUserList.iterator();
        while (true) {
            if (!it1.hasNext()) {
                DatabaseConnection.commit();
                DatabaseConnection.close();
                return;
            }
            try {}
            catch (Exception e) {
                this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                continue;
            }
            runStatement.executeUpdate(String.valueOf(dropUser) + it1.next());
            continue;
            break;
        }
lbl145:
        // 1 sources

        catch (Exception var19_26) {
            return;
        }
    }

    private Vector createTables(String schemaName, String tablePrefix, String columnPrefix, int tablecount, int maxColumnCount, int maxDataCount, boolean unicode) throws Exception {
        Vector<DatabaseObject> tableListIntern = new Vector<DatabaseObject>();
        Connection DBConnection = TestCase.getDatabase().connect(DBAConnectionInternalProperties);
        TestStatement statement = new TestStatement(null, DBConnection);
        if (TestDriver.compareRelease((String)DATABASEVERSION, (String)">=", (String)"7.6")) {
            statement.executeUpdateIgnoreErrors("drop schema " + schemaName);
            statement.executeUpdate("create schema " + schemaName);
        }
        int i = 0;
        while (i < tablecount) {
            tableListIntern.add(DatabaseObject.getRandomTable(schemaName, String.valueOf(tablePrefix) + i, columnPrefix, maxColumnCount, unicode));
            ++i;
        }
        Iterator it = tableListIntern.iterator();
        while (it.hasNext()) {
            try {
                DatabaseObject dbo = (DatabaseObject)it.next();
                statement.executeUpdateIgnoreErrors(dbo.getSqlDropString());
                statement.execute(dbo.getSqlCreateString());
                statement.execute("grant all on " + dbo.getObjectIdentifier() + " to public");
            }
            catch (SQLException e) {
                System.out.println(statement.getSqlString());
                e.printStackTrace();
            }
        }
        Iterator it2 = tableListIntern.iterator();
        SimpleDateFormat TEST_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS");
        while (it2.hasNext()) {
            DatabaseObject dbo = (DatabaseObject)it2.next();
            long time = System.currentTimeMillis();
            if (this.USEPREPAREDSTATEMENTS) {
                try {
                    dbo.insertRandomData(DBConnection, maxDataCount);
                    System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation/Insertion: " + TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)));
                }
                catch (Exception e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
                continue;
            }
            Vector insertSqlStringList = dbo.getSqlInsertRandomDataString(maxDataCount);
            String generationTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            Iterator itInsertSqlStringList = insertSqlStringList.iterator();
            time = System.currentTimeMillis();
            while (itInsertSqlStringList.hasNext()) {
                String insertSqlString = (String)itInsertSqlStringList.next();
                try {
                    statement.execute(insertSqlString);
                }
                catch (SQLException e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
            }
            String insertionTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation: " + generationTime + " Data Insertion: " + insertionTime);
        }
        statement.close();
        DBConnection.close();
        return tableListIntern;
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    public static String getTestClassId() {
        return "DynamicTablesMultiUser";
    }

    public class DynamicTablesMultiUSerThread
    extends Thread {
        private Properties ConnectionProperties = new Properties();
        private DynamicTablesMultiUser main = null;
        private int usernumber;

        public DynamicTablesMultiUSerThread(ThreadGroup group, int usernumber, String username, String password, DynamicTablesMultiUser main) {
            super(group, new String(username));
            this.main = main;
            this.ConnectionProperties.put("user", new String(username));
            this.ConnectionProperties.put("password", new String(password));
            this.ConnectionProperties.put("autocommit", "on");
            this.ConnectionProperties.put("sqlmode", "internal");
            this.usernumber = usernumber;
        }

        public void run() {
            try {
                this.main.tests.verifyMetaDataTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.countResultsetsTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.orderByTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.functionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.groupByQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.unionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.subselectViewQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.subselectQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.joinQueryTest(this.usernumber, this.ConnectionProperties);
            }
            catch (Exception e) {
                this.main.handleExceptions(e);
            }
        }
    }
}

