/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.simple.SQLMaster;
import com.sap.sapdb.oltptest.simple.StressTestActor;
import com.sap.sapdb.oltptest.simple.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.sql.SQLException;
import java.util.Date;

public class StressTest
extends SQLMaster {
    private static int mNumberOfTasks;
    private static int mMaximumRuntime;
    private static final String sVersion = "5.0";

    private Date attemptActorsStop(TestActor[] Actors) {
        int i = 0;
        while (i < Actors.length) {
            Actors[i].shouldStop();
            ++i;
        }
        return new Date();
    }

    TestActor[] createActors() throws Exception {
        int j = 0;
        TestActor[] Actors = new TestActor[mNumberOfTasks];
        int i = 0;
        while (i < mNumberOfTasks) {
            Actors[j] = new StressTestActor();
            Actors[j].setMaster(this);
            Actors[j].setTitle("StressTester" + i);
            ++i;
        }
        i = 0;
        while (i < Actors.length) {
            Actors[i].start();
            ++i;
        }
        return Actors;
    }

    private void forceActorsStop(TestActor[] Actors) {
        int i = 0;
        while (i < Actors.length) {
            Actors[i].interrupt();
            ++i;
        }
    }

    public static void prepare() throws TestCaseException {
        StressTest.readParameters();
        StressTest.printParameters();
    }

    private static void printParameters() throws TestCaseException {
        SQLMaster.printInfo("StressTest", "Starting StressTest 5.0");
        SQLMaster.printInfo("StressTest", "Number of parallel tasks= " + mNumberOfTasks);
        SQLMaster.printInfo("StressTest", "Maximum row count per table= " + TestCase.getParameterInt((String)"MaxRownumber", (int)1024));
        SQLMaster.printInfo("StressTest", "Initial row count per table= " + TestCase.getParameterInt((String)"InitialRownumber", (int)1024));
        SQLMaster.printInfo("StressTest", "Table row size= " + TestCase.getParameterInt((String)"RowLength", (int)1024) + " Bytes");
        SQLMaster.printInfo("StressTest", "Drop the tables when finished= " + TestCase.getParameterBoolean((String)"DropAfterExecution", (boolean)true));
        SQLMaster.printInfo("StressTest", "Percentage of INSERT commands= " + TestCase.getParameterInt((String)"InsertPercentage", (int)25) + " %");
        SQLMaster.printInfo("StressTest", "Percentage of UPDATE commands= " + TestCase.getParameterInt((String)"UpdatePercentage", (int)25) + " %");
        SQLMaster.printInfo("StressTest", "Percentage of DELETE commands= " + TestCase.getParameterInt((String)"DeletePercentage", (int)25) + " %");
        SQLMaster.printInfo("StressTest", "Percentage of SELECT commands= " + TestCase.getParameterInt((String)"SelectPercentage", (int)25) + " %");
        SQLMaster.printInfo("StressTest", "Commit percentage= " + TestCase.getParameterInt((String)"CommitPercentage", (int)67) + " %");
        SQLMaster.printInfo("StressTest", "Maximum statements per transaction= " + TestCase.getParameterInt((String)"MaxStatementsPerTransaction", (int)5));
        SQLMaster.printInfo("StressTest", "Maximum runtime= " + mMaximumRuntime + " min");
    }

    private static void readParameters() throws TestCaseException {
        SQLMaster.mTraceOn = TestCase.getParameterBoolean((String)"TraceOn", (boolean)true);
        mNumberOfTasks = TestCase.getParameterInt((String)"NumberOfTasks", (int)1);
        mMaximumRuntime = TestCase.getParameterInt((String)"MaximumRuntime", (int)5);
        SQLMaster.mRandomSeed = TestCase.getParameterInt((String)"RandomSeed", (int)-1);
        if (SQLMaster.mRandomSeed != -1) {
            RandomGenerator.setRandomSeed((int)SQLMaster.mRandomSeed);
        }
        if (mNumberOfTasks < 1) {
            throw new TestCaseException("NumberOfTasks has to be greater than 0");
        }
        if (mMaximumRuntime <= 0) {
            throw new TestCaseException("MaximumRuntime has to be greater than 0");
        }
    }

    public void run() {
        boolean Finished = false;
        boolean AttemptToStop = false;
        Date AttemptToStopTime = null;
        try {
            int i;
            TestActor[] Actors = this.createActors();
            Date StartTime = new Date();
            while (!Finished) {
                long TimeDiff;
                if (!AttemptToStop) {
                    if (mMaximumRuntime != -1 && (TimeDiff = (new Date().getTime() - StartTime.getTime()) / 60000L) > (long)mMaximumRuntime) {
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                } else {
                    TimeDiff = new Date().getTime() - AttemptToStopTime.getTime();
                    if (TimeDiff > 5000L) {
                        this.forceActorsStop(Actors);
                    }
                }
                int NumberOfRunningActors = 0;
                i = 0;
                while (i < Actors.length) {
                    if (Actors[i].isRunning()) {
                        ++NumberOfRunningActors;
                    } else if (Actors[i].hasError()) {
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                    ++i;
                }
                if (NumberOfRunningActors == 0) {
                    Finished = true;
                    continue;
                }
                Thread.sleep(100L);
            }
            i = 0;
            while (i < Actors.length) {
                if (Actors[i].hasError()) {
                    TestCase.addGlobalMessage((String)Actors[i].getTitle(), (char)'E', (String)Actors[i].getStatusMessage());
                } else {
                    TestCase.addGlobalMessage((String)Actors[i].getTitle(), (char)'I', (String)Actors[i].getStatusMessage());
                }
                ++i;
            }
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"StressTest", (char)'E', (String)e.getMessage());
        }
    }
}

