/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.migration;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Zipper;
import com.sap.sapdb.testframe.utilities.webdav.WebDAVClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RecoverFromPreviousBuild
extends TestCase {
    private DBM mDBMan = null;
    protected Connection myConnection = null;
    protected TestStatement myStatement = null;
    protected WebDAVClient client = null;
    private String pltf;
    private String createBackup;
    private String webDavDir;
    private String ownRelease = null;
    private int ownBuild = 0;
    private String addFilename = null;
    private String fileSep = null;
    private Properties conProps = null;
    private Properties conProps2 = null;
    private Properties conPropsDba = null;
    private String rundir = null;
    private String testUser = null;
    private String testPassword = null;
    protected static final String mVersion = "3.0";

    public static String getTestClassId() {
        return "RecoverFromPreviousBuild";
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [5 : 2276->2279)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createBackupIfRequired(int unicode) {
        block14: {
            String os = this.getOsDir();
            if (os == null) {
                this.addMessage("run()", 'W', "Cannot determine OS directory on WebDAV server.");
            } else {
                String fileName = unicode == 1 ? "migrtstu" : "migrtst";
                String zipFileName = String.valueOf(fileName) + ".zip";
                String ownReleaseShort = "";
                if (this.ownRelease != null) {
                    ownReleaseShort = this.ownRelease.substring(this.ownRelease.length() - 2, this.ownRelease.length() - 1).equals("0") ? this.ownRelease.substring(0, this.ownRelease.length() - 1) : this.ownRelease;
                }
                String ownBuildName = this.ownBuild < 10 ? "b_0" + this.ownBuild : "b_" + this.ownBuild;
                String url = "http://" + this.webDavDir + "/" + ownReleaseShort + "/" + ownBuildName + "/" + os + "/" + zipFileName;
                String resource = String.valueOf(ownReleaseShort) + "/" + ownBuildName + "/" + os + "/" + zipFileName;
                try {
                    if (this.client.exists(url)) break block14;
                    System.out.println("Backup of this build does not yet exist on server, creating it now...");
                    this.addMessage("run()", 'I', "Backup of this build does not yet exist on server, creating it now...");
                    File addFile = new File(String.valueOf(this.getDataInputPath()) + this.fileSep + this.addFilename);
                    if (addFile.exists()) {
                        BufferedReader reader = new BufferedReader(new FileReader(addFile));
                        Connection myDbaConnection = TestCase.getDatabase().connect(this.conPropsDba);
                        TestStatement myDbaStatement = new TestStatement((TestCase)this, myDbaConnection);
                        try {
                            myDbaStatement.executeUpdate("create user " + this.testUser + "2 password " + this.testPassword + "2 resource not exclusive");
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.myConnection = TestCase.getDatabase().connect(this.conProps2);
                        this.myStatement = new TestStatement((TestCase)this, this.myConnection);
                        String line = null;
                        System.out.println("  Executing additional statements from " + this.getDataInputPath() + this.fileSep + this.addFilename + " ...");
                        while ((line = reader.readLine()) != null) {
                            if (line.trim().length() == 0 || line.startsWith("//")) continue;
                            try {
                                System.out.println("  " + line);
                                this.myStatement.execute(line);
                            }
                            catch (SQLException sQLException) {}
                        }
                        reader.close();
                        this.myConnection.close();
                    }
                    System.out.println("  Saving backup...");
                    this.executeDBMCmd("db_offline");
                    this.executeDBMCmd("db_admin");
                    this.executeDBMCmd("util_connect");
                    this.executeDBMCmd("backup_media_put " + fileName + " " + this.getDataOutputPath() + this.fileSep + fileName + " file data 0 8 yes no");
                    this.executeDBMCmd("backup_save " + fileName + " data");
                    this.executeDBMCmd("util_release");
                    this.executeDBMCmd("db_online");
                    System.out.println("  Compressing backup...");
                    File zipFile = new File(String.valueOf(this.getDataOutputPath()) + this.fileSep + zipFileName);
                    Zipper myZipper = new Zipper(zipFile);
                    myZipper.setRootDirectory(new File(this.getDataOutputPath()));
                    myZipper.addFile(new File(String.valueOf(this.getDataOutputPath()) + this.fileSep + fileName));
                    try {
                        myZipper.zip();
                        System.out.println("  Uploading backup...");
                        WebDAVClient clientForUpload = new WebDAVClient(new URL("http://" + this.webDavDir + "/"));
                        boolean uploadSuccessful = clientForUpload.upload(zipFile, resource, 300);
                        if (uploadSuccessful) {
                            System.out.println("  Backup uploaded successfully to " + url);
                            this.addMessage("run()", 'I', "Backup uploaded successfully to " + url);
                            break block14;
                        }
                        this.addMessage("run()", 'W', "Failed to create a zipfile that contains a new backup.");
                        System.out.println("  WARNING: failed to create a zip file that contains a new backup.");
                    }
                    catch (Exception e) {
                        this.addMessage("run()", 'W', "Failed to create a zipfile that contains a new backup.\n" + e.getLocalizedMessage());
                        System.out.println("  WARNING: failed to create a zip file that contains a new backup.");
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
                    this.addMessage("createBackupIfRequired()", 'E', "Exception: " + e.getMessage() + "\n" + e.getClass());
                }
            }
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            this.addMessage("executeDBMCmd()", 'E', "Could not execute: " + pCmd + "\nException: " + e.getMessage());
            return "error";
        }
    }

    private String getResultField(ResultSet result, int index, int type) {
        String resultField = "";
        try {
            resultField = type == 4 ? "" + result.getInt(index) : (type == 5 ? "" + result.getShort(index) : (type == 3 ? "" + result.getBigDecimal(index) : (type == 6 ? "" + result.getDouble(index) : (type == 1 || type == 12 || type == -1 ? result.getString(index) : (type == 91 ? "" + result.getDate(index) : (type == 92 ? "" + result.getTime(index) : (type == 93 ? "" + result.getTimestamp(index) : "" + result.getObject(index))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultField;
    }

    private void extractFile(String zipFileName, String targetDir) throws Exception {
        String fileSep = System.getProperty("file.separator");
        ZipInputStream zis = new ZipInputStream(new FileInputStream(new File(zipFileName)));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File outFile = new File(String.valueOf(targetDir) + fileSep + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (outFile.exists()) {
                    if (!outFile.isDirectory()) {
                        throw new TestCaseException(String.valueOf(targetDir) + fileSep + zipEntry.getName() + " exists but is not a directory - cannot continue extraction.");
                    }
                } else if (!outFile.mkdir()) {
                    throw new TestCaseException("Cannot create directory " + targetDir + fileSep + zipEntry.getName());
                }
            } else {
                if (outFile.exists() && outFile.isFile() && !outFile.delete()) {
                    throw new TestCaseException("Cannot delete file " + targetDir + fileSep + zipEntry.getName());
                }
                if (outFile.isFile() && !outFile.createNewFile()) {
                    throw new TestCaseException("Cannot create file " + targetDir + fileSep + zipEntry.getName());
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = zis.read(buf, 0, 1024)) != -1) {
                    fos.write(buf, 0, i);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.close();
    }

    /*
     * WARNING - void declaration
     */
    private boolean downloadFromWebdav(String webdavUrl, String targetPath) throws Exception {
        void var4_5;
        File outFile;
        String resource = webdavUrl;
        if (resource != null && this.client.exists(resource)) {
            outFile = new File(targetPath);
            if (outFile.exists()) {
                if (outFile.isDirectory()) {
                    throw new TestCaseException(String.valueOf(targetPath) + " exists but is a directory - cannot continue download.");
                }
                if (!outFile.delete()) {
                    System.out.println("Cannot delete old backup file, trying again after 5 sec.");
                    System.gc();
                    this.addMessage("downloadFromWebdav()", 'I', "Cannot delete old backup file, trying again after 5 sec.");
                    Thread.sleep(5000L);
                    if (!outFile.delete()) {
                        throw new TestCaseException("Cannot delete file " + targetPath);
                    }
                }
            }
            if (!outFile.createNewFile()) {
                throw new TestCaseException("Cannot create file " + targetPath);
            }
        } else {
            return false;
        }
        boolean result = this.client.download(webdavUrl, outFile);
        outFile = null;
        System.gc();
        return (boolean)var4_5;
    }

    private String getOsDir() {
        String name = System.getProperty("os.name");
        String osName = null;
        Integer bits = (Integer)TestCase.mTestDriverOptions.get("DBBits");
        if (bits == null) {
            return null;
        }
        String sbits = "" + bits;
        if (name == null || name.equals("")) {
            return null;
        }
        if (name.indexOf("Windows") != -1) {
            osName = "win";
        }
        if (name.indexOf("Windows") != -1 && this.pltf.equals("Winx86_64")) {
            osName = "winx86_";
        }
        if (name.equals("SunOS")) {
            osName = "sun";
        }
        if (name.equals("SunOS") && this.pltf.equals("Sunx86_64")) {
            osName = "sunx86_";
        }
        if (name.equals("AIX")) {
            osName = "aix";
        }
        if (name.equals("HP-UX")) {
            osName = "hp";
        }
        if (name.equals("HP-UX") && this.pltf.equals("Hpia64")) {
            osName = "hpia";
        }
        if (name.equals("OSF1")) {
            osName = "dec";
        }
        if (name.equals("ReliantUNIX-N")) {
            osName = "sni";
        }
        if (name.equals("Linux")) {
            osName = "linux";
        }
        if (name.equals("Linux") && this.pltf.equals("Linuxx86_64")) {
            osName = "linuxx86_";
        }
        if (name.equals("Linux") && this.pltf.equals("pLinux")) {
            osName = "plinux";
        }
        if (name.equals("Linux") && this.pltf.equals("zLinux")) {
            osName = "zlinux";
        }
        if (osName == null) {
            return null;
        }
        return String.valueOf(osName) + sbits;
    }

    public static long getTimeout() {
        return 10800000L;
    }
}

