/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AndCondition;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.LeftOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.RightOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class RightOuterJoinTest
extends TestCase {
    final int c_maxColumns = 1;
    final int c_rowCount = 3;
    private AbstractList tableList;
    private DatabaseTable table2;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
        this.tableList.add(this.createTable(1, 10));
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    protected DatabaseTable createTable(int columnCount, int rowCount) {
        DatabaseTable table = new DatabaseTable();
        int i = 1;
        while (i <= columnCount) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
            ++i;
        }
        i = 1;
        while (i <= rowCount) {
            TableRow row = new TableRow(table);
            int j = 1;
            while (j <= columnCount) {
                row.setValue(j, new IntegerCell(i + j));
                ++j;
            }
            table.insert(row);
            ++i;
        }
        return table;
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testRightOuterJoin() {
        System.out.println("RightOuterJoinTables");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 2);
        RightOuterJoin bf = new RightOuterJoin(new DbResultTable(this.getTable(1)), new DbResultTable(this.getTable(0)), eq);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
    }

    public void testRightOuterJoin1() {
        System.out.println("RightOuterJoinTables-1");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 1);
        EqualCondition eq1 = new EqualCondition(this.getTable(0), 2, this.getTable(1), 2);
        AndCondition and1 = new AndCondition(eq, eq1);
        RightOuterJoin bf = new RightOuterJoin(new DbResultTable(this.getTable(1)), new DbResultTable(this.getTable(0)), and1);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
        Assert.assertEquals((int)7, (int)joinedTable.getRowCount());
    }

    public void testTwoLevelJoin() {
        System.out.println("RightOuterJoinTables: two level join");
        EqualCondition eq = new EqualCondition(new DbResultTable(this.getTable(0)), 1, new DbResultTable(this.getTable(1)), 2);
        LeftOuterJoin jo1 = new LeftOuterJoin(new DbResultTable(this.getTable(1)), new DbResultTable(this.getTable(0)), eq);
        eq = new EqualCondition(new DbResultTable(this.getTable(0)), 2, new DbResultTable(this.getTable(2)), 1);
        LeftOuterJoin jo2 = new LeftOuterJoin(new DbResultTable(this.getTable(2)), jo1, eq);
        DatabaseTable joinedTable = new DatabaseTable(jo2.getResultTableDefinition());
        while (jo2.hasNext()) {
            TableRow row = jo2.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
        Assert.assertEquals((int)10, (int)joinedTable.getRowCount());
    }
}

