/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.CellAccessorFunction;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.GroupByOperator;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.SumSetFunction;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.ArrayList;
import junit.framework.TestCase;

public class GroupByOperatorTest
extends TestCase {
    private DatabaseTable table;

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new DatabaseTable();
        this.table.addColumn(new IntegerColumn());
        this.table.addColumn(new IntegerColumn());
        this.table.addColumn(new IntegerColumn());
        TableRow row = new TableRow(this.table);
        row.setValue(1, new IntegerCell(2));
        row.setValue(2, new IntegerCell(5));
        row.setValue(3, new IntegerCell(7));
        this.table.insert(row);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new IntegerCell(5));
        row.setValue(3, new IntegerCell(6));
        this.table.insert(row);
        row.setValue(1, new IntegerCell(2));
        row.setValue(2, new IntegerCell(5));
        row.setValue(3, new IntegerCell(9));
        this.table.insert(row);
        row.setValue(1, new IntegerCell(1));
        row.setValue(2, new IntegerCell(5));
        row.setValue(3, new IntegerCell(9));
        this.table.insert(row);
    }

    public void testSimpleGroup1() {
        System.out.println("GroupByOperatorTest: simple group1.");
        ArrayList<Integer> columnNos = new ArrayList<Integer>(1);
        columnNos.add(new Integer(1));
        GroupByOperator gb = new GroupByOperator(new DbResultTable(this.table), columnNos);
        while (gb.hasNext()) {
            System.out.println(gb.next());
        }
    }

    public void testSimpleGroup2() {
        System.out.println("GroupByOperatorTest: simple group2.");
        ArrayList<Integer> columnNos = new ArrayList<Integer>(1);
        columnNos.add(new Integer(2));
        GroupByOperator gb = new GroupByOperator(new DbResultTable(this.table), columnNos);
        while (gb.hasNext()) {
            System.out.println(gb.next());
        }
    }

    public void testSimpleGroup3() {
        System.out.println("GroupByOperatorTest: simple group3.");
        ArrayList<Integer> columnNos = new ArrayList<Integer>(2);
        columnNos.add(new Integer(2));
        columnNos.add(new Integer(1));
        GroupByOperator gb = new GroupByOperator(new DbResultTable(this.table), columnNos);
        SumSetFunction av = new SumSetFunction(new CellAccessorFunction(this.table, 3));
        gb.addSetFunction(av, 3);
        while (gb.hasNext()) {
            System.out.println(gb.next());
        }
        gb.dumpStructure();
    }
}

