/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.ColumnSortInfo;
import com.sap.sapdb.oltptest.join.simulation.SortInfo;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.Comparator;
import java.util.Iterator;

public class SortTableComparator
implements Comparator {
    private SortInfo sortInfo;

    public SortTableComparator(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public int compare(Object o1, Object o2) {
        TableRow leftRow = (TableRow)o1;
        TableRow rightRow = (TableRow)o2;
        Iterator it = this.sortInfo.columnIterator();
        while (it.hasNext()) {
            ColumnSortInfo columnInfo = (ColumnSortInfo)it.next();
            AbstractCell leftValue = leftRow.getValue(columnInfo.getColumnNumber());
            AbstractCell rightValue = rightRow.getValue(columnInfo.getColumnNumber());
            switch (columnInfo.getSortOrder()) {
                case 1: {
                    if (leftValue.isGreater(rightValue)) {
                        return 1;
                    }
                    if (!leftValue.isLess(rightValue)) break;
                    return -1;
                }
                case 2: {
                    if (leftValue.isLess(rightValue)) {
                        return 1;
                    }
                    if (!leftValue.isGreater(rightValue)) break;
                    return -1;
                }
            }
        }
        return 0;
    }
}

