/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.JoinedTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class NestedLoopJoin
extends JoinedTable {
    private ResultTable leftTable;
    private ResultTable rightTable;
    private AbstractCondition qualification;
    private TableRow currentRow;
    private boolean valueReady = false;
    private boolean cycleComplete = false;
    private boolean initialized;
    private int rightTableStartColumn;

    public NestedLoopJoin(ResultTable leftTable, ResultTable rightTable, AbstractCondition qualification) {
        super(leftTable, rightTable);
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.qualification = qualification;
        this.qualification.prepare(this);
        this.currentRow = new TableRow(this);
        this.rightTableStartColumn = this.leftTable.getColumnCount() + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (this.cycleComplete) {
            return false;
        }
        if (!this.initialized) {
            this.initialized = true;
            if (!this.leftTable.hasNext()) {
                this.cycleComplete = true;
                return false;
            }
            this.currentRow.setValues(1, this.leftTable.next());
        }
        while (true) {
            if (!this.valueReady && this.rightTable.hasNext()) {
                this.currentRow.setValues(this.rightTableStartColumn, this.rightTable.next());
                if (!this.qualification.isTrue(this.currentRow)) continue;
                this.valueReady = true;
                return true;
            }
            if (!this.leftTable.hasNext()) {
                this.cycleComplete = true;
                return false;
            }
            this.currentRow.setValues(1, this.leftTable.next());
            this.rightTable.resetIterator();
        }
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.leftTable.resetIterator();
        this.rightTable.resetIterator();
        this.initialized = false;
        this.valueReady = false;
        this.cycleComplete = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "NestedLoopJoinOperator " + this.getTableName());
        s.println(String.valueOf(indentStr) + "  Qualification:");
        this.qualification.dumpStructure(s, String.valueOf(indentStr) + "    ");
        s.println(String.valueOf(indentStr) + "  Tables:");
        this.leftTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
        this.rightTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
    }
}

