/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.Iterator;

public class MaterializeResultOperator
extends ResultTable {
    ResultTable inputTable;
    DatabaseTable materializedTable;
    DbResultTable outputTable;
    boolean initialized;

    public MaterializeResultOperator(ResultTable inputTable) {
        super(inputTable);
        this.inputTable = inputTable;
        this.materializedTable = new DatabaseTable(inputTable.getTableDefinition());
        this.outputTable = new DbResultTable(this.materializedTable);
        this.initialized = false;
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.outputTable.hasNext();
    }

    public TableRow next() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.outputTable.next();
    }

    public void resetIterator() {
        if (!this.initialized) {
            this.initialize();
        }
        this.outputTable.resetIterator();
    }

    public DatabaseTable getResultTable() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.materializedTable;
    }

    public Iterator containedTablesIterator() {
        return this.inputTable.containedTablesIterator();
    }

    private void initialize() {
        while (this.inputTable.hasNext()) {
            this.materializedTable.insert(this.inputTable.next());
        }
        this.outputTable.resetIterator();
        this.initialized = true;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "MaterializeResultOperator " + this.getTableName());
        s.println(String.valueOf(indentStr) + "  Input table:");
        this.inputTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
    }

    public int getColumnCount() {
        return this.inputTable.getColumnCount();
    }

    public Column getColumnInfo(int columnNumber) {
        return this.inputTable.getColumnInfo(columnNumber);
    }

    public int getColumnBaseOffset(Table table) {
        return this.inputTable.getColumnBaseOffset(table);
    }
}

