/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.ValueFunction;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FunctionFilter
extends ResultTable {
    private List functionList;
    private ResultTable inputTable;
    private TableRow evalRow;
    private TableRow outputRow;

    public FunctionFilter(ResultTable inputTable) {
        this.inputTable = inputTable;
        this.tableDef = this.inputTable.getResultTableDefinition();
        this.functionList = new ArrayList();
        this.evalRow = new TableRow(this.inputTable);
        this.outputRow = new TableRow(this.inputTable);
    }

    public void addFunction(ValueFunction function, int columnNumber) {
        function.prepare(this);
        this.functionList.add(new FunctionInfo(function, columnNumber));
    }

    public boolean hasNext() {
        return this.inputTable.hasNext();
    }

    public TableRow next() {
        if (!this.inputTable.hasNext()) {
            throw new NoSuchElementException();
        }
        TableRow row = this.inputTable.next();
        int i = 1;
        while (i <= row.getColumnCount()) {
            this.outputRow.setValue(i, row.getValue(i));
            ++i;
        }
        Iterator funcIt = this.functionList.iterator();
        while (funcIt.hasNext()) {
            int i2 = 1;
            while (i2 <= row.getColumnCount()) {
                this.evalRow.setValue(i2, row.getValue(i2));
                ++i2;
            }
            FunctionInfo funcInfo = (FunctionInfo)funcIt.next();
            this.outputRow.setValue(funcInfo.getColumnNumber(), funcInfo.getFunction().evaluate(this.evalRow));
        }
        return this.outputRow;
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "FunctionFilterOperator");
        s.println(String.valueOf(indentStr) + "  input table:");
        this.inputTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
        s.println(String.valueOf(indentStr) + "  value functions:");
        Iterator it = this.functionList.iterator();
        while (it.hasNext()) {
            FunctionInfo fi = (FunctionInfo)it.next();
            fi.getFunction().dumpStructure(s, String.valueOf(indentStr) + "    ");
        }
    }

    class FunctionInfo {
        private ValueFunction function;
        private int columnNumber;

        public FunctionInfo(ValueFunction function, int columnNumber) {
            this.function = function;
            this.columnNumber = columnNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public ValueFunction getFunction() {
            return this.function;
        }
    }
}

