/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

import com.sap.sapdb.oltptest.join.data.Generator;
import com.sap.sapdb.oltptest.join.description.ColumnDescription;
import com.sap.sapdb.oltptest.join.description.ColumnType;
import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.CellFactory;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TableDescription {
    static double rowCountBase = 10.0;
    private String name;
    private double size = 1.0;
    private AbstractList columns = new ArrayList();
    private boolean _isOuter = false;
    private DatabaseTable simulatedTable;

    public TableDescription(String name) {
        this.name = name;
        this.addColumn("id", ColumnType.Serial);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[Table " + this.name + "]";
    }

    ColumnDescription findColumn(String name) {
        ColumnIterator iter = this.columnIterator();
        while (iter.hasNext()) {
            ColumnDescription col = iter.nextColumn();
            if (!col.getName().equals(name)) continue;
            return col;
        }
        return null;
    }

    int findColumnIndex(String name) {
        ColumnIterator iter = this.columnIterator();
        int result = 0;
        while (iter.hasNext()) {
            ++result;
            ColumnDescription col = iter.nextColumn();
            if (!col.getName().equals(name)) continue;
            return result;
        }
        return -1;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    TableDescription addColumn(String name, ColumnType type) {
        if (this.findColumn(name) != null) {
            return this;
        }
        if (name == null) {
            name = "COL_" + this.columns.size();
        }
        if (type == null) {
            type = ColumnType.Integer;
        }
        ColumnDescription colDesc = new ColumnDescription(name, type);
        this.columns.add(colDesc);
        colDesc.setTableName(this.name);
        return this;
    }

    public ColumnIterator columnIterator() {
        return new ColumnIterator(this.columns);
    }

    public TableDescription setSize(double size) {
        this.size = size;
        return this;
    }

    public long rowCount() {
        return (long)(this.size * rowCountBase);
    }

    public long minMatchingRows(double percentage) {
        return (long)(percentage * (double)this.rowCount());
    }

    public void markAsOuter() {
        this._isOuter = true;
    }

    public boolean isOuter() {
        return this._isOuter;
    }

    public String createTableSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ");
        buf.append(this.name);
        buf.append(" (\n    ");
        String delimiter = "";
        ColumnIterator iter = this.columnIterator();
        while (iter.hasNext()) {
            buf.append(delimiter);
            buf.append(iter.nextColumn().getDeclaration());
            delimiter = ",\n    ";
        }
        buf.append("\n)");
        return buf.toString();
    }

    public DatabaseTable createSimulationTable() {
        DatabaseTable result = new DatabaseTable(this.name);
        ColumnIterator iter = this.columnIterator();
        while (iter.hasNext()) {
            String colname = iter.nextColumn().getName();
            result.addColumn(new IntegerColumn(colname));
        }
        this.simulatedTable = result;
        return result;
    }

    protected void fillSimulationTable(DatabaseTable simTable, Generator[] generators) {
        long rowCount = this.rowCount();
        long rowI = 0L;
        while (rowI < rowCount) {
            TableRow row = new TableRow(simTable);
            int i = 0;
            while (i < generators.length) {
                Integer nextVal = (Integer)generators[i].next();
                row.setValue(i + 1, new IntegerCell(nextVal));
                ++i;
            }
            simTable.insert(row);
            ++rowI;
        }
    }

    public void fillSimulationTable(AbstractList data) {
        DatabaseTable simTable = this.getSimulatedTable();
        Iterator iter = data.iterator();
        int colCount = simTable.getColumnCount();
        while (iter.hasNext()) {
            Object[] baserow = (Object[])iter.next();
            TableRow row = new TableRow(simTable);
            int i = 0;
            while (i < colCount) {
                AbstractCell cell = CellFactory.createCell(baserow[i]);
                row.setValue(i + 1, cell);
                ++i;
            }
            simTable.insert(row);
        }
    }

    public void fillSimulationTable(Generator[] generators) {
        this.fillSimulationTable(this.simulatedTable, generators);
    }

    public DatabaseTable getSimulatedTable() {
        return this.simulatedTable;
    }

    public static class ColumnIterator {
        private Iterator iter;

        ColumnIterator(AbstractList collection) {
            this.iter = collection.iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public ColumnDescription nextColumn() {
            return (ColumnDescription)this.iter.next();
        }
    }
}

