/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join;

import com.sap.sapdb.oltptest.join.JoinTest;
import com.sap.sapdb.oltptest.join.ParameterCombination;
import com.sap.sapdb.oltptest.join.ParameterIterator;
import com.sap.sapdb.oltptest.join.data.CommonIntGenerator;
import com.sap.sapdb.oltptest.join.data.Serial;
import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.oltptest.join.description.JoinVersion;
import com.sap.sapdb.oltptest.join.description.NaturalJoin;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;

public class ThoroughSmallJoinTest
extends JoinTest {
    protected void declareTables(JoinQuery join) {
        int tableCount = 3;
        int i = 0;
        while (i < tableCount) {
            TableDescription table = join.addTable();
            table.setSize(3.0);
            ++i;
        }
    }

    protected void addJoinPredicates(JoinQuery join) {
        JoinQuery.TableIterator iter = join.tableIterator();
        String lastName = iter.nextTable().getName();
        while (iter.hasNext()) {
            String newName = iter.nextTable().getName();
            NaturalJoin pred = new NaturalJoin("x", lastName, newName);
            join.addPredicate(pred);
            lastName = newName;
        }
    }

    protected void enterData(JoinQuery join) throws SQLException {
        JoinQuery.TableIterator iter = join.tableIterator();
        CommonIntGenerator generator = null;
        while (iter.hasNext()) {
            TableDescription table = iter.nextTable();
            if (generator == null) {
                generator = new CommonIntGenerator();
                generator.initKeys((int)table.minMatchingRows(0.2));
            } else {
                generator.nextTable((int)table.minMatchingRows(0.2));
            }
            Serial serial = new Serial();
            long rowCount = table.rowCount();
            ArrayList<Object[]> tableData = new ArrayList<Object[]>((int)rowCount);
            int i = 0;
            while ((long)i < rowCount) {
                Object[] row = new Object[]{serial.next(), generator.next()};
                ((AbstractList)tableData).add(row);
                ++i;
            }
            this.session.fillTable(table, tableData, this.verbosity);
            table.fillSimulationTable(tableData);
            if (this.verbosity < 6) continue;
            System.out.println("sql " + table.getName());
            this.session.dumpQuery("SELECT * from " + table.getName());
            table.getSimulatedTable().dump();
        }
    }

    protected int runAndCompare(JoinQuery join, ParameterIterator[] parameters) throws SQLException {
        int result = 0;
        ParameterCombination combination = new ParameterCombination(join, this.session, parameters);
        while (combination.next()) {
            if (this.verbosity > 0) {
                System.out.println("================================");
                System.out.println();
                if (this.verbosity >= 1) {
                    combination.dumpOn(System.out);
                }
            }
            try {
                DatabaseTable simMat = null;
                DatabaseTable sqlMat = null;
                if (this.forSim) {
                    simMat = this.runSimulatedQuery(join);
                    if (this.verbosity >= 1) {
                        System.out.println("expected rows: " + simMat.getRowCount());
                    }
                }
                if (this.forSQL) {
                    sqlMat = this.runSQLQuery(join);
                }
                if (this.forSim && this.forSQL && !sqlMat.sortAndCompare(simMat, true)) {
                    System.out.println("comparison failed");
                    join.generateSUT(simMat, sqlMat);
                    ++this.errors;
                }
                ++this.testsRun;
            }
            catch (JoinQuery.InvalidTestException invalidTestException) {
                // empty catch block
            }
        }
        return result;
    }

    protected int runAndCompare(JoinQuery join) throws SQLException {
        this.runAndCompare(join, new ParameterIterator[]{join.allJoinLayouts(), new JoinQuery.AllIndexLayouts(join), new JoinVersion()});
        return this.errors;
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        JoinTest.main(new ThoroughSmallJoinTest());
    }
}

