/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join;

import com.sap.sapdb.oltptest.join.JoinTest;
import com.sap.sapdb.oltptest.join.TestPrintStream;
import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public class JoinTestCase
extends TestCase {
    private static final String exUser = "JoinTester";
    private static final String exPasswd = "JoinTester";
    private static final String[] testScenarios = new String[]{"ThoroughSmallJoinTest", "RandomLargeJoinTest"};

    public static String getMinimumRelease() {
        return "7.5.0";
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        System.out.println("Start of " + TestCase.getTestClassId());
        try {
            myConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user JoinTester");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user JoinTester password JoinTester resource not exclusive");
            myStatement.close();
            myConnection.close();
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        JoinTestCase.initTestProperties();
    }

    public void run() {
        PrintStream systemOutSave = System.out;
        TestPrintStream testStream = new TestPrintStream(this);
        System.setOut(testStream);
        System.out.println("RandomSeed = " + System.getProperty("sdb.jointest.seed"));
        System.out.println();
        boolean testOk = true;
        String testScenario = System.getProperties().getProperty("sdb.jointest.testToRun", "");
        if (!testScenario.equals("")) {
            testOk = this.runTestScenario(testScenario.toString());
        } else {
            int i = 0;
            while (i < testScenarios.length && testOk) {
                testOk = this.runTestScenario(testScenarios[i]);
                ++i;
            }
        }
        testStream.flush();
        System.setOut(systemOutSave);
        System.out.println("End of " + TestCase.getTestClassId());
    }

    private boolean runTestScenario(String scenarioName) {
        try {
            JoinTest test = (JoinTest)Class.forName("com.sap.sapdb.oltptest.join." + scenarioName).newInstance();
            System.out.println("Starting test " + scenarioName);
            System.out.println();
            boolean result = false;
            test.run();
            if (test.hasErrors()) {
                TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Join test failed. Check for *.vdnts files in your test run directory.");
            }
        }
        catch (SQLException e) {
            TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Test failed.");
            e.printStackTrace(System.out);
            return false;
        }
        catch (ClassNotFoundException e) {
            TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Test failed: could not load class");
            e.printStackTrace(System.out);
            return false;
        }
        catch (JoinQuery.InvalidTestException e) {
            TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Unexpected test exception.");
            e.printStackTrace(System.out);
            return false;
        }
        catch (InstantiationException e) {
            TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Unknown test scenario class.");
            e.printStackTrace(System.out);
            return false;
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"Run", (char)'E', (String)"Unexpected test exception.");
            e.printStackTrace(System.out);
        }
        return true;
    }

    private static void initTestProperties() {
        Properties sysProps = System.getProperties();
        sysProps.setProperty("sdb.host", TestCase.getDatabase().getHost());
        sysProps.setProperty("sdb.dbname", TestCase.getDatabase().getName());
        sysProps.setProperty("sdb.user", "JoinTester");
        sysProps.setProperty("sdb.pwd", "JoinTester");
        sysProps.setProperty("sdb.sqlmode", TestCase.getParameterString((String)"SQLMode", (String)""));
        sysProps.setProperty("sdb.jointest.tablecount", TestCase.getParameterString((String)"TableCount", (String)"4"));
        sysProps.setProperty("sdb.jointest.verbosity", TestCase.getParameterString((String)"Verbosity", (String)"2"));
        sysProps.setProperty("sdb.jointest.seed", TestCase.getParameterString((String)"RandomSeed", (String)String.valueOf(new Date().getTime())));
        sysProps.setProperty("sdb.jointest.testToRun", TestCase.getParameterString((String)"TestToRun", (String)""));
        System.setProperties(sysProps);
    }
}

