/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.interfaces;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.File;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Python
extends TestCase {
    private static int mMaxRuntime = 60;
    private static String fileSep;
    private static String dbName;
    private static String dbHost;
    private static String instRoot;
    private String cmd;
    private String[] cmdArr;
    private String startTime;

    public static long getTimeout() {
        return mMaxRuntime * 1000 * 60;
    }

    public static void prepare() throws TestCaseException {
        mMaxRuntime = TestCase.getParameterInt((String)"timeout", (int)60);
        fileSep = System.getProperty("file.separator");
        dbName = TestCase.getDatabase().getName();
        dbHost = TestCase.getDatabase().getHost();
        instRoot = TestCase.mTestDriverOptions.getProperty("DBRoot");
        if (instRoot == null) {
            instRoot = "";
            TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). INSTROOT (DBROOT) not set.");
        }
    }

    public void run() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.cmdArr = new String[1];
        } else {
            this.cmdArr = new String[3];
            this.cmdArr[0] = "sh";
            this.cmdArr[1] = "-c";
        }
        StringTokenizer st = new StringTokenizer(TestDriver.getStartTime().toString());
        String token = "";
        try {
            int i = 0;
            while (i < 4) {
                token = st.nextToken();
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            this.addMessage("run()", 'W', "Unable to get start time of test sequence, pysqltest.log may contain outdated entries.");
            token = "";
        }
        this.startTime = token.replaceAll(":", "");
        this.cmdArr[this.cmdArr.length - 1] = this.cmd = String.valueOf(instRoot) + fileSep + "bin" + fileSep + "x_python " + this.getDataInputPath() + fileSep + "main.py " + "-u " + TestCase.getDatabase().getDBAUser() + "," + TestCase.getDatabase().getDBAPassword() + " -dbm " + TestCase.getDatabase().getDBMUser() + "," + TestCase.getDatabase().getDBMPassword() + " -d " + dbName + " -n " + dbHost + " -log " + this.getDataOutputPath() + fileSep + "pyslqtest" + this.startTime + ".log";
        System.out.println("Executing command " + this.cmd);
        this.addMessage("run()", 'I', "Executing command:\n" + this.cmd);
        StringBuffer sb = new StringBuffer();
        Execute exc = System.getProperty("os.name").indexOf("Windows") != -1 ? new Execute(this.cmd, null, sb) : new Execute(this.cmdArr, null, sb);
        exc.exec(new File(this.getDataInputPath()));
        int rc = exc.getExitValue();
        System.out.println("Command returned RC " + rc + ", output:\n" + sb.toString());
        if (rc == 0) {
            this.addMessage("run()", 'I', "Command returned RC " + rc + ", output:\n" + sb.toString());
        } else {
            this.addMessage("run()", 'E', "Command returned RC " + rc + ", output:\n" + sb.toString());
        }
    }

    public String getLogFile() {
        return String.valueOf(this.getDataOutputPath()) + fileSep + "pyslqtest" + this.startTime + ".log";
    }
}

