/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.hotstandby;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class HotStandbyBasics
extends TestCase {
    protected DBM mDBMan1 = null;
    protected DBM mDBMan2 = null;
    protected int mTraceLevel = -1;
    protected boolean mTraceLevelIsSet = false;
    protected String currentCmd = null;
    protected Connection lConnection = null;
    protected TestPreparedStatement Stmt = null;
    private int maxArrayCount = 5;
    protected String mDatabaseName = "HSB75B";
    protected String mHSStorageDll = "libhsscopy";
    protected String mKernelSpeed = "FAST";
    protected String mRemoteUser = "remuser,Remuser";
    protected int mLogVolumeCounter = 1;
    protected String[] mLogVolume_Name = new String[this.maxArrayCount];
    protected String[] mLogVolume_Type = new String[this.maxArrayCount];
    protected int[] mLogVolume_Size = new int[this.maxArrayCount];
    protected int mDataVolumeCounter = 1;
    protected String[] mDataVolume_Name = new String[this.maxArrayCount];
    protected String[] mDataVolume_Type = new String[this.maxArrayCount];
    protected int[] mDataVolume_Size = new int[this.maxArrayCount];
    protected String mMasterNode = "hs0030";
    protected String mMasterRoot = "/SAP_DB/7500DEV/db";
    protected int mStandbyNodeCounter = 1;
    protected String[] mStandbyNode = new String[this.maxArrayCount];
    protected String[] mStandbyRoot = new String[this.maxArrayCount];
    protected String mOfficialNode = "HOT";
    protected String mDBMUser = "DBM";
    protected String mDBMUserPW = "DBM";
    protected String mDBAUser = "DBA";
    protected String mDBAUserPW = "DBA";
    protected String mDBUser = "tst024";
    protected String mDBUserPW = "tst024";

    public String executeDBMCmdViaName(String pHost, String pName, String pCmd) throws TestDatabaseException {
        this.currentCmd = pCmd;
        String logon = "USER_LOGON " + this.mDBMUser + "," + this.mDBMUserPW;
        String result = "";
        try {
            if (this.mDBMan1 == null) {
                this.mDBMan1 = DBM.dbDBM((String)pHost, (String)pName);
                this.mDBMan1.cmd(logon);
            }
            result = this.mDBMan1.cmd(pCmd);
            if (this.mTraceLevel > 2) {
                System.out.println(String.valueOf(pCmd) + " -> " + result);
            }
            return result;
        }
        catch (Exception e) {
            if (this.mTraceLevel > 1) {
                System.out.println("Could not execute: " + pCmd);
            }
            if (this.mTraceLevel > 1) {
                System.out.println("Exception: " + e.getLocalizedMessage() + "\n" + e.getClass());
            }
            if (this.mTraceLevel > 1) {
                e.printStackTrace();
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + " with logon String: " + logon);
        }
    }

    public String executeDBMCmdViaRoot(String pHost, String pRoot, String pCmd) throws TestDatabaseException {
        String result = "";
        this.currentCmd = pCmd;
        try {
            if (this.mDBMan2 == null) {
                this.mDBMan2 = DBM.dbrootDBM((String)pHost, (String)pRoot);
            }
            result = this.mDBMan2.cmd(pCmd);
            if (this.mTraceLevel > 2) {
                System.out.println(String.valueOf(pCmd) + " -> " + result);
            }
            return result;
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getLocalizedMessage() + "\n" + e.getClass());
            e.printStackTrace();
            throw new TestDatabaseException(e, " DBM command: " + pCmd);
        }
    }

    public void releaseDBMConnection() {
        try {
            if (this.mDBMan1 != null) {
                this.mDBMan1.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mDBMan1 = null;
        try {
            if (this.mDBMan2 != null) {
                this.mDBMan2.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mDBMan2 = null;
    }

    public void run() {
    }

    protected void checkDBState(String pNode, String pDatabaseName, String pExpectedValue) throws TestDatabaseException, SQLException, TestCaseException {
        String dummyResult = this.executeDBMCmdViaName(pNode, pDatabaseName, "db_state");
        if (dummyResult.toLowerCase().indexOf(pExpectedValue.toLowerCase()) == -1) {
            throw new TestCaseException("Expected value '" + pExpectedValue + "' not found.\nGot:\n" + dummyResult);
        }
    }

    public static String getTestClassId() {
        return "HotStandbyBasics";
    }

    public String getLogFile() {
        return null;
    }

    public boolean readParameter() {
        if (this.getParameterFileLocation() != null) {
            this.mDatabaseName = TestCase.getParameterString((String)"DatabaseName", (String)this.mDatabaseName);
            this.mMasterNode = TestCase.getParameterString((String)"MasterNode", (String)this.mMasterNode);
            this.mMasterRoot = TestCase.getParameterString((String)"MasterRoot", (String)this.mMasterRoot);
            this.mKernelSpeed = TestCase.getParameterString((String)"KernelSpeed", (String)this.mKernelSpeed);
            this.mRemoteUser = TestCase.getParameterString((String)"RemoteUser", (String)this.mRemoteUser);
            this.mHSStorageDll = TestCase.getParameterString((String)"HS_STORAGE_DLL", (String)this.mHSStorageDll);
            this.mOfficialNode = TestCase.getParameterString((String)"OfficialNode", (String)this.mOfficialNode);
            this.mTraceLevel = TestCase.getParameterInt((String)"TraceLevel", (int)this.mTraceLevel);
            if (this.mTraceLevel == -1) {
                this.mTraceLevel = 0;
            } else {
                this.mTraceLevelIsSet = true;
            }
            this.mStandbyNodeCounter = TestCase.getParameterInt((String)"CounterOfStandbyNodes", (int)this.mStandbyNodeCounter);
            int i = 0;
            while (i < this.mStandbyNodeCounter) {
                this.mStandbyNode[i] = TestCase.getParameterString((String)("NODE_" + i), null);
                if (this.mStandbyNode[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: NODE_" + i);
                    return false;
                }
                this.mStandbyRoot[i] = TestCase.getParameterString((String)("ROOT_" + i), null);
                if (this.mStandbyRoot[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: ROOT_" + i);
                    return false;
                }
                ++i;
            }
            this.mDataVolumeCounter = TestCase.getParameterInt((String)"CounterOfDataVolume", (int)this.mDataVolumeCounter);
            i = 0;
            while (i < this.mDataVolumeCounter) {
                this.mDataVolume_Name[i] = TestCase.getParameterString((String)("DATA_NAME_" + i), null);
                if (this.mDataVolume_Name[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: DATA_NAME_" + i);
                    return false;
                }
                this.mDataVolume_Type[i] = TestCase.getParameterString((String)("DATA_TYPE_" + i), null);
                if (this.mDataVolume_Type[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: DATA_TYPE_" + i);
                    return false;
                }
                this.mDataVolume_Size[i] = TestCase.getParameterInt((String)("DATA_SIZE_" + i), (int)-1);
                if (this.mDataVolume_Size[i] == -1) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: DATA_SIZE_" + i);
                    return false;
                }
                ++i;
            }
            this.mLogVolumeCounter = TestCase.getParameterInt((String)"CounterOfLogVolume", (int)this.mLogVolumeCounter);
            i = 0;
            while (i < this.mLogVolumeCounter) {
                this.mLogVolume_Name[i] = TestCase.getParameterString((String)("LOG_NAME_" + i), null);
                if (this.mLogVolume_Name[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: LOG_NAME_" + i);
                    return false;
                }
                this.mLogVolume_Type[i] = TestCase.getParameterString((String)("LOG_TYPE_" + i), null);
                if (this.mLogVolume_Type[i] == null) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: LOG_TYPE_" + i);
                    return false;
                }
                this.mLogVolume_Size[i] = TestCase.getParameterInt((String)("LOG_SIZE_" + i), (int)-1);
                if (this.mLogVolume_Size[i] == -1) {
                    this.addMessage("readParameter()", 'W', "Can not read parameter for: LOG_SIZE_" + i);
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected void takeOverAndCompareData() throws TestDatabaseException, SQLException, ClassNotFoundException, TestCaseException {
        this.releaseDBMConnection();
        ResultSet masterRS = null;
        TestDatabaseSap masterDB = null;
        masterDB = new TestDatabaseSap(this.mMasterNode, this.mDatabaseName);
        Connection masterConnection = null;
        masterConnection = masterDB.connect(this.mDBUser, this.mDBUserPW);
        TestStatement masterStmt = new TestStatement((TestCase)this, masterConnection);
        masterRS = masterStmt.executeQuery("select * from mydatatab");
        VerificationDataSorted Veri = new VerificationDataSorted(masterRS);
        masterRS.close();
        masterStmt.close();
        this.currentCmd = "db_stop";
        this.executeDBMCmdViaName(this.mMasterNode, this.mDatabaseName, this.currentCmd);
        this.releaseDBMConnection();
        System.err.println("Standby");
        this.currentCmd = "util_execute takeover";
        this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, this.currentCmd);
        masterDB = new TestDatabaseSap(this.mStandbyNode[0], this.mDatabaseName);
        masterConnection = null;
        masterConnection = masterDB.connect(this.mDBUser, this.mDBUserPW);
        masterStmt = new TestStatement((TestCase)this, masterConnection);
        masterRS = masterStmt.executeQuery("select * from mydatatab");
        if (!this.checkQuery(masterStmt, (VerificationData)Veri)) {
            throw new TestDatabaseException("compare data... DIFFERENCE!\n" + Veri.getErrorMessage());
        }
    }
}

