/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref.sax2dtm;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.DTMStringPool;
import org.apache.xml.dtm.ref.DTMTreeWalker;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.NodeLocator;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.IntVector;
import org.apache.xml.utils.StringVector;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SAX2DTM
extends DTMDefaultBaseIterators
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    private static final boolean DEBUG = false;
    private IncrementalSAXSource m_incrementalSAXSource = null;
    private FastStringBuffer m_chars = new FastStringBuffer(13, 13);
    protected SuballocatedIntVector m_data;
    private transient IntStack m_parents = new IntStack();
    private transient int m_previous = 0;
    private transient Vector m_prefixMappings = new Vector();
    private transient IntStack m_contextIndexes = new IntStack();
    private transient int m_textType = 3;
    private transient int m_coalescedTextType = 3;
    private transient Locator m_locator = null;
    private transient boolean m_insideDTD = false;
    protected DTMTreeWalker m_walker = new DTMTreeWalker();
    private DTMStringPool m_valuesOrPrefixes = new DTMStringPool();
    private boolean m_endDocumentOccured = false;
    protected SuballocatedIntVector m_dataOrQName;
    protected Hashtable m_idAttributes = new Hashtable();
    static final String[] m_fixednames = new String[]{null, null, null, "#text", "#cdata_section", null, null, null, "#comment", "#document", null, "#document-fragment", null};
    private Vector m_entities = null;
    private static final int ENTITY_FIELD_PUBLICID = 0;
    private static final int ENTITY_FIELD_SYSTEMID = 1;
    private static final int ENTITY_FIELD_NOTATIONNAME = 2;
    private static final int ENTITY_FIELD_NAME = 3;
    private static final int ENTITY_FIELDS_PER = 4;
    private int m_textPendingStart = -1;
    private boolean m_useSourceLocationProperty = false;
    private StringVector m_sourceSystemId;
    private IntVector m_sourceLine;
    private IntVector m_sourceColumn;
    boolean m_pastFirstElement = false;

    public SAX2DTM(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
        this.m_data = new SuballocatedIntVector(doIndexing ? 2048 : 512, 1024);
        this.m_data.addElement(0);
        this.m_dataOrQName = new SuballocatedIntVector(this.m_initialblocksize);
    }

    protected int _dataOrQName(int identity) {
        if (identity < this.m_size) {
            return this.m_dataOrQName.elementAt(identity);
        }
        do {
            boolean isMore;
            if (isMore = this.nextNode()) continue;
            return -1;
        } while (identity >= this.m_size);
        return this.m_dataOrQName.elementAt(identity);
    }

    public void clearCoRoutine() {
        this.clearCoRoutine(true);
    }

    public void clearCoRoutine(boolean callDoTerminate) {
        if (null != this.m_incrementalSAXSource) {
            if (callDoTerminate) {
                this.m_incrementalSAXSource.deliverMoreNodes(false);
            }
            this.m_incrementalSAXSource = null;
        }
    }

    public void setIncrementalSAXSource(IncrementalSAXSource incrementalSAXSource) {
        this.m_incrementalSAXSource = incrementalSAXSource;
        incrementalSAXSource.setContentHandler(this);
        incrementalSAXSource.setLexicalHandler(this);
    }

    public ContentHandler getContentHandler() {
        if (this.m_incrementalSAXSource instanceof IncrementalSAXSource_Filter) {
            return (ContentHandler)((Object)this.m_incrementalSAXSource);
        }
        return this;
    }

    public LexicalHandler getLexicalHandler() {
        if (this.m_incrementalSAXSource instanceof IncrementalSAXSource_Filter) {
            return (LexicalHandler)((Object)this.m_incrementalSAXSource);
        }
        return this;
    }

    public EntityResolver getEntityResolver() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    public ErrorHandler getErrorHandler() {
        return this;
    }

    public DeclHandler getDeclHandler() {
        return this;
    }

    public boolean needsTwoThreads() {
        return null != this.m_incrementalSAXSource;
    }

    public void dispatchCharactersEvents(int nodeHandle, ContentHandler ch, boolean normalize) throws SAXException {
        int identity = this.makeNodeIdentity(nodeHandle);
        short type = this._type(identity);
        if (this.isTextType(type)) {
            int dataIndex = this.m_dataOrQName.elementAt(identity);
            int offset = this.m_data.elementAt(dataIndex);
            int length = this.m_data.elementAt(dataIndex + 1);
            if (normalize) {
                this.m_chars.sendNormalizedSAXcharacters(ch, offset, length);
            } else {
                this.m_chars.sendSAXcharacters(ch, offset, length);
            }
        } else {
            int firstChild = this._firstch(identity);
            if (-1 != firstChild) {
                int offset = -1;
                int length = 0;
                int level = this._level(identity);
                identity = firstChild;
                while (-1 != identity && this._level(identity) > level) {
                    type = this._type(identity);
                    if (this.isTextType(type)) {
                        int dataIndex = this._dataOrQName(identity);
                        if (-1 == offset) {
                            offset = this.m_data.elementAt(dataIndex);
                        }
                        length += this.m_data.elementAt(dataIndex + 1);
                    }
                    identity = this.getNextNodeIdentity(identity);
                }
                if (length > 0) {
                    if (normalize) {
                        this.m_chars.sendNormalizedSAXcharacters(ch, offset, length);
                    } else {
                        this.m_chars.sendSAXcharacters(ch, offset, length);
                    }
                }
            } else if (type != 1) {
                int dataIndex = this._dataOrQName(identity);
                if (dataIndex < 0) {
                    dataIndex = -dataIndex;
                    dataIndex = this.m_data.elementAt(dataIndex + 1);
                }
                String str = this.m_valuesOrPrefixes.indexToString(dataIndex);
                if (normalize) {
                    FastStringBuffer.sendNormalizedSAXcharacters(str.toCharArray(), 0, str.length(), ch);
                } else {
                    ch.characters(str.toCharArray(), 0, str.length());
                }
            }
        }
    }

    public String getNodeName(int nodeHandle) {
        int expandedTypeID = this.getExpandedTypeID(nodeHandle);
        int namespaceID = expandedTypeID & ExpandedNameTable.MASK_NAMESPACE;
        if (0 == namespaceID) {
            short type = this.getNodeType(nodeHandle);
            if (type == 13) {
                if (null == this.m_expandedNameTable.getLocalName(expandedTypeID)) {
                    return "xmlns";
                }
                return "xmlns:" + this.m_expandedNameTable.getLocalName(expandedTypeID);
            }
            if (0 == ExpandedNameTable.getLocalNameID(expandedTypeID)) {
                return m_fixednames[type];
            }
            return this.m_expandedNameTable.getLocalName(expandedTypeID);
        }
        int qnameIndex = this.m_dataOrQName.elementAt(this.makeNodeIdentity(nodeHandle));
        if (qnameIndex < 0) {
            qnameIndex = -qnameIndex;
            qnameIndex = this.m_data.elementAt(qnameIndex);
        }
        return this.m_valuesOrPrefixes.indexToString(qnameIndex);
    }

    public String getNodeNameX(int nodeHandle) {
        int expandedTypeID = this.getExpandedTypeID(nodeHandle);
        int namespaceID = (expandedTypeID & ExpandedNameTable.MASK_NAMESPACE) >> ExpandedNameTable.BITS_PER_LOCALNAME;
        if (0 == namespaceID) {
            String name = this.m_expandedNameTable.getLocalName(expandedTypeID);
            if (name == null) {
                return "";
            }
            return name;
        }
        int qnameIndex = this.m_dataOrQName.elementAt(this.makeNodeIdentity(nodeHandle));
        if (qnameIndex < 0) {
            qnameIndex = -qnameIndex;
            qnameIndex = this.m_data.elementAt(qnameIndex);
        }
        return this.m_valuesOrPrefixes.indexToString(qnameIndex);
    }

    public boolean isAttributeSpecified(int attributeHandle) {
        return true;
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    protected int getNextNodeIdentity(int identity) {
        ++identity;
        while (identity >= this.m_size) {
            if (null == this.m_incrementalSAXSource) {
                return -1;
            }
            this.nextNode();
        }
        return identity;
    }

    public void dispatchToEvents(int nodeHandle, ContentHandler ch) throws SAXException {
        DTMTreeWalker treeWalker = this.m_walker;
        ContentHandler prevCH = treeWalker.getcontentHandler();
        if (null != prevCH) {
            treeWalker = new DTMTreeWalker();
        }
        treeWalker.setcontentHandler(ch);
        treeWalker.setDTM(this);
        try {
            treeWalker.traverse(nodeHandle);
            Object var6_5 = null;
            treeWalker.setcontentHandler(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            treeWalker.setcontentHandler(null);
            throw throwable;
        }
    }

    protected int getNumberOfNodes() {
        return this.m_size;
    }

    protected boolean nextNode() {
        if (null == this.m_incrementalSAXSource) {
            return false;
        }
        if (this.m_endDocumentOccured) {
            this.clearCoRoutine();
            return false;
        }
        Object gotMore = this.m_incrementalSAXSource.deliverMoreNodes(true);
        if (!(gotMore instanceof Boolean)) {
            if (gotMore instanceof RuntimeException) {
                throw (RuntimeException)gotMore;
            }
            if (gotMore instanceof Exception) {
                throw new WrappedRuntimeException((Exception)gotMore);
            }
            this.clearCoRoutine();
            return false;
        }
        if (gotMore != Boolean.TRUE) {
            this.clearCoRoutine();
        }
        return true;
    }

    private final boolean isTextType(int type) {
        return 3 == type || 4 == type;
    }

    protected int addNode(int type, int expandedTypeID, int parentIndex, int previousSibling, int dataOrPrefix, boolean canHaveFirstChild) {
        int nodeIndex = this.m_size++;
        if (this.m_dtmIdent.size() == nodeIndex >>> 16) {
            try {
                if (this.m_mgr == null) {
                    throw new ClassCastException();
                }
                DTMManagerDefault mgrD = (DTMManagerDefault)this.m_mgr;
                int id = mgrD.getFirstFreeDTMID();
                mgrD.addDTM(this, id, nodeIndex);
                this.m_dtmIdent.addElement(id << 16);
            }
            catch (ClassCastException e) {
                this.error(XSLMessages.createMessage(170, null));
            }
        }
        this.m_firstch.addElement(canHaveFirstChild ? -2 : -1);
        this.m_nextsib.addElement(-2);
        this.m_prevsib.addElement(previousSibling);
        this.m_parent.addElement(parentIndex);
        this.m_exptype.addElement(expandedTypeID);
        this.m_dataOrQName.addElement(dataOrPrefix);
        if (-1 != previousSibling) {
            this.m_nextsib.setElementAt(nodeIndex, previousSibling);
        }
        switch (type) {
            case 13: {
                this.declareNamespaceInContext(parentIndex, nodeIndex);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (-1 == parentIndex || -2 != this.m_firstch.elementAt(parentIndex)) break;
                this.m_firstch.setElementAt(nodeIndex, parentIndex);
            }
        }
        return nodeIndex;
    }

    public String getNodeValue(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        short type = this._type(identity);
        if (this.isTextType(type)) {
            int dataIndex = this._dataOrQName(identity);
            int offset = this.m_data.elementAt(dataIndex);
            int length = this.m_data.elementAt(dataIndex + 1);
            return this.m_chars.getString(offset, length);
        }
        if (1 == type || 11 == type || 9 == type) {
            return null;
        }
        int dataIndex = this._dataOrQName(identity);
        if (dataIndex < 0) {
            dataIndex = -dataIndex;
            dataIndex = this.m_data.elementAt(dataIndex + 1);
        }
        return this.m_valuesOrPrefixes.indexToString(dataIndex);
    }

    public String getLocalName(int nodeHandle) {
        return this.m_expandedNameTable.getLocalName(this._exptype(this.makeNodeIdentity(nodeHandle)));
    }

    public String getUnparsedEntityURI(String name) {
        String url = "";
        if (null == this.m_entities) {
            return url;
        }
        int n = this.m_entities.size();
        int i = 0;
        while (i < n) {
            String ename = (String)this.m_entities.elementAt(i + 3);
            if (null != ename && ename.equals(name)) {
                String nname = (String)this.m_entities.elementAt(i + 2);
                if (null == nname || null != (url = (String)this.m_entities.elementAt(i + 1))) break;
                url = (String)this.m_entities.elementAt(i + 0);
                break;
            }
            i += 4;
        }
        return url;
    }

    public String getPrefix(int nodeHandle) {
        int prefixIndex;
        int identity = this.makeNodeIdentity(nodeHandle);
        short type = this.getNodeType(identity);
        if (1 == type) {
            int prefixIndex2 = this._dataOrQName(identity);
            if (0 == prefixIndex2) {
                return "";
            }
            String qname = this.m_valuesOrPrefixes.indexToString(prefixIndex2);
            return this.getPrefix(qname, null);
        }
        if (2 == type && (prefixIndex = this._dataOrQName(identity)) < 0) {
            prefixIndex = this.m_data.elementAt(-prefixIndex);
            String qname = this.m_valuesOrPrefixes.indexToString(prefixIndex);
            return this.getPrefix(qname, null);
        }
        return "";
    }

    public int getAttributeNode(int nodeHandle, String namespaceURI, String name) {
        int attrH = this.getFirstAttribute(nodeHandle);
        while (-1 != attrH) {
            boolean nsMatch;
            String attrNS = this.getNamespaceURI(attrH);
            String attrName = this.getLocalName(attrH);
            boolean bl = nsMatch = namespaceURI == attrNS || namespaceURI != null && namespaceURI.equals(attrNS);
            if (nsMatch && name.equals(attrName)) {
                return attrH;
            }
            attrH = this.getNextAttribute(attrH);
        }
        return -1;
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public String getNamespaceURI(int nodeHandle) {
        return this.m_expandedNameTable.getNamespace(this._exptype(this.makeNodeIdentity(nodeHandle)));
    }

    public XMLString getStringValue(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        short type = this._type(identity);
        if (this.isTextType(type)) {
            int dataIndex = this._dataOrQName(identity);
            int offset = this.m_data.elementAt(dataIndex);
            int length = this.m_data.elementAt(dataIndex + 1);
            return this.m_xstrf.newstr(this.m_chars, offset, length);
        }
        int firstChild = this._firstch(identity);
        if (-1 != firstChild) {
            int offset = -1;
            int length = 0;
            int level = this._level(identity);
            identity = firstChild;
            while (-1 != identity && this._level(identity) > level) {
                type = this._type(identity);
                if (this.isTextType(type)) {
                    int dataIndex = this._dataOrQName(identity);
                    if (-1 == offset) {
                        offset = this.m_data.elementAt(dataIndex);
                    }
                    length += this.m_data.elementAt(dataIndex + 1);
                }
                identity = this.getNextNodeIdentity(identity);
            }
            if (length > 0) {
                return this.m_xstrf.newstr(this.m_chars, offset, length);
            }
        } else if (type != 1) {
            int dataIndex = this._dataOrQName(identity);
            if (dataIndex < 0) {
                dataIndex = -dataIndex;
                dataIndex = this.m_data.elementAt(dataIndex + 1);
            }
            return this.m_xstrf.newstr(this.m_valuesOrPrefixes.indexToString(dataIndex));
        }
        return this.m_xstrf.emptystr();
    }

    public int getElementById(String elementId) {
        Integer intObj;
        boolean isMore = true;
        do {
            if (null != (intObj = (Integer)this.m_idAttributes.get(elementId))) {
                return this.makeNodeHandle(intObj);
            }
            if (!isMore || this.m_endDocumentOccured) break;
            isMore = this.nextNode();
        } while (null == intObj);
        return -1;
    }

    private String getPrefix(String qname, String uri) {
        String prefix;
        int uriIndex = -1;
        if (null != uri && uri.length() > 0) {
            do {
                ++uriIndex;
            } while (((uriIndex = this.m_prefixMappings.indexOf(uri, uriIndex)) & 1) == 0);
            if (uriIndex >= 0) {
                prefix = (String)this.m_prefixMappings.elementAt(uriIndex - 1);
            } else if (null != qname) {
                int indexOfNSSep = qname.indexOf(58);
                prefix = qname.equals("xmlns") ? "" : (qname.startsWith("xmlns:") ? qname.substring(indexOfNSSep + 1) : (indexOfNSSep > 0 ? qname.substring(0, indexOfNSSep) : null));
            } else {
                prefix = null;
            }
        } else if (null != qname) {
            int indexOfNSSep = qname.indexOf(58);
            prefix = qname.equals("xmlns") ? "" : (qname.startsWith("xmlns:") ? qname.substring(indexOfNSSep + 1) : (indexOfNSSep > 0 ? qname.substring(0, indexOfNSSep) : null));
        } else {
            prefix = null;
        }
        return prefix;
    }

    public void setIDAttribute(String id, int elem) {
        this.m_idAttributes.put(id, new Integer(elem));
    }

    protected void charactersFlush() {
        if (this.m_textPendingStart >= 0) {
            int length = this.m_chars.size() - this.m_textPendingStart;
            boolean doStrip = false;
            if (this.getShouldStripWhitespace()) {
                doStrip = this.m_chars.isWhitespace(this.m_textPendingStart, length);
            }
            if (doStrip) {
                this.m_chars.setLength(this.m_textPendingStart);
            } else {
                int exName = this.m_expandedNameTable.getExpandedTypeID(3);
                int dataIndex = this.m_data.size();
                this.m_previous = this.addNode(this.m_coalescedTextType, exName, this.m_parents.peek(), this.m_previous, dataIndex, false);
                this.m_data.addElement(this.m_textPendingStart);
                this.m_data.addElement(length);
            }
            this.m_textPendingStart = -1;
            this.m_coalescedTextType = 3;
            this.m_textType = 3;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (null == this.m_entities) {
            this.m_entities = new Vector();
        }
        try {
            systemId = SystemIDResolver.getAbsoluteURI(systemId, this.getDocumentBaseURI());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.m_entities.addElement(publicId);
        this.m_entities.addElement(systemId);
        this.m_entities.addElement(notationName);
        this.m_entities.addElement(name);
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void startDocument() throws SAXException {
        int doc = this.addNode(9, this.m_expandedNameTable.getExpandedTypeID(9), -1, -1, 0, true);
        this.m_parents.push(doc);
        this.m_previous = -1;
        this.m_contextIndexes.push(this.m_prefixMappings.size());
    }

    public void endDocument() throws SAXException {
        this.charactersFlush();
        this.m_nextsib.setElementAt(-1, 0);
        if (this.m_firstch.elementAt(0) == -2) {
            this.m_firstch.setElementAt(-1, 0);
        }
        if (-1 != this.m_previous) {
            this.m_nextsib.setElementAt(-1, this.m_previous);
        }
        this.m_parents = null;
        this.m_prefixMappings = null;
        this.m_contextIndexes = null;
        this.m_endDocumentOccured = true;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == prefix) {
            prefix = "";
        }
        this.m_prefixMappings.addElement(prefix);
        this.m_prefixMappings.addElement(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (null == prefix) {
            prefix = "";
        }
        int index = this.m_contextIndexes.peek() - 1;
        do {
            ++index;
        } while ((index = this.m_prefixMappings.indexOf(prefix, index)) >= 0 && (index & 1) == 1);
        if (index > -1) {
            this.m_prefixMappings.setElementAt("%@$#^@#", index);
            this.m_prefixMappings.setElementAt("%@$#^@#", index + 1);
        }
    }

    protected boolean declAlreadyDeclared(String prefix) {
        int startDecls = this.m_contextIndexes.peek();
        Vector prefixMappings = this.m_prefixMappings;
        int nDecls = prefixMappings.size();
        int i = startDecls;
        while (i < nDecls) {
            String prefixDecl = (String)prefixMappings.elementAt(i);
            if (prefixDecl != null && prefixDecl.equals(prefix)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.charactersFlush();
        int exName = this.m_expandedNameTable.getExpandedTypeID(uri, localName, 1);
        String prefix = this.getPrefix(qName, uri);
        int prefixIndex = null != prefix ? this.m_valuesOrPrefixes.stringToIndex(qName) : 0;
        int elemNode = this.addNode(1, exName, this.m_parents.peek(), this.m_previous, prefixIndex, true);
        this.indexNode(exName, elemNode);
        this.m_parents.push(elemNode);
        int startDecls = this.m_contextIndexes.peek();
        int nDecls = this.m_prefixMappings.size();
        int prev = -1;
        if (!this.m_pastFirstElement) {
            prefix = "xml";
            String declURL = "http://www.w3.org/XML/1998/namespace";
            exName = this.m_expandedNameTable.getExpandedTypeID(null, prefix, 13);
            int val = this.m_valuesOrPrefixes.stringToIndex(declURL);
            prev = this.addNode(13, exName, elemNode, prev, val, false);
            this.m_pastFirstElement = true;
        }
        int i = startDecls;
        while (i < nDecls) {
            prefix = (String)this.m_prefixMappings.elementAt(i);
            if (prefix != null) {
                String declURL = (String)this.m_prefixMappings.elementAt(i + 1);
                exName = this.m_expandedNameTable.getExpandedTypeID(null, prefix, 13);
                int val = this.m_valuesOrPrefixes.stringToIndex(declURL);
                prev = this.addNode(13, exName, elemNode, prev, val, false);
            }
            i += 2;
        }
        int n = attributes.getLength();
        int i2 = 0;
        while (i2 < n) {
            block10: {
                int nodeType;
                String valString;
                String attrQName;
                String attrUri;
                block11: {
                    block9: {
                        attrUri = attributes.getURI(i2);
                        attrQName = attributes.getQName(i2);
                        valString = attributes.getValue(i2);
                        prefix = this.getPrefix(attrQName, attrUri);
                        if (null == attrQName || !attrQName.equals("xmlns") && !attrQName.startsWith("xmlns:")) break block9;
                        if (this.declAlreadyDeclared(prefix)) break block10;
                        nodeType = 13;
                        break block11;
                    }
                    nodeType = 2;
                    if (attributes.getType(i2).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(valString, elemNode);
                    }
                }
                if (null == valString) {
                    valString = "";
                }
                int val = this.m_valuesOrPrefixes.stringToIndex(valString);
                String attrLocalName = attributes.getLocalName(i2);
                if (null != prefix) {
                    prefixIndex = this.m_valuesOrPrefixes.stringToIndex(attrQName);
                    int dataIndex = this.m_data.size();
                    this.m_data.addElement(prefixIndex);
                    this.m_data.addElement(val);
                    val = -dataIndex;
                }
                exName = this.m_expandedNameTable.getExpandedTypeID(attrUri, attrLocalName, nodeType);
                prev = this.addNode(nodeType, exName, elemNode, prev, val, false);
            }
            ++i2;
        }
        if (-1 != prev) {
            this.m_nextsib.setElementAt(-1, prev);
        }
        if (null != this.m_wsfilter) {
            short wsv = this.m_wsfilter.getShouldStripSpace(this.makeNodeHandle(elemNode), this);
            boolean shouldStrip = 3 == wsv ? this.getShouldStripWhitespace() : 2 == wsv;
            this.pushShouldStripWhitespace(shouldStrip);
        }
        this.m_previous = -1;
        this.m_contextIndexes.push(this.m_prefixMappings.size());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.charactersFlush();
        this.m_prefixMappings.setSize(this.m_contextIndexes.pop());
        this.m_prefixMappings.setSize(this.m_contextIndexes.pop());
        this.m_contextIndexes.push(this.m_prefixMappings.size());
        int lastNode = this.m_previous;
        this.m_previous = this.m_parents.pop();
        if (-2 == this.m_firstch.elementAt(this.m_previous)) {
            this.m_firstch.setElementAt(-1, this.m_previous);
        } else if (-1 != lastNode) {
            this.m_nextsib.setElementAt(-1, lastNode);
        }
        this.popShouldStripWhitespace();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_textPendingStart == -1) {
            this.m_textPendingStart = this.m_chars.size();
            this.m_coalescedTextType = this.m_textType;
        }
        this.m_chars.append(ch, start, length);
        if (this.m_textType == 3) {
            this.m_coalescedTextType = 3;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.charactersFlush();
        int exName = this.m_expandedNameTable.getExpandedTypeID(null, target, 7);
        int dataIndex = this.m_valuesOrPrefixes.stringToIndex(data);
        this.m_previous = this.addNode(7, exName, this.m_parents.peek(), this.m_previous, dataIndex, false);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_insideDTD = true;
    }

    public void endDTD() throws SAXException {
        this.m_insideDTD = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_textType = 4;
    }

    public void endCDATA() throws SAXException {
        this.m_textType = 3;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.m_insideDTD) {
            return;
        }
        this.charactersFlush();
        int exName = this.m_expandedNameTable.getExpandedTypeID(8);
        int dataIndex = this.m_valuesOrPrefixes.stringToIndex(new String(ch, start, length));
        this.m_previous = this.addNode(8, exName, this.m_parents.peek(), this.m_previous, dataIndex, false);
    }

    public void setProperty(String property, Object value) {
        if (property.equals("http://xml.apache.org/xalan/properties/source-location")) {
            if (!(value instanceof Boolean)) {
                throw new RuntimeException(XSLMessages.createMessage(177, new Object[]{"http://xml.apache.org/xalan/properties/source-location"}));
            }
            this.m_useSourceLocationProperty = (Boolean)value;
            this.m_sourceSystemId = new StringVector();
            this.m_sourceLine = new IntVector();
            this.m_sourceColumn = new IntVector();
        }
    }

    public SourceLocator getSourceLocatorFor(int node) {
        if (this.m_useSourceLocationProperty) {
            return new NodeLocator(null, this.m_sourceSystemId.elementAt(node &= ExpandedNameTable.MASK_NODEHANDLE), this.m_sourceLine.elementAt(node), this.m_sourceColumn.elementAt(node));
        }
        return null;
    }
}

