/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestPut016
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static boolean TEST_WAS_OK = true;

    public static void prepare() throws TestCaseException {
        TestPut016.createWebDAVSchema();
        TestPut016.addGlobalMessage((String)("prepare test " + TestPut016.getTestClassId()), (char)'I', (String)"*******************************************************************************************************************************************\n* put on a not existing resource with 'contenttype' - property values that have to be declined by the server (subtype-part of contenttype)*\n*******************************************************************************************************************************************");
        host = new String(TestPut016.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut016.getPort();
        baseUrl = TestPut016.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut016.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut016.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut016.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut016.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut016.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut016.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut016.addGlobalMessage((String)"1. DELETE the resource /TestPut016.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut016.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        Vector<Character> restrictedSigns = new Vector<Character>();
        restrictedSigns.add(new Character(' '));
        restrictedSigns.add(new Character('('));
        restrictedSigns.add(new Character(')'));
        restrictedSigns.add(new Character(','));
        restrictedSigns.add(new Character('/'));
        int j = 58;
        while (j <= 64) {
            restrictedSigns.add(new Character((char)j));
            ++j;
        }
        restrictedSigns.add(new Character('['));
        restrictedSigns.add(new Character('\\'));
        restrictedSigns.add(new Character(']'));
        restrictedSigns.add(new Character('{'));
        restrictedSigns.add(new Character('}'));
        restrictedSigns.add(new Character('\u007f'));
        if (System.getProperty("os.name").startsWith("Windows")) {
            restrictedSigns.add(new Character('\u008c'));
        }
        Vector<String> subtypeVector = new Vector<String>(10, 5);
        int i = 0;
        Enumeration typeEnum = restrictedSigns.elements();
        while (typeEnum.hasMoreElements()) {
            char typeSign = ((Character)typeEnum.nextElement()).charValue();
            subtypeVector.add(String.valueOf(typeSign) + "plain");
            subtypeVector.add("pl" + typeSign + "ain");
            subtypeVector.add("plain" + typeSign);
            Enumeration enum1 = subtypeVector.elements();
            while (enum1.hasMoreElements()) {
                if (!TEST_WAS_OK) break;
                String subtypeString = (String)enum1.nextElement();
                String typeString = "text/";
                content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
                contentType = String.valueOf(typeString) + subtypeString;
                contentLength = content.length();
                try {
                    int l = 0;
                    while (l < 1000000) {
                        ++l;
                    }
                    resource.PUT(content, contentType, locktoken);
                    if (resource.getStatus().getStatusCode() >= 400) continue;
                    TestPut016.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'E', (String)("WebDAV status: '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'\n" + "'SubType' - ASCII code is: " + new Integer(typeSign) + "\n"));
                    TEST_WAS_OK = false;
                }
                catch (WDVTestJ_WdvException exc) {
                    if (exc.getStatusCode() != 400) {
                        TestPut016.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                        TestPut016.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
                        TEST_WAS_OK = false;
                        return;
                    }
                    if (exc.getStatusCode() != 400) continue;
                    TEST_WAS_OK = true;
                }
                catch (IOException exc) {
                    System.out.println("ContentType:" + contentType + " (No. " + i + ")");
                    TestPut016.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'W', (String)("Java exception: " + exc.getMessage() + "\n" + "This defect is caused by an socket connection error of the Java testframe. This is not a WebDAV server exception."));
                    this.handleExceptions(exc);
                    TEST_WAS_OK = false;
                    return;
                }
            }
            subtypeVector.clear();
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (!TEST_WAS_OK) {
            return;
        }
        urlStr = new String("/TestPut016.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut016.addGlobalMessage((String)"3. DELETE the resource /TestPut016.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut016.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (TEST_WAS_OK) {
            TestPut016.addGlobalMessage((String)"Test status", (char)'I', (String)"Test was OK.");
        } else {
            TestPut016.addGlobalMessage((String)"Test status", (char)'I', (String)"Test failed.");
        }
    }
}

