/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut007.createWebDAVSchema();
        TestPut007.addGlobalMessage((String)("prepare test " + TestPut007.getTestClassId()), (char)'I', (String)"put on a not existing resource without a request body");
        host = new String(TestPut007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut007.getPort();
        baseUrl = TestPut007.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
    }

    public void run() {
        urlStr = "/TestPut007";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut007.addGlobalMessage((String)"1. try to create the resource /TestPut007 at baseUrl without a request body", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.PUT();
        }
        catch (WDVTestJ_WdvException exc) {
            TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            return;
        }
        if (resource.getStatus().getStatusCode() != 201) {
            TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV reWDV_PORTs: " + new Integer(resource.getStatus().getStatusCode()).toString() + " " + resource.getStatus().getStatusMessage()));
            TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " without request body"), (char)'I', (String)"PUT was succesful.");
        TestPut007.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " without request body"), (char)'I', (String)("Status: " + resource.getStatus().getStatusCode()));
    }

    public static void cleanUp() throws TestCaseException {
        TestPut007.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

