/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut002.createWebDAVSchema();
        TestPut002.addGlobalMessage((String)("prepare test " + TestPut002.getTestClassId()), (char)'I', (String)"put on a existing resource");
        host = new String(TestPut002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut002.getPort();
        baseUrl = TestPut002.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut002.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut002.addGlobalMessage((String)"1. DELETE the resource /TestPut002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        content = "Die Sch\u00e4fchen sind nun m\u00fcde und wollen nicht mehr.";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPut002.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
    }

    public void run() {
        content = "Jetzt ist das Sch\u00e4fchen wieder wach und brutzelt fein am Elektroz\u00e4unelein";
        contentType = "text/plain";
        contentLength = content.length();
        TestPut002.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        if (resource.getStatus().getStatusCode() != 204) {
            TestPut002.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("recieved HTTP/1.1 Status Code " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "    Expected result: 204 No content"));
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestPut002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

