/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getlastmodified_node = null;
    static String getlastmodified_Str = null;
    static String getlastmodified_StrR = null;

    public static void prepare() throws TestCaseException {
        TestPropfind009.createWebDAVSchema();
        TestPropfind009.addGlobalMessage((String)("prepare test " + TestPropfind009.getTestClassId()), (char)'I', (String)"*************************************************************************************************************\n* Create a resource and check whether the property 'getlastmodified' supplied by PROPFIND is correct or not *\n*************************************************************************************************************");
        host = new String(TestPropfind009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind009.getPort();
        baseUrl = TestPropfind009.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind009.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind009.addGlobalMessage((String)"1. DELETE the resource /TestPropfind009.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        block18: {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException iexc) {
                this.handleExceptions(iexc);
            }
            catch (IllegalMonitorStateException mst_exc) {
                this.handleExceptions(mst_exc);
            }
            content = "Die Schaefchen sind jetzt schlafen gegangen...";
            contentType = "text/plain";
            contentLength = content.length();
            TestPropfind009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            SimpleDateFormat sdf_fulldate = new SimpleDateFormat("EEE, dd MMM yyyy", new Locale("en"));
            SimpleDateFormat sdf_fulltime = new SimpleDateFormat("HH:mm:ss z", new Locale("en"));
            if (TestPropfind009.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                sdf_fulltime.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            Date date = new Date();
            getlastmodified_Str = String.valueOf(sdf_fulldate.format(date)) + " " + sdf_fulltime.format(date);
            TestPropfind009.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
            body = String.valueOf(body) + "<D:propfind xmlns:D=\"DAV:\">";
            body = String.valueOf(body) + "<D:prop>";
            body = String.valueOf(body) + "<D:getlastmodified/>";
            body = String.valueOf(body) + "</D:prop>";
            body = String.valueOf(body) + "</D:propfind>";
            try {
                xmlDocument = resource.PROPFIND(body);
                TestPropfind009.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result is going to be compared to posted data");
                xmlDocument.toString();
            }
            catch (WDVTestJ_WdvException exc) {
                TestPropfind009.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Test failed due to some WebDAV feature"));
            }
            catch (Exception exc) {
                this.handleExceptions(exc);
            }
            try {
                NodeList nl = xmlDocument.getElementsByTagName("s1:getlastmodified");
                if (nl.getLength() == 0) {
                    nl = xmlDocument.getElementsByTagName("D:getlastmodified");
                }
                getlastmodified_node = nl.item(0);
            }
            catch (NullPointerException npexc) {
                TestPropfind009.addGlobalMessage((String)"retrieving the 'getlastmodified'-element", (char)'E', (String)"the 'getlastmodified'-element for the reource could not be retrieved");
            }
            String status = null;
            status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
                try {
                    getlastmodified_StrR = getlastmodified_node.getFirstChild().getNodeValue().toString();
                    if (getlastmodified_StrR.substring(0, 16).compareToIgnoreCase(getlastmodified_Str.substring(0, 16)) == 0) {
                        TestPropfind009.addGlobalMessage((String)"comparing the posted and the received getlastmodified-value", (char)'I', (String)"test succesful");
                        break block18;
                    }
                    if (!TestPropfind009.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                        TestPropfind009.addGlobalMessage((String)"comparing the posted and the received getlastmodified-value", (char)'W', (String)"test failedsee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128786");
                    } else {
                        TestPropfind009.addGlobalMessage((String)"comparing the posted and the received getlastmodified-value", (char)'E', (String)"test failed");
                    }
                    TestPropfind009.addGlobalMessage((String)"comparing the posted and the received getlastmodified-value", (char)'I', (String)("posted: " + getlastmodified_Str + "\n" + "received: " + getlastmodified_StrR));
                }
                catch (NullPointerException npexc) {
                    TestPropfind009.addGlobalMessage((String)"receiving the value of the 'getlastmodified'-node for the resource", (char)'E', (String)"value of 'getlastmodified'-node is not existing");
                    this.handleExceptions(npexc);
                }
            } else {
                TestPropfind009.addGlobalMessage((String)"receiving 'getlastmodified'-node for the resource", (char)'E', (String)("'getlastmodified'-node is not existing\nstatus code: " + status));
            }
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind009.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "'207 Multistatus' expected"));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind009.addGlobalMessage((String)"5. clean up and DELETE the resource /TestPropfind009.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPropfind009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

