/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import org.w3c.dom.Document;

public class TestPropfind002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlbody = null;
    static boolean skipTest = false;

    public static void prepare() throws TestCaseException {
        TestPropfind002.createWebDAVSchema();
        TestPropfind002.addGlobalMessage((String)("prepare test " + TestPropfind002.getTestClassId()), (char)'I', (String)"**********************************\n* Propfind on an existing folder *\n**********************************");
        host = new String(TestPropfind002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind002.getPort();
        baseUrl = TestPropfind002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/\u00c4\u00d6\u00dc");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind002.addGlobalMessage((String)"1. DELETE folder /\u00c4\u00d6\u00dc at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            try {
                resource.DELETE(null);
            }
            catch (WDVTestJ_WdvException e) {
                if (e.getStatusCode() == 400 && !OS_IS_WINDOWS) {
                    TestPropfind002.addGlobalMessage((String)"Trying to delete a resource with umlauts", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                    skipTest = true;
                    return;
                }
                TestPropfind002.addGlobalMessage((String)"1. DELETE folder /\u00c4\u00d6\u00dc at baseUrl", (char)'E', (String)("Server returned: '" + e.getStatusCode() + " " + e.getMessage() + "'"));
            }
            catch (IOException exc) {
                TestPropfind002.addGlobalMessage((String)"IOException occurred", (char)'W', (String)exc.getMessage());
            }
        }
        if (skipTest) {
            return;
        }
        if (!resource.exists()) {
            try {
                resource.MKCOL(null);
            }
            catch (WDVTestJ_WdvException e) {
                if (!(e.getStatusCode() != 500 && e.getStatusCode() != 400 || OS_IS_WINDOWS)) {
                    TestPropfind002.addGlobalMessage((String)"2. MKCOL to create the folder /\u00c4\u00d6\u00dc at baseUrl", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                    skipTest = true;
                    return;
                }
                TestPropfind002.addGlobalMessage((String)"2. MKCOL to create the folder /\u00c4\u00d6\u00dc at baseUrl", (char)'E', (String)("Server returned: '" + e.getStatusCode() + " " + e.getMessage() + "'"));
            }
            catch (IOException exc) {
                if (!TestPropfind002.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                    TestPropfind002.addGlobalMessage((String)"IOException occurred", (char)'W', (String)exc.getMessage());
                }
                TestPropfind002.addGlobalMessage((String)"2. MKCOL to create the folder /\u00c4\u00d6\u00dc at baseUrl", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                skipTest = true;
                return;
            }
        }
    }

    public void run() {
        if (skipTest) {
            return;
        }
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = String.valueOf(body) + new String("<D:propfind xmlns:D=\"DAV:\">\n");
        body = String.valueOf(body) + new String("<D:allprop/>\n");
        body = String.valueOf(body) + new String("</D:propfind>\n");
        try {
            resource.PROPFIND_FILE(body, "propfind_on_folder.xml");
            TestPropfind002.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result saved in 'propfind_on_folder.xml'");
        }
        catch (WDVTestJ_WdvException exc) {
            if (!(exc.getStatusCode() != 500 && exc.getStatusCode() != 400 || OS_IS_WINDOWS)) {
                TestPropfind002.addGlobalMessage((String)"call PROPFIND method", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                skipTest = true;
                return;
            }
            TestPropfind002.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Test failed due to some WebDAV feature"));
        }
        catch (Exception exc) {
            TestPropfind002.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestPropfind002.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (skipTest) {
            return;
        }
        urlStr = new String("/\u00c4\u00d6\u00dc");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind002.addGlobalMessage((String)"4. clean up and DELETE folder /\u00c4\u00d6\u00dc at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPropfind002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

